/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.comp_means.one_way_annova;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.one_way_annova.OneWayAnovaContrasts;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.one_way_annova.OneWayAnovaOptions;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.one_way_annova.OneWayAnovaPostHoc;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class OneWayAnova
extends BaseProcedureDialog
implements ListDataListener {
    private SrcVariableList mSrcVarList;
    private TargetVariableList mDepListVarList;
    private TargetVariableList mFactorVarList;
    private ArrowButton mDepListArrowButton;
    private ArrowButton mFactorListArrowButton;
    private boolean mIsBootstrapOK;

    public OneWayAnova(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_ONE_WAY_ANOVA"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_onew";
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runBootstrapSubDialog();
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = SyntaxUtil.startSyntax().toString();
        DialogDataModel dialogDataModel2 = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel2 != null) {
            object5 = this.mDepListVarList.getVariablesStringList();
            object4 = this.mFactorVarList.getVariablesStringList();
            string = string + BootstrapDlg.getBootstrapSyntax((String)object5, (String)object4, dialogDataModel2);
        }
        string = string + SyntaxUtil.getMainCommand("ONEWAY").toString();
        string = string + SyntaxUtil.getMainCommandParamters(this.mDepListVarList.getVariablesStringList());
        string = string + " BY " + this.mFactorVarList.getVariablesStringList() + "\n";
        object5 = dialogDataModel.getBoolean("IDS_POLYNOMIAL_CHECK");
        if (object5 != null && ((Boolean)object5).booleanValue()) {
            object4 = dialogDataModel.getInteger("IDS_DEGREE_COMBO");
            object3 = object4 != null ? Integer.toString((Integer)object4 + 1) : "1";
            string = string + SyntaxUtil.getSubCommand("/POLYNOMIAL=").toString();
            string = string + (String)object3 + "\n";
        }
        object4 = "";
        object3 = dialogDataModel.getInteger("IDS_LAYER_COUNT");
        int n = object3 == null ? 0 : (Integer)object3;
        for (int i = 0; i < n; ++i) {
            object2 = (String[])dialogDataModel.getArray("IDS_LAYERS" + i);
            object4 = (String)object4 + SyntaxUtil.getSubCommand("/CONTRAST=").toString();
            object = object2;
            int n2 = ((String[])object).length;
            for (int j = 0; j < n2; ++j) {
                String string2 = object[j];
                object4 = (String)object4 + string2 + " ";
            }
            object4 = (String)object4 + "\n";
        }
        if (((String)object4).length() > 0) {
            string = string + (String)object4;
        }
        String string3 = "";
        object5 = dialogDataModel.getBoolean("IDS_DESCRIPTIVE_CHECK");
        if (object5 != null && ((Boolean)object5).booleanValue()) {
            string3 = string3 + "DESCRIPTIVES ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_FIXED_RANDOM_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            string3 = string3 + "EFFECTS ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_HOMOGENEITY_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            string3 = string3 + "HOMOGENEITY ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_BROWN_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            string3 = string3 + "BROWNFORSYTHE ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_WELCH_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            string3 = string3 + "WELCH ";
        }
        if (string3.length() > 0) {
            string = string + SyntaxUtil.getSubCommand("/STATISTICS ").toString();
            string = string + string3 + "\n";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_MEANS_PLOT_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            string = string + SyntaxUtil.getSubCommand("/PLOT MEANS").toString();
            string = string + "\n";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_LISTWISE_RADIO")) != null && ((Boolean)object5).booleanValue()) {
            string = string + SyntaxUtil.getSubCommand("/MISSING LISTWISE").toString();
            string = string + "\n";
        } else {
            string = string + SyntaxUtil.getSubCommand("/MISSING ANALYSIS").toString();
            string = string + "\n";
        }
        object2 = "";
        object5 = dialogDataModel.getBoolean("IDS_SNK_CHECK");
        if (object5 != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "SNK ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_TUKEY_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "TUKEY ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_TUKEYSB_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "BTUKEY ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_DUNCAN_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "DUNCAN ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_SCHEFFE_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "SCHEFFE ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_LSD_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "LSD ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_BONFERRONI_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "BONFERRONI ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_SIDAK_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "SIDAK ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_GABRIEL_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "GABRIEL ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_REGWF_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "FREGW ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_REGWQ_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "QREGW ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_HOCHBERGS_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "GT2 ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_TAMHANES_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "T2 ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_DUNNETTS_T3_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "T3 ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_GAMES_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "GH ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_DUNNETTS_C_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "C ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_WALLER_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object2 = (String)object2 + "WALLER(" + dialogDataModel.getString("IDS_TYPE_1_EDIT") + ") ";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_DUNNETT_CHECK")) != null && ((Boolean)object5).booleanValue()) {
            object5 = dialogDataModel.getBoolean("IDS_2_SIDED_RADIO");
            if (object5 != null && ((Boolean)object5).booleanValue()) {
                object2 = (String)object2 + "DUNNETT ";
            }
            if ((object5 = dialogDataModel.getBoolean("IDS_LT_CONTROL_RADIO")) != null && ((Boolean)object5).booleanValue()) {
                object2 = (String)object2 + "DUNNETTL ";
            }
            if ((object5 = dialogDataModel.getBoolean("IDS_GT_CONTROL_RADIO")) != null && ((Boolean)object5).booleanValue()) {
                object2 = (String)object2 + "DUNNETTR ";
            }
            if ((object = dialogDataModel.getInteger("IDS_CONTROL_CAT_COMBO")) != null && (Integer)object == 0) {
                object2 = (String)object2 + "(1) ";
            }
        }
        if (((String)object2).length() > 0) {
            object = dialogDataModel.getString("IDS_SIG_LEVEL_EDIT");
            if (object != null) {
                object2 = (String)object2 + "ALPHA(" + (String)object + ")";
            }
            string = string + SyntaxUtil.getSubCommand("/POSTHOC=").toString();
            string = string + (String)object2 + "\n";
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string + SyntaxUtil.terminateSyntax();
        if (this.mIsBootstrapOK && dialogDataModel2 != null) {
            string = string + BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY));
        }
        return string;
    }

    @Override
    public final String getIActionKey() {
        return "analyze_comp_means_one_anova";
    }

    @Override
    public void reset() {
        super.reset();
        this.mDepListVarList.removeAll();
        this.mFactorVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkAndPaste();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    protected void runContrastsSubDialog() {
        this.runSubDialog(new OneWayAnovaContrasts(this));
    }

    protected void runPostHocSubDialog() {
        this.runSubDialog(new OneWayAnovaPostHoc(this));
    }

    protected void runOptionsSubDialog() {
        this.runSubDialog(new OneWayAnovaOptions(this));
    }

    private void runBootstrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }

    protected void updateOkAndPaste() {
        this.enableOkPaste(this.mDepListVarList.getModel().getSize() > 0 && this.mFactorVarList.getModel().getSize() > 0);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setIdentifier("AnovaSrcList");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ONE_WAY_ANOVA_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n, insets);
        this.mDepListArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mDepListArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_DEP_LIST_COLON");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mDepListVarList = new TargetVariableList();
        this.mDepListVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDepListVarList.setIdentifier("AnovaDepVarList");
        this.mDepListVarList.addVarFilter(spssVarFilter);
        this.mDepListVarList.setMaxLimitOfList(100);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mDepListVarList);
        this.mDepListVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDepListVarList.getFixedCellHeight() * 6 + 2));
        jScrollPane.setPreferredSize(this.mDepListVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        this.mDepListVarList.getModel().addListDataListener(this);
        jLabel2.setLabelFor(this.mDepListVarList);
        this.mDepListArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDepListArrowButton.registerVariableList(this.mDepListVarList, SpssArrowButton.ButtonOrientation.left);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets3 = new Insets(n2, 0, 0, 0);
        jLabel2 = DialogUtil.createLabel(this, "IDS_FACTOR_COLON");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        TargetVariableList.TargetListType targetListType = TargetVariableList.TargetListType.single_item;
        this.mFactorVarList = new TargetVariableList(targetListType);
        this.mFactorVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorVarList.setIdentifier("AnovaFactorVarList");
        this.mFactorVarList.addVarFilter(spssVarFilter);
        n = 23;
        jScrollPane = new JScrollPane(this.mFactorVarList);
        jScrollPane.setPreferredSize(this.mFactorVarList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets);
        this.mFactorVarList.getModel().addListDataListener(this);
        jLabel2.setLabelFor(this.mFactorVarList);
        this.mFactorListArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mFactorListArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets);
        this.mFactorListArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorListArrowButton.registerVariableList(this.mFactorVarList, SpssArrowButton.ButtonOrientation.left);
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
        this.updateOkAndPaste();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_CONTRASTS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OneWayAnova.this.runContrastsSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_POSTHOC_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OneWayAnova.this.runPostHocSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction2));
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OneWayAnova.this.runOptionsSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction3));
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction3 = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OneWayAnova.this.runBootstrapSubDialog();
                }
            };
            JButton jButton = new JButton(toggleButtonAction3);
            this.addOptionsPanelButton(jPanel, jButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                jButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    private void setDefaults() {
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDepListArrowButton);
        vector.add(this.mFactorListArrowButton);
        vector.add(this.mDepListVarList);
        vector.add(this.mFactorVarList);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }
}

