/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.comp_means.means;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MeansOptions
extends BaseSubDialog
implements ListDataListener,
ItemListener {
    static final String SOURCE_KEY = "IDS_SOURCE_KEY";
    static final String TARGET_KEY = "IDS_TARGET_KEY";
    static final String ANOVA_CHECK = "IDS_MEANS_OPTIONS_ANOVA_CHECK";
    static final String LINEAR_CHECK = "IDS_MEANS_OPTIONS_LINEAR_CHECK";
    private PlainListArrowButton mArrowButton;
    private PlainList mSrcVarList;
    private PlainList mTargetVarList;
    private JCheckBox mAnovaCheck;
    private JCheckBox mLinearityCheck;

    public MeansOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_MEANS_OPTIONS_SUB_TITLE"), true);
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableContinue(this.mTargetVarList.getModel().getSize() > 0 || this.mAnovaCheck.isSelected() || this.mLinearityCheck.isSelected());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableContinue(this.mTargetVarList.getModel().getSize() > 0 || this.mAnovaCheck.isSelected() || this.mLinearityCheck.isSelected());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableContinue(this.mTargetVarList.getModel().getSize() > 0 || this.mAnovaCheck.isSelected() || this.mLinearityCheck.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableContinue(this.mTargetVarList.getModel().getSize() > 0 || this.mAnovaCheck.isSelected() || this.mLinearityCheck.isSelected());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mean_opt";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setDefaults() {
        this.enableContinue(true);
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mSrcVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mSrcVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSrcVarList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mTargetVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mTargetVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mTargetVarList, this.mPlainListVarMoveHandler));
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mAnovaCheck);
        vector.add(this.mLinearityCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        int n;
        this.mSrcVarList = new PlainList(SOURCE_KEY);
        this.mTargetVarList = new PlainList(TARGET_KEY);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mArrowButton = new PlainListArrowButton(SpssArrowButton.ButtonOrientation.right);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, ANOVA_CHECK);
        this.mAnovaCheck = new JCheckBox(toggleButtonAction);
        this.mAnovaCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, LINEAR_CHECK);
        this.mLinearityCheck = new JCheckBox(toggleButtonAction);
        this.mLinearityCheck.addItemListener(this);
        this.mSrcVarList.setModel(new DefaultListModel());
        DefaultListModel defaultListModel = (DefaultListModel)this.mSrcVarList.getModel();
        Vector<String> vector = this.mAddintoSrcModel();
        for (n = 0; n < vector.size(); ++n) {
            defaultListModel.addElement(vector.get(n));
        }
        this.mTargetVarList.setModel(new DefaultListModel());
        defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
        vector = this.mAddintoTrgModel();
        for (n = 0; n < vector.size(); ++n) {
            defaultListModel.addElement(vector.get(n));
        }
        this.mSrcVarList.setDragEnabled(true);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetVarList.getModel().addListDataListener(this);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupListPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupLayerPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MEANS_OPTIONS_STATIC_LABEL");
        gridBagConstraints.fill = 0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jLabel.setLabelFor(this.mSrcVarList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(new Dimension(150, 200));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MEANS_OPTIONS_CELL_LABEL");
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        jLabel2.setLabelFor(this.mTargetVarList);
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 15 + 2));
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupLayerPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_MEANS_OPTIONS_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mAnovaCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mLinearityCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private Vector<String> mAddintoSrcModel() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.getResString("IDS_MEANS_OPTIONS_MEDIAN"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_GROUPEDMEDIAN"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_STDERR_OF_MEAN"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_SUM"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_MINIMUM"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_MAXIMUM"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_RANGE"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_FIRST"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_LAST"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_VAR"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_KURTOSIS"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_STDERR_OF_KURTOSIS"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_SKEWNESS"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_STDERR_OF_SKEWNESS"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_HARMONIC_MEAN"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_GEOMETRIC_MEAN"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_PERCENT_OF_TOTAL_SUM"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_PERCENT_OF_TOTAL_N"));
        return vector;
    }

    private Vector<String> mAddintoTrgModel() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.getResString("IDS_MEANS_OPTIONS_TRG_MEAN"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_TRG_NO_CASES"));
        vector.add(this.getResString("IDS_MEANS_OPTIONS_TRG_STD_DEVIATION"));
        return vector;
    }
}

