/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.comp_means.means;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.LayeredListWidget;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.means.MeansOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MeansDlg
extends BaseProcedureDialog
implements ListDataListener {
    public static final int MAX_ELEMENTS_DEPENDENT = 100;
    public static final int MAX_ELEMENTS_INDEPENDENT = 20;
    static final String OPTION_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mDependentList;
    private ArrowButton mDependentArrow;
    private JScrollPane mScrollPane;
    private JButton mOption;
    private JButton mBootstrappingButton;
    private JButton mTableStyleButton;
    private LayeredListWidget mLayerWidget;
    private TargetVariableList mIndependentList;
    private JScrollPane mIndependentScrollPane;
    private ArrayList<VarListModel> mLayerList;
    private int MAX_MULTIPLICATION = 250;
    private boolean mIsBootstrapOK;

    public MeansDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_CMEANS_MEANS_TITLE"));
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putBoolean("EnableOkPaste", true);
        this.mLayerWidget.saveListState(this.getDialogDataModel());
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this));
            DialogUtil.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mLayerWidget.getVarMoveHandler());
        }
    }

    @Override
    public boolean okPastePressed() {
        super.okPastePressed();
        this.mLayerWidget.saveListState(this.getDialogDataModel());
        int n = 0;
        for (int i = 0; i < this.mLayerWidget.getVarListModels().size(); ++i) {
            n += this.mLayerWidget.getVarListModels().get(i).getSize();
        }
        if ((n *= this.mDependentList.getModel().getSize()) > this.MAX_MULTIPLICATION) {
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_MEANS_MAX_ELEMENT_ERROR_MESSAGE"), VersionInfo.getAppVersionString());
            return false;
        }
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runBootstrapSubDialog();
            return false;
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mean";
    }

    @Override
    public String getIActionKey() {
        return "analyze_comp_means_means";
    }

    @Override
    public String generateSyntax() {
        String string;
        Object object;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        this.mLayerList = this.mLayerWidget.getVarListModels();
        for (VarListModel object22 : this.mLayerList) {
            if (object22.getSize() <= 0) continue;
            stringBuffer2.append(" BY");
            for (int objectArray = 0; objectArray < object22.getSize(); ++objectArray) {
                object = object22.getElementAt(objectArray).getName();
                stringBuffer2.append(" ").append((String)object);
                stringBuffer3.append(" ").append((String)object);
            }
        }
        DialogDataModel dialogDataModel2 = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel2 != null) {
            String string2 = this.mDependentList.getVariablesStringList();
            String string3 = stringBuffer3.toString();
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax(string2, string3, dialogDataModel2));
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("MEANS"));
        String string4 = this.mDependentList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("TABLES=" + string4));
        stringBuffer.append(stringBuffer2);
        Object[] objectArray = dialogDataModel.getArray("IDS_TARGET_KEY");
        object = this.getStatMap();
        if (dialogDataModel.getArray("IDS_TARGET_KEY") == null) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CELLS="));
            stringBuffer.append((String)((HashMap)object).get(this.getResString("IDS_MEANS_OPTIONS_TRG_MEAN"))).append(" ");
            stringBuffer.append((String)((HashMap)object).get(this.getResString("IDS_MEANS_OPTIONS_TRG_NO_CASES"))).append(" ");
            stringBuffer.append((String)((HashMap)object).get(this.getResString("IDS_MEANS_OPTIONS_TRG_STD_DEVIATION")));
        } else if (objectArray.length != 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CELLS="));
            for (int i = 0; i < objectArray.length; ++i) {
                string = (String)((HashMap)object).get(objectArray[i]);
                if (i == 0) {
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append(" ").append(string);
            }
        }
        Boolean bl = dialogDataModel.getBoolean("IDS_MEANS_OPTIONS_ANOVA_CHECK");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS ANOVA"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MEANS_OPTIONS_LINEAR_CHECK")) != null && bl.booleanValue()) {
            if (stringBuffer.indexOf("STATISTICS") > 0) {
                stringBuffer.append(" LINEARITY");
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS LINEARITY"));
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel2 != null) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        if ((string = TableStyleDlg.generateSyntax(dialogDataModel, TableStyleDlg.ConditionalFormatDlgType.Means)) != null) {
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.mDependentList.getModel().getSize() > 1) {
            this.mScrollPane.setVerticalScrollBarPolicy(22);
            this.mScrollPane.validate();
            this.mScrollPane.repaint();
        }
        if (this.mIndependentList.getModel().getSize() > 1) {
            this.mIndependentScrollPane.setVerticalScrollBarPolicy(22);
            this.mIndependentScrollPane.validate();
            this.mIndependentScrollPane.repaint();
        }
        this.enableOkPaste(this.mDependentList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mDependentList.getModel().getSize() < 2) {
            this.mScrollPane.setVerticalScrollBarPolicy(20);
            this.mScrollPane.validate();
            this.mScrollPane.repaint();
        }
        if (this.mIndependentList.getModel().getSize() < 2) {
            this.mIndependentScrollPane.setVerticalScrollBarPolicy(20);
            this.mIndependentScrollPane.validate();
            this.mIndependentScrollPane.repaint();
        }
        this.enableOkPaste(this.mDependentList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mDependentList.getModel().getSize() > 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.mDependentList.removeAll();
        this.mLayerWidget.resetLayeredListWidget();
        this.setDefaults();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        if (this.getDialogDataModel().getBoolean("EnableOkPaste") != null) {
            this.enableOkPaste(true);
        }
        for (ListDataListener listDataListener : this.mIndependentList.getModel().getListDataListeners()) {
            if (listDataListener != this) continue;
            this.mIndependentList.getModel().removeListDataListener(this);
        }
        this.mIndependentList.getModel().addListDataListener(this);
        this.mLayerWidget.loadListState(this.getDialogDataModel());
        this.mLayerWidget.addListener(this);
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupAllPanel(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.enableOkPaste(false);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new MeansOptions(this));
    }

    private void runBootstrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }

    private void runTableStyleSubDialog() {
        this.runSubDialog(new TableStyleDlg(this, TableStyleDlg.ConditionalFormatDlgType.Means));
    }

    private void initVars() {
        this.mLayerWidget = new LayeredListWidget(this.getResString("IDS_CMEANS_LAYERED_LIST_TITLE"), this);
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mDependentList = new TargetVariableList();
        this.mDependentList.setIdentifier("DependentList");
        this.mDependentList.setMaxLimitOfList(100);
        this.mIndependentList = this.mLayerWidget.getTargetVariableList();
        this.mIndependentList.getModel().addListDataListener(this);
        this.mIndependentList.setMaxLimitOfList(20);
        this.mIndependentList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mIndependentList.getFixedCellHeight() * 2 + 9));
        this.mIndependentScrollPane = this.mLayerWidget.getScrollPane();
        this.mIndependentScrollPane.setPreferredSize(this.mIndependentList.getMinimumSize());
        this.mScrollPane = new JScrollPane(this.mSrcVarList);
        this.mScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mDependentArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDependentList.getModel().addListDataListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(OPTION_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeansDlg.this.runOptionsSubDialog();
            }
        };
        this.mLayerWidget.setMaxNoOfItemsInLayers(200);
        this.mLayerWidget.setMaxNoOfLayers(10);
        this.mLayerWidget.setMaxNoOfItemsPerLayers(200);
        this.mOption = new JButton(toggleButtonAction);
        this.mLayerWidget.setSrcList(this.mSrcVarList);
        this.mLayerWidget.setVarListListMnemonic(73);
        this.addOptionsPanelButton(this.mOptionButtonPanel, this.mOption);
        toggleButtonAction = new ToggleButtonAction("IDS_TABLE_STYLE_BUTTON_MEANS"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeansDlg.this.runTableStyleSubDialog();
            }
        };
        this.mTableStyleButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(this.mOptionButtonPanel, this.mTableStyleButton);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MeansDlg.this.runBootstrapSubDialog();
                }
            };
            this.mBootstrappingButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(this.mOptionButtonPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        DialogUtil.normalizeButtonWidths((JPanel)this.mOptionButtonPanel);
        this.mDependentArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrow.registerVariableList(this.mDependentList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setupAllPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap() - 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupSourceListPanel(), gridBagConstraints, 0, 0, 1, 3, n, null);
        DialogUtil.addUsingGBL(jPanel, this.setupDependentPanel(), gridBagConstraints, 1, 0, 2, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mLayerWidget, gridBagConstraints, 1, 1, 2, 1, n, insets);
    }

    private JPanel setupSourceListPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CMEANS_MEANS_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 2, n, null);
        return jPanel;
    }

    private JPanel setupDependentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CMEANS_MEANS_DEPEN_LABEL");
        jLabel.setLabelFor(this.mDependentList);
        this.mScrollPane = new JScrollPane(this.mDependentList);
        this.mDependentList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDependentList.getFixedCellHeight() * 2 + 9));
        this.mDependentList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollPane.setPreferredSize(this.mDependentList.getMinimumSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, insets.left + 15, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDependentArrow, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(0, insets.left - 10, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        return jPanel;
    }

    private HashMap<String, String> getStatMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_TRG_MEAN"), "MEAN");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_MEDIAN"), "MEDIAN");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_GROUPEDMEDIAN"), "GMEDIAN");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_STDERR_OF_MEAN"), "SEMEAN");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_SUM"), "SUM");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_MINIMUM"), "MIN");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_MAXIMUM"), "MAX");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_RANGE"), "RANGE");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_FIRST"), "FIRST");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_LAST"), "LAST");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_TRG_STD_DEVIATION"), "STDDEV");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_VAR"), "VAR");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_KURTOSIS"), "KURT");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_STDERR_OF_KURTOSIS"), "SEKURT");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_SKEWNESS"), "SKEW");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_STDERR_OF_SKEWNESS"), "SESKEW");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_HARMONIC_MEAN"), "HARMONIC");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_GEOMETRIC_MEAN"), "GEOMETRIC");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_PERCENT_OF_TOTAL_SUM"), "SPCT");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_PERCENT_OF_TOTAL_N"), "NPCT");
        hashMap.put(this.getResString("IDS_MEANS_OPTIONS_TRG_NO_CASES"), "COUNT");
        return hashMap;
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDependentArrow);
        vector.add(this.mDependentList);
        Vector<Object> vector2 = this.mLayerWidget.getTraversalComponent();
        for (n = 0; n < vector2.size(); ++n) {
            vector.add(vector2.get(n));
        }
        vector.add(this.mOption);
        if (this.mTableStyleButton != null) {
            vector.add(this.mTableStyleButton);
        }
        if (this.mBootstrappingButton != null) {
            vector.add(this.mBootstrappingButton);
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

