/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.comp_means.ind_samples_ttest;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.CompareMeansOptions;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.ind_samples_ttest.IndSamplesDefineGroups;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.ind_samples_ttest.IndSamplesDefineGroupsForStrings;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.ind_samples_ttest.IndSamplesGroupVarFormatter;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.ind_samples_ttest.IndSamplesGroupVarModel;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class IndSamplesTTestDlg
extends BaseProcedureDialog
implements ListDataListener,
FocusListener {
    static final String IDS_OPTIONS_KEY = "IDS_COMMON_OPTIONS_3DOT";
    static final String TEST_VALUE = "IDS_TEST_VALUE";
    static final String CONF_VALUE = "95";
    private StringBuffer mBuffer;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetTestVarList;
    private TargetVariableList mTargetGroupVarList;
    private JScrollPane mSrcLstScrollPane;
    private JScrollPane mTargetListScrollPane;
    private JScrollPane mGroupVarListScroll;
    private ArrowButton mArrowButton;
    private ArrowButton mGroupArrowButton;
    private JLabel mTestVarLabel;
    private JLabel mGroupVarLabel;
    private JButton mDefineGroupsButton;
    private IndSamplesGroupVarFormatter mTargetGroupVarFormatter;
    private boolean mIsBootstrapOK;

    public IndSamplesTTestDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_INDEPENDENT_SAMPLES_T_TEST"));
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        boolean bl = false;
        if (this.mTargetGroupVarList.getModel().getSize() > 0) {
            this.mDefineGroupsButton.setEnabled(true);
            ISpssVariable iSpssVariable = this.mTargetGroupVarList.getModel().getElementAt(0);
            String[] stringArray = (String[])this.mTargetGroupVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (stringArray != null && !stringArray[0].equals("?") && this.mTargetTestVarList.getModel().getSize() > 0) {
                bl = true;
            }
        } else {
            this.mDefineGroupsButton.setEnabled(false);
        }
        this.enableOkPaste(bl);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        boolean bl = false;
        if (this.mTargetGroupVarList.getModel().getSize() > 0) {
            this.mDefineGroupsButton.setEnabled(true);
            ISpssVariable iSpssVariable = this.mTargetGroupVarList.getModel().getElementAt(0);
            String[] stringArray = (String[])this.mTargetGroupVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (stringArray != null && !stringArray[0].equals("?") && this.mTargetTestVarList.getModel().getSize() > 0) {
                bl = true;
            }
        } else {
            this.mDefineGroupsButton.setEnabled(false);
        }
        this.enableOkPaste(bl);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        boolean bl = false;
        if (this.mTargetGroupVarList.getModel().getSize() > 0) {
            this.mDefineGroupsButton.setEnabled(true);
            ISpssVariable iSpssVariable = this.mTargetGroupVarList.getModel().getElementAt(0);
            String[] stringArray = (String[])this.mTargetGroupVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (stringArray != null && !stringArray[0].equals("?") && this.mTargetTestVarList.getModel().getSize() > 0) {
                bl = true;
            }
        } else {
            this.mDefineGroupsButton.setEnabled(false);
        }
        this.enableOkPaste(bl);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mTargetTestVarList) {
            this.mGroupArrowButton.setEnabled(false);
            this.mDefineGroupsButton.setEnabled(false);
        }
        if (focusEvent.getSource() == this.mTargetGroupVarList && this.mTargetGroupVarList.getModel().getSize() > 0) {
            this.mArrowButton.setEnabled(false);
            this.mGroupArrowButton.setEnabled(true);
            this.mDefineGroupsButton.setEnabled(true);
        }
        if (focusEvent.getSource() == this.mSrcVarList) {
            this.mDefineGroupsButton.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public TargetVariableList getGroupVarList() {
        return this.mTargetGroupVarList;
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runBootstrapSubDialog();
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        String string;
        Object object;
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            object = this.mTargetTestVarList.getVariablesStringList();
            string = this.mTargetGroupVarList.getVariablesStringList();
            this.mBuffer.append(BootstrapDlg.getBootstrapSyntax((String)object, string, dialogDataModel));
        }
        this.mBuffer.append(SyntaxUtil.getMainCommand("T-TEST"));
        this.mBuffer.append(SyntaxUtil.getMainCommandParamters("GROUPS="));
        this.mBuffer.append(this.mTargetGroupVarFormatter.getDisplayText(this.mTargetGroupVarList.getModel().getElementAt(0)));
        this.mBuffer.append("\n");
        this.mBuffer.append(SyntaxUtil.getSubCommand("/MISSING="));
        object = this.getDialogDataModel().getBoolean("IDS_EXC_CASE_LIST_RADIO");
        if (object != null && ((Boolean)object).booleanValue()) {
            this.mBuffer.append("LISTWISE");
        } else {
            this.mBuffer.append("ANALYSIS");
        }
        this.mBuffer.append("\n");
        this.mBuffer.append(SyntaxUtil.getSubCommand("/VARIABLES="));
        this.mBuffer.append(this.mTargetTestVarList.getVariablesStringList());
        string = this.getDialogDataModel().getString("IDS_CONF_INTERVAL");
        String string2 = CONF_VALUE;
        if (string == null) {
            string = string2;
        }
        float f = Float.parseFloat(string);
        int n = SyntaxUtil.getDecimalDigits(string);
        string = SyntaxUtil.prepareFloatForSyntax(f /= 100.0f, n + 2);
        string = SyntaxUtil.removeLeadingZeros(string);
        this.mBuffer.append("\n");
        this.mBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("CRITERIA", "CI", string, false));
        this.mBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            this.mBuffer.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        return this.mBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ttin";
    }

    @Override
    public String getIActionKey() {
        return "analyze_comp_means_indep_ttest";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetTestVarList.removeAll();
        this.mTargetGroupVarList.removeAll();
        this.setDefaults();
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mTargetGroupVarList.getIdentifier(), this.mTargetGroupVarFormatter.getVarMapForSerialization());
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mTargetGroupVarFormatter.setVarMap(this.getDialogDataModel().getMap(this.mTargetGroupVarList.getIdentifier()));
        boolean bl = false;
        if (this.mTargetGroupVarList.getModel().getSize() > 0) {
            this.mDefineGroupsButton.setEnabled(true);
            ISpssVariable iSpssVariable = this.mTargetGroupVarList.getModel().getElementAt(0);
            String[] stringArray = (String[])this.mTargetGroupVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (stringArray != null && !stringArray[0].equals("?") && this.mTargetTestVarList.getModel().getSize() > 0) {
                bl = true;
            }
        } else {
            this.mDefineGroupsButton.setEnabled(false);
        }
        this.enableOkPaste(bl);
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.setupUI(jPanel);
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(IDS_OPTIONS_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndSamplesTTestDlg.this.runOptionsSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IndSamplesTTestDlg.this.runBootstrapSubDialog();
                }
            };
            JButton jButton2 = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, jButton2);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                jButton2.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    private void initVars() {
        this.mBuffer = SyntaxUtil.startSyntax();
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.setIdentifier("OneSampleTTestSrcVarList");
        this.mSrcVarList.addFocusListener(this);
        this.mSrcLstScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcLstScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTestVarLabel = DialogUtil.createLabel(this, "IDS_TEST_VARIABLES_COLON");
        this.mTargetTestVarList = new TargetVariableList();
        this.mTargetTestVarList.setIdentifier("TARGET_LIST");
        this.mTargetTestVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetTestVarList.getModel().addListDataListener(this);
        this.mTargetTestVarList.addFocusListener(this);
        this.mTargetListScrollPane = new JScrollPane(this.mTargetTestVarList);
        this.mTargetTestVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetTestVarList.getFixedCellHeight() * 6 + 2));
        this.mTargetListScrollPane.setPreferredSize(this.mTargetTestVarList.getMinimumSize());
        this.mTestVarLabel.setLabelFor(this.mTargetTestVarList);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetTestVarList, SpssArrowButton.ButtonOrientation.left);
        this.mGroupVarLabel = DialogUtil.createLabel(this, "IDS_GROUPING_VARIABLES_COLON");
        this.mTargetGroupVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetGroupVarFormatter = new IndSamplesGroupVarFormatter(this.mTargetGroupVarList);
        this.mTargetGroupVarList.setModel(new IndSamplesGroupVarModel(this.mTargetGroupVarFormatter));
        this.mTargetGroupVarList.setCellRenderer(new CustomVarListCellRenderer(this.mTargetGroupVarFormatter));
        this.mTargetGroupVarList.getModel().addListDataListener(this);
        this.mTargetGroupVarList.setIdentifier("GROUP_VARIALE_LIST");
        this.mTargetGroupVarList.addFocusListener(this);
        this.mGroupVarListScroll = new JScrollPane(this.mTargetGroupVarList);
        this.mGroupVarListScroll.setHorizontalScrollBarPolicy(31);
        this.mGroupVarListScroll.setVerticalScrollBarPolicy(21);
        this.mGroupVarListScroll.setPreferredSize(this.mTargetGroupVarList.getMinimumSize());
        this.mGroupVarLabel.setLabelFor(this.mTargetGroupVarList);
        this.mGroupArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mGroupArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mGroupArrowButton.registerVariableList(this.mTargetGroupVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_ISTT_DEFINE_GROUPS"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndSamplesTTestDlg.this.runDefineGroupsSubDialog();
                IndSamplesTTestDlg.this.mTargetGroupVarList.requestFocus();
            }
        };
        this.mDefineGroupsButton = new JButton(toggleButtonAction);
        this.mDefineGroupsButton.setEnabled(true);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mGroupArrowButton);
        vector.add(this.mTargetTestVarList);
        vector.add(this.mTargetGroupVarList);
        vector.add(this.mDefineGroupsButton);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void setupUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ISTT_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcLstScrollPane, gridBagConstraints, 0, 1, 1, 4, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mTestVarLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetListScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 20;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mGroupArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mGroupVarLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mGroupVarListScroll, gridBagConstraints, 2, 3, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mDefineGroupsButton, gridBagConstraints, 2, 4, 1, 1, n, insets);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new CompareMeansOptions(this, this.getResString("IDS_ISTT_OPTIONS_TITLE")));
    }

    private void runBootstrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }

    private void runDefineGroupsSubDialog() {
        if (this.mTargetGroupVarList.getModel().getElementAt(0).getType() == 0) {
            this.runSubDialog(new IndSamplesDefineGroups(this));
        } else {
            this.runSubDialog(new IndSamplesDefineGroupsForStrings(this));
        }
    }
}

