/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.comp_means;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PairedVariablesDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PairedVariablesDropListener;
import com.spss.java_client.ui.dialogs.adv_stats.rep_measures.ListTraversalArrowButton;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.CompareMeansOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.PairedVariableUtility;
import com.spss.java_client.ui.dialogs.common.PairedVariablesTable;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SwapTableContentListener;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class PairedTTestDlg
extends BaseProcedureDialog
implements ActionListener,
FocusListener {
    static final String SWAP_PAIR_BUTTON = "IDS_PAIRED_TTEST_SWAP_PAIR";
    static final String IDS_OPTIONS_KEY = "IDS_PAIRED_TTEST_OPTIONS_3DOT";
    public static final String PAIRED_TARGET_LIST_KEY = "PAIRED_TTEST_TARGET_LIST";
    static final String CONF_VALUE = "95";
    private SrcVariableList mSrcVarList;
    private JButton mSwapButton;
    private ComponentsArrowButton mArrowButton;
    private Vector<Object> mTabOrder;
    private JButton mOptionsButton;
    private JButton mBootstrappingButton;
    private PairedVariablesTable mPairedTable;
    private JScrollPane mPaireTableScrollPane;
    private Border mDefaultScrollPaneBorder;
    private Border mBlueBorder = BorderFactory.createLineBorder(Color.BLUE);
    private JPanel mPanel;
    private ListTraversalArrowButton mListTraversalPanel;
    private boolean mIsBootstrapOK;

    public PairedTTestDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_PAIRED_TTEST_TITLE"));
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.clearSelection();
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        PairedVariableUtility.resetTable(this.mPairedTable);
        this.getDialogDataModel().putSerializableArray(PAIRED_TARGET_LIST_KEY, null);
        this.enableOkPaste(false);
        this.setDefaults();
        this.mSwapButton.setEnabled(false);
        this.mListTraversalPanel.resetArrowButtons();
    }

    @Override
    public String getIActionKey() {
        return "analyze_comp_means_paired_ttest";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ttpr";
    }

    @Override
    public String generateSyntax() {
        String string;
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            object = "";
            string = this.getVariableString();
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax((String)object, string, dialogDataModel));
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("T-TEST"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("PAIRS="));
        stringBuffer.append(PairedVariableUtility.getSyntaxString(this.mPairedTable, true));
        object = this.getDialogDataModel();
        string = ((DialogDataModel)object).getString("IDS_CONF_INTERVAL");
        String string2 = CONF_VALUE;
        if (string != null) {
            string2 = string;
        }
        float f = Float.parseFloat(string2);
        DecimalFormat decimalFormat = new DecimalFormat();
        String string3 = new Float(f /= 100.0f).toString();
        int n = string3.indexOf(46);
        String string4 = string3.substring(n + 1);
        decimalFormat.setMinimumFractionDigits(string4.length() + 2);
        string = decimalFormat.format(f);
        string = string.substring(1);
        string = UIToolResUtil.removeLocale((String)string);
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("CRITERIA", "CI", string));
        Boolean bl = ((DialogDataModel)object).getBoolean("IDS_EXC_CASE_LIST_RADIO");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("MISSING", "LISTWISE", false));
        } else {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("MISSING", "ANALYSIS", false));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        return stringBuffer.toString();
    }

    private String getVariableString() {
        String string = "";
        String string2 = "";
        for (int i = 0; i < this.mPairedTable.getRowCount() - 1; ++i) {
            string = string + ((ISpssVariable)this.mPairedTable.getValueAt(i, 1)).getName() + " ";
            string2 = string2 + ((ISpssVariable)this.mPairedTable.getValueAt(i, 2)).getName() + " ";
        }
        String string3 = string + " " + string2;
        return string3;
    }

    @Override
    public boolean okPastePressed() {
        if (PairedVariableUtility.isDuplicatePairAvailable(this.mPairedTable)) {
            return false;
        }
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runBootstrapSubDialog();
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (SpssArrowButton.ButtonOrientation.right != ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
            PairedVariableUtility.removeElementFromTable(this.mPairedTable, this.mSrcVarList);
        } else {
            PairedVariableUtility.addElementToTable(this.mPairedTable, this.mSrcVarList);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof SrcVariableList) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mPairedTable.setSelectionBackground(Color.lightGray);
            this.mArrowButton.setEnabled(true);
            this.enableOkPasteButton();
        } else if (focusEvent.getSource() instanceof PlainTable) {
            this.mPaireTableScrollPane.setBorder(this.mBlueBorder);
            this.enableOkPasteButton();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mPaireTableScrollPane.setBorder(this.mDefaultScrollPaneBorder);
    }

    @Override
    public void pack() {
        super.pack();
        DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), this.mSrcVarList);
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        PairedVariableUtility.validateTableData(this.getDialogDataModel());
        return super.validateDialogDataModel(bl);
    }

    protected void setDefaults() {
        this.mSrcVarList.ensureIndexIsVisible(0);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setTabPolicy();
        this.pack();
    }

    @Override
    protected void saveDialogState() {
        PairedVariableUtility.saveTableData(this.getDialogDataModel(), this.mPairedTable);
    }

    @Override
    protected void loadDialogState() {
        PairedVariableUtility.loadTableData(this.getDialogDataModel(), this.mPairedTable);
        this.validateSerializableLists();
        this.enableOkPaste(this.mPairedTable.getRowCount() > 2);
        this.setVisible(true);
    }

    @Override
    protected void validateSerializableLists() {
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PairedTTestDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.mOptionsButton.setEnabled(false);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PairedTTestDlg.this.runBootstrapSubDialog();
                }
            };
            this.mBootstrappingButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eDoNothing);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PairedTTestDlg.this.mArrowButton.doClick();
                }
            }
        });
        this.mSrcVarList.addFocusListener(this);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getResString("IDS_PAIRED_TTEST_TABLE_COL_FIRST"));
        arrayList.add(this.getResString("IDS_PAIRED_TTEST_TABLE_COL_SECOND"));
        arrayList.add(this.getResString("IDS_PAIRED_TTEST_TABLE_COL_THREE"));
        this.mPairedTable = new PairedVariablesTable(this.mSrcVarList, arrayList);
        this.mPairedTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                PairedTTestDlg.this.mOptionsButton.setEnabled(PairedTTestDlg.this.isPairTableValid());
            }
        });
        this.mPairedTable.addFocusListener(this);
        this.mPaireTableScrollPane = new JScrollPane(this.mPairedTable);
        Dimension dimension = this.mPairedTable.getPreferredSize();
        this.mPaireTableScrollPane.setPreferredSize(new Dimension(dimension.width, 215));
        this.mArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mPairedTable, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.setEnabled(false);
        this.mArrowButton.addActionListener(this);
        this.mSwapButton = new JButton();
        String string = ResUtil.getCommonDlgString("IDS_PAIR_VARIABLE_SWAP_BUTTON_IMAGE");
        URL uRL = ResUtil.getCommonDlgImageResource(string);
        this.mSwapButton.setIcon(new ImageIcon(uRL));
        this.mSwapButton.addActionListener(new SwapTableContentListener(this.mPairedTable, this.mSwapButton));
        this.mListTraversalPanel = new ListTraversalArrowButton(this.mPairedTable, false, this.mSrcVarList.getSelectionBackground());
        this.mSwapButton.setEnabled(false);
        this.mPanel = this.mListTraversalPanel.setupArrowButtonPanel();
        this.mTabOrder = new Vector();
    }

    private void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler) {
        if (component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            ListDragAdapter listDragAdapter = new ListDragAdapter(variableList, dragPane, "VariableList");
            DialogUtil.modifyMouseInputListeners(variableList, listDragAdapter);
        } else if (component instanceof PlainTable) {
            PairedVariablesDragAdapter pairedVariablesDragAdapter = new PairedVariablesDragAdapter(this.mPairedTable, dragPane, "PlainTable");
            DialogUtil.modifyMouseInputListeners(this.mPairedTable, pairedVariablesDragAdapter);
            dragPane.addDropListener((IDropListener)new PairedVariablesDropListener(this.mPairedTable, iVarMoveHandler, this.mSrcVarList));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2, iVarMoveHandler);
            }
        }
    }

    private boolean needToAddRow() {
        for (int i = 0; i < ((DefaultTableModel)this.mPairedTable.getModel()).getRowCount(); ++i) {
            for (int j = 1; j < 3; ++j) {
                Object object = this.mPairedTable.getValueAt(i, j);
                if (!(object instanceof String) || j == 2 || !((object = this.mPairedTable.getValueAt(i, j + 1)) instanceof String)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean addSingleColumn() {
        ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
        for (int i = 0; i < ((DefaultTableModel)this.mPairedTable.getModel()).getRowCount(); ++i) {
            boolean bl = false;
            for (int j = 1; j < 3; ++j) {
                Object object = this.mPairedTable.getValueAt(i, j);
                if (!(object instanceof String)) continue;
                ISpssVariable iSpssVariable = null;
                Object object2 = null;
                if (j == 1) {
                    object2 = this.mPairedTable.getValueAt(i, j + 1);
                    if (object2 instanceof ISpssVariable) {
                        bl = true;
                        iSpssVariable = (ISpssVariable)object2;
                    }
                } else if (j == 2 && (object2 = this.mPairedTable.getValueAt(i, j - 1)) instanceof ISpssVariable) {
                    bl = true;
                    iSpssVariable = (ISpssVariable)object2;
                }
                if (bl && iSpssVariable.getId().equals((Object)iSpssVariableArray[0].getId())) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_PAIRED_TTEST_TOO_SAME_VARS_WARNING"), VersionInfo.getAppVersionString());
                    int n = this.mSrcVarList.getModel().findElementIndex(iSpssVariableArray[0]);
                    this.mSrcVarList.setSelectedIndex(n);
                    return true;
                }
                this.mPairedTable.setValueAt(iSpssVariableArray[0], i, j);
                return false;
            }
        }
        return false;
    }

    private void enableOkPasteButton() {
        this.enableOkPaste(this.isPairTableValid());
    }

    private boolean isPairTableValid() {
        if (this.mPairedTable.getRowCount() == 1) {
            return false;
        }
        return PairedVariableUtility.isBlankCellAvailable(this.mPairedTable);
    }

    private JPanel setupSrcListPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        n = 23;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets3 = new Insets(insets2.top, insets2.left, insets2.bottom, insets2.right - n2);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 2, 1, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupTargetListPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PAIRED_TTEST_PAIRED_VAR_LABEL");
        jLabel.setLabelFor(this.mPairedTable);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        this.mDefaultScrollPaneBorder = this.mPaireTableScrollPane.getBorder();
        DialogUtil.addUsingGBL(jPanel, this.mPaireTableScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(20, n2 + 80, 0, n2 + 80);
        DialogUtil.addUsingGBL(jPanel, this.mSwapButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(20, n2 + 80, 0, n2 + 80);
        DialogUtil.addUsingGBL(jPanel, this.mPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(17, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupSrcListPanel(), gridBagConstraints, 0, 0, 2, 3, n, insets);
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupTargetListPanel(), gridBagConstraints, 2, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.setupButtonsPanel(), gridBagConstraints, 3, 0, 1, 1, n, insets);
    }

    private JComponent setupButtonsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(40, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(20, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSwapButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabPolicy() {
        int n;
        this.mTabOrder.add(this.mSrcVarList);
        this.mTabOrder.add(this.mArrowButton);
        this.mTabOrder.add(this.mPairedTable);
        for (n = 0; n < this.mPanel.getComponentCount(); ++n) {
            this.mTabOrder.add(this.mPanel.getComponent(n));
        }
        this.mTabOrder.add(this.mSwapButton);
        this.mTabOrder.add(this.mOptionsButton);
        if (VersionInfo.allowBootstrapping()) {
            this.mTabOrder.add(this.mBootstrappingButton);
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new CompareMeansOptions(this, this.getResString("IDS_PAIRED_TTEST_OPTIONS_TITLE")));
    }

    private void runBootstrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }
}

