/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.comp_means;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.comp_means.CompareMeansOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class OneSampleTTestDlg
extends BaseProcedureDialog
implements ListDataListener,
DocumentListener,
FocusListener {
    static final String IDS_OPTIONS_KEY = "IDS_COMMON_OPTIONS_3DOT";
    static final String TEST_VALUE = "IDS_TEST_VALUE";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetTestVarList;
    private JScrollPane mSrcLstScrollPane;
    private JScrollPane mTargetLstScrollPane;
    private ArrowButton mArrowButton;
    private JLabel mTestVarLabel;
    private JLabel mTestValLabel;
    private ContextEnabledTextField mTestValText;
    private JButton mOptionsButton;
    private JButton mBootstrappingButton;
    private boolean mIsBootstrapOK;

    public OneSampleTTestDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_ONE_SAMPLE_T_TEST"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ttss";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetTestVarList.removeAll();
        this.setDefaults();
        this.mSrcVarList.requestFocus();
        this.enableOkPaste(false);
    }

    @Override
    public String getIActionKey() {
        return "analyze_comp_means_one_ttest";
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runBootstrapSubDialog();
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string2 = this.mTargetTestVarList.getVariablesStringList();
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            string = "";
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax(string, string2, dialogDataModel));
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("T-TEST"));
        string = this.mTestValText.getText();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/TESTVAL="));
        stringBuffer.append(string);
        stringBuffer.append("\n");
        DialogDataModel dialogDataModel2 = this.getDialogDataModel();
        Boolean bl = dialogDataModel2.getBoolean("IDS_EXC_CASE_ANA_RADIO");
        if (bl == null || bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING=ANALYSIS"));
        }
        if ((bl = dialogDataModel2.getBoolean("IDS_EXC_CASE_LIST_RADIO")) != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING=LISTWISE"));
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/VARIABLES="));
        stringBuffer.append(string2);
        String string3 = dialogDataModel2.getString("IDS_CONF_INTERVAL");
        if (string3 == null) {
            string3 = CompareMeansOptions.getDefConfidenceInterval();
        }
        float f = Float.parseFloat(string3);
        int n = SyntaxUtil.getDecimalDigits(string3);
        string3 = SyntaxUtil.prepareFloatForSyntax(f /= 100.0f, n + 2);
        string3 = SyntaxUtil.removeLeadingZeros(string3);
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA=CI("));
        stringBuffer.append(string3 + ")");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        return stringBuffer.toString();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mTestValText.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetTestVarList.getModel().getSize() > 0 && this.isValidTextEntered());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetTestVarList.getModel().getSize() > 0 && this.isValidTextEntered());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetTestVarList.getModel().getSize() > 0 && this.isValidTextEntered());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.mTargetTestVarList.getModel().getSize() > 0 && this.isValidTextEntered());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.mTargetTestVarList.getModel().getSize() > 0 && this.isValidTextEntered());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.mTargetTestVarList.getModel().getSize() > 0 && this.isValidTextEntered());
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(IDS_OPTIONS_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OneSampleTTestDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OneSampleTTestDlg.this.runBootstrapSubDialog();
                }
            };
            this.mBootstrappingButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.pack();
    }

    private boolean isValidTextEntered() {
        boolean bl = false;
        String string = this.mTestValText.getText();
        if (string.length() > 0) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (!Character.isDigit(cArray[i])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.setIdentifier("OneSampleTTestSrcVarList");
        this.mSrcLstScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcLstScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTestVarLabel = DialogUtil.createLabel(this, "IDS_TEST_VARIABLES_COLON");
        this.mTargetTestVarList = new TargetVariableList();
        this.mTargetTestVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetTestVarList.setIdentifier("OneSampleTestTargetVarList");
        this.mTargetTestVarList.getModel().addListDataListener(this);
        this.mTargetTestVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetTestVarList.getFixedCellHeight() * 6 + 2));
        this.mTargetLstScrollPane = new JScrollPane(this.mTargetTestVarList);
        this.mTargetLstScrollPane.setPreferredSize(this.mTargetTestVarList.getMinimumSize());
        this.mTestVarLabel.setLabelFor(this.mTargetTestVarList);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetTestVarList, SpssArrowButton.ButtonOrientation.left);
        TextFieldAction textFieldAction = new TextFieldAction(this, TEST_VALUE);
        this.mTestValText = new ContextEnabledTextField();
        this.mTestValText.setColumns(4);
        this.mTestValText.setAction((Action)textFieldAction);
        this.mTestValText.setDocument((Document)new FixedLengthNumericDocument(19, false, true));
        this.mTestValText.getDocument().addDocumentListener(this);
        this.mTestValText.addFocusListener((FocusListener)this);
        this.mTestValLabel = DialogUtil.createLabel(this, "IDS_TEST_VALUE_COLON");
        this.mTestValLabel.setLabelFor((Component)this.mTestValText);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        String string = "0";
        this.mTestValText.setText(string);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetTestVarList);
        vector.add(this.mTestValText);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ONE_SAMPLE_T_TEST_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcLstScrollPane, gridBagConstraints, 0, 1, 1, 2, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mTestVarLabel, gridBagConstraints, 2, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetLstScrollPane, gridBagConstraints, 2, 1, 2, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 0;
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTestValLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 25;
        gridBagConstraints.fill = 0;
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTestValText, gridBagConstraints, 3, 2, 1, 1, n, insets);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new CompareMeansOptions(this, this.getResString("IDS_ONE_SAMPLE_T_TEST_OPTIONS_TITLE")));
    }

    private void runBootstrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }
}

