/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.two_step_cluster;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TwoStepClusterPlots
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String IDS_PERCENTAGE_CHART_KEY = "IDS_PERCENTAGE_CHART";
    static final String IDS_PIE_CHART_KEY = "IDS_PIE_CHART";
    static final String IDS_RANK_KEY = "IDS_RANK";
    static final String IDS_CLUSTER_RADIO_KEY = "IDS_CLUSTER_RADIO";
    static final String IDS_VARIABLE_RADIO_KEY = "IDS_VARIABLE_RADIO";
    static final String IDS_CHI_SQUARE_RADIO_KEY = "IDS_CHI_SQUARE_RADIO";
    static final String IDS_SIGNIFICANCE_RADIO_KEY = "IDS_SIGNIFICANCE_RADIO";
    static final String IDS_CONFIDENCE_LEVEL_KEY = "IDS_CONFIDENCE_LEVEL";
    static final String IDS_OMIT_VARIABLES_KEY = "IDS_OMIT_VARIABLES";
    static final String CONFIDENCE_EDIT_KEY = "IDS_CONFIDENCE_EDIT";
    static final Integer PERCENTAGE = 95;
    private JPanel mRankPanel;
    private JPanel mImpMeasurePanel;
    private JPanel mImpPlotPanel;
    private JRadioButton mClusterRadio;
    private JRadioButton mVarRadio;
    private JRadioButton mChiSquareRadio;
    private JRadioButton mSignificanceRadio;
    private SpssButtonGroup mMeasureRadioGroup;
    private SpssButtonGroup mRankRadioGroup;
    private SpssButtonGroup mClusterCheckBoxGroup;
    private JCheckBox mClustCentChart;
    private JCheckBox mClustPieChart;
    private JCheckBox mRankOfVarImp;
    private JCheckBox mConfidenceLevel;
    private JCheckBox mOmitVar;
    private JLabel mPercentLabel;
    private IntTextField mPercentageText;
    private Font mFont;

    public TwoStepClusterPlots(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TWO_STEP_CLUSTER_PLOTS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2;
        Object object = itemEvent.getItem();
        boolean bl3 = bl2 = itemEvent.getStateChange() == 1;
        if (object == this.mRankOfVarImp) {
            bl = this.mConfidenceLevel.isSelected();
            this.mConfidenceLevel.setEnabled(bl2);
            this.mClusterRadio.setEnabled(bl2);
            this.mVarRadio.setEnabled(bl2);
            this.mChiSquareRadio.setEnabled(bl2);
            this.mSignificanceRadio.setEnabled(bl2);
            this.mPercentLabel.setEnabled(bl2 && bl);
            this.mPercentageText.setEnabled(bl2 && bl);
            this.mPercentageText.setOpaque(bl2 && bl);
            this.mOmitVar.setEnabled(bl2 && bl);
            if (bl2) {
                this.enableContinue(bl ? this.mPercentageText.getText().length() != 0 : true);
            } else {
                this.enableContinue(true);
            }
        }
        if (object == this.mConfidenceLevel) {
            bl = this.mConfidenceLevel.isEnabled();
            this.mPercentLabel.setEnabled(bl2 && bl);
            this.mPercentageText.setEnabled(bl2 && bl);
            this.mPercentageText.setOpaque(bl2 && bl);
            this.mOmitVar.setEnabled(bl2 && bl);
            if (bl2 && bl) {
                this.enableContinue(this.mPercentageText.getText().length() != 0);
            } else {
                this.enableContinue(true);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mPercentageText.getText().length() != 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mPercentageText.getText().length() != 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mPercentageText.getText().length() != 0);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_twostep_plots";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mClustCentChart, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mClustPieChart, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mImpPlotPanel = this.setupImpPlotPanel();
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        JTextArea jTextArea = new JTextArea(this.getResString("ERR_SELECTION_WARNING"));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(this.mFont);
        jTextArea.setFocusable(false);
        jTextArea.setRows(2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mImpPlotPanel, gridBagConstraints, 0, 2, 2, -1, n, insets2);
        insets2 = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        this.pack();
    }

    private void initVars() {
        this.mMeasureRadioGroup = new SpssButtonGroup();
        this.mRankRadioGroup = new SpssButtonGroup();
        this.mClusterCheckBoxGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_PERCENTAGE_CHART_KEY);
        this.mClustCentChart = new JCheckBox(toggleButtonAction);
        this.mClusterCheckBoxGroup.add(this.mClustCentChart);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_PIE_CHART_KEY);
        this.mClustPieChart = new JCheckBox(toggleButtonAction);
        this.mClusterCheckBoxGroup.add(this.mClustPieChart);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_RANK_KEY);
        this.mRankOfVarImp = new JCheckBox(toggleButtonAction);
        this.mRankOfVarImp.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_CLUSTER_RADIO_KEY);
        this.mClusterRadio = new JRadioButton(toggleButtonAction);
        this.mClusterRadio.setSelected(true);
        this.mClusterRadio.setEnabled(false);
        this.mRankRadioGroup.add(this.mClusterRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_VARIABLE_RADIO_KEY);
        this.mVarRadio = new JRadioButton(toggleButtonAction);
        this.mVarRadio.setEnabled(false);
        this.mRankRadioGroup.add(this.mVarRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_CHI_SQUARE_RADIO_KEY);
        this.mChiSquareRadio = new JRadioButton(toggleButtonAction);
        this.mChiSquareRadio.setSelected(true);
        this.mChiSquareRadio.setEnabled(false);
        this.mMeasureRadioGroup.add(this.mChiSquareRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_SIGNIFICANCE_RADIO_KEY);
        this.mSignificanceRadio = new JRadioButton(toggleButtonAction);
        this.mSignificanceRadio.setEnabled(false);
        this.mMeasureRadioGroup.add(this.mSignificanceRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_CONFIDENCE_LEVEL_KEY);
        this.mConfidenceLevel = new JCheckBox(toggleButtonAction);
        this.mConfidenceLevel.setEnabled(false);
        this.mConfidenceLevel.setEnabled(false);
        this.mConfidenceLevel.addItemListener(this);
        this.mPercentLabel = DialogUtil.createLabel(this, "IDS_PERCENTAGE_COLON");
        this.mPercentLabel.setEnabled(false);
        this.mFont = this.mPercentLabel.getFont();
        this.mPercentageText = new IntTextField(50, 99, true);
        this.mPercentageText.setText(PERCENTAGE.toString());
        this.mPercentageText.getDocument().addDocumentListener(this);
        this.mPercentageText.setPreferredSize((Dimension)this.mPercentageText.getPreferredSize().clone());
        this.mPercentageText.setAction((Action)new TextFieldAction(this.mParentDlg, CONFIDENCE_EDIT_KEY));
        this.mPercentageText.setEnabled(false);
        this.mPercentageText.setOpaque(false);
        this.mPercentLabel.setLabelFor((Component)this.mPercentageText);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_OMIT_VARIABLES_KEY);
        this.mOmitVar = new JCheckBox(toggleButtonAction);
        this.mOmitVar.setEnabled(false);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mClustCentChart);
        vector.add(this.mClustPieChart);
        vector.add(this.mRankOfVarImp);
        vector.add(this.mRankRadioGroup);
        vector.add(this.mMeasureRadioGroup);
        vector.add(this.mConfidenceLevel);
        vector.add(this.mPercentageText);
        vector.add(this.mOmitVar);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setupImpPlotPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_VARIABLE_PLOT"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        this.mRankPanel = this.setupRankPanel();
        this.mImpMeasurePanel = this.setupImpMeasurePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mRankOfVarImp, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() * 3, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mRankPanel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mImpMeasurePanel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.setupConfiOmitPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupRankPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mClusterRadio, this.mVarRadio};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_RANK_VARIABLES"), 2);
        return jPanel;
    }

    private JPanel setupImpMeasurePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mChiSquareRadio, this.mSignificanceRadio};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_IMPORTANCE_MEASURE"), 2);
        return jPanel;
    }

    private JPanel setupConfiOmitPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceLevel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(insets.top, insets.left * 12, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupPercentagePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mOmitVar, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupPercentagePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets2 = new Insets(insets.top, 0, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPercentLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPercentageText, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }
}

