/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.two_step_cluster;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.classify.two_step_cluster.TwoStepClusterDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class TwoStepClusterOutput
extends BaseSubDialog
implements ItemListener,
ActionListener,
DocumentListener,
ListDataListener,
ListSelectionListener {
    static final String XML_FILE_EXT = ".xml";
    static final String IDS_IVOT_TABLE_CHECK_KEY = "IDS_PIVOT_TABLES_CHECK";
    static final String IDS_CHARTS_AND_TABLES_KEY = "IDS_CHARTS_AND_TABLES";
    static final String IDS_CREATE_CLUST_VAR_KEY = "IDS_CREATE_CLUST_VAR";
    static final String IDS_EXPORT_FINAL_MODEL_KEY = "IDS_EXPORT_FINAL_MODEL";
    static final String IDS_EXPORT_CF_TREE_KEY = "IDS_EXPORT_CF_TREE";
    public static final String MODEL_SUFFIX = "_MODEL";
    public static final String CF_SUFFIX = "_CF";
    static final String IDS_BROWSE_3_DOT_KEY = "IDS_BROWSE_3_DOT";
    static final String IDS_BROWSE_3DOT_KEY = "IDS_BROWSE_3DOT";
    private JCheckBox mPivotTableCheck;
    private JCheckBox mChartTableCheck;
    private JCheckBox mClustVarCheck;
    private JCheckBox mExportModel;
    private JCheckBox mExportCFTree;
    private JButton mBrowseButton1;
    private JButton mBrowseButton2;
    private JLabel mModelNameLabel;
    private JLabel CFTreeNameLabel;
    private FileTextField mModelName;
    private FileTextField mCFTreeName;
    private JLabel mChartTableLbl1;
    private JLabel mChartTableLbl2;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private ArrowButton mEvalArrow;
    static final String TARGETLIST1KEY = "TARGET_LIST_EVAL";
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private JPanel mEvalPanel;

    public TwoStepClusterOutput(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TWO_STEP_CLUSTER_OUTPUT_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (!RemoteFileChooser.enableSaveInModeler()) {
            bl = false;
        }
        if (object == this.mExportModel) {
            this.mModelNameLabel.setEnabled(bl);
            this.mModelName.setEnabled(bl);
            this.mModelName.setOpaque(bl);
            this.mBrowseButton1.setEnabled(bl);
        }
        if (object == this.mExportCFTree) {
            this.CFTreeNameLabel.setEnabled(bl);
            this.mCFTreeName.setEnabled(bl);
            this.mCFTreeName.setOpaque(bl);
            this.mBrowseButton2.setEnabled(bl);
        }
        if (object == this.mChartTableCheck) {
            this.setComponentEnableState(this.mEvalPanel, bl);
        }
        this.enableContinueButton();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
            remoteFileChooser.setDialogTitle(this.getResString("IDS_SAVE_TO_FILE"));
            RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_TWOSTEP_XML_FILE_FILTER"), this.getResString("IDS_TWOSTEP_XML_FILE_EXT"));
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            remoteFileChooser.setApproveButtonText(this.getResString("IDS_SAVE_BUTTON"));
            if (actionEvent.getSource() == this.mBrowseButton1) {
                remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
                int n = remoteFileChooser.showSaveDialog((Component)((Object)this.mParentDlg));
                if (n == 0) {
                    String string = remoteFileChooser.getSelectedFilePath();
                    FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    if (!XML_FILE_EXT.regionMatches(true, 0, string, string.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) {
                        this.mModelName.setText(string + XML_FILE_EXT);
                    } else {
                        this.mModelName.setText(string);
                    }
                }
            } else if (actionEvent.getSource() == this.mBrowseButton2) {
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                int n = remoteFileChooser.showSaveDialog((Component)((Object)this.mParentDlg));
                if (n == 0) {
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!XML_FILE_EXT.regionMatches(true, 0, string, string.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length())) {
                        this.mCFTreeName.setText(string + XML_FILE_EXT);
                    } else {
                        this.mCFTreeName.setText(string);
                    }
                }
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_twostep_output";
    }

    @Override
    public boolean continuePressed() {
        if (this.mExportModel.isSelected() && this.mExportCFTree.isSelected() && this.mModelName.getText().equalsIgnoreCase(this.mCFTreeName.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_UNIQUE_WARNING"), VersionInfo.getAppVersionString());
            this.mCFTreeName.requestFocus();
            return false;
        }
        if (!CommandLine.isClementineCaller() || RemoteFileChooser.getFileBrowseCallback() != null) {
            if (this.mExportModel.isSelected() && !FileValidator.validatePath((Component)((Object)this), this.mModelName.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())) {
                return false;
            }
            if (this.mExportCFTree.isSelected() && !FileValidator.validatePath((Component)((Object)this), this.mCFTreeName.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupModelViewerPanel();
        JPanel jPanel3 = this.setupDataFilePanel();
        JPanel jPanel4 = this.setupXmlFilesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.createButtonGroup(jPanel2);
        DialogUtil.createButtonGroup(jPanel4);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, null);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
            this.mClustVarCheck.setEnabled(false);
            this.mExportCFTree.setEnabled(false);
            this.mExportModel.setEnabled(false);
            boolean bl = dialogDataModel.getSafeString("EXPORT_XML_FILE_PATH_MODEL").length() > 0;
            this.mExportModel.setSelected(bl);
        }
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_IVOT_TABLE_CHECK_KEY);
        this.mPivotTableCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_CHARTS_AND_TABLES_KEY);
        this.mChartTableCheck = new JCheckBox(toggleButtonAction);
        this.mChartTableCheck.setSelected(true);
        this.mChartTableCheck.addItemListener(this);
        this.mChartTableLbl1 = DialogUtil.createLabel(this, "IDS_MODEL_DESCRIPTION1");
        this.mChartTableLbl2 = DialogUtil.createLabel(this, "IDS_MODEL_DESCRIPTION2");
        SrcVariableList srcVariableList = ((TwoStepClusterDlg)((Object)this.getParent())).getSourceVarList();
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("OutputSrcList");
        VarListModel varListModel = this.mSrcVarList.getModel();
        VarListModel varListModel2 = srcVariableList.getModel();
        int n = varListModel2.getSize();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                varListModel.addElement(varListModel2.getElementAt(i));
            }
        }
        Dimension dimension = this.mSrcVarList.getMinimumSize();
        this.mSrcVarList.setMinimumSize(new Dimension(dimension.width, dimension.height * 2 / 3));
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setIdentifier(TARGETLIST1KEY);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mEvalArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mEvalArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mEvalArrow.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_CREATE_CLUST_VAR_KEY);
        this.mClustVarCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_EXPORT_FINAL_MODEL_KEY);
        this.mExportModel = new JCheckBox(toggleButtonAction);
        this.mExportModel.addItemListener(this);
        this.mModelNameLabel = DialogUtil.createLabel(this, "IDS_NAME_COLON");
        this.mModelNameLabel.setEnabled(false);
        this.mModelName = new FileTextField();
        this.mModelName.setPreferredSize(this.mModelName.getPreferredSize());
        this.mModelName.setAction(new TextFieldAction(this.mParentDlg, "EXPORT_XML_FILE_PATH_MODEL"));
        this.mModelName.setEnabled(false);
        this.mModelName.setOpaque(false);
        this.mModelName.setColumns(20);
        if (this.mModelName.getDocument() != null) {
            this.mModelName.getDocument().addDocumentListener(this);
        }
        this.mModelNameLabel.setLabelFor((Component)((Object)this.mModelName));
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_EXPORT_CF_TREE_KEY);
        this.mExportCFTree = new JCheckBox(toggleButtonAction);
        this.mExportCFTree.addItemListener(this);
        this.CFTreeNameLabel = DialogUtil.createLabel(this, "IDS_EXT_CF_TREE_NAME_COLON");
        this.CFTreeNameLabel.setEnabled(false);
        this.mCFTreeName = new FileTextField();
        this.mCFTreeName.setAction(new TextFieldAction(this.mParentDlg, "EXPORT_XML_FILE_PATH_CF"));
        this.mCFTreeName.setPreferredSize(this.mCFTreeName.getPreferredSize());
        this.mCFTreeName.setEnabled(false);
        this.mCFTreeName.setOpaque(false);
        this.mCFTreeName.setColumns(20);
        if (this.mCFTreeName.getDocument() != null) {
            this.mCFTreeName.getDocument().addDocumentListener(this);
        }
        this.CFTreeNameLabel.setLabelFor((Component)((Object)this.mCFTreeName));
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_BROWSE_3_DOT_KEY);
        this.mBrowseButton1 = new JButton(toggleButtonAction);
        this.mBrowseButton1.setEnabled(false);
        this.mBrowseButton1.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_BROWSE_3DOT_KEY);
        this.mBrowseButton2 = new JButton(toggleButtonAction);
        this.mBrowseButton2.setEnabled(false);
        this.mBrowseButton2.addActionListener(this);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mSrcVarList.requestFocus();
        if (this.mSrcVarList.getModel().getElementAt(0) != null) {
            this.mSrcVarList.setSelectedIndex(0);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPivotTableCheck);
        vector.add(this.mChartTableCheck);
        vector.add(this.mSrcVarList);
        vector.add(this.mEvalArrow);
        vector.add(this.mTargetVarList);
        vector.add(this.mClustVarCheck);
        vector.add(this.mExportModel);
        vector.add(this.mModelName);
        vector.add(this.mBrowseButton1);
        vector.add(this.mExportCFTree);
        vector.add(this.mCFTreeName);
        vector.add(this.mBrowseButton2);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setupModelViewerPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TWO_STEP_MODEL_VIEWER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() * 3, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPivotTableCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mChartTableCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mChartTableLbl1, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mChartTableLbl2, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        this.mEvalPanel = this.setupLists();
        DialogUtil.addUsingGBL(jPanel, this.mEvalPanel, gridBagConstraints, 0, 4, 1, 1, n, new Insets(5, DialogUtil.getComponentGroupGap() * 3, 5, 0));
        return jPanel;
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TWO_STEP_VARIABLES_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 3, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mEvalArrow, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_TWO_STEP_EVALUATION_FIELDS_LABEL");
        jLabel2.setLabelFor(this.mTargetVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Insets insets3 = new Insets(0, 0, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupDataFilePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_WORKING_DATA_FILE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mClustVarCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupXmlFilesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_XML_FILES"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() * 3, 0, 0);
        Insets insets3 = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mExportModel, gridBagConstraints, 0, 0, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mModelNameLabel, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mModelName), gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton1, gridBagConstraints, 3, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mExportCFTree, gridBagConstraints, 0, 2, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.CFTreeNameLabel, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mCFTreeName), gridBagConstraints, 2, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton2, gridBagConstraints, 3, 3, 1, 1, n, insets3);
        return jPanel;
    }

    private void enableContinueButton() {
        boolean bl = true;
        if (this.mExportModel.isSelected()) {
            boolean bl2 = bl = this.mModelName.getText().length() != 0;
        }
        if (this.mExportCFTree.isSelected()) {
            bl &= this.mCFTreeName.getText().length() != 0;
        }
        this.enableContinue(bl);
    }
}

