/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.two_step_cluster;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.classify.two_step_cluster.TwoStepClusterDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.TraceSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class TwoStepClusterOptions
extends BaseSubDialog
implements ItemListener,
KeyListener,
ActionListener,
DocumentListener {
    static final String IDS_NOISE_HANDLING_KEY = "IDS_NOISE_HANDLING";
    static final String IDS_IMPORT_CF_TREE_KEY = "IDS_IMPORT_CF_TREE";
    static final String NOISE_EDIT_KEY = "IDS_NOISE_EDIT";
    static final String MEMORY_EDIT_KEY = "IDS_MEMORY_EDIT";
    static final String IDS_ADVANCED_FORWARD_ARROW_KEY = "IDS_ADVANCED_FORWARD_ARROW";
    static final String IDS_ADVANCED_BACKWARD_ARROW_KEY = "IDS_ADVANCED_BACKWARD_ARROW";
    static final String THRESHOLD_EDIT_KEY = "IDS_THRESHOLD_EDIT";
    static final String MXBRANCH_EDIT_KEY = "IDS_MXBRANCH_EDIT";
    static final String MXDEPTH_EDIT_KEY = "IDS_MXDEPTH_EDIT";
    static final String IMPORT_CF_TREE_EDIT_KEY = "IDS_IMPORT_CF_TREE_EDIT";
    static final String IDS_BROWSE_3DOT_KEY = "IDS_BROWSE_3DOT";
    static final String SOURCE_LIST_KEY = "IDS_SOURCE_LIST";
    static final String TARGET_LIST_KEY = "IDS_TARGET_LIST";
    static final String PANEL_STATE_KEY = "IDS_PANEL";
    static final String BUTTON_LABEL_KEY = "IDS_BUTTON_LABEL";
    static final String MAX_NUM_NODES = "IDS_MAX_NUM_NODES";
    static final Integer NOISE = 25;
    static final Integer MEMORY = 64;
    static final Integer THRESHOLD = 0;
    static final Integer MAXBRANCHES = 8;
    static final Integer MAXTREEDEPTH = 3;
    static final Integer MAXNODES = 585;
    static final Integer MAX_NUMBER_OF_NODES = 100000000;
    static TargetVariableList mTargetVarList;
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private ArrowButton mArrowButton;
    private JPanel mCFTreePanel;
    private JPanel mClusterModelPanel;
    private JCheckBox mNoiseCheck;
    private JLabel mNoiseLabel;
    private IntTextField mNoiseEdit;
    private FloatTextField mThreshold;
    private IntTextField mMxBranch;
    private IntTextField mMxDepth;
    private IntTextField mMemoryValue;
    private JTextField mMaxNodes;
    private JLabel mMaxNodesLabel;
    private JButton mAdvancedButton;
    private JCheckBox mImportCFTreeCheck;
    private JLabel mCFTreeNamelabel;
    private FileTextField mCFTreeNameText;
    private JButton mBrowseButton;
    private DialogFocusTraversalPolicy mPolicyOnAdvanceButtonMaximised;
    private DialogFocusTraversalPolicy mPolicyOnAdvanceButtonMinimised;

    public TwoStepClusterOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TWO_STEP_CLUSTER_OPTIONS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.updateMaxNodeField();
    }

    private void updateMaxNodeField() {
        if (!this.mMxBranch.getText().equals("") && !this.mMxDepth.getText().equals("")) {
            int n = Integer.parseInt(this.mMxDepth.getText());
            int n2 = Integer.parseInt(this.mMxBranch.getText());
            if (n <= 9999) {
                int n3 = 1;
                if (n2 <= 9 || n <= 9) {
                    if (n2 > 3) {
                        int n4 = 1;
                        for (int i = 0; i < n; ++i) {
                            n3 += (n4 *= n2);
                        }
                        if (n3 < 0 || n3 > MAX_NUMBER_OF_NODES) {
                            this.mMaxNodes.setText(this.getResString("IDS_GT_HUNDRED_MILLION"));
                        } else {
                            this.mMaxNodes.setText("" + n3);
                        }
                    } else {
                        this.mMaxNodes.setText("");
                    }
                } else {
                    this.mMaxNodes.setText(this.getResString("IDS_GT_HUNDRED_MILLION"));
                }
            } else {
                this.mMaxNodes.setText(this.getResString("IDS_GT_HUNDRED_MILLION"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mBrowseButton) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
            remoteFileChooser.setDialogTitle(this.getResString("IDS_READ_FILE"));
            RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_TWOSTEP_XML_FILE_FILTER"), this.getResString("IDS_TWOSTEP_XML_FILE_EXT"));
            remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
            remoteFileChooser.setApproveButtonText(this.getResString("IDS_OPEN_BUTTON"));
            int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mParentDlg));
            if (n == 0) {
                File file = remoteFileChooser.getSelectedFile();
                remoteFileChooser.setCurrentDirectory(file);
                FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                this.mCFTreeNameText.setText(remoteFileChooser.getSelectedFilePath());
            } else {
                TraceSettings.trace1((String)"No Selection", (int)15);
            }
        } else if (actionEvent.getSource() == this.mAdvancedButton) {
            if (this.mAdvancedButton.getText().equals(this.mParentDlg.getResString(IDS_ADVANCED_FORWARD_ARROW_KEY))) {
                ((JButton)actionEvent.getSource()).setText(this.mParentDlg.getResString(IDS_ADVANCED_BACKWARD_ARROW_KEY));
                this.mCFTreePanel.setVisible(true);
                this.mClusterModelPanel.setVisible(true);
                this.setFocusTraversalPolicy(this.mPolicyOnAdvanceButtonMaximised);
            } else if (this.mAdvancedButton.getText().equals(this.mParentDlg.getResString(IDS_ADVANCED_BACKWARD_ARROW_KEY))) {
                ((JButton)actionEvent.getSource()).setText(this.mParentDlg.getResString(IDS_ADVANCED_FORWARD_ARROW_KEY));
                this.mCFTreePanel.setVisible(false);
                this.mClusterModelPanel.setVisible(false);
                this.setFocusTraversalPolicy(this.mPolicyOnAdvanceButtonMinimised);
            }
            this.pack();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mNoiseCheck) {
            this.mNoiseEdit.setEnabled(bl);
            this.mNoiseEdit.setOpaque(bl);
            this.mNoiseLabel.setEnabled(bl);
        }
        if (object == this.mImportCFTreeCheck) {
            this.mCFTreeNamelabel.setEnabled(bl);
            this.mCFTreeNameText.setEnabled(bl);
            this.mCFTreeNameText.setOpaque(bl);
            this.mBrowseButton.setEnabled(bl);
            if (this.mCFTreeNameText.getText().length() == 0) {
                this.enableContinue(!bl);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl;
        boolean bl2 = bl = this.mThreshold.getDocument().getLength() > 0 && this.mMxBranch.getDocument().getLength() > 0 && this.mMxDepth.getDocument().getLength() > 0 && this.mMemoryValue.getDocument().getLength() > 0;
        if (this.mNoiseCheck.isSelected()) {
            this.enableContinue(this.mNoiseEdit.getDocument().getLength() > 0 && bl);
        } else {
            this.enableContinue(bl);
        }
        if (documentEvent.getDocument() == this.mMxDepth.getDocument() || documentEvent.getDocument() == this.mMxBranch.getDocument()) {
            this.updateMaxNodeField();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        boolean bl;
        boolean bl2 = bl = this.mThreshold.getDocument().getLength() > 0 && this.mMxBranch.getDocument().getLength() > 0 && this.mMxDepth.getDocument().getLength() > 0 && this.mMemoryValue.getDocument().getLength() > 0;
        if (this.mNoiseCheck.isSelected()) {
            this.enableContinue(this.mNoiseEdit.getDocument().getLength() > 0 && bl);
        } else {
            this.enableContinue(bl);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        boolean bl;
        boolean bl2 = bl = this.mThreshold.getDocument().getLength() > 0 && this.mMxBranch.getDocument().getLength() > 0 && this.mMxDepth.getDocument().getLength() > 0 && this.mMemoryValue.getDocument().getLength() > 0;
        if (this.mNoiseCheck.isSelected()) {
            this.enableContinue(this.mNoiseEdit.getDocument().getLength() > 0 && bl);
        } else {
            this.enableContinue(bl);
        }
    }

    @Override
    public boolean continuePressed() {
        short s;
        super.continuePressed();
        if (this.mImportCFTreeCheck.isSelected() && (s = FileValidator.evaluateOpenFile((Component)((Object)this), this.mCFTreeNameText.getText(), false, true)) == 5) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), String.format(this.getResString("ERR_INVALID_FILE_MSG"), FileValidator.addDirectoryPath(this.mCFTreeNameText.getText())), VersionInfo.getAppVersionString());
            this.mCFTreeNameText.requestFocus();
            this.mCFTreeNameText.selectAll();
            return false;
        }
        TwoStepClusterDlg.mAssumedStd.setText(Integer.valueOf(mTargetVarList.getModel().getSize()).toString());
        TwoStepClusterDlg.mToBeStd.setText(Integer.valueOf(this.mSrcVarList.getModel().getSize()).toString());
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_twostep_options";
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        if (this.mCFTreePanel.isVisible() && this.mClusterModelPanel.isVisible()) {
            dialogDataModel.putBoolean(PANEL_STATE_KEY, true);
        } else {
            dialogDataModel.putBoolean(PANEL_STATE_KEY, false);
        }
        dialogDataModel.putString(BUTTON_LABEL_KEY, this.mAdvancedButton.getText());
        dialogDataModel.putString(MAX_NUM_NODES, this.mMaxNodes.getText());
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        Boolean bl = dialogDataModel.getBoolean(PANEL_STATE_KEY);
        if (bl != null) {
            if (bl.booleanValue()) {
                this.mCFTreePanel.setVisible(true);
                this.mClusterModelPanel.setVisible(true);
            } else {
                this.mCFTreePanel.setVisible(false);
                this.mClusterModelPanel.setVisible(false);
            }
            this.mAdvancedButton.setText(dialogDataModel.getString(BUTTON_LABEL_KEY));
            this.mMaxNodes.setText(dialogDataModel.getString(MAX_NUM_NODES));
            if (this.mAdvancedButton.getText().equals(this.getResString(IDS_ADVANCED_FORWARD_ARROW_KEY))) {
                this.setFocusTraversalPolicy(this.mPolicyOnAdvanceButtonMinimised);
            } else {
                this.setFocusTraversalPolicy(this.mPolicyOnAdvanceButtonMaximised);
            }
            this.pack();
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNoiseCheck);
        vector.add(this.mNoiseEdit);
        vector.add(this.mMemoryValue);
        vector.add(mTargetVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mSrcVarList);
        vector.add(this.mAdvancedButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.mPolicyOnAdvanceButtonMinimised = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(this.mPolicyOnAdvanceButtonMinimised);
        this.mPolicyOnAdvanceButtonMaximised = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupOutlierPanel();
        JPanel jPanel3 = this.setupMemoryPanel();
        this.setupListsPanel(jPanel);
        this.mCFTreePanel = this.setupCFTreePanel();
        this.mClusterModelPanel = this.setupClusterModelPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mAdvancedButton, gridBagConstraints, 0, 2, 1, 1, 23, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = new Insets(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, insets2);
        insets2.set(0, 0, DialogUtil.getComponentGroupGap(), 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, 23, insets2);
        insets2.set(DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap(), 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCFTreePanel, gridBagConstraints, 0, 3, 2, 1, 23, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mClusterModelPanel, gridBagConstraints, 0, 4, 2, 1, 23, null);
        this.mCFTreePanel.setVisible(false);
        this.mClusterModelPanel.setVisible(false);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mImportCFTreeCheck.setEnabled(false);
        }
        this.pack();
    }

    @Override
    public void pack() {
        super.pack();
        Dimension dimension = this.getSize();
        this.setSizeConstraints(dimension);
    }

    private void initVars() {
        Object object;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_NOISE_HANDLING_KEY);
        this.mNoiseCheck = new JCheckBox(toggleButtonAction);
        this.mNoiseCheck.addItemListener(this);
        this.mNoiseLabel = DialogUtil.createLabel(this, "IDS_PERCENTAGE_COLON");
        this.mNoiseLabel.setEnabled(false);
        this.mNoiseLabel.setOpaque(false);
        this.mNoiseEdit = new IntTextField(0, 99, true);
        this.mNoiseEdit.setText(NOISE.toString());
        this.mNoiseEdit.setPreferredSize((Dimension)this.mNoiseEdit.getPreferredSize().clone());
        this.mNoiseEdit.setAction((Action)new TextFieldAction(this.mParentDlg, NOISE_EDIT_KEY));
        this.mNoiseEdit.setEnabled(false);
        this.mNoiseEdit.setOpaque(false);
        this.mNoiseEdit.getDocument().addDocumentListener(this);
        this.mNoiseLabel.setLabelFor((Component)this.mNoiseEdit);
        this.mMemoryValue = new IntTextField(4, 99999, true);
        this.mMemoryValue.setText(MEMORY.toString());
        this.mMemoryValue.setAction((Action)new TextFieldAction(this.mParentDlg, MEMORY_EDIT_KEY));
        this.mMemoryValue.setPreferredSize(this.mMemoryValue.getPreferredSize());
        this.mMemoryValue.getDocument().addDocumentListener(this);
        this.mSrcVarList = new SrcVariableList();
        mTargetVarList = new TargetVariableList();
        this.mSrcVarList.setIdentifier(SOURCE_LIST_KEY);
        mTargetVarList.setIdentifier(TARGET_LIST_KEY);
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(this.mSrcVarList.getIdentifier());
        ISpssVariable iSpssVariable = dialogDataModel.getVarArray(mTargetVarList.getIdentifier());
        VarListModel varListModel = TwoStepClusterDlg.mTargetVarList2.getModel();
        Integer n = varListModel.getSize();
        if (iSpssVariableArray == null && iSpssVariable == null) {
            object = new ISpssVariable[n.intValue()];
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable2;
                object[i] = iSpssVariable2 = varListModel.getElementAt(i);
            }
            dialogDataModel.putVarArray(this.mSrcVarList.getIdentifier(), (ISpssVariable[])object);
        } else {
            ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
            ArrayList<ISpssVariable> arrayList2 = new ArrayList<ISpssVariable>();
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (iSpssDataSrc == null) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                object = false;
                Boolean bl = false;
                ISpssVariable iSpssVariable3 = varListModel.getElementAt(i);
                if (iSpssVariable != null) {
                    for (ISpssVariable iSpssVariable4 : iSpssVariable) {
                        if (!iSpssVariable3.equals(iSpssVariable4)) continue;
                        arrayList2.add(iSpssVariable4);
                        bl = true;
                        break;
                    }
                }
                if (bl.booleanValue() || iSpssVariableArray == null) continue;
                for (ISpssVariable iSpssVariable4 : iSpssVariableArray) {
                    if (!iSpssVariable3.equals(iSpssVariable4)) continue;
                    arrayList.add(iSpssVariable4);
                    object = true;
                    break;
                }
                if (((Boolean)object).booleanValue()) continue;
                ISpssVariable iSpssVariable5 = varListModel.getElementAt(i);
                arrayList.add(iSpssVariable5);
            }
            ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                iSpssVariableArray2[i] = (ISpssVariable)arrayList.get(i);
            }
            ISpssVariable[] iSpssVariableArray3 = new ISpssVariable[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                iSpssVariableArray3[i] = (ISpssVariable)arrayList2.get(i);
            }
            dialogDataModel.putVarArray(this.mSrcVarList.getIdentifier(), iSpssVariableArray2);
            dialogDataModel.putVarArray(mTargetVarList.getIdentifier(), iSpssVariableArray3);
        }
        this.mTargetScrollPane = new JScrollPane(mTargetVarList);
        mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), mTargetVarList.getFixedCellHeight() * 4 + 2));
        this.mTargetScrollPane.setPreferredSize(mTargetVarList.getMinimumSize());
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(mTargetVarList.getMinimumSize());
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.registerVariableList(mTargetVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.setEnabled(false);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this.mParentDlg, IDS_ADVANCED_FORWARD_ARROW_KEY);
        this.mAdvancedButton = new JButton(toggleButtonAction2);
        this.mAdvancedButton.addActionListener(this);
        this.mThreshold = new FloatTextField(0.0, 1.0, 5, true);
        this.mThreshold.setColumns(5);
        this.mThreshold.setText(THRESHOLD.toString());
        this.mThreshold.setMinimumSize(this.mThreshold.getPreferredSize());
        this.mThreshold.setAction((Action)new TextFieldAction(this.mParentDlg, THRESHOLD_EDIT_KEY));
        this.mThreshold.getDocument().addDocumentListener(this);
        this.mMaxNodesLabel = new JLabel(this.getResString("IDS_MAXIMUM_NO_OF_NODES"), 2);
        this.mMaxNodes = new JTextField(MAXNODES.toString());
        this.mMaxNodes.setEditable(false);
        this.mMaxNodes.setEnabled(true);
        object = new Dimension(this.mMaxNodes.getPreferredSize());
        ((Dimension)object).width = (int)(1.5 * (double)this.mThreshold.getPreferredSize().width);
        this.mMaxNodes.setPreferredSize((Dimension)object);
        this.mMaxNodesLabel.setLabelFor(this.mMaxNodes);
        this.mMxBranch = new IntTextField(4, 9999, true);
        this.mMxBranch.setColumns(3);
        this.mMxBranch.setText(MAXBRANCHES.toString());
        this.mMxBranch.setMinimumSize(this.mMxBranch.getPreferredSize());
        this.mMxBranch.setAction((Action)new TextFieldAction(this.mParentDlg, MXBRANCH_EDIT_KEY));
        this.mMxBranch.addKeyListener((KeyListener)this);
        this.mMxBranch.getDocument().addDocumentListener(this);
        this.mMxDepth = new IntTextField(2, 9999, true);
        this.mMxDepth.setColumns(3);
        this.mMxDepth.setText(MAXTREEDEPTH.toString());
        this.mMxDepth.setMinimumSize(this.mMxDepth.getPreferredSize());
        this.mMxDepth.setAction((Action)new TextFieldAction(this.mParentDlg, MXDEPTH_EDIT_KEY));
        this.mMxDepth.addKeyListener((KeyListener)this);
        this.mMxDepth.getDocument().addDocumentListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_IMPORT_CF_TREE_KEY);
        this.mImportCFTreeCheck = new JCheckBox(toggleButtonAction);
        this.mImportCFTreeCheck.addItemListener(this);
        this.mCFTreeNamelabel = DialogUtil.createLabel(this, "IDS_NAME_COLON");
        this.mCFTreeNamelabel.setEnabled(false);
        this.mCFTreeNameText = new FileTextField();
        this.mCFTreeNameText.setPreferredSize(this.mCFTreeNameText.getPreferredSize());
        this.mCFTreeNameText.setAction(new TextFieldAction(this.mParentDlg, IMPORT_CF_TREE_EDIT_KEY));
        this.mCFTreeNameText.setEnabled(false);
        this.mCFTreeNameText.setOpaque(false);
        this.mCFTreeNamelabel.setLabelFor((Component)((Object)this.mCFTreeNameText));
        if (this.mCFTreeNameText.getDocument() != null) {
            this.mCFTreeNameText.getDocument().addDocumentListener(this);
        }
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_BROWSE_3DOT_KEY);
        this.mBrowseButton = new JButton(toggleButtonAction);
        this.mBrowseButton.setEnabled(false);
        this.mBrowseButton.addActionListener(this);
        this.mCFTreeNameText.setFocusable(true);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNoiseCheck);
        vector.add(this.mNoiseEdit);
        vector.add(this.mMemoryValue);
        vector.add(mTargetVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mSrcVarList);
        vector.add(this.mAdvancedButton);
        vector.add(this.mThreshold);
        vector.add(this.mMxBranch);
        vector.add(this.mMxDepth);
        vector.add(this.mMaxNodes);
        vector.add(this.mImportCFTreeCheck);
        vector.add(this.mCFTreeNameText);
        vector.add(this.mBrowseButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setupOutlierPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_OUTLIER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mNoiseCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        n = 24;
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() * 3, DialogUtil.getMainButtonGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mNoiseLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        insets2 = new Insets(0, DialogUtil.getComponentGroupGap() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNoiseEdit, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupMemoryPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_MEMORY_ALLOCATION"));
        jPanel.setBorder(titledBorder);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MAXIMUM_MB_COLON");
        jLabel.setLabelFor((Component)this.mMemoryValue);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(8, DialogUtil.getComponentGroupGap(), 0, 0);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(8, DialogUtil.getComponentGroupGap() * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMemoryValue, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setupListsPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_STDZATION_OF_CONTINUOUS_VARIABLES"));
        jPanel2.setBorder(titledBorder);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ASSUMED_STANDARDIZED_COLON");
        jLabel.setLabelFor(mTargetVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_TO_BE_STANDARDIZED_COLON");
        jLabel2.setLabelFor(this.mSrcVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        insets2 = new Insets(0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel2, this.mTargetScrollPane, gridBagConstraints, 0, 1, 1, 2, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel2, this.mArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jLabel2, gridBagConstraints, 2, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        insets2 = new Insets(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel2, this.mSrcScrollPane, gridBagConstraints, 2, 1, 1, 2, n, insets2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
    }

    private JPanel setupCFTreePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CF_TREE_TUNING_CRITERIA"));
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_INITIAL_DISTANCE");
        jLabel.setLabelFor((Component)this.mThreshold);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MAXIMUM_BRANCHES");
        jLabel2.setLabelFor((Component)this.mMxBranch);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_MAXIMUM_DEPTH");
        jLabel3.setLabelFor((Component)this.mMxDepth);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        Insets insets2 = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mThreshold, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mMxBranch, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, jLabel3, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mMxDepth, gridBagConstraints, 1, 2, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(DialogUtil.getComponentGroupGap() * 4, DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        n = 25;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMaxNodesLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), 125, 0, DialogUtil.getGroupBoxInnerMargin());
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMaxNodes, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupClusterModelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TWOSTEP_CLUSTER_MODEL_UPDATE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mImportCFTreeCheck, gridBagConstraints, 0, 2, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() * 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCFTreeNamelabel, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mCFTreeNameText), gridBagConstraints, 2, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 3, 3, 1, 1, n, insets);
        return jPanel;
    }
}

