/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.two_step_cluster;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.classify.two_step_cluster.TwoStepClusterOptions;
import com.spss.java_client.ui.dialogs.base.analyze.classify.two_step_cluster.TwoStepClusterOutput;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.TraceSettings;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TwoStepClusterDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ListSelectionListener,
ChangeListener {
    public static boolean sSpinnerChanged = true;
    public static TargetVariableList mTargetVarList2;
    public static JTextField mToBeStd;
    public static JTextField mAssumedStd;
    static final String IDS_LOG_LIKELIHOOD_KEY = "IDS_LOG_LIKELIHOOD_RADIO";
    static final String IDS_EUCLIDEAN_KEY = "IDS_EUCLIDEAN_RADIO";
    static final String IDS_DET_AUTO_KEY = "IDS_DET_AUTO_RADIO";
    static final String IDS_SPECIFY_FIXED_KEY = "IDS_SPECIFY_FIXED_RADIO";
    static final String IDS_BIC_RADIO_KEY = "IDS_BIC_RADIO";
    static final String IDS_AIC_RADIO_KEY = "IDS_AIC_RADIO";
    static final String TARGETLIST1KEY = "TARGET_LIST_1";
    static final String TARGETLIST2KEY = "TARGET_LIST_2";
    static String TO_BE_STD_KEY;
    static String TO_BE_ASSUMED_STD_KEY;
    static String AUTO_SPIN_KEY;
    static String FIXED_SPIN_KEY;
    static final Integer ZERO;
    static final Integer AUTOSPIN;
    static final Integer FIXEDSPIN;
    static final Integer MINLIMIT;
    static final Integer MAXLIMIT;
    static Boolean mSave;
    private JPanel mContVarPanel;
    private Border mClusterCriteriaBorder;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList1;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane1;
    private JScrollPane mTargetScrollPane2;
    private ArrowButton mCategArrow;
    private ArrowButton mContArrow;
    private JLabel mCategVarLabel;
    private JLabel mContVarLabel;
    private JRadioButton mLogRadio;
    private JRadioButton mEuclideanRadio;
    private JRadioButton mAutoRadio;
    private JRadioButton mFixedRadio;
    private JRadioButton mAicRadio;
    private JRadioButton mBicRadio;
    private SpssButtonGroup mDistanceRadioGroup;
    private SpssButtonGroup mClusterRadioGroup;
    private SpssButtonGroup mCriterionRadioGroup;
    private JLabel mFixedNoLabel;
    private JLabel mAutoMaxLabel;
    private JSpinner mAutoMaxSpin;
    private JSpinner mFixedNoSpin;
    private String mModelFileName;
    private String mTreeFileName;

    public TwoStepClusterDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TWO_STEP_CLUSTER"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.canEnableOkPaste();
        if (listDataEvent.getSource() == mTargetVarList2.getModel()) {
            Integer n = Integer.parseInt(mToBeStd.getText() == null ? "0" : mToBeStd.getText()) + (listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1);
            mToBeStd.setText(n.toString());
        }
        if (listDataEvent.getSource() == this.mTargetVarList1.getModel()) {
            if (this.mTargetVarList1.getModel().getSize() > 0) {
                if (this.mEuclideanRadio.isSelected()) {
                    this.mLogRadio.setSelected(true);
                }
                this.mEuclideanRadio.setEnabled(false);
            } else {
                this.mEuclideanRadio.setEnabled(true);
            }
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.canEnableOkPaste();
        if (listDataEvent.getSource() == mTargetVarList2.getModel()) {
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_SOURCE_LIST");
            ISpssVariable[] iSpssVariableArray2 = dialogDataModel.getVarArray("IDS_TARGET_LIST");
            List<LocallyUniqueId> list = this.getLocallyUniqueIdList(iSpssVariableArray2);
            List<LocallyUniqueId> list2 = this.getLocallyUniqueIdList(iSpssVariableArray);
            if (list.size() == 0) {
                mAssumedStd.setText("0");
                if (iSpssVariableArray != null) {
                    mToBeStd.setText("" + iSpssVariableArray.length);
                } else {
                    mToBeStd.setText("" + mTargetVarList2.getModel().getSize());
                }
            } else {
                VarListModel varListModel = mTargetVarList2.getModel();
                ArrayList<LocallyUniqueId> arrayList = new ArrayList<LocallyUniqueId>();
                block0: for (LocallyUniqueId object : list2) {
                    for (int i = 0; i < varListModel.getSize(); ++i) {
                        if (!varListModel.getElementAt(i).getId().equals((Object)object)) continue;
                        arrayList.add(object);
                        continue block0;
                    }
                }
                ArrayList arrayList2 = new ArrayList();
                block2: for (LocallyUniqueId locallyUniqueId : list) {
                    for (int i = 0; i < varListModel.getSize(); ++i) {
                        if (!varListModel.getElementAt(i).getId().equals((Object)locallyUniqueId)) continue;
                        arrayList2.add(locallyUniqueId);
                        continue block2;
                    }
                }
                mAssumedStd.setText("" + arrayList2.size());
                mToBeStd.setText("" + arrayList.size());
                boolean bl = false;
                LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                iSpssVariableArray = new ISpssVariable[arrayList.size()];
                for (LocallyUniqueId locallyUniqueId2 : arrayList) {
                    iSpssVariableArray[++var10_13] = iSpssDataSrc.getVariable(iSpssDataSrc.findVarIndex(locallyUniqueId2));
                }
                dialogDataModel.putVarArray("IDS_SOURCE_LIST", iSpssVariableArray);
                boolean bl2 = false;
                iSpssVariableArray2 = new ISpssVariable[arrayList2.size()];
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    LocallyUniqueId locallyUniqueId3 = (LocallyUniqueId)iterator.next();
                    iSpssVariableArray2[++var10_15] = iSpssDataSrc.getVariable(iSpssDataSrc.findVarIndex(locallyUniqueId3));
                }
                dialogDataModel.putVarArray("IDS_TARGET_LIST", iSpssVariableArray2);
            }
        }
        if (listDataEvent.getSource() == this.mTargetVarList1.getModel()) {
            if (this.mTargetVarList1.getModel().getSize() > 0) {
                if (this.mEuclideanRadio.isSelected()) {
                    this.mLogRadio.setSelected(true);
                }
                this.mEuclideanRadio.setEnabled(false);
            } else {
                this.mEuclideanRadio.setEnabled(true);
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.canEnableOkPaste();
        if (listDataEvent.getSource() == mTargetVarList2.getModel()) {
            mToBeStd.setText(Integer.valueOf(mTargetVarList2.getModel().getSize()).toString());
        }
        if (this.mTargetVarList1.getModel().getSize() > 0) {
            if (this.mEuclideanRadio.isSelected()) {
                this.mLogRadio.setSelected(true);
            }
            this.mEuclideanRadio.setEnabled(false);
        } else {
            this.mEuclideanRadio.setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mAutoRadio) {
            this.mAutoMaxLabel.setEnabled(bl);
            this.mAutoMaxSpin.setEnabled(bl);
            this.mAutoMaxSpin.getEditor().setOpaque(bl);
            this.mBicRadio.setEnabled(bl);
            this.mAicRadio.setEnabled(bl);
            ((TitledBorder)this.mClusterCriteriaBorder).setTitleColor(UIManager.getColor("TitledBorder.titleColor"));
            this.canEnableOkPaste();
            this.repaint();
        }
        if (object == this.mFixedRadio) {
            this.mFixedNoLabel.setEnabled(bl);
            this.mFixedNoSpin.setEnabled(bl);
            this.mFixedNoSpin.getEditor().setOpaque(bl);
            ((TitledBorder)this.mClusterCriteriaBorder).setTitleColor(this.mContVarPanel.getBackground().darker());
            this.canEnableOkPaste();
            this.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.mAutoMaxSpin) {
            JTextField jTextField = (JTextField)this.mAutoMaxSpin.getEditor();
            if (sSpinnerChanged) {
                jTextField.setText(this.mAutoMaxSpin.getValue() + "");
            }
            jTextField.requestFocus();
        } else if (object == this.mFixedNoSpin) {
            JTextField jTextField = (JTextField)this.mFixedNoSpin.getEditor();
            if (sSpinnerChanged) {
                jTextField.setText(this.mFixedNoSpin.getValue() + "");
            }
            jTextField.requestFocus();
        }
        sSpinnerChanged = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList1.removeAll();
        mTargetVarList2.requestFocus();
        mTargetVarList2.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(ZERO);
        this.mLogRadio.setSelected(true);
        this.mEuclideanRadio.setEnabled(true);
        this.mAutoRadio.setSelected(true);
        this.mBicRadio.setSelected(true);
        mAssumedStd.setText(ZERO.toString());
        mToBeStd.setText(ZERO.toString());
        ((JTextField)this.mAutoMaxSpin.getEditor()).setText(AUTOSPIN.toString());
        ((JTextField)this.mFixedNoSpin.getEditor()).setText(FIXEDSPIN.toString());
        this.enableOkPaste(false);
        this.mSrcVarList.requestFocus();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_twostep_main";
    }

    @Override
    public String getIActionKey() {
        return "analyze_classify_two_cluster";
    }

    @Override
    public boolean okPastePressed() {
        int n;
        if (this.mAutoRadio.isSelected()) {
            int n2 = Integer.parseInt(((JTextField)this.mAutoMaxSpin.getEditor()).getText());
            if (n2 <= 1) {
                String string = n2 == 0 ? this.getResString("ERR_LEADING_ZERO_NOT_ALLOWED_MSG") : this.getResString("ERR_VALUE_SHLD_GREATER_THAN_ONE_ERROR");
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                this.mAutoMaxSpin.getEditor().requestFocus();
                return false;
            }
        } else if (this.mFixedRadio.isSelected() && (n = Integer.parseInt(((JTextField)this.mFixedNoSpin.getEditor()).getText())) <= 1) {
            String string = n == 0 ? this.getResString("ERR_LEADING_ZERO_NOT_ALLOWED_MSG") : this.getResString("ERR_VALUE_SHLD_GREATER_THAN_ONE_ERROR");
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
            this.mFixedNoSpin.getEditor().requestFocus();
            return false;
        }
        return this.checkOutputSelections();
    }

    public String createGroupID() {
        String string = "TSC_";
        Integer n = (int)(Math.random() * 10000.0);
        string = string + n.toString();
        return string;
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2 = this.createGroupID();
        this.mModelFileName = null;
        this.mTreeFileName = null;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("TWOSTEP CLUSTER"));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string3 = this.mTargetVarList1.getVariablesStringList();
        if (!string3.equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CATEGORICAL VARIABLES="));
            stringBuffer.append(string3);
        }
        if (!(string3 = mTargetVarList2.getVariablesStringList()).equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CONTINUOUS VARIABLES="));
            stringBuffer.append(string3);
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/DISTANCE "));
        Boolean bl = dialogDataModel.getBoolean(IDS_LOG_LIKELIHOOD_KEY);
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("LIKELIHOOD");
        } else {
            stringBuffer.append("EUCLIDEAN");
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/NUMCLUSTERS "));
        bl = dialogDataModel.getBoolean(IDS_DET_AUTO_KEY);
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("AUTO ");
            stringBuffer.append(this.mAutoMaxSpin.getValue());
            bl = dialogDataModel.getBoolean(IDS_BIC_RADIO_KEY);
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(" BIC");
            } else {
                stringBuffer.append(" AIC");
            }
        } else {
            stringBuffer.append("FIXED=");
            stringBuffer.append(this.mFixedNoSpin.getValue());
        }
        stringBuffer.append(this.generateOptionsSyntax(dialogDataModel));
        stringBuffer.append(this.generateOutputSyntax(dialogDataModel, string2));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        PesFile pesFile = PES_Repository.getPesFile((String)this.mModelFileName);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if ((pesFile = PES_Repository.getPesFile((String)this.mTreeFileName)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String generateOptionsSyntax(DialogDataModel dialogDataModel) {
        Boolean bl;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_TARGET_LIST");
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/NOSTANDARDIZE VARIABLES="));
            object = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                stringBuffer.append(iSpssVariable.getName()).append(" ");
            }
            String string = stringBuffer.toString();
            stringBuffer = new StringBuffer(string.substring(0, string.length() - 1));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NOISE_HANDLING")) != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/HANDLENOISE "));
            if (dialogDataModel.getString("IDS_NOISE_EDIT") != null) {
                stringBuffer.append(dialogDataModel.getString("IDS_NOISE_EDIT"));
            }
        } else {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/HANDLENOISE "));
            stringBuffer.append(ZERO);
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MEMALLOCATE "));
        if (dialogDataModel.getString("IDS_MEMORY_EDIT") != null) {
            stringBuffer.append(dialogDataModel.getString("IDS_MEMORY_EDIT"));
        } else {
            stringBuffer.append(TwoStepClusterOptions.MEMORY);
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        stringBuffer.append(" INITHRESHOLD(");
        if (dialogDataModel.getString("IDS_THRESHOLD_EDIT") != null) {
            stringBuffer.append(dialogDataModel.getString("IDS_THRESHOLD_EDIT"));
        } else {
            stringBuffer.append(TwoStepClusterOptions.THRESHOLD);
        }
        stringBuffer.append(")");
        stringBuffer.append(" MXBRANCH(");
        if (dialogDataModel.getString("IDS_MXBRANCH_EDIT") != null) {
            stringBuffer.append(dialogDataModel.getString("IDS_MXBRANCH_EDIT"));
        } else {
            stringBuffer.append(TwoStepClusterOptions.MAXBRANCHES);
        }
        stringBuffer.append(")");
        stringBuffer.append(" MXLEVEL(");
        if (dialogDataModel.getString("IDS_MXDEPTH_EDIT") != null) {
            stringBuffer.append(dialogDataModel.getString("IDS_MXDEPTH_EDIT"));
        } else {
            stringBuffer.append(TwoStepClusterOptions.MAXTREEDEPTH);
        }
        stringBuffer.append(")");
        bl = dialogDataModel.getBoolean("IDS_IMPORT_CF_TREE");
        if (bl != null && bl.booleanValue() && (object = dialogDataModel.getString("IDS_IMPORT_CF_TREE_EDIT")) != null && ((String)object).length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/INFILE FILE="));
            stringBuffer.append(CharacterUtil.smartQuote((String)object));
        }
        return stringBuffer.toString();
    }

    public String generateOutputSyntax(DialogDataModel dialogDataModel, String string) {
        Boolean bl;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Boolean bl2 = dialogDataModel.getBoolean("IDS_EXPORT_FINAL_MODEL");
        if (!RemoteFileChooser.enableSaveInModeler()) {
            bl2 = true;
        }
        if (bl2 != null && bl2.booleanValue() && (string2 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_MODEL")) != null && string2.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE MODEL="));
            stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            this.mModelFileName = string2;
        }
        if ((bl = dialogDataModel.getBoolean("IDS_EXPORT_CF_TREE")) != null && bl.booleanValue() && (string2 = dialogDataModel.getString("EXPORT_XML_FILE_PATH_CF")) != null && string2.length() > 0) {
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append(" STATE=");
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE STATE="));
            }
            stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            this.mTreeFileName = string2;
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/VIEWMODEL"));
        bl = dialogDataModel.getBoolean("IDS_CHARTS_AND_TABLES");
        if (bl == null || bl != null && bl.booleanValue()) {
            stringBuffer.append(" DISPLAY=YES");
            ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("TARGET_LIST_EVAL");
            if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
                stringBuffer.append(" EVALUATIONFIELDS=");
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    stringBuffer.append(iSpssVariable.getName() + " ");
                }
            }
        } else {
            stringBuffer.append(" DISPLAY=NO");
        }
        bl = dialogDataModel.getBoolean("IDS_PIVOT_TABLES_CHECK");
        if (stringBuffer2.length() > 0 || bl != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT"));
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(" IC COUNT SUMMARY");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CREATE_CLUST_VAR")) != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE VARIABLE="));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String generateAIMSyntax(DialogDataModel dialogDataModel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getMainCommand("AIM "));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
        String string2 = this.mTargetVarList1.getVariablesStringList();
        if (!string2.equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CATEGORICAL "));
            stringBuffer.append(string2);
        }
        if (!(string2 = mTargetVarList2.getVariablesStringList()).equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CONTINUOUS "));
            stringBuffer.append(string2);
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA ADJUST=BONFERRONI "));
        stringBuffer.append(" SHOWREFLINE=NO HIDENOTSIG=NO");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    public SrcVariableList getSourceVarList() {
        return this.mSrcVarList;
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        super.validateDialogDataModel(bl);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(TARGETLIST2KEY);
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            ISpssVariable[] iSpssVariableArray2 = dialogDataModel.getVarArray("IDS_SOURCE_LIST");
            if (iSpssVariableArray2 == null || iSpssVariableArray2.length == 0) {
                dialogDataModel.putString(TO_BE_STD_KEY, "0");
            } else {
                dialogDataModel.putString(TO_BE_STD_KEY, "" + iSpssVariableArray2.length);
            }
        }
        if ((iSpssVariableArray = dialogDataModel.getVarArray("IDS_TARGET_LIST")) != null) {
            if (iSpssVariableArray.length == 0) {
                dialogDataModel.putString(TO_BE_ASSUMED_STD_KEY, "0");
            } else {
                dialogDataModel.putString(TO_BE_ASSUMED_STD_KEY, "" + iSpssVariableArray.length);
            }
        }
        return true;
    }

    private boolean checkOutputSelections() {
        String[] stringArray;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        boolean bl = false;
        for (String string : stringArray = new String[]{"IDS_PIVOT_TABLES_CHECK", "IDS_CHARTS_AND_TABLES", "IDS_CREATE_CLUST_VAR", "IDS_EXPORT_FINAL_MODEL", "IDS_EXPORT_CF_TREE"}) {
            Boolean bl2 = dialogDataModel.getBoolean(string);
            boolean bl3 = string.equals("IDS_CHARTS_AND_TABLES");
            if ((bl2 == null || !bl2.booleanValue()) && (!bl3 || bl2 != null)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_NO_OUTPUT_WARNING"), VersionInfo.getAppVersionString());
        }
        return bl;
    }

    @Override
    protected void saveDialogState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString(TO_BE_STD_KEY, mToBeStd.getText());
        dialogDataModel.putString(TO_BE_ASSUMED_STD_KEY, mAssumedStd.getText());
        dialogDataModel.putString(AUTO_SPIN_KEY, ((JTextField)this.mAutoMaxSpin.getEditor()).getText());
        dialogDataModel.putString(FIXED_SPIN_KEY, ((JTextField)this.mFixedNoSpin.getEditor()).getText());
        super.saveDialogState();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = dialogDataModel.getString(TO_BE_STD_KEY);
        if (string != null) {
            mToBeStd.setText(string);
            mAssumedStd.setText(dialogDataModel.getString(TO_BE_ASSUMED_STD_KEY));
            ((JTextField)this.mAutoMaxSpin.getEditor()).setText(dialogDataModel.getString(AUTO_SPIN_KEY));
            ((JTextField)this.mFixedNoSpin.getEditor()).setText(dialogDataModel.getString(FIXED_SPIN_KEY));
        }
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupLists();
        JPanel jPanel3 = this.setupDistanceMeasurePanel();
        this.mContVarPanel = this.setupContVarCountsPanel();
        JPanel jPanel4 = this.setupClustersPanel();
        JPanel jPanel5 = this.setupClustCriteriaPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mContVarPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TwoStepClusterDlg.this.runOptionsSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OUTPUT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TwoStepClusterDlg.this.runOutputSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        return jPanel;
    }

    private List<LocallyUniqueId> getLocallyUniqueIdList(ISpssVariable[] iSpssVariableArray) {
        ArrayList<LocallyUniqueId> arrayList = new ArrayList<LocallyUniqueId>();
        if (iSpssVariableArray != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                arrayList.add(iSpssVariable.getId());
            }
        }
        return arrayList;
    }

    private void initVars() {
        this.mDistanceRadioGroup = new SpssButtonGroup();
        this.mClusterRadioGroup = new SpssButtonGroup();
        this.mCriterionRadioGroup = new SpssButtonGroup();
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mTargetVarList1 = new TargetVariableList();
        this.mTargetVarList1.getModel().addListDataListener(this);
        this.mTargetVarList1.setIdentifier(TARGETLIST1KEY);
        mTargetVarList2 = new TargetVariableList();
        mTargetVarList2.getModel().addListDataListener(this);
        mTargetVarList2.addListSelectionListener(this);
        mTargetVarList2.setIdentifier(TARGETLIST2KEY);
        mTargetVarList2.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetScrollPane1 = new JScrollPane(this.mTargetVarList1);
        this.mTargetScrollPane1.setPreferredSize(this.mTargetVarList1.getMinimumSize());
        this.mTargetScrollPane2 = new JScrollPane(mTargetVarList2);
        this.mTargetScrollPane2.setPreferredSize(mTargetVarList2.getMinimumSize());
        this.mCategVarLabel = DialogUtil.createLabel(this, "IDS_CATEGEGORICAL_VARIABLES_COLON");
        this.mCategVarLabel.setLabelFor(this.mTargetVarList1);
        this.mContVarLabel = DialogUtil.createLabel(this, "IDS_CONTINUOUS_VARIABLES_COLON");
        this.mContVarLabel.setLabelFor(mTargetVarList2);
        this.mCategArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCategArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCategArrow.registerVariableList(this.mTargetVarList1, SpssArrowButton.ButtonOrientation.left);
        this.mContArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mContArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mContArrow.registerVariableList(mTargetVarList2, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, IDS_LOG_LIKELIHOOD_KEY);
        this.mLogRadio = new JRadioButton(toggleButtonAction);
        this.mLogRadio.setSelected(true);
        this.mDistanceRadioGroup.add(this.mLogRadio);
        toggleButtonAction = new ToggleButtonAction(this, IDS_EUCLIDEAN_KEY);
        this.mEuclideanRadio = new JRadioButton(toggleButtonAction);
        this.mDistanceRadioGroup.add(this.mEuclideanRadio);
        mToBeStd = new JTextField();
        mToBeStd.setEditable(false);
        mToBeStd.setEnabled(true);
        mToBeStd.setText(ZERO.toString());
        mToBeStd.setOpaque(false);
        mToBeStd.setBorder(null);
        mAssumedStd = new JTextField();
        mAssumedStd.setEditable(false);
        mAssumedStd.setEnabled(true);
        mAssumedStd.setText(ZERO.toString());
        mAssumedStd.setOpaque(false);
        mAssumedStd.setBorder(null);
        toggleButtonAction = new ToggleButtonAction(this, IDS_DET_AUTO_KEY);
        this.mAutoRadio = new JRadioButton(toggleButtonAction);
        this.mAutoRadio.setSelected(true);
        this.mAutoRadio.addItemListener(this);
        this.mClusterRadioGroup.add(this.mAutoRadio);
        this.mAutoMaxLabel = DialogUtil.createLabel(this, "IDS_MAXIMUM_COLON");
        Integer n = 1;
        Integer n2 = AUTOSPIN;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n2, MINLIMIT, MAXLIMIT, n);
        this.mAutoMaxSpin = new JSpinner(spinnerNumberModel);
        this.mAutoMaxSpin.setPreferredSize(new Dimension(55, 22));
        this.mAutoMaxSpin.addChangeListener(this);
        IntTextField intTextField = new IntTextField(true);
        intTextField.getDocument().addDocumentListener(this.getDocumentListener(MINLIMIT, MAXLIMIT, (JTextField)intTextField, this.mAutoMaxSpin));
        this.mAutoMaxSpin.setEditor((JComponent)intTextField);
        ((IntTextField)this.mAutoMaxSpin.getEditor()).setText(AUTOSPIN.toString());
        DialogUtil.leftAlignSpinnerText(this.mAutoMaxSpin);
        this.mAutoMaxLabel.setLabelFor(this.mAutoMaxSpin.getEditor());
        toggleButtonAction = new ToggleButtonAction(this, IDS_SPECIFY_FIXED_KEY);
        this.mFixedRadio = new JRadioButton(toggleButtonAction);
        this.mFixedRadio.addItemListener(this);
        this.mClusterRadioGroup.add(this.mFixedRadio);
        this.mFixedNoLabel = DialogUtil.createLabel(this, "IDS_NUMBER_COLON");
        this.mFixedNoLabel.setEnabled(false);
        Integer n3 = FIXEDSPIN;
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(n3, MINLIMIT, MAXLIMIT, n);
        this.mFixedNoSpin = new JSpinner(spinnerNumberModel2);
        this.mFixedNoSpin.setPreferredSize(new Dimension(55, 22));
        this.mFixedNoSpin.setEnabled(false);
        this.mFixedNoSpin.addChangeListener(this);
        intTextField = new IntTextField(true);
        intTextField.getDocument().addDocumentListener(this.getDocumentListener(MINLIMIT, MAXLIMIT, (JTextField)intTextField, this.mFixedNoSpin));
        this.mFixedNoSpin.setEditor((JComponent)intTextField);
        this.mFixedNoSpin.getEditor().setOpaque(false);
        ((IntTextField)this.mFixedNoSpin.getEditor()).setText(FIXEDSPIN.toString());
        DialogUtil.leftAlignSpinnerText(this.mFixedNoSpin);
        this.mFixedNoLabel.setLabelFor(this.mFixedNoSpin.getEditor());
        toggleButtonAction = new ToggleButtonAction(this, IDS_BIC_RADIO_KEY);
        this.mBicRadio = new JRadioButton(toggleButtonAction);
        this.mBicRadio.setSelected(true);
        this.mCriterionRadioGroup.add(this.mBicRadio);
        toggleButtonAction = new ToggleButtonAction(this, IDS_AIC_RADIO_KEY);
        this.mAicRadio = new JRadioButton(toggleButtonAction);
        this.mCriterionRadioGroup.add(this.mAicRadio);
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mCategArrow);
        vector.add(this.mContArrow);
        vector.add(this.mTargetVarList1);
        vector.add(mTargetVarList2);
        vector.add(this.mDistanceRadioGroup);
        vector.add(mToBeStd);
        vector.add(mAssumedStd);
        vector.add(this.mClusterRadioGroup);
        vector.add(this.mAutoMaxSpin.getEditor());
        vector.add(this.mFixedNoSpin.getEditor());
        vector.add(this.mCriterionRadioGroup);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            if (!(this.mOptionButtonPanel.getComponent(n) instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TWO_STEP_CLUSTER_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 3, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mCategArrow, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mContArrow, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCategVarLabel, gridBagConstraints, 2, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Insets insets3 = new Insets(0, 0, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane1, gridBagConstraints, 2, 1, 1, 1, n, insets3);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mContVarLabel, gridBagConstraints, 2, 2, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane2, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setupDistanceMeasurePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_DIST_MEASURE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mLogRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mEuclideanRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupContVarCountsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CONT_VAR"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0);
        int n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(this.getResString("IDS_TO_BE_STD"));
        jLabel.setLabelFor(mToBeStd);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() + 10, DialogUtil.getComponentGroupGap(), 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, mToBeStd, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        JLabel jLabel2 = new JLabel(this.getResString("IDS_ASSUMED_STD"));
        jLabel2.setLabelFor(mAssumedStd);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, mAssumedStd, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupClustersPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CLUSTERS"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mAutoRadio, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        n = 24;
        Insets insets3 = new Insets(0, DialogUtil.getComponentGroupGap() * 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAutoMaxLabel, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mAutoMaxSpin, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFixedRadio, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mFixedNoLabel, gridBagConstraints, 0, 3, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mFixedNoSpin, gridBagConstraints, 1, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupClustCriteriaPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        this.mClusterCriteriaBorder = new TitledBorder(this.getResString("IDS_CLUSTERING_CRITERIAN"));
        jPanel.setBorder(this.mClusterCriteriaBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mBicRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mAicRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new TwoStepClusterOptions(this));
    }

    private void runOutputSubDialog() {
        this.runSubDialog(new TwoStepClusterOutput(this));
    }

    private DocumentListener getDocumentListener(final int n, final int n2, final JTextField jTextField, final JSpinner jSpinner) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                sSpinnerChanged = false;
                int n3 = Integer.parseInt(jSpinner.getModel().getValue().toString());
                int n22 = 5;
                if (jTextField.getText().equals("")) {
                    TwoStepClusterDlg.this.enableOkPaste(false);
                } else {
                    try {
                        n22 = Integer.parseInt(jTextField.getText());
                        if (n22 < n || n22 > n2) {
                            TraceSettings.trace1((String)TwoStepClusterDlg.this.getResString("ERR_LIMIT_EXCEED_ERROR_MSG"), (int)15);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        TraceSettings.trace1((String)TwoStepClusterDlg.this.getResString("ERR_NUMBERFORMAT_ERROR_MSG"), (int)15);
                    }
                    jSpinner.getModel().setValue(n22);
                    if (TwoStepClusterDlg.this.mTargetVarList1.getModel().getSize() <= 0 && mTargetVarList2.getModel().getSize() <= 0) {
                        TwoStepClusterDlg.this.enableOkPaste(false);
                    } else {
                        TwoStepClusterDlg.this.enableOkPaste(true);
                    }
                    if (n22 == n3) {
                        TwoStepClusterDlg.this.fireStateChanged(jSpinner);
                    }
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    private void canEnableOkPaste() {
        if (this.mAutoRadio.isSelected()) {
            if (((JTextField)this.mAutoMaxSpin.getEditor()).getText().equals("") || this.mTargetVarList1.getModel().getSize() < 1 && mTargetVarList2.getModel().getSize() < 1) {
                this.enableOkPaste(false);
            } else {
                this.enableOkPaste(true);
            }
        } else if (this.mFixedRadio.isSelected()) {
            if (((JTextField)this.mFixedNoSpin.getEditor()).getText().equals("") || this.mTargetVarList1.getModel().getSize() < 1 && mTargetVarList2.getModel().getSize() < 1) {
                this.enableOkPaste(false);
            } else {
                this.enableOkPaste(true);
            }
        }
    }

    private void fireStateChanged(JSpinner jSpinner) {
        ChangeListener[] changeListenerArray;
        for (ChangeListener changeListener : changeListenerArray = jSpinner.getChangeListeners()) {
            ChangeEvent changeEvent = new ChangeEvent(jSpinner);
            changeListener.stateChanged(changeEvent);
        }
    }

    static {
        TO_BE_STD_KEY = "TO_BE_STD";
        TO_BE_ASSUMED_STD_KEY = "TO_BE_ASSUMED_STD";
        AUTO_SPIN_KEY = "AUTO_SPIN";
        FIXED_SPIN_KEY = "FIXED_SPIN";
        ZERO = 0;
        AUTOSPIN = 15;
        FIXEDSPIN = 5;
        MINLIMIT = 1;
        MAXLIMIT = 99999;
        mSave = false;
    }
}

