/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.roc_analysis;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RocDisplayOptions
extends BaseSubDialog
implements ItemListener {
    private JCheckBox mRocCurveCheckBox;
    private JCheckBox mReflineCheckBox;
    private JCheckBox mPRCCheckBox;
    private JRadioButton mIntepolateTrueRadio;
    private JRadioButton mIntepolateFalseRadio;
    private SpssButtonGroup mIntepolateRadioGroup;
    private JCheckBox mOverallCheckBox;
    private JCheckBox mSECICheckBox;
    private JCheckBox mROCPointCheckBox;
    private JCheckBox mPRCPointCheckBox;

    public RocDisplayOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_ROC_ANALYSIS_DISPLAY_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_roc_display";
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupPlotPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupPrintPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void initVars() {
        this.mRocCurveCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_ROC_CURVE_CHECKBOX"));
        this.mReflineCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_REF_LINE_CHECKBOX"));
        this.mPRCCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PRC_CHECKBOX"));
        this.mIntepolateTrueRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INTEPOLATE_TRUE_RADIO"));
        this.mIntepolateFalseRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INTEPOLATE_FALSE_RADIO"));
        this.mOverallCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_OVERALL_CHECKBOX"));
        this.mSECICheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_SECI_CHECKBOX"));
        this.mROCPointCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_ROC_POINT_CHECKBOX"));
        this.mPRCPointCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PRC_POINT_CHECKBOX"));
        this.mIntepolateRadioGroup = new SpssButtonGroup();
        this.mIntepolateRadioGroup.add(this.mIntepolateTrueRadio);
        this.mIntepolateRadioGroup.add(this.mIntepolateFalseRadio);
        this.mRocCurveCheckBox.setSelected(true);
        this.mIntepolateTrueRadio.setSelected(true);
        this.mIntepolateTrueRadio.setEnabled(false);
        this.mIntepolateFalseRadio.setEnabled(false);
        this.mRocCurveCheckBox.addItemListener(this);
        this.mPRCCheckBox.addItemListener(this);
    }

    private JPanel setupPlotPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ROC_ANALYSIS_PLOT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mRocCurveCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPRCCheckBox, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mReflineCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mIntepolateTrueRadio, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mIntepolateFalseRadio, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mOverallCheckBox, gridBagConstraints, 0, 5, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPrintPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ROC_ANALYSIS_PRINT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSECICheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mROCPointCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mPRCPointCheckBox, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRocCurveCheckBox);
        vector.add(this.mReflineCheckBox);
        vector.add(this.mPRCCheckBox);
        vector.add(this.mIntepolateRadioGroup);
        vector.add(this.mOverallCheckBox);
        vector.add(this.mSECICheckBox);
        vector.add(this.mROCPointCheckBox);
        vector.add(this.mPRCPointCheckBox);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mRocCurveCheckBox) {
            this.mReflineCheckBox.setEnabled(this.mRocCurveCheckBox.isSelected());
        } else if (object == this.mPRCCheckBox) {
            boolean bl = this.mPRCCheckBox.isSelected();
            this.mIntepolateTrueRadio.setEnabled(bl);
            this.mIntepolateFalseRadio.setEnabled(bl);
        }
    }
}

