/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.roc_analysis;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.classify.roc_analysis.RocDisplayOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.analyze.roc_curve.RocCurveOptions;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DefineGroupsSubDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class RocAnalysisDlg
extends BaseProcedureDialog
implements ListDataListener,
DocumentListener,
ItemListener {
    private JCheckBox mPairedSampleCheck;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mStateTargetVariableList;
    private StringTextField mStateVarValEdit;
    private TargetVariableList mTestTargetVariableList;
    private ArrowButton mTestVarArrow;
    private ArrowButton mStateVarArrow;
    private TargetVariableList mTargetGroupVarList;
    private JLabel mGroupingVarLabel;
    private ArrowButton mGroupVarArrow;
    private JButton mGroupButton;
    private DefineGroupsSubDlg.GroupVarFormatter mTargetGroupVarFormatter;
    private JButton mOptionsButton;
    private JButton mDisplayButton;

    public RocAnalysisDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_ROC_ANALYSIS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_roc";
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.mStateVarValEdit.setEnabled(this.mStateTargetVariableList.getModel().getSize() > 0);
        this.enableButtons();
    }

    @Override
    public String generateSyntax() {
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("ROC ANALYSIS"));
        String string = this.mTestTargetVariableList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
        stringBuffer.append(" BY ");
        String string2 = this.mStateTargetVariableList.getVariablesStringList();
        stringBuffer.append(string2);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string3 = dialogDataModel.getString("ROC_ANALYSIS_STATE_EDIT");
        boolean bl = false;
        try {
            Double.parseDouble(string3);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            ComponentState.trace1((String)numberFormatException.getMessage(), (int)15);
        }
        if (bl) {
            stringBuffer.append(" (").append(string3).append(")\n");
        } else {
            stringBuffer.append(" (").append(CharacterUtil.smartQuote((String)dialogDataModel.getString("ROC_ANALYSIS_STATE_EDIT"))).append(")\n");
        }
        Boolean bl2 = dialogDataModel.getBoolean("IDS_VALID_MIS_VAL_RADIO");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING USERMISSING="));
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("INCLUDE");
        } else {
            stringBuffer.append("EXCLUDE");
        }
        stringBuffer.append("\n");
        boolean bl3 = dialogDataModel.getBoolean("IDS_PAIRED_SAMPLE_CHECK");
        StringBuilder stringBuilder = new StringBuilder("CUTOFF=");
        bl2 = dialogDataModel.getBoolean("IDS_EXC_CUTOFF_RADIO");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuilder.append("EXCLUDE");
        } else {
            stringBuilder.append("INCLUDE");
        }
        stringBuilder.append(" TESTPOS=");
        bl2 = dialogDataModel.getBoolean("IDS_SMALLER_TEST_RADIO");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuilder.append("SMALL");
        } else {
            stringBuilder.append("LARGE");
        }
        if (!bl3) {
            stringBuilder.append(" DISTRIBUTION=");
            object = dialogDataModel.getInteger("IDS_DIST_ASSUM_COMBO");
            if (object != null && (Integer)object == 1) {
                stringBuilder.append("NEGEXPO");
            } else {
                stringBuilder.append("FREE");
            }
        }
        stringBuilder.append(" CI=");
        object = dialogDataModel.getString("IDS_CONF_LEVEL_EDIT");
        if (object != null && ((String)object).length() > 0) {
            stringBuilder.append((String)object);
        } else {
            stringBuilder.append("95");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA "));
        stringBuffer.append(stringBuilder.toString()).append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/DESIGN PAIR="));
        stringBuffer.append(!bl3 ? "FALSE" : "TRUE");
        if (!bl3 && this.mTargetGroupVarList.getModel().getSize() > 0) {
            String string4 = this.mTargetGroupVarList.getVariablesStringList();
            stringBuffer.append(" GROUP=").append(string4);
            stringBuffer.append(" SELECT=");
            stringBuffer.append(this.mTargetGroupVarFormatter.getDisplaySyntax(this.mTargetGroupVarList.getModel().getElementAt(0)));
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.getPlotPrintSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    private String getPlotPrintSyntax(DialogDataModel dialogDataModel) {
        boolean bl;
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        boolean bl3 = dialogDataModel.containsBooleanKey("IDS_ROC_CURVE_CHECKBOX") ? dialogDataModel.getBoolean("IDS_ROC_CURVE_CHECKBOX") : true;
        boolean bl4 = dialogDataModel.containsBooleanKey("IDS_PRC_CHECKBOX") ? dialogDataModel.getBoolean("IDS_PRC_CHECKBOX") : false;
        boolean bl5 = bl2 = dialogDataModel.containsBooleanKey("IDS_OVERALL_CHECKBOX") ? dialogDataModel.getBoolean("IDS_OVERALL_CHECKBOX") : false;
        if (bl3) {
            string = "ROC";
            boolean bl6 = bl = dialogDataModel.containsBooleanKey("IDS_REF_LINE_CHECKBOX") ? dialogDataModel.getBoolean("IDS_REF_LINE_CHECKBOX") : false;
            if (bl) {
                string = string + "(REFERENCE)";
            }
        }
        if (bl4) {
            if (string.length() > 0) {
                string = string + " ";
            }
            string = string + "PR";
        }
        if (string.length() == 0) {
            string = "NONE";
        }
        stringBuilder.append(SyntaxUtil.getSubCommand("/PLOT "));
        stringBuilder.append("CURVE=").append(string);
        if (bl4) {
            bl = dialogDataModel.containsBooleanKey("IDS_INTEPOLATE_TRUE_RADIO") ? dialogDataModel.getBoolean("IDS_INTEPOLATE_TRUE_RADIO") : true;
            stringBuilder.append(" PR_INTERPOLATE=").append(bl ? "TP" : "FP");
        }
        stringBuilder.append(" MODELQUALITY=").append(bl2 ? "TRUE" : "FALSE");
        bl = dialogDataModel.containsBooleanKey("IDS_SECI_CHECKBOX") ? dialogDataModel.getBoolean("IDS_SECI_CHECKBOX") : false;
        boolean bl7 = dialogDataModel.containsBooleanKey("IDS_ROC_POINT_CHECKBOX") ? dialogDataModel.getBoolean("IDS_ROC_POINT_CHECKBOX") : false;
        boolean bl8 = dialogDataModel.containsBooleanKey("IDS_PRC_POINT_CHECKBOX") ? dialogDataModel.getBoolean("IDS_PRC_POINT_CHECKBOX") : false;
        stringBuilder.append("\n");
        stringBuilder.append(SyntaxUtil.getSubCommand("/PRINT "));
        stringBuilder.append("SE=").append(bl ? "TRUE" : "FALSE");
        if (bl7 || bl8) {
            string = "";
            if (bl7) {
                string = "ROC";
            }
            if (bl8) {
                string = string + (string.length() > 0 ? " PR" : "PR");
            }
            stringBuilder.append(" COORDINATES=").append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public final String getIActionKey() {
        return "analyze_classify_roc_analysis";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.mStateVarValEdit.setEnabled(this.mStateTargetVariableList.getModel().getSize() > 0);
        this.mGroupButton.setEnabled(this.mTargetGroupVarList.getModel().getSize() > 0);
        this.enableButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.mStateVarValEdit.setEnabled(this.mStateTargetVariableList.getModel().getSize() > 0);
        this.mGroupButton.setEnabled(this.mTargetGroupVarList.getModel().getSize() > 0);
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mPairedSampleCheck) {
            boolean bl = this.mPairedSampleCheck.isSelected();
            this.mGroupingVarLabel.setEnabled(!bl);
            this.mTargetGroupVarList.setEnabled(!bl);
            this.mGroupVarArrow.setEnabled(!bl);
            this.mGroupButton.setEnabled(!bl);
            this.enableButtons();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    private void runOptionsSubDialog() {
        RocCurveOptions rocCurveOptions = new RocCurveOptions(this, this.getResString("IDS_ROC_ANALYSIS_OPTIONS_TITLE"));
        rocCurveOptions.setupForROCAnalysis(this.mPairedSampleCheck.isSelected());
        this.runSubDialog(rocCurveOptions);
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mTargetGroupVarFormatter.setVarMap(this.getDialogDataModel().getMap(this.mTargetGroupVarList.getIdentifier()));
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mTargetGroupVarList.getIdentifier(), this.mTargetGroupVarFormatter.getVarMapForSerialization());
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setupPanel(jPanel);
        this.setDefaults();
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RocAnalysisDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_ROC_ANALYSIS_DISPLAY_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RocAnalysisDlg.this.runSubDialog(new RocDisplayOptions(RocAnalysisDlg.this));
            }
        };
        this.mDisplayButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mDisplayButton);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTestVarArrow);
        vector.add(this.mTestTargetVariableList);
        vector.add(this.mStateVarArrow);
        vector.add(this.mStateTargetVariableList);
        vector.add(this.mStateVarValEdit);
        vector.add(this.mPairedSampleCheck);
        vector.add(this.mGroupVarArrow);
        vector.add(this.mTargetGroupVarList);
        vector.add(this.mGroupButton);
        vector.add(this.mOptionsButton);
        vector.add(this.mDisplayButton);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mStateVarValEdit.setText("");
        this.mStateVarValEdit.setEnabled(false);
        this.mPairedSampleCheck.setSelected(false);
        this.mGroupButton.setEnabled(false);
        this.mTestTargetVariableList.removeAll();
        this.mStateTargetVariableList.removeAll();
        this.mTargetGroupVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("ROC_ANALYSIS_SRC_LIST");
        this.mSrcVarList.loadFromActiveDataset();
        this.mStateTargetVariableList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mStateTargetVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mStateTargetVariableList.setIdentifier("ROC_ANALYSIS_STATE_TARGET_LIST");
        this.mTestTargetVariableList = new TargetVariableList();
        this.mTestTargetVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTestTargetVariableList.addVarFilter(new SpssVarFilter(8, false));
        this.mTestTargetVariableList.setIdentifier("ROC_ANALYSIS_TEST_TARGET_LIST");
        this.mGroupingVarLabel = DialogUtil.createLabel(this, "IDS_GROUP_VARIABLE_COLON");
        this.mTargetGroupVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetGroupVarList.setIdentifier("ROC_ANALYSIS_GROUP_TARGET_LIST");
        this.mTargetGroupVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetGroupVarFormatter = new DefineGroupsSubDlg.GroupVarFormatter(this.mTargetGroupVarList);
        this.mTargetGroupVarList.setModel(new DefineGroupsSubDlg.GroupVarModel(this.mTargetGroupVarFormatter));
        this.mTargetGroupVarList.setCellRenderer(new CustomVarListCellRenderer(this.mTargetGroupVarFormatter));
        this.mTestVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStateVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mGroupVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStateVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mStateVarArrow.registerVariableList(this.mStateTargetVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mTestVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTestVarArrow.registerVariableList(this.mTestTargetVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mGroupVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mGroupVarArrow.registerVariableList(this.mTargetGroupVarList, SpssArrowButton.ButtonOrientation.left);
        this.mStateVarValEdit = new StringTextField();
        this.mStateVarValEdit.setDocument(new FixedLengthDocument(29));
        this.mStateVarValEdit.setAction(new TextFieldAction(this, "ROC_ANALYSIS_STATE_EDIT"));
        this.mStateVarValEdit.setPreferredSize((Dimension)this.mStateVarValEdit.getPreferredSize().clone());
        this.mStateVarValEdit.setEnabled(false);
        this.mStateVarValEdit.setColumns(10);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_PAIRED_SAMPLE_CHECK");
        this.mPairedSampleCheck = new JCheckBox(toggleButtonAction);
        this.mPairedSampleCheck.setSelected(false);
        this.mPairedSampleCheck.addItemListener(this);
        this.mGroupButton = new JButton();
        toggleButtonAction = new ToggleButtonAction(this, "IDS_ROC_ANALYSIS_RANGE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = RocAnalysisDlg.this.mTargetGroupVarList.getModel().getElementAt(0).getType() != 0;
                String string = bl ? "idh_roc_define_groups_string" : "idh_roc_define_groups_numeric";
                RocAnalysisDlg.this.runSubDialog(new DefineGroupsSubDlg(RocAnalysisDlg.this, RocAnalysisDlg.this.mTargetGroupVarList.getModel().getElementAt(0).getType() != 0, RocAnalysisDlg.this.mTargetGroupVarList, string));
            }
        };
        this.mGroupButton = new JButton();
        this.mGroupButton.setAction(toggleButtonAction);
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void enableButtons() {
        boolean bl;
        boolean bl2 = false;
        String string = this.mStateVarValEdit.getText();
        boolean bl3 = this.mPairedSampleCheck.isSelected();
        boolean bl4 = bl = string != null && string.length() > 0 && this.mStateTargetVariableList.getModel().getSize() > 0;
        if ((!bl3 && this.mTestTargetVariableList.getModel().getSize() > 0 || bl3 && this.mTestTargetVariableList.getModel().getSize() > 1) && bl && this.isValidGroupVar()) {
            bl2 = true;
        }
        this.enableOkPaste(bl2);
    }

    private boolean isValidGroupVar() {
        boolean bl = true;
        if (!this.mPairedSampleCheck.isSelected() && this.mTargetGroupVarList.getModel().getSize() > 0) {
            ISpssVariable iSpssVariable = this.mTargetGroupVarList.getModel().getElementAt(0);
            String[] stringArray = (String[])this.mTargetGroupVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (stringArray != null && stringArray[0].equals("?")) {
                bl = false;
            }
        }
        return bl;
    }

    private void setupPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TEST_VARIABLE_COLON");
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_STATE_VARIABLE_COLON");
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_ROC_CURVE_SOURCE_LIST_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        jLabel.setLabelFor(this.mTestTargetVariableList);
        jLabel2.setLabelFor(this.mStateTargetVariableList);
        this.mGroupingVarLabel.setLabelFor(this.mTargetGroupVarList);
        this.mTestTargetVariableList.getModel().addListDataListener(this);
        this.mStateTargetVariableList.getModel().addListDataListener(this);
        this.mTargetGroupVarList.getModel().addListDataListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 9, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mTestVarArrow, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mGroupingVarLabel, gridBagConstraints, 2, 6, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        jScrollPane = new JScrollPane(this.mTestTargetVariableList);
        this.mTestTargetVariableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTestTargetVariableList.getFixedCellHeight() * 4 + 2));
        jScrollPane.setPreferredSize(this.mTestTargetVariableList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.mStateTargetVariableList);
        Dimension dimension = this.mStateTargetVariableList.getMinimumSize();
        dimension.height += 4;
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        jScrollPane = new JScrollPane(this.mTargetGroupVarList);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 7, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mStateVarArrow, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mGroupVarArrow, gridBagConstraints, 1, 7, 1, 1, n, insets2);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mGroupButton, gridBagConstraints, 2, 8, 1, 1, n, insets2);
        JPanel jPanel2 = this.setupStateValuePanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 4, 1, 1, n, null);
        n = 16;
        DialogUtil.addUsingGBL(jPanel, this.mPairedSampleCheck, gridBagConstraints, 2, 5, 1, 1, n, new Insets(15, -6, 0, 0));
    }

    private JPanel setupStateValuePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        final JLabel jLabel = DialogUtil.createLabel(this, "IDS_VALUE_STATE_VARIABLE_COLON");
        jLabel.setLabelFor((Component)((Object)this.mStateVarValEdit));
        jLabel.setEnabled(false);
        this.mStateVarValEdit.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                    jLabel.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mStateVarValEdit), gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mStateVarValEdit.getDocument().addDocumentListener(this);
        return jPanel;
    }
}

