/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.KNNFeaturesTab;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.KNNNeighborsTab;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.KNNOptionsTab;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.KNNOutputTab;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.KNNPartitionsTab;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.KNNSaveTab;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.KNNVariablesTab;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class NearestNeighborAnalysisDlg
extends BaseTabbedDialog {
    private KNNVariablesTab mVariableTab;
    private KNNPartitionsTab mPartitionTab;
    private KNNNeighborsTab mNeighborTab;
    private KNNFeaturesTab mFeaturesTab;
    private KNNSaveTab mSaveTab;
    private KNNOutputTab mExportTab;
    private KNNOptionsTab mOptionTab;

    public NearestNeighborAnalysisDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_NEAREST_NEIGHBOR_TITLE"));
        this.setLocationRelativeTo(jFrame);
    }

    public static void setSelectionText(JComponent jComponent) {
        NearestNeighborAnalysisDlg.setSelectionText(jComponent, 0);
    }

    public static void setSelectionText(final JComponent jComponent, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.requestFocusInWindow();
            }
        });
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setSelectionStart(n);
            ((JTextField)jComponent).setSelectionEnd(((JTextField)jComponent).getText().length());
        }
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSaveTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mSaveTab.saveTabState(this.getDialogDataModel());
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("*Nearest Neighbor Analysis.\n");
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string3 = this.mExportTab.getDataSetCommand(dialogDataModel);
        if (string3.length() > 0) {
            stringBuffer.append(string3).append("\n");
        }
        if ((string2 = this.mSaveTab.getDeleteVariableNameSyntax(dialogDataModel)).length() > 0) {
            stringBuffer.append(string2).append("\n");
        }
        if ((string = this.mPartitionTab.getSeedCommand(dialogDataModel)).length() > 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(this.mVariableTab.getVariablesTabSyntax(dialogDataModel));
        stringBuffer.append(this.mNeighborTab.getModelSyntaxFromNeighborsTab(dialogDataModel));
        stringBuffer.append(this.mFeaturesTab.getFeaturesSyntax(dialogDataModel));
        stringBuffer.append(this.mNeighborTab.getCriteriaSyntax(dialogDataModel));
        stringBuffer.append(this.mFeaturesTab.getStoppingRuleSyntax(dialogDataModel));
        stringBuffer.append(this.mPartitionTab.getPartitionSyntax(dialogDataModel));
        stringBuffer.append(this.mSaveTab.getSaveTabSyntax());
        stringBuffer.append(this.mExportTab.getExportTabSyntax(dialogDataModel));
        stringBuffer.append(this.mOptionTab.getOptionTabSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        String string4 = this.mExportTab.getModelFilePath();
        PesFile pesFile = PES_Repository.getPesFile((String)string4);
        if (pesFile != null) {
            stringBuffer.append(pesFile.getPerAttributesSyntax());
        }
        if ((pesFile = PES_Repository.getPesFile((String)(string4 = this.mExportTab.getNewDataFilePath()))) != null) {
            stringBuffer.append(pesFile.getPerAttributesSyntax());
        }
        if (string.length() > 0) {
            stringBuffer.append("RESTORE").append(SyntaxUtil.terminateSyntax());
        }
        if (string3.length() > 0 && CommandLine.isClementineCaller() && RemoteFileChooser.enableSaveInModeler()) {
            stringBuffer.append("\nDATASET ACTIVATE " + this.mExportTab.getNewDatasetName());
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        if (!this.getVariablesTab().validateTab()) {
            return false;
        }
        if (!this.mNeighborTab.validateTab()) {
            return false;
        }
        if (!this.mFeaturesTab.validateTab()) {
            return false;
        }
        if (!this.mPartitionTab.validateTab()) {
            return false;
        }
        if (!this.mExportTab.validateTab()) {
            return false;
        }
        if (!this.mSaveTab.validateTab()) {
            return false;
        }
        if (!this.mExportTab.validateTab()) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String getIActionKey() {
        return "analyze_classify_nearest_neighbor";
    }

    public KNNVariablesTab getVariablesTab() {
        return this.mVariableTab;
    }

    public KNNPartitionsTab getPartitionsTab() {
        return this.mPartitionTab;
    }

    public KNNSaveTab getSaveTab() {
        return this.mSaveTab;
    }

    public KNNNeighborsTab getNeighborsTab() {
        return this.mNeighborTab;
    }

    public KNNOptionsTab getOptionsTab() {
        return this.mOptionTab;
    }

    public KNNFeaturesTab getFeaturesTab() {
        return this.mFeaturesTab;
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    public boolean hasSplitVar() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.getNSplitVars();
        return n > 0;
    }

    @Override
    public void reset() {
        Object[] objectArray = this.getResStringArray("IDS_NEAREST_NEIGHBOR_RESET_BUTTON_LABELS");
        int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), this.getResString("ERR_NEAREST_NEIGHBOR_RESET_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
        if (n != 2) {
            if (n == 0) {
                super.reset();
                this.mVariableTab.reset();
                this.mNeighborTab.reset();
                this.mFeaturesTab.reset();
                this.mPartitionTab.reset();
                this.mSaveTab.reset();
                this.mExportTab.reset();
                this.mOptionTab.reset();
            } else {
                Component component = this.mTabbedPane.getSelectedComponent();
                if (component instanceof BaseProcedureTab) {
                    ((BaseProcedureTab)component).reset();
                }
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.mVariableTab = new KNNVariablesTab(this);
        this.addTab(this.getResString("IDS_NEAREST_NEIGHBOR_VARIABLES_TAB"), this.mVariableTab);
        this.mNeighborTab = new KNNNeighborsTab(this);
        this.addTab(this.getResString("IDS_NEAREST_NEIGHBOR_NEIGHBORS_TAB"), this.mNeighborTab);
        this.mFeaturesTab = new KNNFeaturesTab(this);
        this.addTab(this.getResString("IDS_NEAREST_NEIGHBOR_FEATURES_TAB"), this.mFeaturesTab);
        this.mPartitionTab = new KNNPartitionsTab(this);
        this.addTab(this.getResString("IDS_NEAREST_NEIGHBOR_PARTITIONS_TAB"), this.mPartitionTab);
        this.mSaveTab = new KNNSaveTab(this);
        this.addTab(this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_TAB"), this.mSaveTab);
        this.mExportTab = new KNNOutputTab(this);
        this.addTab(this.getResString("IDS_NEAREST_NEIGHBOR_EXPORT_TAB"), this.mExportTab);
        this.mOptionTab = new KNNOptionsTab(this);
        this.addTab(this.getResString("IDS_NEAREST_NEIGHBOR_OPTIONS_TAB"), this.mOptionTab);
        this.pack();
    }

    public static class MesgPanel
    extends JPanel {
        private JTextArea mInfoDesc;

        public MesgPanel(String string) {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.initLayout(this.getFont(), string);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    MesgPanel.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    MesgPanel.this.repaint();
                }
            });
        }

        protected void initLayout(Font font, String string) {
            this.mInfoDesc = new JTextArea();
            this.mInfoDesc.setOpaque(false);
            this.mInfoDesc.setFont(font);
            this.mInfoDesc.setLineWrap(true);
            this.mInfoDesc.setWrapStyleWord(true);
            this.mInfoDesc.setText("");
            this.mInfoDesc.setFocusable(false);
            this.mInfoDesc.setText(string);
            this.mInfoDesc.setEnabled(true);
            this.getAccessibleContext().setAccessibleName(this.mInfoDesc.getText());
            this.getAccessibleContext().setAccessibleDescription(this.mInfoDesc.getText());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            DialogUtil.addUsingGBL(this, this.mInfoDesc, gridBagConstraints, 0, 0, 1, 1, n, null);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                this.paintFocus(graphics);
            }
        }

        public void paintFocus(Graphics graphics) {
            Color color = UIManager.getColor("ToggleButton.focus");
            graphics.setColor(color);
            Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

