/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.KNNPartitionsTab;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.NearestNeighborAnalysisDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class KNNVariablesTab
extends BaseProcedureTab
implements ItemListener,
ListDataListener {
    private static final String SRC_VAR_LIST = "IDS_KNN_VARIABLE_SRC_VARLIST";
    static final String FEATURE_TARGET_LIST_KEY = "IDS_KNN_VARIABLE_FEATURE_TARGET_LIST";
    static final String TARGET_LIST_KEY = "IDS_KNN_VARIABLE_TARGET_LIST";
    static final String CASE_IDENTIFICATION_KEY = "IDS_KNN_VARIABLE_CASE_IDENTIFICATION_TARGET_LIST_KEY";
    static final String FOCAL_CASE_IDENTIFIER_KEY = "IDS_KNN_VARIABLE_FOCAL_CASE_IDENTIFIER_TARGET_LIST_KEY";
    private ConstextTextArea mAutoDesc;
    private SrcVariableList mVariableSrcList;
    private JLabel mSrcListLabel;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mDepVarList;
    private TargetVariableList mFeatureVarList;
    private TargetVariableList mCaseIdenVarList;
    private TargetVariableList mFocalCaseIdenVarList;
    private JScrollPane mDepVarListScrollPane;
    private JScrollPane mFeatureVarListScrollPane;
    private JScrollPane mCaseIdenScrollPane;
    private JScrollPane mFocalCaseIdenVarListScrollPane;
    private ArrowButton mDepArrowButton;
    private ArrowButton mFeatureArrowButton;
    private ArrowButton mCaseIdenArrowButton;
    private ArrowButton mFocalCaseArrowButton;
    private JCheckBox mNormCovarCheckBox;

    public KNNVariablesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mVariableSrcList;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object.equals(this.mFeatureVarList.getModel())) {
            VarListModel varListModel = this.mFeatureVarList.getModel();
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
            VarListModel varListModel2 = ((NearestNeighborAnalysisDlg)this.mParent).getFeaturesTab().getForwardVarListModel();
            VarListModel varListModel3 = ((NearestNeighborAnalysisDlg)this.mParent).getFeaturesTab().getForcedVarListModel();
            int n = varListModel2.getSize();
            int n2 = varListModel3.getSize();
            if (n > 0 || n2 > 0) {
                int n3 = 0;
                boolean bl = false;
                for (n3 = 0; n3 < varListModel.getSize(); ++n3) {
                    bl = false;
                    ISpssVariable iSpssVariable = varListModel.getElementAt(n3);
                    if (n > 0 && varListModel2.findElementIndex(iSpssVariable) >= 0) {
                        bl = true;
                    }
                    if (n2 > 0 && !bl && varListModel3.findElementIndex(iSpssVariable) >= 0) {
                        bl = true;
                    }
                    if (bl) continue;
                    vector.add(iSpssVariable);
                }
                for (ISpssVariable iSpssVariable : vector) {
                    varListModel2.addElement(iSpssVariable);
                }
                vector.clear();
            }
            this.setEnabledOkPaste();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object.equals(this.mFeatureVarList.getModel())) {
            VarListModel varListModel = this.mFeatureVarList.getModel();
            Vector<Object> vector = new Vector<Object>();
            VarListModel varListModel2 = ((NearestNeighborAnalysisDlg)this.mParent).getFeaturesTab().getForwardVarListModel();
            VarListModel varListModel3 = ((NearestNeighborAnalysisDlg)this.mParent).getFeaturesTab().getForcedVarListModel();
            int n = varListModel2.getSize();
            int n2 = varListModel3.getSize();
            if (n > 0 || n2 > 0) {
                Object object2;
                int n3 = 0;
                if (n > 0) {
                    for (n3 = 0; n3 < n; ++n3) {
                        object2 = varListModel2.getElementAt(n3);
                        if (varListModel.findElementIndex((ISpssVariable)object2) >= 0) continue;
                        vector.add(object2);
                    }
                    for (ISpssVariable iSpssVariable : vector) {
                        varListModel2.removeElement(iSpssVariable);
                    }
                    vector.clear();
                }
                if (n2 > 0) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        object2 = varListModel3.getElementAt(n3);
                        if (varListModel.findElementIndex((ISpssVariable)object2) >= 0) continue;
                        vector.add(object2);
                    }
                    for (ISpssVariable iSpssVariable : vector) {
                        varListModel3.removeElement(iSpssVariable);
                    }
                    vector.clear();
                }
            }
            this.setEnabledOkPaste();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected boolean validateTab() {
        if (this.mDepVarList.getModel().getSize() == 0) {
            if (((NearestNeighborAnalysisDlg)this.mParent).getNeighborsTab().isAutomaticallySelectedK()) {
                Object[] objectArray = this.getResStringArray("ERR_NEAREST_NEIGHBOR_AUTO_SELECT_ALERTS_BUTTON_LABEL");
                int n = SpssAlertOptionPane.showOptionDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_AUTO_SELECT_ALERTS_MESG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
                if (n == 0) {
                    this.mVariableSrcList.requestFocusInWindow();
                } else {
                    ((NearestNeighborAnalysisDlg)this.mParent).getNeighborsTab().selectSpecifyKRadio(true);
                    ((NearestNeighborAnalysisDlg)this.mParent).getTabbedPane().setSelectedComponent(((NearestNeighborAnalysisDlg)this.mParent).getNeighborsTab());
                    ((NearestNeighborAnalysisDlg)this.mParent).getNeighborsTab().setFocusOnKvalue();
                }
                return false;
            }
            if (((NearestNeighborAnalysisDlg)this.mParent).getFeaturesTab().isPerformFeatureSelected()) {
                Object[] objectArray = this.getResStringArray("ERR_NEAREST_NEIGHBOR_PERFORM_FEATURE_ALERTS_BUTTON_LABEL");
                int n = SpssAlertOptionPane.showOptionDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_PERFORM_FEATURE_ALERTS_MESG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
                if (n == 0) {
                    this.mVariableSrcList.requestFocusInWindow();
                } else {
                    ((NearestNeighborAnalysisDlg)this.mParent).getFeaturesTab().selectPerformFeatureCheckbox(false);
                    ((NearestNeighborAnalysisDlg)this.mParent).getTabbedPane().setSelectedComponent(((NearestNeighborAnalysisDlg)this.mParent).getFeaturesTab());
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_KNN_VARIABLES";
    }

    public VarListModel getTargetListModel() {
        return this.mDepVarList.getModel();
    }

    public VarListModel getSrcListModel() {
        return this.mVariableSrcList.getModel();
    }

    public VarListModel getFeatureListModel() {
        return this.mFeatureVarList.getModel();
    }

    public VarListModel getFocalCaseIdentifierListModel() {
        return this.mFocalCaseIdenVarList.getModel();
    }

    public String getVariablesTabSyntax(DialogDataModel dialogDataModel) {
        Boolean bl;
        Object object;
        Object object2;
        int n;
        StringBuffer stringBuffer;
        VarListModel varListModel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer2.append("KNN ");
        VarListModel varListModel2 = this.getTargetListModel();
        if (varListModel2.getSize() == 1) {
            varListModel = varListModel2.getElementAt(0);
            stringBuffer2.append(varListModel.getName()).append(" ");
            stringBuffer = varListModel.getDisplayMeasurementLevel();
            stringBuffer2.append("(MLEVEL=");
            if (stringBuffer == MeasurementLevel.scale) {
                stringBuffer2.append("S");
            } else if (stringBuffer == MeasurementLevel.nominal) {
                stringBuffer2.append("N");
            } else if (stringBuffer == MeasurementLevel.ordinal) {
                stringBuffer2.append("O");
            } else {
                stringBuffer2.append("S");
            }
            stringBuffer2.append(") ");
        }
        varListModel = this.getFeatureListModel();
        stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n = 0; n < varListModel.getSize(); ++n) {
            object2 = varListModel.getElementAt(n);
            object = object2.getDisplayMeasurementLevel();
            if (object == MeasurementLevel.nominal || object == MeasurementLevel.ordinal) {
                stringBuffer3.append(object2.getName()).append(" ");
                continue;
            }
            stringBuffer.append(object2.getName()).append(" ");
        }
        if (stringBuffer3.length() > 0) {
            stringBuffer2.append("BY ").append(stringBuffer3).append(" ");
        }
        n = 0;
        if (stringBuffer.length() > 0) {
            stringBuffer2.append("WITH ").append(stringBuffer);
            n = 1;
        }
        if (((VarListModel)(object2 = this.mFocalCaseIdenVarList.getModel())).getSize() == 1) {
            stringBuffer2.append("\n  /FOCALCASES VARIABLE=");
            object = ((VarListModel)object2).getElementAt(0);
            stringBuffer2.append(object.getName());
        }
        if (((VarListModel)(object = this.mCaseIdenVarList.getModel())).getSize() == 1) {
            stringBuffer2.append("\n  /CASELABELS VARIABLE=");
            bl = ((VarListModel)object).getElementAt(0);
            stringBuffer2.append(bl.getName());
        }
        if (n != 0) {
            bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_NORM_LABEL");
            if (bl != null && bl.booleanValue()) {
                stringBuffer2.append("\n  /RESCALE COVARIATE=ADJNORMALIZED");
            } else {
                stringBuffer2.append("\n  /RESCALE COVARIATE=NONE");
            }
        }
        return stringBuffer2.toString();
    }

    boolean hasCategoricalTarget() {
        ISpssVariable iSpssVariable;
        MeasurementLevel measurementLevel;
        boolean bl = false;
        VarListModel varListModel = this.getTargetListModel();
        if (varListModel.getSize() == 1 && ((measurementLevel = (iSpssVariable = varListModel.getElementAt(0)).getDisplayMeasurementLevel()) == MeasurementLevel.nominal || measurementLevel == MeasurementLevel.ordinal)) {
            return true;
        }
        return bl;
    }

    @Override
    public void reset() {
        this.mDepVarList.getModel().removeAll();
        this.mFeatureVarList.getModel().removeAll();
        this.mFocalCaseIdenVarList.removeAll();
        this.mCaseIdenVarList.removeAll();
        this.setDefaults();
        KNNPartitionsTab kNNPartitionsTab = ((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab();
        if (kNNPartitionsTab != null) {
            TargetVariableList targetVariableList = kNNPartitionsTab.getPartioningVariable();
            if (targetVariableList == null) {
                return;
            }
            VarListModel varListModel = targetVariableList.getModel();
            if (varListModel.getSize() > 0) {
                this.mVariableSrcList.getModel().removeElement(varListModel.getElementAt(0));
            }
        }
    }

    public boolean setEnabledOkPaste() {
        boolean bl = false;
        if (this.mFeatureVarList.getModel().getSize() > 0) {
            bl = true;
        }
        ((NearestNeighborAnalysisDlg)this.mParent).enableOkPaste(bl);
        return bl;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
    }

    private void initialize() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Dimension dimension = this.mSrcScrollPane.getPreferredSize();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 0, 0);
        gridBagConstraints.fill = 0;
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        String string = this.getResString("IDS_NEAREST_NEIGHBOR_VARIABLES_TARGET_VAR_MESG");
        this.mAutoDesc = new ConstextTextArea(string);
        this.mAutoDesc.setOpaque(false);
        this.mAutoDesc.setFont(this.mSrcListLabel.getFont());
        this.mAutoDesc.setLineWrap(true);
        this.mAutoDesc.setWrapStyleWord(true);
        this.mAutoDesc.setRows(2);
        this.mAutoDesc.setEditable(false);
        this.mAutoDesc.setFocusable(true);
        this.mAutoDesc.setMinimumSize(new Dimension(dimension.width * 2, 32));
        this.mAutoDesc.setPreferredSize(new Dimension(dimension.width * 2, 32));
        StringTextField stringTextField = new StringTextField();
        insets.set(n2, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mAutoDesc, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 3, 1, n, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(this, this.mSrcListLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.mSrcScrollPane, gridBagConstraints, 0, 2, 1, 6, n, null);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_NEAREST_NEIGHBOR_VARIABLES_MESG"));
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.mSrcListLabel.getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setRows(3);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setEditable(false);
        dimension = this.mSrcScrollPane.getPreferredSize();
        jTextArea.setMinimumSize(new Dimension(dimension.width, 32));
        jTextArea.setPreferredSize(new Dimension(dimension.width, 32));
        insets.set(n2, n2, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jTextArea, gridBagConstraints, 0, 8, 1, 2, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_TARGET_VAR_LABEL");
        jLabel2.setLabelFor(this.mDepVarList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this, jLabel2, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 * 2, insets2.left, 0, 0);
        DialogUtil.addUsingGBL(this, this.mDepArrowButton, gridBagConstraints, 1, 1, 1, 2, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(1, insets2.left, n2, n2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this, this.mDepVarListScrollPane, gridBagConstraints, 2, 2, 1, 1, n, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_COVARIATE_VAR_LABEL");
        jLabel3.setLabelFor(this.mFeatureVarList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this, jLabel3, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, 0);
        DialogUtil.addUsingGBL(this, this.mFeatureArrowButton, gridBagConstraints, 1, 4, 1, 1, 10, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(this, this.mFeatureVarListScrollPane, gridBagConstraints, 2, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left - 2, n2, 0);
        DialogUtil.addUsingGBL(this, this.mNormCovarCheckBox, gridBagConstraints, 2, 5, 1, 1, n, insets);
        JLabel jLabel4 = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_FOCAL_CASE_VAR_LABEL");
        jLabel4.setLabelFor(this.mFocalCaseIdenVarList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this, jLabel4, gridBagConstraints, 2, 6, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 10, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mFocalCaseArrowButton, gridBagConstraints, 1, 6, 1, 2, 20, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, insets2.left, 10, n2);
        DialogUtil.addUsingGBL(this, this.mFocalCaseIdenVarListScrollPane, gridBagConstraints, 2, 7, 1, 1, n, insets);
        JLabel jLabel5 = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_CASE_VAR_LABEL");
        jLabel5.setLabelFor(this.mCaseIdenVarList);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.set(6, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this, jLabel5, gridBagConstraints, 2, 8, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(10, insets2.left, 0, 0);
        DialogUtil.addUsingGBL(this, this.mCaseIdenArrowButton, gridBagConstraints, 1, 8, 1, 2, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(this, this.mCaseIdenScrollPane, gridBagConstraints, 2, 9, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVariableSrcList);
        vector.add(this.mDepArrowButton);
        vector.add(this.mFeatureArrowButton);
        vector.add(this.mFocalCaseArrowButton);
        vector.add(this.mCaseIdenArrowButton);
        vector.add(this.mDepVarList);
        vector.add(this.mFeatureVarList);
        vector.add(this.mNormCovarCheckBox);
        vector.add(this.mFocalCaseIdenVarList);
        vector.add(this.mCaseIdenVarList);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
        return vector;
    }

    private void setDefaults() {
        this.mVariableSrcList.loadFromActiveDataset();
        this.mVariableSrcList.setSelectedIndex(0);
        VarListModel varListModel = this.mVariableSrcList.getModel();
        this.mDepArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mDepArrowButton.setEnabled(true);
        this.mFeatureArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mNormCovarCheckBox.setSelected(true);
    }

    private void initVars() {
        this.mVariableSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mVariableSrcList.getModel().addListDataListener(this);
        SplitVarFilter splitVarFilter = new SplitVarFilter();
        this.mVariableSrcList.addVarFilter(splitVarFilter);
        this.mVariableSrcList.setIdentifier(SRC_VAR_LIST);
        this.mVariableSrcList.setContextMenuFlags(this.mVariableSrcList.getContextMenuFlags() | 8);
        this.mSrcListLabel = DialogUtil.createLabel(this.mParent, "IDS_KMEANS_VARIABLES");
        this.mSrcListLabel.setLabelFor(this.mVariableSrcList);
        this.mSrcScrollPane = new JScrollPane(this.mVariableSrcList);
        this.mSrcScrollPane.setPreferredSize(this.mVariableSrcList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mDepVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDepVarList.addVarFilter(splitVarFilter);
        this.mDepVarList.getModel().addListDataListener(this);
        this.mDepVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDepVarList.setIdentifier(TARGET_LIST_KEY);
        this.mDepVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDepVarList.getFixedCellHeight()));
        this.mDepVarListScrollPane = new JScrollPane(this.mDepVarList);
        this.mDepVarListScrollPane.setVerticalScrollBarPolicy(21);
        this.mDepVarListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mDepVarListScrollPane.setPreferredSize(this.mDepVarList.getMaximumSize());
        this.mFeatureVarList = new TargetVariableList();
        this.mFeatureVarList.getModel().addListDataListener(this);
        this.mFeatureVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFeatureVarList.addVarFilter(splitVarFilter);
        this.mFeatureVarList.setIdentifier(FEATURE_TARGET_LIST_KEY);
        this.mFeatureVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFeatureVarList.getFixedCellHeight() * 8 + 2));
        this.mFeatureVarListScrollPane = new JScrollPane(this.mFeatureVarList);
        this.mFeatureVarListScrollPane.setPreferredSize(this.mFeatureVarList.getMinimumSize());
        this.mCaseIdenVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCaseIdenVarList.getModel().addListDataListener(this);
        this.mCaseIdenVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCaseIdenVarList.addVarFilter(splitVarFilter);
        this.mCaseIdenVarList.setIdentifier(CASE_IDENTIFICATION_KEY);
        this.mCaseIdenVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCaseIdenVarList.getFixedCellHeight()));
        this.mCaseIdenScrollPane = new JScrollPane(this.mCaseIdenVarList);
        this.mCaseIdenScrollPane.setVerticalScrollBarPolicy(21);
        this.mCaseIdenScrollPane.setHorizontalScrollBarPolicy(31);
        this.mCaseIdenScrollPane.setPreferredSize(this.mCaseIdenVarList.getMinimumSize());
        this.mFocalCaseIdenVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mFocalCaseIdenVarList.getModel().addListDataListener(this);
        this.mFocalCaseIdenVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFocalCaseIdenVarList.addVarFilter(splitVarFilter);
        this.mFocalCaseIdenVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mFocalCaseIdenVarList.setIdentifier(FOCAL_CASE_IDENTIFIER_KEY);
        this.mFocalCaseIdenVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFocalCaseIdenVarList.getFixedCellHeight()));
        this.mFocalCaseIdenVarListScrollPane = new JScrollPane(this.mFocalCaseIdenVarList);
        this.mFocalCaseIdenVarListScrollPane.setVerticalScrollBarPolicy(21);
        this.mFocalCaseIdenVarListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mFocalCaseIdenVarListScrollPane.setPreferredSize(this.mFocalCaseIdenVarList.getMinimumSize());
        this.mDepArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDepArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mDepArrowButton.registerVariableList(this.mDepVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFeatureArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFeatureArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mFeatureArrowButton.registerVariableList(this.mFeatureVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCaseIdenArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCaseIdenArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mCaseIdenArrowButton.registerVariableList(this.mCaseIdenVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFocalCaseArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFocalCaseArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mFocalCaseArrowButton.registerVariableList(this.mFocalCaseIdenVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_NORM_LABEL");
        this.mNormCovarCheckBox = new JCheckBox(toggleButtonAction);
        this.mNormCovarCheckBox.addItemListener(this);
    }

    public SplitVarFilter getSplitVarFilter() {
        return new SplitVarFilter();
    }

    class ConstextTextArea
    extends JTextArea {
        ConstextTextArea(String string) {
            super(string);
            if (this.accessibleContext == null) {
                this.accessibleContext = this.getAccessibleContext();
                this.accessibleContext.setAccessibleName(string);
                this.accessibleContext.setAccessibleDescription(string);
            }
        }

        public void setAccessibleContextName(String string) {
            this.accessibleContext.setAccessibleName(string);
        }

        public void setAccessibleContextDescription(String string) {
            this.accessibleContext.setAccessibleDescription(string);
        }
    }

    private class SplitVarFilter
    implements IVarFilter {
        private SplitVarFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.getNSplitVars();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(iSpssDataSrc.getSplitVarIndex(i));
                if (iSpssVariable == null || iSpssVariable2 == null || !iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                return false;
            }
            return true;
        }
    }
}

