/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.KNNSaveTableModel;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.NearestNeighborAnalysisDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.cox_reg.CSCoxRegSaveVariable;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class KNNSaveTab
extends BaseProcedureTab
implements ItemListener,
DocumentListener {
    private JRadioButton mAutoNameRadio;
    private JRadioButton mCustomNameRadio;
    private PlainTable mSaveTable;
    private KNNSaveTableModel mSaveTableModel;
    private JLabel mMaxCatsToSaveLabel;
    private IntTextField mMaxCatsToSaveField;
    private StringBuffer mSavedSyntax = new StringBuffer("");
    private boolean mHasTargetVar = false;
    private boolean mIsCateTargetVar = false;
    private boolean mRandomAssignToPartition = false;
    private boolean mRandomAssignToFold = false;
    private Vector<String> mCustomNames = new Vector();
    private static final String MAX_CATS_TO_SAVE = "IDS_NEAREST_NEIGHBOR_SAVE_MAX_CATS";
    private static final String SAVE_TABLE_DATA = "IDS_NEAREST_NEIGHBOR_SAVE_TABLE_MODEL_DATA";
    private static final String SAVE_NAME_PREFIX = "KNN_";
    static final int VAR_ROOT_COL_IND = 2;

    public KNNSaveTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_KNN_SAVE";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mAutoNameRadio) {
            this.mSaveTableModel.resetNames();
        }
        if (itemEvent.getSource() == this.mCustomNameRadio) {
            int n = this.mSaveTable.getSelectedRow();
            int n2 = this.mSaveTable.getSelectedColumn();
            this.mSaveTableModel.setEnableFlags(this.mCustomNameRadio.isSelected(), this.mHasTargetVar, this.mIsCateTargetVar, this.mRandomAssignToPartition, this.mRandomAssignToFold);
            this.mSaveTable.changeSelection(n, n2, false, false);
        }
    }

    public String getDeleteVariableNameSyntax(DialogDataModel dialogDataModel) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        boolean bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_SAVE_CUSTOM_VARIABLE_NAME");
        this.mSavedSyntax.delete(0, this.mSavedSyntax.length());
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        Object[] objectArray = dialogDataModel.getSerializableArray(SAVE_TABLE_DATA);
        StringBuffer stringBuffer2 = new StringBuffer("");
        boolean bl2 = false;
        if (objectArray != null) {
            for (int i = 0; i < 4; ++i) {
                if (i == 1) {
                    bl2 = ((CSCoxRegSaveVariable)objectArray[i]).isSelected();
                }
                this.addSaveVariable(objectArray, stringBuffer2, i, stringBuffer, bl, iSpssDataSrc);
            }
        }
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (stringBuffer.length() > 0) {
            stringBuffer3.append("\nDELETE VARIABLES").append(stringBuffer).append(".");
        }
        if (stringBuffer2.length() > 0) {
            this.mSavedSyntax.append("\n  /SAVE ").append(stringBuffer2);
            if (this.mIsCateTargetVar && bl2) {
                this.mSavedSyntax.append(" MAXCAT(").append(this.mMaxCatsToSaveField.getText()).append(") ");
            }
        }
        return stringBuffer3.toString();
    }

    public String getSaveTabSyntax() {
        return this.mSavedSyntax.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        for (int i = 0; i < this.mSaveTable.getModel().getRowCount(); ++i) {
            this.mSaveTable.getModel().setValueAt(false, i, 0);
        }
        this.setupColumnWidths();
        this.updateTable();
        this.validate();
        this.setFocusTraversalPolicy();
        this.repaint();
    }

    @Override
    public boolean validateTab() {
        return this.doValidation();
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        Object[] objectArray = dialogDataModel.getSerializableArray(SAVE_TABLE_DATA);
        if (objectArray != null && this.mSaveTable != null) {
            ((KNNSaveTableModel)this.mSaveTable.getModel()).copyData(objectArray);
        }
    }

    @Override
    public void saveTabState(DialogDataModel dialogDataModel) {
        Vector<CSCoxRegSaveVariable> vector = this.mSaveTableModel.getTableData();
        dialogDataModel.putSerializableArray(SAVE_TABLE_DATA, vector.toArray(new SerializableObject[vector.size()]));
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mAutoNameRadio;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setupColumnWidths();
        this.updateTable();
        if (((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().hasCategoricalTarget()) {
            this.mMaxCatsToSaveField.setEnabled(true);
            this.mMaxCatsToSaveLabel.setEnabled(true);
        } else {
            this.mMaxCatsToSaveField.setEnabled(false);
            this.mMaxCatsToSaveLabel.setEnabled(false);
        }
        this.validate();
        this.setFocusTraversalPolicy();
        this.repaint();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mAutoNameRadio);
        vector.add(this.mCustomNameRadio);
        vector.add(this.mSaveTable);
        vector.add(this.mMaxCatsToSaveField);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initialize() {
        this.initVars();
        super.initPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, n2, n2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.setupNamesOfSavedVariablesPanel(), gridBagConstraints, 0, 0, 2, 1, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_SAVE_VARIABLE_TO_SAVE");
        JScrollPane jScrollPane = new JScrollPane(this.mSaveTable, 21, 31);
        jLabel.setLabelFor(this.mSaveTable);
        int n3 = (int)this.mSaveTable.getCellRect(0, 0, true).getHeight();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 2, n2);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        jScrollPane.setMinimumSize(new Dimension(jScrollPane.getPreferredSize().width, 102));
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 102));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mMaxCatsToSaveLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, (JComponent)this.mMaxCatsToSaveField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void setDefaults() {
        this.mAutoNameRadio.setSelected(true);
        this.mMaxCatsToSaveField.setText("25");
        this.mSaveTableModel.setEnableFlags(this.mCustomNameRadio.isSelected(), false, false, true, false);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_SAVE_AUTO_VARIABLE_NAME");
        this.mAutoNameRadio = new JRadioButton(toggleButtonAction);
        this.mAutoNameRadio.setEnabled(true);
        this.mAutoNameRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_SAVE_CUSTOM_VARIABLE_NAME");
        this.mCustomNameRadio = new JRadioButton(toggleButtonAction);
        this.mCustomNameRadio.setEnabled(true);
        this.mCustomNameRadio.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAutoNameRadio);
        spssButtonGroup.add(this.mCustomNameRadio);
        this.mSaveTable = new PlainTable(){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (ComponentState.isBtdRtlOrLtr() && n2 == 2 && (JTextComponent)component != null && ((JTextComponent)component).getDocument() != null) {
                        if (ComponentState.getBTD() == 1) {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                        } else {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                        }
                    }
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mSaveTableModel = this.getSaveTableModel();
        this.mSaveTableModel.setDefaultNames();
        KNNSaveTableModel.COLUMN_NAMES[0] = this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_VARIABLE_TABLE_SAVE");
        KNNSaveTableModel.COLUMN_NAMES[1] = this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_VARIABLE_TABLE_DESCRIP");
        KNNSaveTableModel.COLUMN_NAMES[2] = this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_VARIABLE_TABLE_ROOT");
        this.mSaveTable.setModel(this.mSaveTableModel);
        this.mSaveTable.setRowSelectionAllowed(false);
        this.mSaveTable.setCellSelectionEnabled(true);
        int n = (int)this.mSaveTable.getCellRect(0, 0, true).getHeight();
        this.mSaveTable.setRowHeight(20);
        this.mSaveTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.mSaveTable.setDefaultRenderer(Object.class, new SaveTableRenderer());
        JTableHeader jTableHeader = this.mSaveTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = null;
                jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 0) {
                    jLabel.setHorizontalAlignment(0);
                } else {
                    jLabel.setHorizontalAlignment(2);
                }
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                return jLabel;
            }
        });
        TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new CheckBoxRenderer());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mSaveTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mSaveTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mSaveTable.getActionMap().put("tabIn", abstractAction2);
        this.mSaveTable.getActionMap().put("tabOut", abstractAction);
        this.mMaxCatsToSaveLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_SAVE_MAX_NUM_CATEGORIES_LABEL");
        this.mMaxCatsToSaveField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMaxCatsToSaveField.setAction((Action)new TextFieldAction(this.mParent, MAX_CATS_TO_SAVE));
        this.mMaxCatsToSaveField.setColumns(5);
        this.mMaxCatsToSaveField.getDocument().addDocumentListener(this);
        this.mMaxCatsToSaveLabel.setLabelFor((Component)this.mMaxCatsToSaveField);
    }

    private JPanel setupNamesOfSavedVariablesPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_SAVED_VARIABLE_NAMES"));
        jPanel.setBorder(titledBorder);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(2);
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.mAutoNameRadio.getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_AUTO_VARIABLE_NAME_MESG"));
        jTextArea.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n, 0, n);
        int n2 = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mAutoNameRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(0, n * 5, 0, n);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mCustomNameRadio, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setRows(2);
        jTextArea2.setOpaque(false);
        jTextArea2.setFont(this.mCustomNameRadio.getFont());
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setText(this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_CUSTOM_VARIABLE_NAME_MESG"));
        jTextArea.setFocusable(false);
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n * 5, 0, n);
        DialogUtil.addUsingGBL(jPanel, jTextArea2, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        return jPanel;
    }

    private KNNSaveTableModel getSaveTableModel() {
        Vector<CSCoxRegSaveVariable> vector = new Vector<CSCoxRegSaveVariable>();
        CSCoxRegSaveVariable cSCoxRegSaveVariable = new CSCoxRegSaveVariable(false, this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_PREDICTED_VALUE_LABEL"), SAVE_NAME_PREFIX + this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_PREDICTED_VALUE_ROOT"), "PREDVAL");
        vector.addElement(cSCoxRegSaveVariable);
        cSCoxRegSaveVariable = new CSCoxRegSaveVariable(false, this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_PREDICTED_PROB_LABEL"), SAVE_NAME_PREFIX + this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_PREDICTED_PROB_ROOT"), "PREDPROB");
        vector.addElement(cSCoxRegSaveVariable);
        cSCoxRegSaveVariable = new CSCoxRegSaveVariable(false, this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_PARTITION_VAR_LABEL"), SAVE_NAME_PREFIX + this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_PARTITION_VAR_ROOT"), "PARTITION");
        vector.addElement(cSCoxRegSaveVariable);
        cSCoxRegSaveVariable = new CSCoxRegSaveVariable(false, this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_CROSS_FOLD_VAR_LABEL"), SAVE_NAME_PREFIX + this.getResString("IDS_NEAREST_NEIGHBOR_SAVE_CROSS_FOLD_VAR_ROOT"), "FOLD");
        vector.addElement(cSCoxRegSaveVariable);
        return new KNNSaveTableModel(vector);
    }

    private void addSaveVariable(Object[] objectArray, StringBuffer stringBuffer, int n, StringBuffer stringBuffer2, boolean bl, ISpssDataSrc iSpssDataSrc) {
        CSCoxRegSaveVariable cSCoxRegSaveVariable = (CSCoxRegSaveVariable)objectArray[n];
        if (cSCoxRegSaveVariable.isSelected()) {
            stringBuffer.append(" ");
            stringBuffer.append(cSCoxRegSaveVariable.getKeyword());
            if (bl) {
                stringBuffer.append("(");
                String string = cSCoxRegSaveVariable.getName().trim();
                stringBuffer.append(string).append(")");
                if (iSpssDataSrc.findVarIndex(string) > -1) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string);
                }
                Vector<String> vector = DocUtil.findVariablesWithRootName(string);
                for (String string2 : vector) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string2);
                }
            }
        }
    }

    private boolean doValidation() {
        String string;
        this.mCustomNames.clear();
        TableCellEditor tableCellEditor = this.mSaveTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        if (this.mCustomNameRadio.isSelected()) {
            if (this.mHasTargetVar && !this.validateName(0)) {
                return false;
            }
            if (this.mIsCateTargetVar && !this.validateName(1)) {
                return false;
            }
            if (this.mRandomAssignToPartition && !this.validateName(2)) {
                return false;
            }
            if (this.mRandomAssignToFold && !this.validateName(3)) {
                return false;
            }
        }
        if (this.mIsCateTargetVar && ((string = this.mMaxCatsToSaveField.getText()).length() == 0 || Integer.parseInt(string) == 0)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_NEAREST_NEIGHBOR_TARGET_MAX_CATS_WARNING"), VersionInfo.getAppVersionString());
            NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mMaxCatsToSaveField);
            return false;
        }
        return true;
    }

    private boolean validateName(int n) {
        boolean bl = (Boolean)this.mSaveTableModel.getValueAt(n, 0);
        if (bl) {
            String string = ((String)this.mSaveTableModel.getValueAt(n, 2)).trim();
            if (string.length() < 1) {
                this.errorMessageForValue(n);
                return false;
            }
            if (string.length() > 64) {
                this.errorMessageForLength(n);
                return false;
            }
            if (VarNameValidator.ValidNameCode.SPSSNAME_STANDARD != VarNameValidator.validateSPSSName((String)string, (boolean)true)) {
                this.errorMessageForValue(n);
                return false;
            }
            String string2 = string.toUpperCase();
            if (this.mCustomNames.contains(string2)) {
                this.errorMessageForUnique(n);
                return false;
            }
            this.mCustomNames.add(string2);
        }
        return true;
    }

    private void errorMessageForLength(int n) {
        String string = String.format(this.getResString("ERR_NEAREST_NEIGHBOR_VAR_NAME_TO_LONG_WARNING"), 64);
        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string, VersionInfo.getAppVersionString());
        this.mSaveTable.setRowSelectionInterval(n, n);
        this.mSaveTable.editCellAt(n, 2);
    }

    private void errorMessageForValue(int n) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_NEAREST_NEIGHBOR_INVALID_VAR_NAME_WARNING"), VersionInfo.getAppVersionString());
        this.mSaveTable.setRowSelectionInterval(n, n);
        this.mSaveTable.editCellAt(n, 2);
    }

    private void errorMessageForUnique(int n) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_NEAREST_NEIGHBOR_VAR_NAME_NOT_UNIQUE_WARNING"), VersionInfo.getAppVersionString());
        this.mSaveTable.setRowSelectionInterval(n, n);
        this.mSaveTable.editCellAt(n, 2);
    }

    private void setupColumnWidths() {
        TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
        int n = this.mSaveTable.getWidth();
        tableColumnModel.getColumn(0).setPreferredWidth((int)((double)n * 0.1));
        tableColumnModel.getColumn(1).setPreferredWidth((int)((double)n * 0.6));
        tableColumnModel.getColumn(2).setPreferredWidth((int)((double)n * 0.3));
    }

    private void updateTable() {
        this.mHasTargetVar = ((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getTargetListModel().getSize() > 0;
        this.mIsCateTargetVar = ((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().hasCategoricalTarget();
        this.mRandomAssignToPartition = ((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab().isRandomlyAssignCasesToPartionsSelected();
        this.mRandomAssignToFold = ((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab().isRandomlyAssignCasesToFoldSelected();
        this.mSaveTableModel.setEnableFlags(this.mCustomNameRadio.isSelected(), this.mHasTargetVar, this.mIsCateTargetVar, this.mRandomAssignToPartition, this.mRandomAssignToFold);
        for (int i = 0; i < 4; ++i) {
            if (!this.mSaveTableModel.isCellEnabled(i, 0)) continue;
            this.mSaveTable.changeSelection(i, 0, false, false);
            this.mSaveTable.requestFocusInWindow();
            break;
        }
    }

    class SaveTableRenderer
    extends DefaultTableCellRenderer {
        SaveTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(((KNNSaveTableModel)jTable.getModel()).isCellEnabled(n, n2));
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
            } else {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            return this;
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        public CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(((KNNSaveTableModel)jTable.getModel()).isCellEnabled(n, n2));
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(this.mHighLightBorder);
            } else {
                this.setBorder(this.mEmptyBorder);
            }
            return this;
        }
    }
}

