/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.NearestNeighborAnalysisDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class KNNPartitionsTab
extends BaseProcedureTab
implements CaretListener,
ItemListener,
DocumentListener {
    public static final String RANDOMLY_ASSIGN_KEY = "IDS_NEAREST_NEIGHBOR_RANDOMLY_CASES_LABEL";
    public static final String USE_PARTITIONING_KEY = "IDS_NEAREST_NEIGHBOR_USE_PARTITIONING_LABEL";
    public static final String V_FOLD_USE_PARTITIONING_KEY = "IDS_NEAREST_NEIGHBOR_V_FILD_USE_PARTITIONING_LABEL";
    private static final String TARGET_PARTIONING_VARIBLE_KEY = "IDS_NEAREST_NEIGHBOR_PARTITION_VARIABLES";
    private static final String V_FOLD_TARGET_PARTIONING_VARIBLE_KEY = "IDS_NEAREST_NEIGHBOR__VFOLD_PARTION_VAR";
    private static final String SOURCE_LIST_KEY = "IDS_NEAREST_NEIGHBOR_PARTITION_SOURCE_LIST_KEY";
    private static final String TRAINING_PERCENT = "IDS_NEAREST_NEIGHBOR_TRINING_PERCENT";
    private static final String SEED_FIELD = "IDS_NEAREST_NEIGHBOR_PARTITION_SEED";
    public static final String V_FOLD_RANDOM_RADIO = "IDS_NEAREST_NEIGHBOR_CROSS_VALIDATION_RANDOMLY_CASES_LABEL";
    private static final String V_FOLD_NUM_OF_PARTITIONS = "IDS_NEAREST_NEIGHBOR_NUM_PARTITIONS";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mPartitioningVariable;
    private JRadioButton mUseRandomlyRadio;
    private JRadioButton mUseVariableRadio;
    private JScrollPane mSrcScrollPane;
    private JPanel mPartitionDatasetPanel;
    private ArrowButton mPartitioningArrow;
    private TargetVariableList mVFoldPartitioningVariable;
    private JLabel mPartitioningVarLabel;
    private JRadioButton mVFoldUseRandomlyRadio;
    private JRadioButton mVFoldUsePartioningVarRadio;
    private JPanel mVFoldPartitionPanel;
    private ArrowButton mVFoldPartitioningArrow;
    private JLabel mNumPartitionLabel;
    private IntTextField mNumPartitionField;
    private FloatTextField mTrainingNumber;
    private JLabel mHoldoutNumber;
    private JLabel mOneHundredField;
    private JCheckBox mSetSeedcheck;
    private JLabel mSeedLabel;
    private IntTextField mSeedField;
    private NumberFormat mRecordFormat;

    public KNNPartitionsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initializePanel();
    }

    public JPanel setUpListPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[2]);
        jScrollPane.setPreferredSize(jComponentArray[2].getMinimumSize());
        jScrollPane.setMinimumSize(jComponentArray[2].getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 1, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n - 5, 0, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 0, 1, 2, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 0, n * 2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, insets);
        return jPanel;
    }

    @Override
    public void reset() {
        VarListModel varListModel = this.mSrcVarList.getModel();
        if (this.mPartitioningVariable.getModel().getSize() > 0) {
            varListModel.addElement(this.mPartitioningVariable.getModel().getElementAt(0));
        }
        this.setDefaults();
        this.mPartitioningVariable.removeAll();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_KNN_PARTITIONS";
    }

    public TargetVariableList getPartioningVariable() {
        return this.mPartitioningVariable;
    }

    public boolean isRandomlyAssignCasesToFoldSelected() {
        return this.mVFoldUseRandomlyRadio.isSelected() && this.mVFoldUseRandomlyRadio.isEnabled();
    }

    public boolean isRandomlyAssignCasesToPartionsSelected() {
        return this.mUseRandomlyRadio.isSelected();
    }

    void setCrossVFoldRadioButtonEnabled(boolean bl) {
        this.mVFoldUseRandomlyRadio.setEnabled(bl);
        if (bl && this.mVFoldUseRandomlyRadio.isSelected()) {
            this.mNumPartitionField.setEnabled(true);
        } else {
            this.mNumPartitionField.setEnabled(false);
        }
        this.mVFoldUsePartioningVarRadio.setEnabled(bl);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mUseRandomlyRadio) {
            this.mTrainingNumber.setEnabled(true);
            this.mPartitioningArrow.setEnabled(false);
            this.mPartitioningVariable.setEnabled(false);
        } else if (object == this.mUseVariableRadio) {
            this.mTrainingNumber.setEnabled(false);
            this.mPartitioningArrow.setEnabled(true);
            this.mPartitioningVariable.setEnabled(true);
            if (this.mPartitioningVariable.getModel().getSize() == 1) {
                this.mPartitioningVariable.setSelectedIndex(0);
                this.mPartitioningArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            } else {
                this.mPartitioningArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            }
        }
        if (object == this.mVFoldUseRandomlyRadio) {
            this.mNumPartitionField.setEnabled(true);
            this.mNumPartitionLabel.setEnabled(true);
            this.mVFoldPartitioningArrow.setEnabled(false);
            this.mVFoldPartitioningVariable.setEnabled(false);
            this.mPartitioningVarLabel.setEnabled(false);
        } else if (object == this.mVFoldUsePartioningVarRadio) {
            this.mNumPartitionField.setEnabled(false);
            this.mNumPartitionLabel.setEnabled(false);
            this.mVFoldPartitioningArrow.setEnabled(true);
            this.mVFoldPartitioningVariable.setEnabled(true);
            this.mPartitioningVarLabel.setEnabled(true);
            if (this.mVFoldPartitioningVariable.getModel().getSize() == 1) {
                this.mVFoldPartitioningVariable.setSelectedIndex(0);
                this.mVFoldPartitioningArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            } else {
                this.mVFoldPartitioningArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            }
        }
        if (object == this.mSetSeedcheck) {
            if (itemEvent.getStateChange() == 1) {
                this.mSeedField.setEnabled(true);
                this.mSeedLabel.setEnabled(true);
            } else {
                this.mSeedField.setEnabled(false);
                this.mSeedLabel.setEnabled(false);
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        try {
            Object object = caretEvent.getSource();
            if (object == this.mTrainingNumber) {
                double d;
                String string = this.mTrainingNumber.getText();
                double d2 = 0.0;
                if (!string.equals("")) {
                    d2 = Double.parseDouble(string);
                }
                if ((d = 100.0 - d2) < 0.0) {
                    d = 0.0;
                }
                this.mHoldoutNumber.setText(this.mRecordFormat.format(d));
                this.mOneHundredField.setText("100");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public String getSeedCommand(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        Boolean bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_PARTITION_FOLD_SEED_LABEL");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("PRESERVE.");
            stringBuffer.append("\nSET RNG=MT MTINDEX=").append(this.mSeedField.getText()).append(".");
            stringBuffer.append("\nSHOW RNG.\n");
        }
        return stringBuffer.toString();
    }

    public String getPartitionSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("\n  /PARTITION");
        Boolean bl = dialogDataModel.getBoolean(RANDOMLY_ASSIGN_KEY);
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("  TRAINING=");
            stringBuffer.append(this.mTrainingNumber.getText());
            stringBuffer.append("  HOLDOUT=");
            stringBuffer.append(this.mHoldoutNumber.getText());
        }
        if ((bl = dialogDataModel.getBoolean(USE_PARTITIONING_KEY)) != null && bl.booleanValue()) {
            stringBuffer.append("  VARIABLE=");
            stringBuffer.append(this.mPartitioningVariable.getModel().getElementAt(0).getName());
        }
        StringBuffer stringBuffer2 = new StringBuffer("");
        bl = dialogDataModel.getBoolean(V_FOLD_RANDOM_RADIO);
        if (bl != null && bl.booleanValue() && this.mNumPartitionField.isEnabled()) {
            stringBuffer2.append("FOLDS=").append(this.mNumPartitionField.getText());
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_V_FOLD_USE_PARTITIONING_LABEL")) != null && bl.booleanValue() && this.mVFoldPartitioningVariable.isEnabled() && this.mVFoldPartitioningVariable.getModel().getSize() > 0) {
            stringBuffer2.append("VARIABLE=");
            stringBuffer2.append(this.mVFoldPartitioningVariable.getModel().getElementAt(0).getName());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\n  /CROSSVALIDATION ").append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    VarListModel getSrcVariableList() {
        return this.mSrcVarList.getModel();
    }

    public double getTestRecords() {
        double d = 0.0;
        if (!this.mTrainingNumber.getText().equals("")) {
            d = Double.parseDouble(this.mTrainingNumber.getText());
        }
        return d;
    }

    public boolean usePartitioningVariable() {
        return this.mUseVariableRadio.isSelected();
    }

    protected void initializePanel() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2 - 4, n2, n2 - 4);
        DialogUtil.addUsingGBL(this, this.setupSourcePanel(), gridBagConstraints, 0, 0, 1, 4, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.fill = 1;
        this.setupPartitionDatasetPanel();
        insets.set(n2, n2 - 4, n2, n2);
        DialogUtil.addUsingGBL(this, this.mPartitionDatasetPanel, gridBagConstraints, 1, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        this.setupVFoldCrossValiationPanel();
        insets.set(n2, n2 - 4, n2, n2);
        DialogUtil.addUsingGBL(this, this.mVFoldPartitionPanel, gridBagConstraints, 1, 1, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mSetSeedcheck, gridBagConstraints, 1, 2, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 6, n2, n2);
        DialogUtil.addUsingGBL(this, this.mSeedLabel, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, (JComponent)this.mSeedField, gridBagConstraints, 2, 3, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
        Boolean bl = ((NearestNeighborAnalysisDlg)this.mParent).getDialogDataModel().getBoolean("IDS_NEAREST_NEIGHBOR_MODEL_NUM_NN_AUTO_SELECT_LABEL");
        Boolean bl2 = ((NearestNeighborAnalysisDlg)this.mParent).getDialogDataModel().getBoolean("IDS_NEAREST_NEIGHBOR_FEATURES_PERFORM_SELECTION_LABEL");
        if (bl != null && bl.booleanValue() && (bl2 == null || !bl2.booleanValue())) {
            this.mVFoldUseRandomlyRadio.setEnabled(true);
            this.mVFoldUsePartioningVarRadio.setEnabled(true);
        } else {
            this.mVFoldUseRandomlyRadio.setEnabled(false);
            this.mVFoldUsePartioningVarRadio.setEnabled(false);
        }
        if (this.mVFoldUseRandomlyRadio.isEnabled() && this.mVFoldUseRandomlyRadio.isSelected()) {
            this.mNumPartitionLabel.setEnabled(true);
            this.mNumPartitionField.setEnabled(true);
            this.mVFoldPartitioningArrow.setEnabled(false);
            this.mVFoldPartitioningVariable.setEnabled(false);
            this.mPartitioningVarLabel.setEnabled(false);
        } else {
            this.mNumPartitionLabel.setEnabled(false);
            this.mNumPartitionField.setEnabled(false);
        }
        if (this.mVFoldUsePartioningVarRadio.isEnabled() && this.mVFoldUsePartioningVarRadio.isSelected()) {
            this.mNumPartitionLabel.setEnabled(false);
            this.mNumPartitionField.setEnabled(false);
            this.mVFoldPartitioningArrow.setEnabled(true);
            this.mVFoldPartitioningVariable.setEnabled(true);
            this.mPartitioningVarLabel.setEnabled(true);
        } else {
            this.mVFoldPartitioningArrow.setEnabled(false);
            this.mPartitioningVarLabel.setEnabled(false);
            this.mVFoldPartitioningVariable.setEnabled(false);
        }
    }

    @Override
    public boolean validateTab() {
        return this.doValidation();
    }

    private boolean doValidation() {
        String string;
        if (this.mUseRandomlyRadio.isEnabled() && this.mUseRandomlyRadio.isSelected()) {
            double d;
            string = this.mTrainingNumber.getText();
            if (string.equals("") || (d = Double.parseDouble(string)) == 0.0) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_TRAINING_NUM_WARNING1"), VersionInfo.getAppVersionString());
                NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mTrainingNumber);
                return false;
            }
            if (d > 100.0) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_TRAINING_NUM_WARNING2"), VersionInfo.getAppVersionString());
                NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mTrainingNumber);
                return false;
            }
        } else if (this.mUseVariableRadio.isEnabled() && this.mUseVariableRadio.isSelected() && this.mPartitioningVariable.getModel().getSize() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_NO_PARTITION_VAR_WARNING"), VersionInfo.getAppVersionString());
            this.mPartitioningVariable.requestFocusInWindow();
            return false;
        }
        if (this.mVFoldUseRandomlyRadio.isEnabled() && this.mVFoldUseRandomlyRadio.isSelected()) {
            string = this.mNumPartitionField.getText();
            if (string.length() == 0 || Integer.parseInt(string) == 0) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_EMPTY_NUM_FOLDS_WARNING"), VersionInfo.getAppVersionString());
                NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mNumPartitionField);
                return false;
            }
        } else if (this.mVFoldUsePartioningVarRadio.isEnabled() && this.mVFoldUsePartioningVarRadio.isSelected() && this.mVFoldPartitioningVariable.getModel().getSize() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_NO_FOLD_VAR_WARNING"), VersionInfo.getAppVersionString());
            this.mVFoldPartitioningVariable.requestFocusInWindow();
            return false;
        }
        if (this.mSetSeedcheck.isEnabled() && this.mSetSeedcheck.isSelected() && ((string = this.mSeedField.getText()).length() == 0 || Integer.parseInt(string) == 0)) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_ZERO_SEED_WARNING"), VersionInfo.getAppVersionString());
            NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mSeedField);
            return false;
        }
        return true;
    }

    private JPanel setupSourcePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_KMEANS_VARIABLES");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setupPartitionDatasetPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, n2, n2 - 6, n2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, this.mUseRandomlyRadio, gridBagConstraints, 0, 0, 3, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_TRAINING_LABEL");
        jLabel.setLabelFor((Component)this.mTrainingNumber);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 6, n2 * 5, 0, n2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_HOLDOUT_ROW");
        jLabel2.setLabelFor(this.mHoldoutNumber);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 6, n2 * 5, 0, n2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, jLabel2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_TOTAL_ROW");
        jLabel3.setLabelFor(this.mOneHundredField);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 - 6, n2 * 5, 0, n2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, jLabel3, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 - 6, n2 * 5, 0, n2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, (JComponent)this.mTrainingNumber, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 - 6, 0, 0, n2 + 4);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, this.mHoldoutNumber, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 6, n2 * 7, 0, n2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, this.mOneHundredField, gridBagConstraints, 2, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, this.mUseVariableRadio, gridBagConstraints, 0, 3, 3, 1, n, insets);
        JLabel jLabel4 = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_PARTITION_VARIABLES_LABEL");
        jLabel4.setLabelFor(this.mPartitioningVariable);
        JComponent[] jComponentArray = new JComponent[]{jLabel4, this.mPartitioningArrow, this.mPartitioningVariable};
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n2 * 5, n2, n2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, this.setUpListPanel(jComponentArray), gridBagConstraints, 0, 4, 3, 1, n, insets);
    }

    private void setupVFoldCrossValiationPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, n2, n2 - 6, n2);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_NEAREST_NEIGHBOR_CROSS_VALIDATIONL_MESG"));
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.mVFoldUseRandomlyRadio.getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setRows(3);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(60, 30));
        jTextArea.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mVFoldPartitionPanel, jTextArea, gridBagConstraints, 0, 0, 2, 1, n, insets);
        insets.set(n2 - 6, n2, 2, n2);
        DialogUtil.addUsingGBL(this.mVFoldPartitionPanel, this.mVFoldUseRandomlyRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 * 7, 4, 4);
        DialogUtil.addUsingGBL(this.mVFoldPartitionPanel, this.mNumPartitionLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(2, 4, 4, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mVFoldPartitionPanel, (JComponent)this.mNumPartitionField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mVFoldPartitionPanel, this.mVFoldUsePartioningVarRadio, gridBagConstraints, 0, 3, 2, 1, n, insets);
        JComponent[] jComponentArray = new JComponent[]{this.mPartitioningVarLabel, this.mVFoldPartitioningArrow, this.mVFoldPartitioningVariable};
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n2 * 5, n2, n2);
        DialogUtil.addUsingGBL(this.mVFoldPartitionPanel, this.setUpListPanel(jComponentArray), gridBagConstraints, 0, 4, 2, 1, n, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mUseRandomlyRadio);
        vector.add(this.mTrainingNumber);
        vector.add(this.mUseVariableRadio);
        vector.add(this.mPartitioningArrow);
        vector.add(this.mPartitioningVariable);
        vector.add(this.mVFoldUseRandomlyRadio);
        vector.add(this.mNumPartitionField);
        vector.add(this.mVFoldUsePartioningVarRadio);
        vector.add(this.mVFoldPartitioningArrow);
        vector.add(this.mVFoldPartitioningVariable);
        vector.add(this.mSetSeedcheck);
        vector.add(this.mSeedField);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        this.mSrcVarList.setModel(((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getSrcListModel());
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
        this.mUseRandomlyRadio.setSelected(true);
        this.mPartitioningArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mPartitioningArrow.setEnabled(false);
        this.mPartitioningVariable.setEnabled(false);
        this.mTrainingNumber.setText("70");
        this.mHoldoutNumber.setText("30");
        this.mVFoldUseRandomlyRadio.setEnabled(false);
        this.mVFoldUseRandomlyRadio.setSelected(true);
        this.mNumPartitionLabel.setEnabled(false);
        this.mNumPartitionField.setEnabled(false);
        this.mNumPartitionField.setText("10");
        this.mVFoldUsePartioningVarRadio.setEnabled(false);
        this.mVFoldPartitioningArrow.setEnabled(false);
        this.mPartitioningVarLabel.setEnabled(false);
        this.mSetSeedcheck.setSelected(false);
        this.mSeedLabel.setEnabled(false);
        this.mSeedField.setText("");
        this.mSeedField.setEnabled(false);
    }

    private void initVars() {
        this.mUseRandomlyRadio = DialogUtil.createRadioButton(this.mParent, RANDOMLY_ASSIGN_KEY, null);
        this.mUseRandomlyRadio.addItemListener(this);
        this.mUseVariableRadio = DialogUtil.createRadioButton(this.mParent, USE_PARTITIONING_KEY, null);
        this.mUseVariableRadio.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mUseRandomlyRadio);
        spssButtonGroup.add(this.mUseVariableRadio);
        this.mPartitionDatasetPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NEAREST_NEIGHBOR_PARTITION_PANEL_TITLE"));
        this.mPartitionDatasetPanel.setEnabled(true);
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getSplitVarFilter());
        this.mSrcVarList.setIdentifier(SOURCE_LIST_KEY);
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mPartitioningVariable = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mPartitioningVariable.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mPartitioningVariable.addVarFilter(new SpssVarFilter(8, false));
        this.mPartitioningVariable.addVarFilter(new SpssVarFilter(32, false));
        this.mPartitioningVariable.addVarFilter(new SpssVarFilter(64, false));
        this.mPartitioningVariable.setIdentifier(TARGET_PARTIONING_VARIBLE_KEY);
        this.mPartitioningVariable.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mPartitioningVariable.getFixedCellHeight() + 2));
        this.mPartitioningVariable.setPreferredSize(new Dimension(DialogUtil.getVarListWidth(), this.mPartitioningVariable.getFixedCellHeight() + 2));
        this.mPartitioningArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mPartitioningArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mPartitioningArrow.registerVariableList(this.mPartitioningVariable, SpssArrowButton.ButtonOrientation.left);
        this.mTrainingNumber = new FloatTextField(0.0, 100.0, 5, true);
        this.mTrainingNumber.setAction((Action)new TextFieldAction(this.mParent, TRAINING_PERCENT));
        this.mTrainingNumber.setColumns(5);
        this.mTrainingNumber.setHorizontalAlignment(4);
        this.mTrainingNumber.getDocument().addDocumentListener(this);
        this.mTrainingNumber.addCaretListener((CaretListener)this);
        this.mHoldoutNumber = new JLabel("30");
        this.mHoldoutNumber.setHorizontalAlignment(4);
        this.mHoldoutNumber.setHorizontalTextPosition(4);
        this.mOneHundredField = new JLabel("   100");
        this.mOneHundredField.setHorizontalAlignment(4);
        this.mVFoldUseRandomlyRadio = DialogUtil.createRadioButton(this.mParent, V_FOLD_RANDOM_RADIO, null);
        this.mVFoldUseRandomlyRadio.addItemListener(this);
        this.mVFoldUsePartioningVarRadio = DialogUtil.createRadioButton(this.mParent, "IDS_NEAREST_NEIGHBOR_V_FOLD_USE_PARTITIONING_LABEL", null);
        this.mVFoldUsePartioningVarRadio.addItemListener(this);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mVFoldUseRandomlyRadio);
        spssButtonGroup2.add(this.mVFoldUsePartioningVarRadio);
        this.mVFoldPartitionPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NEAREST_NEIGHBOR_CROSS_VALIDATION_PANEL_TITLE"));
        this.mVFoldPartitionPanel.setEnabled(true);
        this.mVFoldPartitioningVariable = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mVFoldPartitioningVariable.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mVFoldPartitioningVariable.addVarFilter(new SpssVarFilter(8, false));
        this.mVFoldPartitioningVariable.addVarFilter(new SpssVarFilter(32, false));
        this.mVFoldPartitioningVariable.addVarFilter(new SpssVarFilter(64, false));
        this.mVFoldPartitioningVariable.setIdentifier(V_FOLD_TARGET_PARTIONING_VARIBLE_KEY);
        this.mPartitioningVarLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_CROSS_VALIDATION_FOLD_VARIABLE_LABEL");
        this.mPartitioningVarLabel.setLabelFor(this.mVFoldPartitioningVariable);
        this.mVFoldPartitioningArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVFoldPartitioningArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVFoldPartitioningArrow.registerVariableList(this.mVFoldPartitioningVariable, SpssArrowButton.ButtonOrientation.left);
        this.mNumPartitionLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_CROSS_VALIDATION_NUM_PARTITIONS_LABEL");
        this.mNumPartitionField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mNumPartitionField.setAction((Action)new TextFieldAction(this.mParent, V_FOLD_NUM_OF_PARTITIONS));
        this.mNumPartitionField.setColumns(5);
        this.mNumPartitionField.getDocument().addDocumentListener(this);
        this.mNumPartitionField.setMinimumSize(new Dimension(80, this.mPartitioningVariable.getFixedCellHeight() + 4));
        this.mNumPartitionLabel.setLabelFor((Component)this.mNumPartitionField);
        this.mSetSeedcheck = DialogUtil.createCheckBox(this.mParent, "IDS_NEAREST_NEIGHBOR_PARTITION_FOLD_SEED_LABEL", null);
        this.mSetSeedcheck.addItemListener(this);
        this.mSeedLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_PARTITION_SEED_LABEL");
        this.mSeedField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mSeedField.setAction((Action)new TextFieldAction(this.mParent, SEED_FIELD));
        this.mSeedField.setColumns(5);
        this.mSeedField.getDocument().addDocumentListener(this);
        this.mSeedField.setMinimumSize(new Dimension(80, this.mPartitioningVariable.getFixedCellHeight() + 4));
        this.mSeedLabel.setLabelFor((Component)this.mSeedField);
        this.mRecordFormat = NumberFormat.getNumberInstance(UIToolResUtil.getSPSSLocale());
        this.mRecordFormat.setMaximumFractionDigits(5);
    }
}

