/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.NearestNeighborAnalysisDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class KNNOutputTab
extends BaseProcedureTab
implements ItemListener,
ActionListener,
DocumentListener,
FocusListener {
    static String KNN_EXPORT_DEP_VAR_NAMES = "IDS_KNN_EXPORT_DEP_VAR_NAMES";
    static String KNN_EXPORT_FILE_ROOT_NAMES = "IDS_KNN_EXPORT_FILE_NAMES_PRE";
    private static String DISPLAY_IN_MAP = "IDS_KNN_EXPORT_DISPLAY_IN_MAP";
    private static String DISPLAY_IN_PEER = "IDS_KNN_EXPORT_DISPLAY_IN_PEER";
    private static String DASET_SET_NAME = "IDS_KNN_EXPORT_DATASET_NAME_KEY";
    private static String NEW_FILE_NAME = "IDS_KNN_EXPORT_NEW_FILE_NAME_KEY";
    private JCheckBox mCaseSummaryCheck;
    private JCheckBox mChartAndTableCheck;
    private JCheckBox mExportModelXMLCheck;
    private FileTextField mXMLFilePath;
    private JButton mModelXMLButton;
    private JCheckBox mExportDistanceCheck;
    private SpssButtonGroup mExportDistanceRadioGrp;
    private JRadioButton mCreateDatasetRadio;
    private JRadioButton mWriteDataFileRadio;
    private JLabel mDatasetNameLabel;
    private FileTextField mNewDataFilePath;
    private StringTextField mDatasetNameValue;
    private JButton mDataFileButton;
    private String mModelPath = "";
    private String mNewDataFilePathString = "";

    public KNNOutputTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        VarListModel varListModel = ((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getFocalCaseIdentifierListModel();
        boolean bl = ((NearestNeighborAnalysisDlg)this.mParent).hasSplitVar();
        if (bl) {
            this.mExportModelXMLCheck.setEnabled(false);
        } else {
            this.mExportModelXMLCheck.setEnabled(true);
        }
        if (this.mExportModelXMLCheck.isEnabled() && this.mExportModelXMLCheck.isSelected()) {
            this.mModelXMLButton.setEnabled(true);
            this.mXMLFilePath.setEnabled(true);
        } else {
            this.mModelXMLButton.setEnabled(false);
            this.mXMLFilePath.setEnabled(false);
        }
        if (varListModel.getSize() == 1) {
            this.mExportDistanceCheck.setEnabled(true);
        } else {
            this.mExportDistanceCheck.setEnabled(false);
            this.mExportDistanceCheck.setSelected(false);
            this.mNewDataFilePath.setText("");
            this.mDatasetNameValue.setText("");
        }
        if (this.mExportDistanceCheck.isEnabled() && this.mExportDistanceCheck.isSelected()) {
            this.mCreateDatasetRadio.setEnabled(true);
            this.mWriteDataFileRadio.setEnabled(true);
        } else {
            this.mCreateDatasetRadio.setEnabled(false);
            this.mWriteDataFileRadio.setEnabled(false);
        }
        if (this.mCreateDatasetRadio.isEnabled() && this.mCreateDatasetRadio.isSelected()) {
            this.mDatasetNameValue.setEnabled(true);
            this.mDatasetNameLabel.setEnabled(true);
            this.mNewDataFilePath.setEnabled(false);
            this.mDataFileButton.setEnabled(false);
        }
        if (this.mWriteDataFileRadio.isEnabled() && this.mWriteDataFileRadio.isSelected()) {
            this.mNewDataFilePath.setEnabled(true);
            this.mDataFileButton.setEnabled(true);
            this.mDatasetNameValue.setEnabled(false);
            this.mDatasetNameLabel.setEnabled(false);
        }
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.setForClementine();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (itemEvent.getSource() == this.mExportModelXMLCheck) {
            if (n == 1) {
                this.mModelXMLButton.setEnabled(true);
                this.mXMLFilePath.setEnabled(true);
            } else {
                this.mModelXMLButton.setEnabled(false);
                this.mXMLFilePath.setEnabled(false);
            }
        }
        if (itemEvent.getSource() == this.mExportDistanceCheck) {
            if (n == 1) {
                this.mCreateDatasetRadio.setEnabled(true);
                if (this.mCreateDatasetRadio.isSelected()) {
                    this.mDatasetNameValue.setEnabled(true);
                    this.mDatasetNameLabel.setEnabled(true);
                }
                this.mWriteDataFileRadio.setEnabled(true);
                if (this.mWriteDataFileRadio.isSelected()) {
                    this.mNewDataFilePath.setEnabled(true);
                    this.mDataFileButton.setEnabled(true);
                }
            } else {
                this.mCreateDatasetRadio.setEnabled(false);
                this.mDatasetNameValue.setEnabled(false);
                this.mDatasetNameLabel.setEnabled(false);
                this.mWriteDataFileRadio.setEnabled(false);
                this.mNewDataFilePath.setEnabled(false);
                this.mDataFileButton.setEnabled(false);
            }
        }
        if (itemEvent.getSource() == this.mCreateDatasetRadio) {
            this.mDatasetNameValue.setEnabled(true);
            this.mDatasetNameLabel.setEnabled(true);
            this.mNewDataFilePath.setEnabled(false);
            this.mDataFileButton.setEnabled(false);
        }
        if (itemEvent.getSource() == this.mWriteDataFileRadio) {
            this.mNewDataFilePath.setEnabled(true);
            this.mDataFileButton.setEnabled(true);
            this.mDatasetNameValue.setEnabled(false);
            this.mDatasetNameLabel.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mDataFileButton) {
            this.showSaveDialog("IDS_NEAREST_NEIGHBOR_EXPORT_DISTANCE_SAVE_DIALOG_TITLE", "IDS_NEAREST_NEIGHBOR_EXPORT_DISTANCE_FILE_FILTER", "IDS_NEAREST_NEIGHBOR_EXPORT_DISTANCE_FILE_FILTER_EXTN", 0);
        } else if (object == this.mModelXMLButton) {
            this.showSaveDialog("IDS_NEAREST_NEIGHBOR_EXPORT_SAVE_DIALOG_TITLE", "IDS_NEAREST_NEIGHBOR_EXPORT_XML_FILE_FILTER", "IDS_NEAREST_NEIGHBOR_EXPORT_XML_FILE_FILTER_EXTN", 1);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_KNN_OUTPUT";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public String getExportTabSyntax(DialogDataModel dialogDataModel) {
        this.mModelPath = "";
        this.mNewDataFilePathString = "";
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n  /PRINT ");
        Boolean bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_OPTIONS_OUTPUT_SUMMARY");
        if (bl.booleanValue() && bl.booleanValue()) {
            stringBuffer.append("CPS ");
        } else {
            stringBuffer.append("NONE ");
        }
        bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_OPTIONS_OUTPUT_CHARTS");
        stringBuffer.append("\n  /VIEWMODEL DISPLAY=");
        if (bl.booleanValue() && bl.booleanValue()) {
            stringBuffer.append("YES ");
        } else {
            stringBuffer.append("NO ");
        }
        bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_EXPORT_MODEL");
        boolean bl2 = ((NearestNeighborAnalysisDlg)this.mParent).hasSplitVar();
        StringBuffer stringBuffer2 = new StringBuffer("");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_EXPORT_DISTANCE_CONTROL");
        if (bl.booleanValue() && bl.booleanValue() || bl3.booleanValue() && bl3.booleanValue()) {
            if (bl.booleanValue() && bl.booleanValue() && !bl2 && this.mXMLFilePath.getText().length() > 0) {
                stringBuffer2.append("MODEL='").append(this.mXMLFilePath.getText()).append("' ");
                this.mModelPath = this.mXMLFilePath.getText();
            }
            if (bl3.booleanValue() && bl3.booleanValue()) {
                Boolean bl4 = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_EXPORT_NEW_DATASET");
                if (bl4.booleanValue() && bl4.booleanValue()) {
                    stringBuffer2.append("FOCALCASES='").append(this.mDatasetNameValue.getText()).append("'");
                } else {
                    stringBuffer2.append("FOCALCASES='").append(this.mNewDataFilePath.getText()).append("' ");
                    this.mNewDataFilePathString = this.mNewDataFilePath.getText();
                }
            }
        }
        if (stringBuffer2.toString().length() > 0) {
            stringBuffer.append("\n  /OUTFILE ");
            stringBuffer.append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    String getModelFilePath() {
        return this.mModelPath;
    }

    String getNewDataFilePath() {
        return this.mNewDataFilePathString;
    }

    public String getDataSetCommand(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.mCreateDatasetRadio.isEnabled() && this.mCreateDatasetRadio.isSelected()) {
            stringBuffer.append("\nDATASET DECLARE ").append(this.mDatasetNameValue.getText()).append(".");
        }
        return stringBuffer.toString();
    }

    public String getNewDatasetName() {
        return this.mDatasetNameValue.getText();
    }

    @Override
    protected boolean validateTab() {
        return this.doValidation();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mExportModelXMLCheck;
    }

    private void initialize() {
        this.initVars();
        super.initPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.setupOutputPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, this.setupFilesPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private JPanel setupOutputPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NEAREST_NEIGHBOR_OPTIONS_OUTPUT_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n - 2, 2, 4, n);
        int n2 = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCaseSummaryCheck, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mChartAndTableCheck, gridBagConstraints, 0, 1, 2, 1, n2, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCaseSummaryCheck);
        vector.add(this.mChartAndTableCheck);
        vector.add(this.mExportModelXMLCheck);
        vector.add(this.mExportDistanceCheck);
        vector.add(this.mCreateDatasetRadio);
        vector.add(this.mDatasetNameValue);
        vector.add(this.mWriteDataFileRadio);
        vector.add(this.mDataFileButton);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        this.mCaseSummaryCheck.setSelected(true);
        this.mChartAndTableCheck.setSelected(true);
        this.mExportModelXMLCheck.setEnabled(true);
        this.mExportModelXMLCheck.setSelected(false);
        this.mModelXMLButton.setEnabled(false);
        this.mXMLFilePath.setEnabled(false);
        this.mCreateDatasetRadio.setSelected(true);
        this.mCreateDatasetRadio.setEnabled(false);
        this.mWriteDataFileRadio.setEnabled(false);
        this.mDatasetNameValue.setEnabled(false);
        this.mDatasetNameLabel.setEnabled(false);
        this.mNewDataFilePath.setEnabled(false);
        this.mNewDataFilePath.setText("");
        this.mXMLFilePath.setText("");
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.setForClementine();
        }
    }

    private void setForClementine() {
        String string;
        this.mExportModelXMLCheck.setSelected(true);
        this.mExportModelXMLCheck.setEnabled(false);
        this.mModelXMLButton.setEnabled(false);
        this.mXMLFilePath.setEnabled(false);
        DialogDataModel dialogDataModel = ((NearestNeighborAnalysisDlg)this.mParent).getDialogDataModel();
        if (dialogDataModel != null && (string = dialogDataModel.getString("EXPORT_XML_FILE_PATH")) != null) {
            this.mXMLFilePath.setText(string);
        }
        this.mExportDistanceCheck.setEnabled(false);
    }

    private void initVars() {
        this.mCaseSummaryCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NEAREST_NEIGHBOR_OPTIONS_OUTPUT_SUMMARY", null);
        this.mCaseSummaryCheck.addItemListener(this);
        this.mChartAndTableCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NEAREST_NEIGHBOR_OPTIONS_OUTPUT_CHARTS", null);
        this.mChartAndTableCheck.addItemListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_EXPORT_MODEL");
        this.mExportModelXMLCheck = new JCheckBox(toggleButtonAction);
        this.mExportModelXMLCheck.addItemListener(this);
        this.mXMLFilePath = new FileTextField();
        this.mXMLFilePath.setEditable(false);
        this.mXMLFilePath.setOpaque(false);
        this.mXMLFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mXMLFilePath.setAction(new TextFieldAction(this.mParent, "EXPORT_XML_FILE_PATH"));
        this.mModelXMLButton = DialogUtil.createButton(this.mParent, "IDS_GLM_EXPORT_DATA_FILE_BUTTON", null);
        this.mModelXMLButton.setEnabled(true);
        this.mModelXMLButton.addActionListener(this);
        this.mExportDistanceCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NEAREST_NEIGHBOR_EXPORT_DISTANCE_CONTROL", null);
        this.mExportDistanceCheck.addItemListener(this);
        this.mCreateDatasetRadio = DialogUtil.createRadioButton(this.mParent, "IDS_NEAREST_NEIGHBOR_EXPORT_NEW_DATASET", null);
        this.mCreateDatasetRadio.addItemListener(this);
        this.mWriteDataFileRadio = DialogUtil.createRadioButton(this.mParent, "IDS_NEAREST_NEIGHBOR_EXPORT_NEW_DATA_FILE", null);
        this.mWriteDataFileRadio.addItemListener(this);
        this.mExportDistanceRadioGrp = new SpssButtonGroup();
        this.mExportDistanceRadioGrp.add(this.mCreateDatasetRadio);
        this.mExportDistanceRadioGrp.add(this.mWriteDataFileRadio);
        this.mDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_EXPORT_NEW_DATASET_NAME");
        this.mDatasetNameValue = new StringTextField();
        this.mDatasetNameValue.setColumns(30);
        this.mDatasetNameValue.setAction(new TextFieldAction(this.mParent, DASET_SET_NAME));
        this.mDatasetNameValue.addFocusListener(this);
        this.mDatasetNameValue.getDocument().addDocumentListener(this);
        this.mDatasetNameLabel.setLabelFor((Component)((Object)this.mDatasetNameValue));
        this.mNewDataFilePath = new FileTextField();
        this.mNewDataFilePath.setEditable(false);
        this.mNewDataFilePath.setOpaque(false);
        this.mNewDataFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mNewDataFilePath.setAction(new TextFieldAction(this.mParent, NEW_FILE_NAME));
        this.mDataFileButton = DialogUtil.createButton(this.mParent, "IDS_GLM_EXPORT_DATA_FILE_BUTTON", null);
        this.mDataFileButton.setEnabled(true);
        this.mDataFileButton.addActionListener(this);
    }

    private JPanel setupFilesPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NEAREST_NEIGHBOR_EXPORT_FILE_TILE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n - 2, n, n, n);
        int n2 = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mExportModelXMLCheck, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 4, n, -n * 3);
        DialogUtil.addUsingGBL(jPanel, this.mModelXMLButton, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n + 3, -n * 3, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mXMLFilePath), gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mExportDistanceCheck, gridBagConstraints, 0, 3, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDatasetRadio, gridBagConstraints, 0, 4, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 8, 0, -n * 7);
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameLabel, gridBagConstraints, 0, 5, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n, -n * 7, 0, n * 22);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDatasetNameValue), gridBagConstraints, 1, 5, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mWriteDataFileRadio, gridBagConstraints, 0, 6, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 8, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mDataFileButton, gridBagConstraints, 0, 7, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n + 3, n, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNewDataFilePath), gridBagConstraints, 1, 7, 1, 1, n2, insets);
        return jPanel;
    }

    private void showSaveDialog(String string, String string2, String string3, int n) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setDialogTitle(this.getResString(string));
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString(string2), this.getResString(string3)));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n2 = remoteFileChooser.showSaveDialog((Component)this.mParent);
        if (n2 == 0) {
            String string4 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            int n3 = string4.indexOf(this.getResString(string3));
            if (n3 == -1) {
                string4 = string4.concat(this.getResString(string3));
            }
            if (n == 0) {
                this.mNewDataFilePath.setText(string4);
            } else {
                this.mXMLFilePath.setText(string4);
            }
        }
    }

    private boolean doValidation() {
        try {
            boolean bl = true;
            boolean bl2 = true;
            if (this.mExportModelXMLCheck.isEnabled() && this.mExportModelXMLCheck.isSelected()) {
                boolean bl3 = bl = this.mXMLFilePath.getText().length() > 0;
            }
            if (this.mExportDistanceCheck.isEnabled() && this.mExportDistanceCheck.isSelected() && this.mWriteDataFileRadio.isSelected()) {
                boolean bl4 = bl2 = this.mNewDataFilePath.getText().length() > 0;
            }
            if (!bl || !bl2) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_NO_FILE_PATH_WARNING"), VersionInfo.getAppVersionString());
                if (!bl) {
                    this.mModelXMLButton.requestFocusInWindow();
                } else {
                    this.mDataFileButton.requestFocusInWindow();
                }
                return false;
            }
            if (this.mExportDistanceCheck.isEnabled() && this.mExportDistanceCheck.isSelected() && this.mCreateDatasetRadio.isSelected()) {
                String string = this.mDatasetNameValue.getText();
                if (string.length() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_EMPTY_DATASET_NAME_WARNING"), VersionInfo.getAppVersionString());
                    NearestNeighborAnalysisDlg.setSelectionText((JComponent)((Object)this.mDatasetNameValue));
                    return false;
                }
                int n = DatasetNameValidator.validateDatasetName((String)string, (Component)this);
                if (n == 0) {
                    NearestNeighborAnalysisDlg.setSelectionText((JComponent)((Object)this.mDatasetNameValue));
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

