/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class KNNOptionsTab
extends BaseProcedureTab {
    private SpssButtonGroup mUserMissingRadioGrp;
    private JRadioButton mExcludeRadio;
    private JRadioButton mIncludeRadio;

    public KNNOptionsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    public String getOptionTabSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n  /MISSING ");
        Boolean bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_OPTIONS_MISSING_EXCLUDE");
        if (bl.booleanValue() && bl.booleanValue()) {
            stringBuffer.append("USERMISSING=EXCLUDE");
        } else {
            stringBuffer.append("USERMISSING=INCLUDE");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_KNN_OPTIONS";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mExcludeRadio);
        vector.add(this.mIncludeRadio);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initialize() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2 - 4, n2);
        DialogUtil.addUsingGBL(this, this.setupUserMissingValuePanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2 - 4, 0, n2 - 4, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, PanelFactory.getEmptyPanel(""), gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void setDefaults() {
        this.mExcludeRadio.setEnabled(true);
        this.mExcludeRadio.setSelected(true);
        this.mIncludeRadio.setEnabled(true);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_OPTIONS_MISSING_EXCLUDE");
        this.mExcludeRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_OPTIONS_MISSING_INCLUDE");
        this.mIncludeRadio = new JRadioButton(toggleButtonAction);
        this.mUserMissingRadioGrp = new SpssButtonGroup();
        this.mUserMissingRadioGrp.add(this.mExcludeRadio);
        this.mUserMissingRadioGrp.add(this.mIncludeRadio);
    }

    private JPanel setupUserMissingValuePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NEAREST_NEIGHBOR_OPTIONS_USER_MISSING_VALUES"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 4, n2 - 4, n2);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_OPTIONS_USER_MISSING_VALUES_SPECIFY");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2 - 4, 2, n2 - 4, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mExcludeRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2 - 4, 2, n2 - 4, n2);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        jLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_OPTIONS_USER_MISSING_VALUES_SCALE");
        insets.set(n2, 4, n2 - 4, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }
}

