/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.NearestNeighborAnalysisDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class KNNNeighborsTab
extends BaseProcedureTab
implements ItemListener,
DocumentListener,
FocusListener {
    private static final String AUTO_SELECT_MIN_K = "IDS_NEAREST_NEIGHBOR_MODEL_MIN_K";
    private static final String AUTO_SELECT_MAX_K = "IDS_NEAREST_NEIGHBOR_MODEL_MAX_K";
    private static final String AUTO_SELECT_K = "IDS_NEAREST_NEIGHBOR_MODEL_K";
    private NearestNeighborAnalysisDlg.MesgPanel mMessageLabel;
    private SpssButtonGroup mNNPanelRadioGrp;
    private JRadioButton mSpecifyRadio;
    private JRadioButton mAutoSelectionRadio;
    private JLabel mSpecifyKLabel;
    private JLabel mMinKLabel;
    private JLabel mMaxKLabel;
    private IntTextField mSpecifyKValue;
    private IntTextField mMinKValue;
    private IntTextField mMaxKValue;
    private SpssButtonGroup mMetricRadioGrp;
    private JRadioButton mMetricEucliRadio;
    private JRadioButton mMetricManhattanRadio;
    private JSeparator mSeparator;
    private JCheckBox mWeightFeature;
    private SpssButtonGroup mPredictionsRadioGrp;
    private JRadioButton mPredictionsMeanRadio;
    private JRadioButton mPredictionsMedianRadio;

    public KNNNeighborsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void selectSpecifyKRadio(boolean bl) {
        this.mSpecifyRadio.setSelected(bl);
        this.mAutoSelectionRadio.setEnabled(!bl);
    }

    void setFocusOnKvalue() {
        if (this.mSpecifyRadio.isSelected()) {
            NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mSpecifyKValue);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mMaxKValue || focusEvent.getSource() == this.mMaxKValue || focusEvent.getSource() == this.mMinKValue) {
            NearestNeighborAnalysisDlg.setSelectionText((JComponent)((IntTextField)focusEvent.getSource()), 0);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mSpecifyRadio) {
            this.mMaxKLabel.setEnabled(false);
            this.mMinKLabel.setEnabled(false);
            this.mMaxKValue.setEnabled(false);
            this.mMinKValue.setEnabled(false);
            this.mSpecifyKLabel.setEnabled(true);
            this.mSpecifyKValue.setEnabled(true);
            if (((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab() != null) {
                ((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab().setCrossVFoldRadioButtonEnabled(false);
            }
        } else if (object == this.mAutoSelectionRadio) {
            this.mMaxKLabel.setEnabled(true);
            this.mMinKLabel.setEnabled(true);
            this.mMaxKValue.setEnabled(true);
            this.mMinKValue.setEnabled(true);
            if (((NearestNeighborAnalysisDlg)this.mParent).getFeaturesTab() != null && ((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab() != null && !((NearestNeighborAnalysisDlg)this.mParent).getFeaturesTab().isPerformFeatureSelected()) {
                ((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab().setCrossVFoldRadioButtonEnabled(true);
            }
            this.mSpecifyKLabel.setEnabled(false);
            this.mSpecifyKValue.setEnabled(false);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_KNN_NEIGHBORS";
    }

    public boolean isAutomaticallySelectedK() {
        return this.mAutoSelectionRadio.isSelected();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public String getModelSyntaxFromNeighborsTab(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("\n  /MODEL ");
        Boolean bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_MODEL_NUM_NN_SPECIFY_K_LABEL");
        stringBuffer.append("NEIGHBORS=");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("FIXED(K=").append(this.mSpecifyKValue.getText()).append(") ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_MODEL_NUM_NN_AUTO_SELECT_LABEL")) != null && bl.booleanValue()) {
            stringBuffer.append("AUTO(KMIN=").append(this.mMinKValue.getText()).append(", KMAX=").append(this.mMaxKValue.getText()).append(") ");
        }
        bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_MODEL_METRIC_EUCLIDEAN_LABEL");
        stringBuffer.append("METRIC=");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("EUCLID ");
        } else {
            stringBuffer.append("CITYBLOCK ");
        }
        return stringBuffer.toString();
    }

    public String getCriteriaSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("\n  /CRITERIA ");
        boolean bl = false;
        Boolean bl2 = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_MODEL_PREDICTIONS_MEAN_LABEL");
        VarListModel varListModel = ((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getTargetListModel();
        boolean bl3 = varListModel.getSize() > 0;
        boolean bl4 = ((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().hasCategoricalTarget();
        if (bl3 && !bl4 && bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("PREDICTED=MEAN ");
            bl = true;
        }
        bl2 = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_MODEL_PREDICTIONS_MEDIAN_LABEL");
        if (bl3 && !bl4 && bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("PREDICTED=MEDIAN ");
            bl = true;
        }
        bl2 = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_NEIGHBORS_WEIGHT_CONTROL");
        if (bl3 && bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("WEIGHTFEATURES=YES ");
            bl = true;
        } else {
            stringBuffer.append("WEIGHTFEATURES=NO ");
        }
        return stringBuffer.toString();
    }

    @Override
    protected boolean validateTab() {
        return this.doValidation();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mSpecifyRadio;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        if (((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getTargetListModel().getSize() > 0) {
            this.mWeightFeature.setEnabled(true);
            this.mAutoSelectionRadio.setEnabled(true);
            if (!((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().hasCategoricalTarget()) {
                this.mPredictionsMeanRadio.setEnabled(true);
                this.mPredictionsMedianRadio.setEnabled(true);
            } else {
                this.mPredictionsMeanRadio.setEnabled(false);
                this.mPredictionsMedianRadio.setEnabled(false);
            }
        } else {
            this.mWeightFeature.setEnabled(false);
            this.mPredictionsMeanRadio.setEnabled(false);
            this.mPredictionsMedianRadio.setEnabled(false);
            this.mAutoSelectionRadio.setEnabled(false);
        }
        if (this.mAutoSelectionRadio.isEnabled() && this.mAutoSelectionRadio.isSelected()) {
            this.mMaxKLabel.setEnabled(true);
            this.mMinKLabel.setEnabled(true);
            this.mMaxKValue.setEnabled(true);
            this.mMinKValue.setEnabled(true);
        } else {
            this.mMaxKLabel.setEnabled(false);
            this.mMinKLabel.setEnabled(false);
            this.mMaxKValue.setEnabled(false);
            this.mMinKValue.setEnabled(false);
        }
        if (this.mSpecifyRadio.isSelected()) {
            this.mSpecifyKLabel.setEnabled(true);
            this.mSpecifyKValue.setEnabled(true);
        } else {
            this.mSpecifyKLabel.setEnabled(false);
            this.mSpecifyKValue.setEnabled(false);
        }
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMessageLabel);
        vector.add(this.mSpecifyRadio);
        vector.add(this.mSpecifyKValue);
        vector.add(this.mAutoSelectionRadio);
        vector.add(this.mMinKValue);
        vector.add(this.mMaxKValue);
        vector.add(this.mMetricEucliRadio);
        vector.add(this.mMetricManhattanRadio);
        vector.add(this.mWeightFeature);
        vector.add(this.mPredictionsMeanRadio);
        vector.add(this.mPredictionsMedianRadio);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initialize() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2 - 4, n2);
        DialogUtil.addUsingGBL(this, this.setupNumberOfNearestNeighborPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        JComponent[] jComponentArray = new JComponent[]{this.mMetricEucliRadio, this.mMetricManhattanRadio, this.mSeparator, this.mWeightFeature};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_NEAREST_NEIGHBOR_MODEL_METRIC_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 - 4, n2, n2);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2);
        jComponentArray = new JComponent[]{this.mPredictionsMeanRadio, this.mPredictionsMedianRadio};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_NEAREST_NEIGHBOR_MODEL_PREDICTIONS_TITLE"));
        insets.set(n2, n2 - 4, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets.set(n2, n2 - 4, n2 - 4, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, new JPanel(), gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.setDefaults();
    }

    private void setDefaults() {
        this.mSpecifyRadio.setSelected(true);
        this.mAutoSelectionRadio.setEnabled(false);
        this.mMetricEucliRadio.setSelected(true);
        this.mPredictionsMeanRadio.setSelected(true);
        this.mPredictionsMeanRadio.setEnabled(false);
        this.mPredictionsMedianRadio.setEnabled(false);
        this.mSpecifyKValue.setText("3");
        this.mMaxKValue.setText("5");
        this.mMinKValue.setText("3");
        this.mWeightFeature.setSelected(false);
        this.mWeightFeature.setEnabled(false);
    }

    private void initVars() {
        this.mMessageLabel = new NearestNeighborAnalysisDlg.MesgPanel(this.getResString("IDS_NEAREST_NEIGHBOR_MODEL_AUTO_MESG"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_NUM_NN_AUTO_SELECT_LABEL");
        this.mAutoSelectionRadio = new JRadioButton(toggleButtonAction);
        this.mAutoSelectionRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_NUM_NN_SPECIFY_K_LABEL");
        this.mSpecifyRadio = new JRadioButton(toggleButtonAction);
        this.mSpecifyRadio.addItemListener(this);
        this.mNNPanelRadioGrp = new SpssButtonGroup();
        this.mNNPanelRadioGrp.add(this.mSpecifyRadio);
        this.mNNPanelRadioGrp.add(this.mAutoSelectionRadio);
        this.mSpecifyKLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_NUM_NN_SPECIFY_K_FIELD");
        this.mSpecifyKValue = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mSpecifyKValue.setAction((Action)new TextFieldAction(this.mParent, AUTO_SELECT_K));
        this.mSpecifyKValue.setColumns(5);
        this.mSpecifyKValue.getDocument().addDocumentListener(this);
        this.removeFocusListener(this.mSpecifyKValue);
        this.mSpecifyKValue.addFocusListener((FocusListener)this);
        this.mSpecifyKLabel.setLabelFor((Component)this.mSpecifyKValue);
        this.mMinKLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_NUM_NN_MIN_LABEL");
        this.mMinKValue = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMinKValue.setAction((Action)new TextFieldAction(this.mParent, AUTO_SELECT_MIN_K));
        this.mMinKValue.setColumns(5);
        this.mMinKValue.getDocument().addDocumentListener(this);
        this.removeFocusListener(this.mMinKValue);
        this.mMinKValue.addFocusListener((FocusListener)this);
        this.mMinKLabel.setLabelFor((Component)this.mMinKValue);
        this.mMaxKLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_NUM_NN_MAX_LABEL");
        this.mMaxKValue = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMaxKValue.setAction((Action)new TextFieldAction(this.mParent, AUTO_SELECT_MAX_K));
        this.mMaxKValue.setColumns(5);
        this.mMaxKValue.getDocument().addDocumentListener(this);
        this.removeFocusListener(this.mMaxKValue);
        this.mMaxKValue.addFocusListener((FocusListener)this);
        this.mMaxKLabel.setLabelFor((Component)this.mMaxKValue);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_METRIC_EUCLIDEAN_LABEL");
        this.mMetricEucliRadio = new JRadioButton(toggleButtonAction);
        this.mMetricEucliRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_METRIC_MANHATTAN_LABEL");
        this.mMetricManhattanRadio = new JRadioButton(toggleButtonAction);
        this.mMetricManhattanRadio.addItemListener(this);
        this.mMetricRadioGrp = new SpssButtonGroup();
        this.mMetricRadioGrp.add(this.mMetricEucliRadio);
        this.mMetricRadioGrp.add(this.mMetricManhattanRadio);
        this.mSeparator = new JSeparator();
        this.mWeightFeature = DialogUtil.createCheckBox(this.mParent, "IDS_NEAREST_NEIGHBOR_NEIGHBORS_WEIGHT_CONTROL", null);
        this.mWeightFeature.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_PREDICTIONS_MEAN_LABEL");
        this.mPredictionsMeanRadio = new JRadioButton(toggleButtonAction);
        this.mPredictionsMeanRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_PREDICTIONS_MEDIAN_LABEL");
        this.mPredictionsMedianRadio = new JRadioButton(toggleButtonAction);
        this.mPredictionsMedianRadio.addItemListener(this);
        this.mPredictionsRadioGrp = new SpssButtonGroup();
        this.mPredictionsRadioGrp.add(this.mPredictionsMeanRadio);
        this.mPredictionsRadioGrp.add(this.mPredictionsMedianRadio);
    }

    private void removeFocusListener(IntTextField intTextField) {
        FocusListener[] focusListenerArray;
        for (FocusListener focusListener : focusListenerArray = intTextField.getFocusListeners()) {
            if (!(focusListener instanceof IntTextField)) continue;
            intTextField.removeFocusListener(focusListener);
            break;
        }
    }

    private JPanel setupNumberOfNearestNeighborPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NEAREST_NEIGHBOR_MODEL_NUM_NN_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 - 4, n2 - 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMessageLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(n2 - 4, n2 - 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSpecifyRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, 2, 0, 4);
        DialogUtil.addUsingGBL(jPanel2, this.mSpecifyKLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, 4, 0, 4);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mSpecifyKValue, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 4, n2 * 5, n2 - 4, 2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2 - 4, n2 - 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAutoSelectionRadio, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        insets.set(n2 - 4, n2 * 5, n2 - 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mMinKLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 4, 2, n2 - 4, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinKValue, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        insets.set(n2 - 4, n2 * 5, n2 - 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxKLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 4, 2, n2 - 4, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxKValue, gridBagConstraints, 1, 5, 1, 1, n, insets);
        return jPanel;
    }

    private boolean doValidation() {
        try {
            if (this.mSpecifyRadio.isSelected()) {
                String string = this.mSpecifyKValue.getText();
                if (string.length() == 0 || Integer.parseInt(string) == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_POSITIVE_SPECIFY_K_WARNING"), VersionInfo.getAppVersionString());
                    NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mSpecifyKValue);
                    return false;
                }
            } else if (this.mAutoSelectionRadio.isEnabled() && this.mAutoSelectionRadio.isSelected()) {
                boolean bl;
                String string = this.mMaxKValue.getText();
                String string2 = this.mMinKValue.getText();
                int n = -1;
                int n2 = -1;
                boolean bl2 = string.length() == 0 || (n = Integer.parseInt(string)) == 0;
                boolean bl3 = bl = string2.length() == 0 || (n2 = Integer.parseInt(string2)) == 0;
                if (bl || bl2) {
                    IntTextField intTextField;
                    String string3;
                    if (bl) {
                        string3 = this.mMinKLabel.getText();
                        intTextField = this.mMinKValue;
                    } else {
                        string3 = this.mMaxKLabel.getText();
                        intTextField = this.mMaxKValue;
                    }
                    SpssAlertOptionPane.showWarningMessageDialog(this, String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_NEAREST_NEIGHBOR_POSITIVE_MIN_MAX_K_WARNING"), string3), VersionInfo.getAppVersionString());
                    NearestNeighborAnalysisDlg.setSelectionText((JComponent)intTextField);
                    return false;
                }
                if (n2 > 0 && n > 0 && n2 >= n) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_POSITIVE_MIN_MAX_WRONG_WARNING"), VersionInfo.getAppVersionString());
                    NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mMinKValue);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

