/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.classify.nearest_neighbor.NearestNeighborAnalysisDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class KNNFeaturesTab
extends BaseProcedureTab
implements ItemListener,
FocusListener,
DocumentListener,
ListDataListener {
    static final String FEATURE_FORWARD_SELECTION_LIST = "IDS_NEAREST_NEIGHBOR_FEATURES_FORWARD_SELECTION";
    static final String FEATURE_FORWARD_FORCED_LIST = "IDS_NEAREST_NEIGHBOR_FEATURES_FORCED_ENTRY";
    static final String FEATURE_STOPPING_CRITERIA_MAX = "IDS_NEAREST_NEIGHBOR_FEATURES_STOPPING_MAX";
    static final String FEATURE_STOPPING_CRITERIA_MIN_CHANGE = "IDS_NEAREST_NEIGHBOR_FEATURES_STOPPING_MIN_CHANGE";
    private NearestNeighborAnalysisDlg.MesgPanel mMesgPanel;
    private SrcVariableList mForwardSelectionSrcList;
    private JLabel mForwardSelectionLabel;
    private JScrollPane mForwardSelectionSrcScrollPane;
    private ArrowButton mFeatureButton;
    private TargetVariableList mForcedEntryVarList;
    private JLabel mForcedEntryLabel;
    private JScrollPane mForcedEntryScrollPane;
    private StringTextField mFeaturesToEvaluateLabel;
    private JLabel mFeaturesToEvaluateField;
    private StringTextField mForcedFeaturesLabel;
    private JLabel mForcedFeaturesField;
    private JCheckBox mPerformSelection;
    private JTextArea mMessageArea;
    private JPanel mStoppingCriteriaPanel;
    private SpssButtonGroup mStoppingRadioGrp;
    private JRadioButton mMaxReachedRadio;
    private JRadioButton mBelowMinRadio;
    private JLabel mMaxLabel;
    private JLabel mMinChangeLabel;
    private IntTextField mMaxToSelectField;
    private FloatTextField mMinChangeField;

    public KNNFeaturesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updataNumField();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updataNumField();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mMaxReachedRadio && this.mMaxReachedRadio.isSelected()) {
            this.mMaxLabel.setEnabled(true);
            this.mMaxToSelectField.setEnabled(true);
            this.mMinChangeLabel.setEnabled(false);
            this.mMinChangeField.setEnabled(false);
        } else if (object == this.mBelowMinRadio && this.mMaxReachedRadio.isSelected()) {
            this.mMinChangeLabel.setEnabled(true);
            this.mMinChangeField.setEnabled(true);
            this.mMaxLabel.setEnabled(false);
            this.mMaxToSelectField.setEnabled(false);
        }
        if (object == this.mPerformSelection) {
            if (itemEvent.getStateChange() == 1) {
                this.mForwardSelectionLabel.setEnabled(true);
                this.mForwardSelectionSrcList.setEnabled(true);
                this.mFeatureButton.setEnabled(true);
                this.mForcedEntryLabel.setEnabled(true);
                this.mForcedEntryVarList.setEnabled(true);
                this.mFeaturesToEvaluateField.setEnabled(true);
                this.mFeaturesToEvaluateLabel.setEnabled(true);
                this.mForcedFeaturesField.setEnabled(true);
                this.mForcedFeaturesLabel.setEnabled(true);
                this.mMaxReachedRadio.setEnabled(true);
                this.mBelowMinRadio.setEnabled(true);
                if (((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab() != null) {
                    ((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab().setCrossVFoldRadioButtonEnabled(false);
                }
            } else {
                this.mForwardSelectionLabel.setEnabled(false);
                this.mForwardSelectionSrcList.setEnabled(false);
                this.mFeatureButton.setEnabled(false);
                this.mForcedEntryLabel.setEnabled(false);
                this.mForcedEntryVarList.setEnabled(false);
                this.mFeaturesToEvaluateField.setEnabled(false);
                this.mFeaturesToEvaluateLabel.setEnabled(false);
                this.mForcedFeaturesField.setEnabled(false);
                this.mForcedFeaturesLabel.setEnabled(false);
                this.mMaxReachedRadio.setEnabled(false);
                this.mBelowMinRadio.setEnabled(false);
                if (((NearestNeighborAnalysisDlg)this.mParent).getNeighborsTab() != null && ((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getTargetListModel().getSize() > 0 && ((NearestNeighborAnalysisDlg)this.mParent).getNeighborsTab().isAutomaticallySelectedK()) {
                    ((NearestNeighborAnalysisDlg)this.mParent).getPartitionsTab().setCrossVFoldRadioButtonEnabled(true);
                }
            }
        }
        if (this.mMaxReachedRadio.isEnabled() && this.mMaxReachedRadio.isSelected()) {
            this.mMaxLabel.setEnabled(true);
            this.mMaxToSelectField.setEnabled(true);
        } else {
            this.mMaxLabel.setEnabled(false);
            this.mMaxToSelectField.setEnabled(false);
        }
        if (this.mBelowMinRadio.isEnabled() && this.mBelowMinRadio.isSelected()) {
            this.mMinChangeLabel.setEnabled(true);
            this.mMinChangeField.setEnabled(true);
        } else {
            this.mMinChangeLabel.setEnabled(false);
            this.mMinChangeField.setEnabled(false);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_KNN_FEATURES";
    }

    public boolean isPerformFeatureSelected() {
        return this.mPerformSelection.isEnabled() && this.mPerformSelection.isSelected();
    }

    public void selectPerformFeatureCheckbox(boolean bl) {
        this.mPerformSelection.setSelected(bl);
    }

    @Override
    public void reset() {
        super.reset();
        this.mForwardSelectionSrcList.removeAll();
        this.mForcedEntryVarList.removeAll();
        this.setDefaults();
    }

    public String getFeaturesSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("FEATURES=");
        boolean bl = ((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getTargetListModel().getSize() > 0;
        Boolean bl2 = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_FEATURES_PERFORM_SELECTION_LABEL");
        if (bl && bl2 != null && bl2.booleanValue()) {
            VarListModel varListModel = this.mForcedEntryVarList.getModel();
            if (varListModel.getSize() > 0) {
                stringBuffer.append("AUTO(FORCE=");
                for (int i = 0; i < varListModel.getSize(); ++i) {
                    ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                    stringBuffer.append(iSpssVariable.getName()).append(" ");
                }
                stringBuffer.append(") ");
            } else {
                stringBuffer.append("AUTO ");
            }
        } else {
            stringBuffer.append("ALL");
        }
        return stringBuffer.toString();
    }

    public String getStoppingRuleSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        Boolean bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_FEATURES_PERFORM_SELECTION_LABEL");
        if (bl.booleanValue() && bl.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_MODEL_STOPPING_CRITERIA_REACH_MAX_RADIO");
            if (bl.booleanValue() && bl.booleanValue()) {
                stringBuffer.append("NUMFEATURES=FIXED(").append(this.mMaxToSelectField.getText()).append(") ");
            }
            if ((bl = dialogDataModel.getBoolean("IDS_NEAREST_NEIGHBOR_MODEL_STOPPING_CRITERIA_MIN_ERROR")).booleanValue() && bl.booleanValue()) {
                stringBuffer.append("NUMFEATURES=ERRORRATIO(MINCHANGE=").append(this.mMinChangeField.getText()).append(") ");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected boolean validateTab() {
        return this.doValidation();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mPerformSelection;
    }

    public VarListModel getForwardVarListModel() {
        return this.mForwardSelectionSrcList.getModel();
    }

    public VarListModel getForcedVarListModel() {
        return this.mForcedEntryVarList.getModel();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        VarListModel varListModel = ((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getFeatureListModel();
        int n = varListModel.getSize();
        this.mForwardSelectionSrcList.removeAll();
        VarListModel varListModel2 = this.mForwardSelectionSrcList.getModel();
        VarListModel varListModel3 = this.mForcedEntryVarList.getModel();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                boolean bl = false;
                if (varListModel3.getSize() > 0) {
                    boolean bl2 = bl = varListModel3.findElementIndex(iSpssVariable) >= 0;
                }
                if (bl) continue;
                varListModel2.addElement(iSpssVariable);
            }
            this.mForwardSelectionSrcList.setModel(varListModel2);
        }
        if (this.mForwardSelectionSrcList.getModel().getSize() > 0) {
            this.mForwardSelectionSrcList.setSelectedIndex(0);
        }
        if (((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getTargetListModel().getSize() > 0 && ((NearestNeighborAnalysisDlg)this.mParent).getVariablesTab().getFeatureListModel().getSize() > 0) {
            this.mPerformSelection.setEnabled(true);
        } else {
            this.mPerformSelection.setEnabled(false);
        }
        if (this.mPerformSelection.isEnabled() && this.mPerformSelection.isSelected()) {
            this.mForwardSelectionLabel.setEnabled(true);
            this.mForwardSelectionSrcList.setEnabled(true);
            this.mFeatureButton.setEnabled(true);
            this.mForcedEntryLabel.setEnabled(true);
            this.mForcedEntryVarList.setEnabled(true);
            this.mFeaturesToEvaluateField.setEnabled(true);
            this.mFeaturesToEvaluateLabel.setEnabled(true);
            this.mForcedFeaturesField.setEnabled(true);
            this.mForcedFeaturesLabel.setEnabled(true);
            this.mMaxReachedRadio.setEnabled(true);
            this.mBelowMinRadio.setEnabled(true);
        } else {
            this.mForwardSelectionLabel.setEnabled(false);
            this.mForwardSelectionSrcList.setEnabled(false);
            this.mFeatureButton.setEnabled(false);
            this.mForcedEntryLabel.setEnabled(false);
            this.mForcedEntryVarList.setEnabled(false);
            this.mFeaturesToEvaluateField.setEnabled(false);
            this.mFeaturesToEvaluateLabel.setEnabled(false);
            this.mForcedFeaturesField.setEnabled(false);
            this.mForcedFeaturesLabel.setEnabled(false);
            this.mMaxReachedRadio.setEnabled(false);
            this.mBelowMinRadio.setEnabled(false);
        }
        if (this.mMaxReachedRadio.isEnabled() && this.mMaxReachedRadio.isSelected()) {
            this.mMaxLabel.setEnabled(true);
            this.mMaxToSelectField.setEnabled(true);
        } else {
            this.mMaxLabel.setEnabled(false);
            this.mMaxToSelectField.setEnabled(false);
        }
        if (this.mBelowMinRadio.isEnabled() && this.mBelowMinRadio.isSelected()) {
            this.mMinChangeLabel.setEnabled(true);
            this.mMinChangeField.setEnabled(true);
        } else {
            this.mMinChangeLabel.setEnabled(false);
            this.mMinChangeField.setEnabled(false);
        }
        this.setFocusTraversalPolicy();
    }

    private void setDefaults() {
        this.mPerformSelection.setSelected(false);
        this.mPerformSelection.setEnabled(false);
        this.mForwardSelectionSrcList.setEnabled(false);
        this.mFeatureButton.setEnabled(false);
        this.mForcedEntryVarList.setEnabled(false);
        this.mFeaturesToEvaluateField.setEnabled(false);
        this.mForcedFeaturesField.setText("0");
        this.mFeaturesToEvaluateLabel.setEnabled(false);
        this.mForcedFeaturesField.setEnabled(false);
        this.mForcedFeaturesField.setText("0");
        this.mForcedFeaturesLabel.setEnabled(false);
        this.mMaxReachedRadio.setEnabled(false);
        this.mMaxReachedRadio.setSelected(true);
        this.mMaxToSelectField.setText("");
        this.mBelowMinRadio.setEnabled(false);
        this.mMaxLabel.setEnabled(false);
        this.mMaxToSelectField.setEnabled(false);
        this.mMinChangeLabel.setEnabled(false);
        this.mMinChangeField.setEnabled(false);
        this.mMinChangeField.setText(".01");
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMesgPanel);
        vector.add(this.mPerformSelection);
        vector.add(this.mForwardSelectionSrcList);
        vector.add(this.mFeatureButton);
        vector.add(this.mForcedEntryVarList);
        vector.add(this.mFeaturesToEvaluateLabel);
        vector.add(this.mForcedFeaturesLabel);
        vector.add(this.mMaxReachedRadio);
        vector.add(this.mMaxToSelectField);
        vector.add(this.mBelowMinRadio);
        vector.add(this.mMinChangeField);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initialize() {
        super.initPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 4, n2 - 4, n2 - 4);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mMesgPanel, gridBagConstraints, 0, 0, 5, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(n2 - 4, 2, n2, n2 - 4);
        DialogUtil.addUsingGBL(this, this.mPerformSelection, gridBagConstraints, 0, 1, 5, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 - 4, n2 * 4, n2 - 4, n2);
        DialogUtil.addUsingGBL(this, this.mMessageArea, gridBagConstraints, 0, 2, 5, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 4, n2 * 4, 2, n2);
        DialogUtil.addUsingGBL(this, this.mForwardSelectionLabel, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, n2 * 4, 2, n2);
        DialogUtil.addUsingGBL(this, this.mForwardSelectionSrcScrollPane, gridBagConstraints, 0, 4, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 * 4, n2, n2 - 4);
        DialogUtil.addUsingGBL(this, (JComponent)((Object)this.mFeaturesToEvaluateLabel), gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 - 4, n2, n2 - 4);
        DialogUtil.addUsingGBL(this, this.mFeaturesToEvaluateField, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mFeatureButton, gridBagConstraints, 2, 4, 1, 1, 10, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 4, n2 - 4, 2, n2);
        DialogUtil.addUsingGBL(this, this.mForcedEntryLabel, gridBagConstraints, 3, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, n2, 2, n2 - 4);
        DialogUtil.addUsingGBL(this, this.mForcedEntryScrollPane, gridBagConstraints, 3, 4, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 - 4, n2, n2 - 4);
        DialogUtil.addUsingGBL(this, (JComponent)((Object)this.mForcedFeaturesLabel), gridBagConstraints, 3, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2 - 4, n2, n2 - 4);
        DialogUtil.addUsingGBL(this, this.mForcedFeaturesField, gridBagConstraints, 4, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2 * 4, 2, n2 - 4);
        this.setupStoppingCriteriaPanel();
        DialogUtil.addUsingGBL(this, this.mStoppingCriteriaPanel, gridBagConstraints, 0, 6, 5, 1, n, insets);
        this.setDefaults();
    }

    private void initVars() {
        this.mMesgPanel = new NearestNeighborAnalysisDlg.MesgPanel(this.getResString("IDS_NEAREST_NEIGHBOR_FEATURES_FEATURE_SELECTION_LABEL"));
        this.mPerformSelection = DialogUtil.createCheckBox(this.mParent, "IDS_NEAREST_NEIGHBOR_FEATURES_PERFORM_SELECTION_LABEL", null);
        this.mPerformSelection.addItemListener(this);
        this.mForwardSelectionSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mForwardSelectionSrcList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mForwardSelectionSrcList.getFixedCellHeight() * 6 + 2));
        this.mForwardSelectionSrcList.getModel().addListDataListener(this);
        this.mForwardSelectionSrcList.setIdentifier(FEATURE_FORWARD_SELECTION_LIST);
        this.mForwardSelectionSrcList.setContextMenuFlags(this.mForwardSelectionSrcList.getContextMenuFlags() | 8);
        this.mForwardSelectionLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_FEATURES_FORWARD_SELECTION_LIST_LABEL");
        this.mForwardSelectionLabel.setLabelFor(this.mForwardSelectionSrcList);
        this.mForwardSelectionSrcScrollPane = new JScrollPane(this.mForwardSelectionSrcList);
        this.mForwardSelectionSrcScrollPane.setPreferredSize(this.mForwardSelectionSrcList.getMinimumSize());
        this.mForwardSelectionSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mForwardSelectionSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mForcedEntryVarList = new TargetVariableList();
        this.mForcedEntryVarList.getModel().addListDataListener(this);
        this.mForcedEntryVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mForcedEntryVarList.setIdentifier(FEATURE_FORWARD_FORCED_LIST);
        this.mForcedEntryVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mForcedEntryVarList.getFixedCellHeight() * 6 + 2));
        this.mForcedEntryLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_FEATURES_FORCED_ENTRY_LABEL");
        this.mForcedEntryLabel.setLabelFor(this.mForcedEntryVarList);
        this.mForcedEntryScrollPane = new JScrollPane(this.mForcedEntryVarList);
        this.mForcedEntryScrollPane.setPreferredSize(this.mForcedEntryVarList.getMinimumSize());
        this.mFeatureButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFeatureButton.registerVariableList(this.mForwardSelectionSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mFeatureButton.registerVariableList(this.mForcedEntryVarList, SpssArrowButton.ButtonOrientation.left);
        this.mMessageArea = new JTextArea();
        this.mMessageArea.setRows(2);
        this.mMessageArea.setOpaque(false);
        this.mMessageArea.setFont(this.mForcedEntryLabel.getFont());
        this.mMessageArea.setLineWrap(true);
        this.mMessageArea.setWrapStyleWord(true);
        this.mMessageArea.setText(this.getResString("IDS_NEAREST_NEIGHBOR_FEATURES_PERFORM_SELECTION_MESSAGE"));
        this.mMessageArea.setFocusable(false);
        this.mFeaturesToEvaluateLabel = new StringTextField(" " + this.getResString("IDS_NEAREST_NEIGHBOR_FEATURES_FORWARD_NUM_LABEL"));
        this.mFeaturesToEvaluateLabel.setEditable(false);
        this.mFeaturesToEvaluateLabel.setEnabled(true);
        this.mFeaturesToEvaluateLabel.setBorder(null);
        this.mFeaturesToEvaluateField = new JLabel();
        this.mForcedFeaturesLabel = new StringTextField(" " + this.getResString("IDS_NEAREST_NEIGHBOR_FEATURES_FORCED_ENTRY_NUM_LABEL"));
        this.mForcedFeaturesLabel.setEditable(false);
        this.mForcedFeaturesLabel.setEnabled(true);
        this.mForcedFeaturesLabel.setBorder(null);
        this.mForcedFeaturesField = new JLabel();
        this.mStoppingCriteriaPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NEAREST_NEIGHBOR_MODEL_STOPPING_CRITERIA_TITLE"));
        this.mMaxReachedRadio = DialogUtil.createRadioButton(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_STOPPING_CRITERIA_REACH_MAX_RADIO", null);
        this.mMaxReachedRadio.addItemListener(this);
        this.mBelowMinRadio = DialogUtil.createRadioButton(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_STOPPING_CRITERIA_MIN_ERROR", null);
        this.mBelowMinRadio.addItemListener(this);
        this.mStoppingRadioGrp = new SpssButtonGroup();
        this.mStoppingRadioGrp.add(this.mMaxReachedRadio);
        this.mStoppingRadioGrp.add(this.mBelowMinRadio);
        this.mMaxLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_STOPPING_CRITERIA_REACH_MAX_LABEL");
        this.mMaxToSelectField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMaxToSelectField.setAction((Action)new TextFieldAction(this.mParent, FEATURE_STOPPING_CRITERIA_MAX));
        this.mMaxToSelectField.setColumns(5);
        this.mMaxToSelectField.addFocusListener((FocusListener)this);
        this.mMaxToSelectField.getDocument().addDocumentListener(this);
        this.mMaxLabel.setLabelFor((Component)this.mMaxToSelectField);
        this.mMinChangeLabel = DialogUtil.createLabel(this.mParent, "IDS_NEAREST_NEIGHBOR_MODEL_STOPPING_CRITERIA_MIN_CHANGE_LABEL");
        this.mMinChangeField = new FloatTextField(true);
        this.mMinChangeField.setAction((Action)new TextFieldAction(this.mParent, FEATURE_STOPPING_CRITERIA_MIN_CHANGE));
        this.mMinChangeField.setColumns(5);
        this.mMinChangeField.addFocusListener((FocusListener)this);
        this.mMinChangeField.getDocument().addDocumentListener(this);
        this.mMinChangeLabel.setLabelFor((Component)this.mMinChangeField);
    }

    private void setupStoppingCriteriaPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, n2 - 4, 0, 0);
        DialogUtil.addUsingGBL(this.mStoppingCriteriaPanel, this.mMaxReachedRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 - 4, n2 * 6, n2 - 4, 4);
        DialogUtil.addUsingGBL(this.mStoppingCriteriaPanel, this.mMaxLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 4, 4, n2 - 4, n2);
        DialogUtil.addUsingGBL(this.mStoppingCriteriaPanel, (JComponent)this.mMaxToSelectField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2 - 4, n2 - 4, 0, 0);
        DialogUtil.addUsingGBL(this.mStoppingCriteriaPanel, this.mBelowMinRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        insets.set(n2 - 4, n2 * 6, n2 - 4, 4);
        DialogUtil.addUsingGBL(this.mStoppingCriteriaPanel, this.mMinChangeLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 - 4, 4, n2 - 4, n2);
        DialogUtil.addUsingGBL(this.mStoppingCriteriaPanel, (JComponent)this.mMinChangeField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mStoppingCriteriaPanel, new JPanel(), gridBagConstraints, 0, 4, 1, 1, n, insets);
    }

    private boolean doValidation() {
        try {
            if (this.mPerformSelection.isEnabled() && this.mPerformSelection.isSelected()) {
                String string;
                if (this.mForwardSelectionSrcList.getModel().getSize() == 0 && this.mForcedEntryVarList.getModel().getSize() > 0) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_EMPTY_FORWARD_LIST_WARNING"), VersionInfo.getAppVersionString());
                    this.mForcedEntryVarList.setSelectedIndex(0);
                    return false;
                }
                if (this.mMaxReachedRadio.isEnabled() && this.mMaxReachedRadio.isSelected()) {
                    string = this.mMaxToSelectField.getText();
                    int n = -1;
                    if (string.length() == 0 || (n = Integer.parseInt(string)) == 0) {
                        SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_EMPTY_NUM_FEATURES_WARNING"), VersionInfo.getAppVersionString());
                        NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mMaxToSelectField);
                        return false;
                    }
                    if (n > this.mForwardSelectionSrcList.getModel().getSize()) {
                        SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_TOO_MANY_NUM_FEATURES_WARNING"), VersionInfo.getAppVersionString());
                        NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mMaxToSelectField);
                        return false;
                    }
                }
                if (this.mBelowMinRadio.isEnabled() && this.mBelowMinRadio.isSelected() && ((string = this.mMinChangeField.getText()).length() == 0 || Double.parseDouble(string) == 0.0)) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NEAREST_NEIGHBOR_MIN_CHANGE_WARNING"), VersionInfo.getAppVersionString());
                    NearestNeighborAnalysisDlg.setSelectionText((JComponent)this.mMinChangeField);
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void updataNumField() {
        this.mFeaturesToEvaluateField.setText(Integer.toString(this.mForwardSelectionSrcList.getModel().getSize()));
        this.mForcedFeaturesField.setText(Integer.toString(this.mForcedEntryVarList.getModel().getSize()));
    }
}

