/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.kmeans_cluster;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.classify.kmeans_cluster.KMeansClusterDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class KMeansClusterOptions
extends BaseSubDialog {
    public static final String INITIAL_CLUSTER_CENTERS = "IDS_INITIAL_CLUSTER_CENTERS_CHKBOX";
    public static final String ANOVA_TABLE = "IDS_ANOVA TABLE_CHKBOX";
    public static final String CLUSTER_INFO_KEY = "IDS_CLUSTER_INFORMATION_FROM_EACH_CASE_CHKBOX";
    public static final String EXCLUDE_LIST_KEY = "IDS_EXCLUDE_CASES_LISTWISE_RADIO";
    public static final String EXCLUDE_PAIR_KEY = "IDS_EXCLUDE_CASES_PAIRWISE_RADIO";
    private JPanel mOptionsPanel;
    private JPanel mStatisticsPanel;
    private JPanel mMissingValuesPanel;
    private JCheckBox mInitialClusterChkbox;
    private JCheckBox mAnovaChkbox;
    private JCheckBox mClusterInfoChkbox;
    private JRadioButton mExcludeListWise;
    private JRadioButton mExcludePairWise;
    private SpssButtonGroup mGrpStatistics;
    private SpssButtonGroup mGrpMiss;

    public KMeansClusterOptions(KMeansClusterDlg kMeansClusterDlg) {
        super(kMeansClusterDlg, kMeansClusterDlg.getResString("IDS_K_MEANS_CLUSTER_OPTIONS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_quic_opt";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.mOptionsPanel = this.setupOptionPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mOptionsPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
    }

    private void setDefaults() {
        this.mInitialClusterChkbox.setSelected(true);
        this.mExcludeListWise.setSelected(true);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, INITIAL_CLUSTER_CENTERS);
        this.mInitialClusterChkbox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, ANOVA_TABLE);
        this.mAnovaChkbox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CLUSTER_INFO_KEY);
        this.mClusterInfoChkbox = new JCheckBox(toggleButtonAction);
        this.mGrpStatistics = new SpssButtonGroup();
        this.mGrpStatistics.add(this.mInitialClusterChkbox);
        this.mGrpStatistics.add(this.mAnovaChkbox);
        this.mGrpStatistics.add(this.mClusterInfoChkbox);
        toggleButtonAction = new ToggleButtonAction(this, EXCLUDE_LIST_KEY);
        this.mExcludeListWise = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, EXCLUDE_PAIR_KEY);
        this.mExcludePairWise = new JRadioButton(toggleButtonAction);
        this.mGrpMiss = new SpssButtonGroup();
        this.mGrpMiss.add(this.mExcludeListWise);
        this.mGrpMiss.add(this.mExcludePairWise);
    }

    private JPanel setupOptionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        JComponent[] jComponentArray = new JComponent[]{this.mInitialClusterChkbox, this.mAnovaChkbox, this.mClusterInfoChkbox};
        this.mStatisticsPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_STATISTICS"), 3);
        jComponentArray = new JComponent[]{this.mExcludeListWise, this.mExcludePairWise};
        this.mMissingValuesPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_MISSING_VALUES"), 2);
        DialogUtil.addUsingGBL(jPanel, this.mStatisticsPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMissingValuesPanel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInitialClusterChkbox);
        vector.add(this.mAnovaChkbox);
        vector.add(this.mClusterInfoChkbox);
        vector.add(this.mGrpMiss);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

