/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.kmeans_cluster;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.classify.kmeans_cluster.KMeansClusterIterate;
import com.spss.java_client.ui.dialogs.base.analyze.classify.kmeans_cluster.KMeansClusterOptions;
import com.spss.java_client.ui.dialogs.base.analyze.classify.kmeans_cluster.KMeansClusterSave;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.ContentValidatorFileChooser;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class KMeansClusterDlg
extends BaseProcedureDialog
implements ListDataListener,
ActionListener,
ItemListener,
DocumentListener,
ListSelectionListener,
FocusListener {
    static final String READ_DISPLAY_KEY = "IDS_KMEANS_FILE_READ";
    static final String WRITE_DISPLAY_KEY = "IDS_KMEANS_FILE_WRITE";
    static final String READ_INITIAL_KEY = "IDS_READ_INITIAL_CHKBOX";
    static final String WRITE_FINAL_KEY = "IDS_WRITE_FINAL_CHKBOX";
    static final String ITERATE_CLASSIFY_KEY = "IDS_ITERATE_AND_CLASSIFY_RADIO";
    static final String CLASSIFY_KEY = "IDS_CLASSIFY_ONLY_RADIO";
    static final String EXTERNAL_DATA_FILE_RADIO_KEY = "IDS_EXTERNAL_DATAFILE_RADIO";
    static final String OPEN_DATASET_KEY = "IDS_OPEN_DATASET_RADIO";
    static final String NEW_DATASET_KEY = "IDS_NEW_DATASET_RADIO";
    static final String NEW_DATASET_TEXTFIELD_KEY = "IDS_NEW_DATASET_EDIT_KEY";
    static final String DATAFILE_KEY = "IDS_DATAFILE_RADIO";
    static final String EXTERNAL_FILE_KEY = "IDS_FILE_BUTTON_3DOT";
    static final String DATAFILE_BUTTON_KEY = "IDS_FILE_BUTTON_3DOT_SECOND";
    static final String TARGET_LIST_1 = "TARGET_LIST_1";
    static final String NUMBER_CLUSTER_TEXT_KEY = "IDS_KMEANS_NUMBER_OF_CLUSTERS";
    static final String COMBO_KEY = "IDS_OPEN_DATASET_RADIO";
    static final int READWRITETEXT = 25;
    static final int SETCOLUMNS = 3;
    static final String SETTEXT = "2";
    static boolean mSave = false;
    private JPanel mSourceListPanel;
    private JScrollPane mScrollPane;
    private JScrollPane mVarListScrollPane;
    private JPanel mLabelCasesPanel;
    private JPanel mClusterCenterPanel;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mCaseTargetList;
    private JRadioButton mIterateClassifyRadio;
    private JRadioButton mClassifyOnlyRadio;
    private JRadioButton mOpenDatasetRadio;
    private JRadioButton mExternalDatafileRadio;
    private JRadioButton mNewDatasetRadio;
    private JRadioButton mDataFileRadio;
    private JCheckBox mReadInitial;
    private JCheckBox mWriteFinal;
    private JComboBox mOpenDatasetCombo;
    private StringTextField mNewDataTextfield;
    private IntTextField mClusterTextField;
    private JButton mExternalDataFileChooserButton;
    private JButton mDataFileChooser;
    private ArrowButton mRightArrowButtonOne;
    private ArrowButton mRightArrowButtonTwo;
    private JLabel mLabel;
    private JLabel mLabelCases;
    private JLabel mClusterLabel;
    private JPanel mMethodPanel;
    private Border mMethodBorder;
    private JButton mIterateButton;
    private FileTextField mFileReadText;
    private FileTextField mFileWriteText;
    private JScrollPane mTargetScrollPane;
    private JPanel mButtonTextReadPanel;
    private JPanel mButtonTextWritePanel;
    private SpssButtonGroup mGrpMethod;
    private SpssButtonGroup mGrpRead;
    private SpssButtonGroup mGrpWrite;
    private SpssButtonGroup mGrpCluster;

    public KMeansClusterDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_K_MEANS_CLUSTER_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_quic";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        RemoteFileChooser remoteFileChooser;
        Object object = actionEvent.getSource();
        if (object == this.mExternalDataFileChooserButton) {
            remoteFileChooser = new ContentValidatorFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Data, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
            RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_KMEANS_FILE_FILTER"), this.getResString("IDS_KMEANS_FILE_EXTENSION"));
            remoteFileChooser.setDialogTitle(this.getResString("IDS_EXTFILECHOOSER_BUTTON"));
            remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter, true);
            int n = remoteFileChooser.showOpenDialog((Component)((Object)this));
            if (n == 0) {
                FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                this.mFileReadText.setText(remoteFileChooser.getSelectedFilePath());
            }
        }
        if (object == this.mDataFileChooser) {
            remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
            remoteFileChooser.setDialogTitle(this.getResString("IDS_KMEANS_SAVE_CHOOSER_TITLE"));
            remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_KMEANS_FILE_FILTER"), this.getResString("IDS_KMEANS_FILE_EXTENSION")));
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            int n = remoteFileChooser.showSaveDialog((Component)((Object)this));
            if (n == 0) {
                String string = remoteFileChooser.getSelectedFilePath();
                FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                if (!string.endsWith(this.getResString("IDS_KMEANS_FILE_EXTENSION"))) {
                    string = string + this.getResString("IDS_KMEANS_FILE_EXTENSION");
                }
                this.mFileWriteText.setText(string);
            }
        }
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        String string3;
        Boolean bl = null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        Boolean bl4 = null;
        Boolean bl5 = null;
        Boolean bl6 = null;
        Boolean bl7 = null;
        Boolean bl8 = null;
        Boolean bl9 = null;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        bl5 = dialogDataModel.getBoolean(WRITE_FINAL_KEY);
        boolean bl10 = false;
        if (bl5 != null && bl5.booleanValue() && (bl6 = dialogDataModel.getBoolean(NEW_DATASET_KEY)) != null && bl6.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNewDataTextfield.getText()));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("QUICK CLUSTER"));
        String string4 = this.mTargetVarList.getVariablesStringList();
        if (!string4.equals("")) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string4));
        }
        if (!string4.equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING="));
        }
        bl = dialogDataModel.getBoolean("IDS_EXCLUDE_CASES_LISTWISE_RADIO");
        bl2 = dialogDataModel.getBoolean("IDS_EXCLUDE_CASES_PAIRWISE_RADIO");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("PAIRWISE");
        } else {
            stringBuffer.append("LISTWISE");
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA="));
        stringBuffer.append("CLUSTER(");
        stringBuffer.append(this.mClusterTextField.getText() + ") ");
        bl9 = dialogDataModel.getBoolean(ITERATE_CLASSIFY_KEY);
        if (bl9 != null && bl9.booleanValue()) {
            stringBuffer.append("MXITER(");
            if (dialogDataModel.getString("IDS_KMEANS_MAXIMUM_ITERATIONS") != null) {
                stringBuffer.append(dialogDataModel.getString("IDS_KMEANS_MAXIMUM_ITERATIONS") + ") ");
            } else {
                stringBuffer.append(KMeansClusterIterate.MAXITERATIONTEXT + ") ");
            }
            stringBuffer.append("CONVERGE(");
            if (dialogDataModel.getString("IDS_CONVERGENCE_CRITERION") != null) {
                stringBuffer.append(dialogDataModel.getString("IDS_CONVERGENCE_CRITERION") + ")");
            } else {
                stringBuffer.append(KMeansClusterIterate.CONVERGENCETEXT + ")");
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/METHOD="));
        bl = dialogDataModel.getBoolean(ITERATE_CLASSIFY_KEY);
        if (bl != null && bl.booleanValue()) {
            bl2 = dialogDataModel.getBoolean("IDS_USE_RUNNING_MEANS_CHKBOX");
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("KMEANS(UPDATE)");
            } else {
                stringBuffer.append("KMEANS(NOUPDATE)");
            }
        } else {
            stringBuffer.append("CLASSIFY");
        }
        String string5 = this.generateSaveSyntax(dialogDataModel);
        if (!string5.equals("")) {
            stringBuffer.append(string5);
        }
        if (!(string3 = this.generateOptionsSyntax(dialogDataModel)).equals("")) {
            stringBuffer.append(string3);
        }
        if ((bl3 = dialogDataModel.getBoolean(READ_INITIAL_KEY)) != null && bl3.booleanValue()) {
            bl4 = dialogDataModel.getBoolean(EXTERNAL_DATA_FILE_RADIO_KEY);
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/FILE="));
                stringBuffer.append(CharacterUtil.smartQuote((String)this.mFileReadText.getText()));
            }
            if ((bl8 = dialogDataModel.getBoolean("IDS_OPEN_DATASET_RADIO")) != null && bl8.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/FILE="));
                string2 = this.mOpenDatasetCombo.getModel().getSelectedItem().toString().trim();
                string2 = string2.substring(string2.indexOf("[") + 1, string2.indexOf("]"));
                stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            }
        }
        string2 = null;
        bl5 = dialogDataModel.getBoolean(WRITE_FINAL_KEY);
        if (bl5 != null && bl5.booleanValue()) {
            bl6 = dialogDataModel.getBoolean(NEW_DATASET_KEY);
            if (bl6 != null && bl6.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE="));
                stringBuffer.append(this.mNewDataTextfield.getText());
            }
            if ((bl7 = dialogDataModel.getBoolean(DATAFILE_KEY)) != null && bl7.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE="));
                string2 = this.mFileWriteText.getText();
                stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        PesFile pesFile = PES_Repository.getPesFile(string2);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if (bl10 && CommandLine.isClementineCaller() && RemoteFileChooser.enableSaveInModeler()) {
            stringBuffer.append("\nDATASET ACTIVATE " + this.mNewDataTextfield.getText());
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_classify_k_cluster";
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mTargetVarList.getModel()) {
            this.enableOkPaste();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.mReadInitial)) {
            if (this.mReadInitial.isSelected()) {
                this.mExternalDatafileRadio.setEnabled(true);
                this.mExternalDataFileChooserButton.setEnabled(true);
                this.mFileReadText.setEnabled(true);
                if (this.mOpenDatasetCombo.getItemCount() > 0) {
                    this.mOpenDatasetRadio.setEnabled(true);
                    this.mOpenDatasetCombo.setEnabled(this.mOpenDatasetRadio.isSelected());
                    this.mExternalDataFileChooserButton.setEnabled(this.mExternalDatafileRadio.isSelected());
                    this.mFileReadText.setEnabled(this.mExternalDatafileRadio.isSelected());
                }
            } else {
                this.mExternalDatafileRadio.setEnabled(false);
                this.mExternalDataFileChooserButton.setEnabled(false);
                this.mFileReadText.setEnabled(false);
                this.mOpenDatasetRadio.setEnabled(false);
                this.mOpenDatasetCombo.setEnabled(false);
            }
        }
        if (object.equals(this.mWriteFinal)) {
            if (this.mWriteFinal.isSelected()) {
                this.mNewDatasetRadio.setEnabled(true);
                this.mDataFileRadio.setEnabled(true);
                if (this.mNewDatasetRadio.isSelected()) {
                    this.mNewDataTextfield.setEnabled(true);
                    this.mNewDataTextfield.setOpaque(true);
                    this.mDataFileChooser.setEnabled(false);
                    this.mFileWriteText.setEnabled(false);
                }
                if (this.mDataFileRadio.isSelected()) {
                    this.mNewDataTextfield.setEnabled(false);
                    this.mNewDataTextfield.setOpaque(false);
                    this.mDataFileChooser.setEnabled(true);
                    this.mFileWriteText.setEnabled(true);
                }
            } else {
                this.mNewDatasetRadio.setEnabled(false);
                this.mDataFileRadio.setEnabled(false);
                this.mNewDataTextfield.setEnabled(false);
                this.mNewDataTextfield.setOpaque(false);
                this.mDataFileChooser.setEnabled(false);
                this.mFileWriteText.setEnabled(false);
            }
        }
        if (object.equals(this.mNewDatasetRadio)) {
            if (this.mNewDatasetRadio.isSelected()) {
                this.mNewDataTextfield.setEnabled(true);
                this.mNewDataTextfield.setOpaque(true);
                this.mDataFileChooser.setEnabled(false);
                this.mFileWriteText.setEnabled(false);
            } else {
                this.mNewDataTextfield.setEnabled(false);
                this.mNewDataTextfield.setOpaque(false);
                this.mDataFileChooser.setEnabled(true);
                this.mFileWriteText.setEnabled(true);
            }
        }
        if (object.equals(this.mOpenDatasetRadio)) {
            if (this.mOpenDatasetRadio.isSelected()) {
                this.mOpenDatasetCombo.setEnabled(true);
                this.mOpenDatasetCombo.setOpaque(true);
                this.mExternalDataFileChooserButton.setEnabled(false);
                this.mFileReadText.setEnabled(false);
            } else {
                this.mOpenDatasetCombo.setEnabled(false);
                this.mOpenDatasetCombo.setOpaque(false);
                this.mExternalDataFileChooserButton.setEnabled(true);
                this.mFileReadText.setEnabled(true);
            }
        }
        this.enableOkPaste();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mClusterTextField.getText().length() > 0 && this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste();
        }
        if (documentEvent.getLength() == this.mNewDataTextfield.getText().length()) {
            this.enableOkPaste();
        }
        if (this.mWriteFinal.isSelected()) {
            if (this.mNewDatasetRadio.isSelected() && this.mNewDataTextfield.getText().length() > 0) {
                this.enableOkPaste();
            } else if (this.mDataFileRadio.isSelected() && this.mFileWriteText.getText().length() > 0) {
                this.enableOkPaste();
            } else {
                this.enableOkPaste();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mClusterTextField.getText().length() > 0 && this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste();
        }
        if (documentEvent.getLength() == this.mNewDataTextfield.getText().length()) {
            this.enableOkPaste();
        }
        if (this.mWriteFinal.isSelected()) {
            if (this.mNewDatasetRadio.isSelected() && this.mNewDataTextfield.getText().length() > 0) {
                this.enableOkPaste();
            } else if (this.mDataFileRadio.isSelected() && this.mFileWriteText.getText().length() > 0) {
                this.enableOkPaste();
            } else {
                this.enableOkPaste();
            }
        } else {
            this.enableOkPaste();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mClusterTextField.getText().length() > 0 && this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste();
        }
        if (documentEvent.getLength() == this.mNewDataTextfield.getText().length()) {
            this.enableOkPaste();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.mTargetVarList) {
            this.mRightArrowButtonTwo.setEnabled(false);
        }
        if (object == this.mCaseTargetList) {
            this.mRightArrowButtonOne.setEnabled(false);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mClusterTextField.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public boolean okPastePressed() {
        if (this.mWriteFinal.isSelected() && this.mNewDatasetRadio.isSelected()) {
            int n = DatasetNameValidator.validateDatasetName((String)this.mNewDataTextfield.getText(), (Component)((Object)this));
            if (n == 1) {
                return true;
            }
            this.mNewDataTextfield.requestFocus();
            this.mNewDataTextfield.selectAll();
            return false;
        }
        if (this.mReadInitial.isSelected() && this.mWriteFinal.isSelected() && this.mExternalDatafileRadio.isSelected() && this.mDataFileRadio.isSelected() && this.mFileReadText.getText().equals(this.mFileWriteText.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_KMEANS_MESSAGE"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.mLabelCasesPanel = this.setupLabelCasesPanel();
        this.mMethodPanel = this.setupMethodPanel();
        this.mSourceListPanel = this.setupLists();
        this.mButtonTextReadPanel = this.setupButtonTextReadPanel();
        this.mButtonTextWritePanel = this.setupButtonTextWritePanel();
        this.mClusterCenterPanel = this.setupClusterCenterPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mSourceListPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(0, 0, 0, DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mSourceListPanel, this.mLabelCasesPanel, gridBagConstraints, 2, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets3 = new Insets(0, 0, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mClusterCenterPanel, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_ITERATE_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KMeansClusterDlg.this.runIterateSubDialog();
            }
        };
        this.mIterateButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mIterateButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KMeansClusterDlg.this.runSaveSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            jButton.setEnabled(false);
        }
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KMeansClusterDlg.this.runOptionsSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void enableOkPaste() {
        boolean bl = true;
        boolean bl2 = true;
        if (this.mTargetVarList.getModel().getSize() > 0 && this.mClusterTextField.getText().length() > 0) {
            if (this.mReadInitial.isSelected() || this.mWriteFinal.isSelected()) {
                if (this.mReadInitial.isSelected()) {
                    bl = this.mExternalDatafileRadio.isSelected() && this.mFileReadText.getText().length() > 0 || this.mOpenDatasetRadio.isSelected();
                }
                if (this.mWriteFinal.isSelected()) {
                    bl2 = this.mNewDatasetRadio.isSelected() && this.mNewDataTextfield.getText().length() > 0 ? true : this.mDataFileRadio.isSelected() && this.mFileWriteText.getText().length() > 0;
                }
                if (bl && bl2) {
                    this.enableOkPaste(true);
                } else {
                    this.enableOkPaste(false);
                }
            } else {
                this.enableOkPaste(true);
            }
        } else {
            this.enableOkPaste(false);
        }
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mTargetVarList.removeAll();
        this.mCaseTargetList.removeAll();
        this.mReadInitial.setSelected(false);
        this.mOpenDatasetRadio.setSelected(false);
        this.mExternalDatafileRadio.setEnabled(false);
        this.mExternalDataFileChooserButton.setEnabled(false);
        this.mWriteFinal.setSelected(false);
        this.mNewDatasetRadio.setSelected(true);
        this.mDataFileRadio.setEnabled(false);
        this.mNewDataTextfield.setOpaque(false);
        this.mNewDataTextfield.setText("");
        this.mNewDataTextfield.setEnabled(false);
        this.mDataFileChooser.setEnabled(false);
        this.mIterateClassifyRadio.setSelected(true);
        this.mClassifyOnlyRadio.setSelected(false);
        this.mFileReadText.setText("");
        this.mFileReadText.setOpaque(false);
        this.mFileReadText.setEnabled(true);
        this.mFileReadText.setEditable(false);
        this.mFileReadText.setCaretPosition(0);
        this.mFileWriteText.setText("");
        this.mFileWriteText.setOpaque(false);
        this.mFileWriteText.setEnabled(true);
        this.mFileWriteText.setEditable(false);
        this.mFileWriteText.setCaretPosition(0);
        this.mClusterTextField.setText(SETTEXT);
        this.mOpenDatasetRadio.setEnabled(false);
        this.mOpenDatasetCombo.setEnabled(false);
        this.enableOkPaste(false);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mReadInitial.setEnabled(false);
            this.mWriteFinal.setEnabled(false);
        }
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollPane = new JScrollPane(this.mSrcVarList);
        this.mScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mCaseTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCaseTargetList.addListSelectionListener(this);
        this.mLabelCases = DialogUtil.createLabel(this, "IDS_LABEL_CASES_BY");
        this.mLabelCases.setLabelFor(this.mCaseTargetList);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setIdentifier(TARGET_LIST_1);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 4 + 2));
        this.mVarListScrollPane = new JScrollPane(this.mTargetVarList);
        this.mVarListScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mLabel = DialogUtil.createLabel(this, "IDS_KMEANS_VARIABLES");
        this.mLabel.setLabelFor(this.mTargetVarList);
        this.mRightArrowButtonOne = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRightArrowButtonTwo = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRightArrowButtonOne.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRightArrowButtonOne.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRightArrowButtonTwo.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRightArrowButtonTwo.registerVariableList(this.mCaseTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mClusterTextField = new IntTextField(2, 9999, true);
        this.mClusterTextField.setColumns(3);
        this.mClusterTextField.setAction((Action)new TextFieldAction(this, NUMBER_CLUSTER_TEXT_KEY));
        this.mClusterTextField.getDocument().addDocumentListener(this);
        this.mClusterLabel = DialogUtil.createLabel(this, "IDS_NUMBER_OF_CLUSTERS");
        this.mClusterLabel.setLabelFor((Component)this.mClusterTextField);
        this.mClusterTextField.addFocusListener((FocusListener)this);
        ControlAction controlAction = new ToggleButtonAction(this, ITERATE_CLASSIFY_KEY);
        this.mIterateClassifyRadio = new JRadioButton(controlAction);
        this.mIterateClassifyRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, CLASSIFY_KEY);
        this.mClassifyOnlyRadio = new JRadioButton(controlAction);
        this.mClassifyOnlyRadio.addItemListener(this);
        this.mGrpMethod = new SpssButtonGroup();
        this.mGrpMethod.add(this.mIterateClassifyRadio);
        this.mGrpMethod.add(this.mClassifyOnlyRadio);
        controlAction = new ToggleButtonAction(this, READ_INITIAL_KEY);
        this.mReadInitial = new JCheckBox(controlAction);
        this.mReadInitial.addItemListener(this);
        controlAction = new ToggleButtonAction(this, "IDS_OPEN_DATASET_RADIO");
        this.mOpenDatasetRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, EXTERNAL_DATA_FILE_RADIO_KEY);
        this.mExternalDatafileRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, EXTERNAL_FILE_KEY);
        this.mExternalDataFileChooserButton = new JButton(controlAction);
        this.mExternalDataFileChooserButton.addActionListener(this);
        this.mOpenDatasetCombo = new JComboBox<Object>(this.getDataSetList().toArray());
        controlAction = new ComboboxAction(this, "IDS_OPEN_DATASET_RADIO");
        if (this.mOpenDatasetCombo.getItemCount() > 0) {
            this.mOpenDatasetRadio.setSelected(true);
        } else {
            this.mExternalDatafileRadio.setSelected(true);
        }
        this.mOpenDatasetCombo.setAction(controlAction);
        this.mOpenDatasetCombo.setMinimumSize(new Dimension(205, 20));
        this.mOpenDatasetCombo.setPreferredSize(this.mOpenDatasetCombo.getMinimumSize());
        this.mFileReadText = new FileTextField();
        this.mFileReadText.setColumns(25);
        this.mFileReadText.setBorder(BorderFactory.createEmptyBorder());
        this.mFileReadText.getDocument().addDocumentListener(this);
        this.mFileReadText.setAction(new TextFieldAction(this, READ_DISPLAY_KEY));
        controlAction = new ToggleButtonAction(this, WRITE_FINAL_KEY);
        this.mWriteFinal = new JCheckBox(controlAction);
        this.mWriteFinal.addItemListener(this);
        controlAction = new ToggleButtonAction(this, NEW_DATASET_KEY);
        this.mNewDatasetRadio = new JRadioButton(controlAction);
        this.mNewDatasetRadio.addItemListener(this);
        this.mNewDatasetRadio.setEnabled(false);
        this.mNewDataTextfield = new StringTextField();
        this.mNewDataTextfield.getDocument().addDocumentListener(this);
        this.mNewDataTextfield.setAction(new TextFieldAction(this, NEW_DATASET_TEXTFIELD_KEY));
        this.mNewDataTextfield.setColumns(25);
        controlAction = new ToggleButtonAction(this, DATAFILE_KEY);
        this.mDataFileRadio = new JRadioButton(controlAction);
        this.mDataFileRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, DATAFILE_BUTTON_KEY);
        this.mDataFileChooser = new JButton(controlAction);
        this.mDataFileChooser.addActionListener(this);
        this.mFileWriteText = new FileTextField();
        this.mFileWriteText.setColumns(25);
        this.mFileWriteText.setBorder(BorderFactory.createEmptyBorder());
        this.mFileWriteText.getDocument().addDocumentListener(this);
        this.mFileWriteText.setAction(new TextFieldAction(this, WRITE_DISPLAY_KEY));
        this.mOpenDatasetRadio.addItemListener(this);
        this.mExternalDatafileRadio.addItemListener(this);
        this.mGrpCluster = new SpssButtonGroup();
        this.mGrpCluster.add(this.mReadInitial);
        this.mGrpCluster.add(this.mWriteFinal);
        this.mGrpRead = new SpssButtonGroup();
        this.mGrpRead.add(this.mOpenDatasetRadio);
        this.mGrpRead.add(this.mExternalDatafileRadio);
        this.mGrpWrite = new SpssButtonGroup();
        this.mGrpWrite.add(this.mNewDatasetRadio);
        this.mGrpWrite.add(this.mDataFileRadio);
        this.checkReadWriteBoxes();
    }

    private void checkReadWriteBoxes() {
        if (!this.mWriteFinal.isSelected()) {
            this.mFileWriteText.setEnabled(this.mWriteFinal.isSelected());
            this.mDataFileChooser.setEnabled(this.mWriteFinal.isSelected());
        }
        if (!this.mReadInitial.isSelected()) {
            this.mFileReadText.setEnabled(this.mReadInitial.isSelected() && this.mExternalDatafileRadio.isSelected());
            this.mOpenDatasetCombo.setEnabled(false);
        }
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mRightArrowButtonOne);
        vector.add(this.mRightArrowButtonTwo);
        vector.add(this.mTargetVarList);
        vector.add(this.mCaseTargetList);
        vector.add(this.mClusterTextField);
        vector.add(this.mGrpMethod);
        vector.add(this.mReadInitial);
        vector.add(this.mGrpRead);
        vector.add(this.mOpenDatasetCombo);
        vector.add(this.mExternalDataFileChooserButton);
        vector.add(this.mWriteFinal);
        vector.add(this.mGrpWrite);
        vector.add(this.mNewDataTextfield);
        vector.add(this.mDataFileChooser);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            if (!(this.mOptionButtonPanel.getComponent(n) instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private JPanel setupButtonTextReadPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mExternalDataFileChooserButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(DialogUtil.getStandardControlInsets().top * 3, DialogUtil.getComponentGroupGap(), 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileReadText), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupButtonTextWritePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDataFileChooser, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(DialogUtil.getStandardControlInsets().top * 3, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileWriteText), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupMethodPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        this.mMethodBorder = new TitledBorder(this.getResString("IDS_KMEANS_METHOD"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.setBorder(this.mMethodBorder);
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mIterateClassifyRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mClassifyOnlyRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_KMEANS_CLUSTER_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 4, n, null);
        n = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mRightArrowButtonOne, gridBagConstraints, 1, 1, 1, 1, n, insets);
        n = 20;
        Insets insets2 = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mRightArrowButtonTwo, gridBagConstraints, 1, 3, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mVarListScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(DialogUtil.getComponentGroupGap() + 4, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mClusterLabel, gridBagConstraints, 0, 6, 1, 1, n, insets3);
        n = 10;
        Insets insets4 = new Insets(0, DialogUtil.getArrowButtonInsets().left, DialogUtil.getArrowButtonInsets().bottom * 2, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mClusterTextField, gridBagConstraints, 1, 6, 1, 1, n, insets4);
        n = 23;
        Insets insets5 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mMethodPanel, gridBagConstraints, 2, 6, 1, 1, n, insets5);
        return jPanel;
    }

    private JPanel setupClusterCenterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CLUSTER_CENTERS"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mReadInitial, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        Insets insets3 = new Insets(insets.top, DialogUtil.getGroupBoxInnerMargin() * 3, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mOpenDatasetRadio, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mExternalDatafileRadio, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        Insets insets4 = new Insets(insets.top + 2, DialogUtil.getComponentGroupGap(), insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mOpenDatasetCombo, gridBagConstraints, 1, 1, 1, 1, n, insets4);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mButtonTextReadPanel, gridBagConstraints, 1, 2, 1, 1, n, new Insets(insets.top + 1, 0, insets.bottom, insets.right));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mWriteFinal, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mNewDatasetRadio, gridBagConstraints, 0, 4, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        insets4.set(insets.top + 3, DialogUtil.getComponentGroupGap(), insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNewDataTextfield), gridBagConstraints, 1, 4, 6, 1, n, insets4);
        gridBagConstraints.weighty = 1.0;
        Insets insets5 = new Insets(insets.top, DialogUtil.getGroupBoxInnerMargin() * 3, DialogUtil.getGroupBoxInnerMargin(), insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDataFileRadio, gridBagConstraints, 0, 5, 1, 1, n, insets5);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mButtonTextWritePanel, gridBagConstraints, 1, 5, 1, 1, n, new Insets(insets.top + 1, 0, insets.bottom, insets.right));
        return jPanel;
    }

    private JPanel setupLabelCasesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLabelCases, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mTargetScrollPane = new JScrollPane(this.mCaseTargetList);
        this.mTargetScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTargetScrollPane.setVerticalScrollBarPolicy(21);
        this.mTargetScrollPane.setPreferredSize(this.mCaseTargetList.getMinimumSize());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private String generateSaveSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = null;
        Boolean bl2 = null;
        String string = "";
        bl = dialogDataModel.getBoolean("IDS_CLUSTER_MEMBERSHIP_CHKBOX");
        if (bl != null && bl.booleanValue()) {
            string = string + "CLUSTER";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_DISTANCE_FROM_CLUSTER_CENTER_CHKBOX")) != null && bl2.booleanValue()) {
            string = string + " DISTANCE";
        }
        if (string.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE "));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String generateOptionsSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = null;
        String string = "";
        String string2 = this.mCaseTargetList.getVariablesStringList();
        bl = dialogDataModel.getBoolean("IDS_INITIAL_CLUSTER_CENTERS_CHKBOX");
        if (bl != null && bl.booleanValue()) {
            string = string + "INITIAL";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ANOVA TABLE_CHKBOX")) != null && bl.booleanValue()) {
            string = string + " ANOVA";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CLUSTER_INFORMATION_FROM_EACH_CASE_CHKBOX")) != null && bl.booleanValue()) {
            string = string + " CLUSTER DISTAN";
        }
        if (string.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT "));
            if (!string2.equals("")) {
                stringBuffer.append("ID(" + string2 + ") ");
            }
            stringBuffer.append(string);
        } else {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT "));
            if (!string2.equals("")) {
                stringBuffer.append("ID(" + string2 + ") INITIAL");
            } else {
                stringBuffer.append("INITIAL");
            }
        }
        return stringBuffer.toString();
    }

    private ArrayList<String> getDataSetList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        for (int i = 0; i < spssFrameArray.length; ++i) {
            if (!(spssFrameArray[i] instanceof DataFrame)) continue;
            DataFrame dataFrame = (DataFrame)spssFrameArray[i];
            String string = dataFrame.getCoreDocument().getDocName();
            String string2 = dataFrame.getDatasetName();
            String string3 = string + " [" + string2 + "]";
            if (SpssFrameMgr.getSpssFrameMgr().isDesignated(dataFrame)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private void runIterateSubDialog() {
        this.runSubDialog(new KMeansClusterIterate(this));
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new KMeansClusterSave(this));
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new KMeansClusterOptions(this));
    }
}

