/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster.HierClusterMethod;
import com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster.HierClusterPlots;
import com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster.HierClusterSave;
import com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster.HierClusterStatistics;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class HierarchicalClusterDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    static final String CLUS_CASES_RADIO_KEY = "IDS_CLUS_CASES_RADIO";
    static final String CLUS_VAR_RADIO_KEY = "IDS_CLUS_VAR_RADIO";
    static final String DISP_STATS_CHECK_KEY = "IDS_DISP_STATS_CHECK";
    static final String DISP_PLOTS_CHECK_KEY = "IDS_DISP_PLOTS_CHECK";
    static final String HIER_CLUS_SRC_LIST = "HIER_CLUS_VAR_LIST";
    static final String HIER_CLUS_VAR_LIST = "HIER_CLUS_VAR_LIST";
    static final String HIER_CLUS_LABELCASES_LIST = "HIER_CLUS_LABELCASES_LIST";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mLabelCasesList;
    private JLabel mLabelcasesLabel;
    private ArrowButton mTargetVarArrow;
    private ArrowButton mLabelCasesArrow;
    private JRadioButton mClusterCasesRadio;
    private JRadioButton mClusterVarRadio;
    private JCheckBox mDispStatsCheck;
    private JCheckBox mDispPlotsCheck;
    private JButton mStatsButton;
    private JButton mPlotsButton;
    private JButton mMethodButton;
    private JButton mSaveButton;
    private StringBuffer mBuffer;
    private boolean mClusterCasesSelected;
    private SpssButtonGroup mClusRadioGroup;

    public HierarchicalClusterDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_HIERARCHICAL_CLUSTER_TITLE"));
    }

    @Override
    public String generateSyntax() {
        boolean bl;
        this.mBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        boolean bl2 = bl = this.mClusterVarRadio.isSelected() || this.isProximities();
        if (bl) {
            Boolean bl3;
            double d = Math.random();
            String string = "D" + d;
            String string2 = SyntaxUtil.getMainCommand("DATASET DECLARE").toString();
            string2 = string2 + SyntaxUtil.getMainCommandParamters(string);
            string2 = string2 + SyntaxUtil.terminateSyntax();
            this.mBuffer.append(string2);
            this.mBuffer.append(SyntaxUtil.getMainCommand("PROXIMITIES  "));
            this.mBuffer.append(SyntaxUtil.getMainCommandParamters(this.mTargetVarList.getVariablesStringList()));
            this.mBuffer.append("\n");
            this.mBuffer.append(SyntaxUtil.getSubCommand("/MATRIX OUT"));
            this.mBuffer.append("(" + string + ")");
            if (this.mClusterCasesSelected) {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("VIEW", "CASE", false));
            } else {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("VIEW", "VARIABLE", false));
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl4 = false;
            Boolean bl5 = dialogDataModel.getBoolean("IDS_ABS_VAL_CHECK");
            if (bl5 != null) {
                if (bl5.booleanValue()) {
                    stringBuffer.append("ABSOLUTE");
                    bl4 = true;
                }
                if ((bl3 = dialogDataModel.getBoolean("IDS_CHANGE_SIGN_CHECK")).booleanValue()) {
                    if (bl4) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("REVERSE");
                    bl4 = true;
                }
                if ((bl3 = dialogDataModel.getBoolean("IDS_RESCALE_RANGE_CHECK")).booleanValue()) {
                    if (bl4) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("RESCALE");
                    bl4 = true;
                }
            }
            if (bl4) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.generateMeasureString(dialogDataModel));
            this.mBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("MEASURE", stringBuffer.toString(), false, true));
            if (this.mDispStatsCheck.isSelected()) {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("PRINT", "NONE", false));
            }
            if (this.mClusterCasesSelected) {
                this.generateIdString();
            }
            if ((bl3 = dialogDataModel.getBoolean("IDS_BINARY_RADIO")) != null && !bl3.booleanValue()) {
                this.mBuffer.append("\n" + SyntaxUtil.getSubCommand("/STANDARDIZE="));
                if (bl5 != null) {
                    int n = dialogDataModel.getInteger("METHOD_STANDARDIZE_COMBO_KEY");
                    bl3 = dialogDataModel.getBoolean("IDS_BY_CASE_RADIO");
                    if (bl3.booleanValue()) {
                        this.mBuffer.append("CASE ");
                    } else {
                        this.mBuffer.append("VARIABLE ");
                    }
                    switch (n) {
                        case 0: {
                            this.mBuffer.append("NONE");
                            break;
                        }
                        case 1: {
                            this.mBuffer.append("Z");
                            break;
                        }
                        case 2: {
                            this.mBuffer.append("RANGE");
                            break;
                        }
                        case 3: {
                            this.mBuffer.append("RESCALE");
                            break;
                        }
                        case 4: {
                            this.mBuffer.append("MAX");
                            break;
                        }
                        case 5: {
                            this.mBuffer.append("MEAN");
                            break;
                        }
                        case 6: {
                            this.mBuffer.append("SD");
                        }
                    }
                } else {
                    this.mBuffer.append("NONE");
                }
            } else {
                this.mBuffer.append("\n" + SyntaxUtil.getSubCommand("/STANDARDIZE="));
                this.mBuffer.append("NONE");
            }
            if (!this.mDispStatsCheck.isSelected()) {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("PRINT", "NONE", false));
            }
            this.mBuffer.append(SyntaxUtil.terminateSyntax());
            this.mBuffer.append(SyntaxUtil.getCommand("CLUSTER", false));
            this.mBuffer.append("\n" + SyntaxUtil.getSubCommand("/MATRIX IN(") + string + ")");
            this.generateMethodString(dialogDataModel);
            this.generateIdString();
            if (this.mDispStatsCheck.isSelected() && !this.mDispPlotsCheck.isSelected() || this.mDispStatsCheck.isSelected() && this.mDispPlotsCheck.isSelected()) {
                this.generatePrintString(dialogDataModel);
                this.generatePlotString(dialogDataModel);
            } else if (!this.mDispStatsCheck.isSelected() && this.mDispPlotsCheck.isSelected() || !this.mDispStatsCheck.isSelected() && !this.mDispPlotsCheck.isSelected()) {
                this.generatePlotString(dialogDataModel);
                this.generatePrintString(dialogDataModel);
            }
            if (this.mClusterCasesSelected) {
                this.generateSaveString(dialogDataModel);
            }
            this.mBuffer.append(SyntaxUtil.terminateSyntax());
            this.mBuffer.append("Dataset Close ").append(string);
        } else {
            this.mBuffer.append(SyntaxUtil.getCommand("CLUSTER  ", false));
            this.mBuffer.append(SyntaxUtil.getMainCommandParamters(this.mTargetVarList.getVariablesStringList()));
            this.generateMethodString(dialogDataModel);
            this.mBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("MEASURE", this.generateMeasureString(dialogDataModel), false, true));
            this.generateIdString();
            if (this.mDispStatsCheck.isSelected() && !this.mDispPlotsCheck.isSelected() || this.mDispStatsCheck.isSelected() && this.mDispPlotsCheck.isSelected()) {
                this.generatePrintString(dialogDataModel);
                this.generatePlotString(dialogDataModel);
            } else if (!this.mDispStatsCheck.isSelected() && this.mDispPlotsCheck.isSelected() || !this.mDispStatsCheck.isSelected() && !this.mDispPlotsCheck.isSelected()) {
                this.generatePlotString(dialogDataModel);
                this.generatePrintString(dialogDataModel);
            }
            this.generateSaveString(dialogDataModel);
        }
        this.mBuffer.append(SyntaxUtil.terminateSyntax());
        return this.mBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_classify_hier_cluster";
    }

    @Override
    public boolean okPastePressed() {
        if (this.mClusterVarRadio.isSelected() && this.mTargetVarList.getModel().getSize() < 3) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_HIER_FEWVAR_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mTargetVarList.removeAll();
        this.mLabelCasesList.removeAll();
        this.mTargetVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mLabelCasesArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_clus";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mClusterCasesRadio)) {
            this.enableLabelCaseConrols();
        } else if (itemEvent.getSource().equals(this.mClusterVarRadio)) {
            this.enableLabelCaseConrols();
            if (this.mClusterVarRadio.isSelected()) {
                this.checkAllOutputOff();
            }
        } else if (itemEvent.getSource().equals(this.mDispStatsCheck)) {
            this.mStatsButton.setEnabled(this.mDispStatsCheck.isSelected());
        } else if (itemEvent.getSource().equals(this.mDispPlotsCheck)) {
            this.mPlotsButton.setEnabled(this.mDispPlotsCheck.isSelected());
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupClusterPanel();
        JPanel jPanel3 = this.setupDisplayPanels();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_HIERARCHICAL_CLUSTER_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarArrow, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_VARIABLES_COLON_LABEL");
        n = 23;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        jScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 5 + 2));
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        jLabel2.setLabelFor(this.mTargetVarList);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, new Insets(0, 0, DialogUtil.getGroupBoxInnerMargin(), 0));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 20;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLabelCasesArrow, gridBagConstraints, 1, 2, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLabelcasesLabel, gridBagConstraints, 2, 2, 1, 1, n, new Insets(0, 0, DialogUtil.getGroupBoxInnerMargin() * 4, 0));
        jScrollPane = new JScrollPane(this.mLabelCasesList);
        jScrollPane.setPreferredSize(this.mLabelCasesList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        n = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 2, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 3, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 4, 1, 1, n, null);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchicalClusterDlg.this.runStatisticsSubDialog();
            }
        };
        this.mStatsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mStatsButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_PLOTS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchicalClusterDlg.this.runPlotsSubDialog();
            }
        };
        this.mPlotsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mPlotsButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_METHOD_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchicalClusterDlg.this.runMethodSubDialog();
            }
        };
        this.mMethodButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mMethodButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_SAVE_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchicalClusterDlg.this.runSaveSubDialog();
            }
        };
        this.mSaveButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mSaveButton);
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.enableControls();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("HIER_CLUS_VAR_LIST");
        this.mSrcVarList.loadFromActiveDataset();
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setIdentifier(HIER_CLUS_LABELCASES_LIST);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mLabelCasesList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mLabelCasesList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mLabelCasesList.addVarFilter(new SpssVarFilter(8, false, false));
        this.mLabelCasesList.setIdentifier("LabelCasesList");
        this.mLabelcasesLabel = DialogUtil.createLabel(this, "IDS_LABEL_CASES_COLON");
        this.mLabelcasesLabel.setLabelFor(this.mLabelCasesList);
        this.mTargetVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mLabelCasesArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarArrow.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mLabelCasesArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mLabelCasesArrow.registerVariableList(this.mLabelCasesList, SpssArrowButton.ButtonOrientation.left);
        this.mClusRadioGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, CLUS_CASES_RADIO_KEY);
        this.mClusterCasesRadio = new JRadioButton(toggleButtonAction);
        this.mClusRadioGroup.add(this.mClusterCasesRadio);
        toggleButtonAction = new ToggleButtonAction(this, CLUS_VAR_RADIO_KEY);
        this.mClusterVarRadio = new JRadioButton(toggleButtonAction);
        this.mClusRadioGroup.add(this.mClusterVarRadio);
        this.mClusterCasesRadio.addItemListener(this);
        this.mClusterVarRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, DISP_STATS_CHECK_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchicalClusterDlg.this.checkAllOutputOff();
            }
        };
        this.mDispStatsCheck = new JCheckBox(toggleButtonAction);
        this.mDispStatsCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, DISP_PLOTS_CHECK_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchicalClusterDlg.this.checkAllOutputOff();
            }
        };
        this.mDispPlotsCheck = new JCheckBox(toggleButtonAction);
        this.mDispPlotsCheck.addItemListener(this);
        this.mBuffer = new StringBuffer();
    }

    private boolean isProximities() {
        Integer n;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_ABS_VAL_CHECK");
        if (bl != null && bl.booleanValue()) {
            return true;
        }
        bl = dialogDataModel.getBoolean("IDS_CHANGE_SIGN_CHECK");
        if (bl != null && bl.booleanValue()) {
            return true;
        }
        bl = dialogDataModel.getBoolean("IDS_RESCALE_RANGE_CHECK");
        if (bl != null && bl.booleanValue()) {
            return true;
        }
        return bl != null && (n = dialogDataModel.getInteger("METHOD_STANDARDIZE_COMBO_KEY")) != null && n > 0;
    }

    private void setDefaults() {
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
        this.mClusterCasesRadio.setSelected(true);
        this.mClusterCasesSelected = this.mClusterCasesRadio.isSelected();
        this.mDispStatsCheck.setSelected(true);
        this.mDispPlotsCheck.setSelected(true);
        this.enableControls();
        this.mLabelCasesArrow.setEnabled(true);
    }

    private void enableControls() {
        this.mStatsButton.setEnabled(this.mDispStatsCheck.isSelected());
        this.mPlotsButton.setEnabled(this.mDispPlotsCheck.isSelected());
        this.mSaveButton.setEnabled(this.mClusterCasesSelected);
        this.mLabelcasesLabel.setEnabled(this.mClusterCasesSelected);
        this.mLabelCasesList.setEnabled(this.mClusterCasesSelected);
        this.mLabelCasesArrow.setEnabled(this.mClusterCasesSelected);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveButton.setEnabled(false);
        }
    }

    private void enableLabelCaseConrols() {
        this.mClusterCasesSelected = this.mClusterCasesRadio.isSelected();
        this.mLabelCasesList.setEnabled(this.mClusterCasesSelected);
        this.mLabelcasesLabel.setEnabled(this.mClusterCasesSelected);
        this.mLabelCasesArrow.setEnabled(this.mClusterCasesSelected);
        this.mSaveButton.setEnabled(this.mClusterCasesSelected);
        this.mLabelCasesArrow.setEnabled(this.mClusterCasesSelected);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveButton.setEnabled(false);
        }
    }

    private JPanel setupClusterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CLUSTER_PANEL"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        Insets insets = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mClusterCasesRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mClusterVarRadio, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupDisplayPanels() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_DISPLAY_PANEL"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        Insets insets = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDispStatsCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDispPlotsCheck, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mDispStatsCheck);
        spssButtonGroup.add(this.mDispPlotsCheck);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTargetVarArrow);
        vector.add(this.mLabelCasesArrow);
        vector.add(this.mTargetVarList);
        vector.add(this.mLabelCasesList);
        vector.add(this.mClusRadioGroup);
        vector.add(this.mDispStatsCheck);
        vector.add(this.mDispPlotsCheck);
        vector.add(this.mStatsButton);
        vector.add(this.mPlotsButton);
        vector.add(this.mMethodButton);
        vector.add(this.mSaveButton);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void runStatisticsSubDialog() {
        this.runSubDialog(new HierClusterStatistics(this));
    }

    private void runPlotsSubDialog() {
        this.runSubDialog(new HierClusterPlots(this));
    }

    private void runMethodSubDialog() {
        this.runSubDialog(new HierClusterMethod(this));
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new HierClusterSave(this));
    }

    private void generateMethodString(DialogDataModel dialogDataModel) {
        int n = 0;
        if (dialogDataModel.getInteger("METHOD_CLUSTER_COMBO_KEY") != null) {
            n = dialogDataModel.getInteger("METHOD_CLUSTER_COMBO_KEY");
        }
        switch (n) {
            case 0: {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("METHOD", "BAVERAGE", false));
                break;
            }
            case 1: {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("METHOD", "WAVERAGE", false));
                break;
            }
            case 2: {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("METHOD", "SINGLE", false));
                break;
            }
            case 3: {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("METHOD", "COMPLETE", false));
                break;
            }
            case 4: {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("METHOD", "CENTROID", false));
                break;
            }
            case 5: {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("METHOD", "MEDIAN", false));
                break;
            }
            case 6: {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("METHOD", "WARD", false));
            }
        }
    }

    private String generateMeasureString(DialogDataModel dialogDataModel) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_INTERVAL_RADIO");
        if (bl != null) {
            if (bl.booleanValue()) {
                n = dialogDataModel.getInteger("METHOD_INTERVAL_COMBO_KEY");
                switch (n) {
                    case 0: {
                        stringBuffer.append("EUCLID");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("SEUCLID");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("COSINE");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("CORRELATION");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("CHEBYCHEV");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("BLOCK");
                        break;
                    }
                    case 6: {
                        stringBuffer.append("MINKOWSKI(" + (dialogDataModel.getInteger("METHOD_POWER_COMBO_KEY") + 1) + ")");
                        break;
                    }
                    case 7: {
                        stringBuffer.append("POWER(" + (dialogDataModel.getInteger("METHOD_POWER_COMBO_KEY") + 1) + "," + (dialogDataModel.getInteger("METHOD_ROOT_COMBO_KEY") + 1) + ")");
                    }
                }
            } else {
                bl = (boolean)dialogDataModel.getBoolean("IDS_COUNTS_RADIO");
                if (bl.booleanValue()) {
                    if (dialogDataModel.getInteger("METHOD_COUNTS_COMBO_KEY") == 0) {
                        stringBuffer.append("CHISQ");
                    } else {
                        stringBuffer.append("PH2");
                    }
                } else {
                    n = dialogDataModel.getInteger("METHOD_BINARY_COMBO_KEY");
                    switch (n) {
                        case 0: {
                            stringBuffer.append("BEUCLID(");
                            break;
                        }
                        case 1: {
                            stringBuffer.append("BSEUCLID(");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("SIZE(");
                            break;
                        }
                        case 3: {
                            stringBuffer.append("PATTERN(");
                            break;
                        }
                        case 4: {
                            stringBuffer.append("VARIANCE(");
                            break;
                        }
                        case 5: {
                            stringBuffer.append("DISPER(");
                            break;
                        }
                        case 6: {
                            stringBuffer.append("BSHAPE(");
                            break;
                        }
                        case 7: {
                            stringBuffer.append("SM(");
                            break;
                        }
                        case 8: {
                            stringBuffer.append("PHI(");
                            break;
                        }
                        case 9: {
                            stringBuffer.append("LAMBDA(");
                            break;
                        }
                        case 10: {
                            stringBuffer.append("D(");
                            break;
                        }
                        case 11: {
                            stringBuffer.append("DICE(");
                            break;
                        }
                        case 12: {
                            stringBuffer.append("HAMANN(");
                            break;
                        }
                        case 13: {
                            stringBuffer.append("JACCARD(");
                            break;
                        }
                        case 14: {
                            stringBuffer.append("K1(");
                            break;
                        }
                        case 15: {
                            stringBuffer.append("K2(");
                            break;
                        }
                        case 16: {
                            stringBuffer.append("BLWMN(");
                            break;
                        }
                        case 17: {
                            stringBuffer.append("OCHIAI(");
                            break;
                        }
                        case 18: {
                            stringBuffer.append("RT(");
                            break;
                        }
                        case 19: {
                            stringBuffer.append("RR(");
                            break;
                        }
                        case 20: {
                            stringBuffer.append("SS1(");
                            break;
                        }
                        case 21: {
                            stringBuffer.append("SS2(");
                            break;
                        }
                        case 22: {
                            stringBuffer.append("SS3(");
                            break;
                        }
                        case 23: {
                            stringBuffer.append("SS4(");
                            break;
                        }
                        case 24: {
                            stringBuffer.append("SS5(");
                            break;
                        }
                        case 25: {
                            stringBuffer.append("Y(");
                            break;
                        }
                        case 26: {
                            stringBuffer.append("Q(");
                        }
                    }
                    dialogDataModel.getInteger("METHOD_BINARY_COMBO_KEY");
                    stringBuffer.append(dialogDataModel.getString("METHOD_PRESENT_EDIT") + ",");
                    stringBuffer.append(dialogDataModel.getString("METHOD_ABSENT_EDIT") + ")");
                }
            }
        } else {
            stringBuffer.append("SEUCLID");
        }
        return stringBuffer.toString();
    }

    private void generateIdString() {
        if (this.mLabelCasesList.getModel().getSize() > 0 && this.mClusterCasesRadio.isSelected()) {
            this.mBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("ID", this.mLabelCasesList.getVariablesStringList(), false));
        }
    }

    private void generatePlotString(DialogDataModel dialogDataModel) {
        this.mBuffer.append("\n" + SyntaxUtil.getSubCommand("/PLOT"));
        if (this.mDispPlotsCheck.isSelected()) {
            Boolean bl = dialogDataModel.getBoolean("IDS_DENDROGRAM_CHECK");
            if (bl != null && bl.booleanValue()) {
                this.mBuffer.append(" DENDROGRAM");
                bl = dialogDataModel.getBoolean("IDS_HIER_CLUS_PLOTS_NONE");
                if (!bl.booleanValue()) {
                    bl = dialogDataModel.getBoolean("IDS_HORI_ORIE_RADIO");
                    if (bl != null && bl.booleanValue()) {
                        this.mBuffer.append(" HICICLE");
                    } else {
                        this.mBuffer.append(" VICICLE");
                    }
                    bl = dialogDataModel.getBoolean("IDS_RANGE_CLUSTER_RADIO");
                    if (bl != null && bl.booleanValue()) {
                        this.mBuffer.append("(" + dialogDataModel.getString("IDS_START_CLUSTER_EDIT") + "," + dialogDataModel.getString("IDS_STOP_CLUSTER_EDIT") + "," + dialogDataModel.getString("IDS_STEPBY_CLUSTER_EDIT") + ")");
                    }
                }
            } else if (bl == null) {
                this.mBuffer.append(" VICICLE");
            } else if (bl != null && !bl.booleanValue() && (bl = dialogDataModel.getBoolean("IDS_HIER_CLUS_PLOTS_NONE")) != null && !bl.booleanValue()) {
                bl = dialogDataModel.getBoolean("IDS_HORI_ORIE_RADIO");
                if (bl != null && bl.booleanValue()) {
                    this.mBuffer.append(" HICICLE");
                } else {
                    this.mBuffer.append(" VICICLE");
                }
                bl = dialogDataModel.getBoolean("IDS_RANGE_CLUSTER_RADIO");
                if (bl != null && bl.booleanValue()) {
                    this.mBuffer.append("(" + dialogDataModel.getString("IDS_START_CLUSTER_EDIT") + "," + dialogDataModel.getString("IDS_STOP_CLUSTER_EDIT") + "," + dialogDataModel.getString("IDS_STEPBY_CLUSTER_EDIT") + ")");
                }
            }
        } else {
            this.mBuffer.append(" NONE");
        }
    }

    private void generatePrintString(DialogDataModel dialogDataModel) {
        this.mBuffer.append("\n" + SyntaxUtil.getSubCommand("/PRINT"));
        if (this.mDispStatsCheck.isSelected()) {
            Boolean bl = dialogDataModel.getBoolean("IDS_AGGL_SCHEDULE_CHECK");
            if (bl != null) {
                bl = dialogDataModel.getBoolean("IDS_HIER_CLUS_STATS_NONE");
                if (bl.booleanValue() && !dialogDataModel.getBoolean("IDS_AGGL_SCHEDULE_CHECK").booleanValue()) {
                    this.mBuffer.append(" NONE");
                } else if (bl.booleanValue() && dialogDataModel.getBoolean("IDS_AGGL_SCHEDULE_CHECK").booleanValue()) {
                    this.mBuffer.append(" SCHEDULE");
                } else {
                    bl = dialogDataModel.getBoolean("IDS_AGGL_SCHEDULE_CHECK");
                    if (bl == null || bl.booleanValue()) {
                        this.mBuffer.append(" SCHEDULE");
                    }
                    this.mBuffer.append(" CLUSTER(");
                    if (dialogDataModel.getBoolean("IDS_SINGLE_SOL_STATS_RADIO").booleanValue()) {
                        this.mBuffer.append(dialogDataModel.getString("IDS_STAT_NUM_CLUS_EDIT"));
                    } else {
                        this.mBuffer.append(dialogDataModel.getString("IDS_STAT_MIN_CLUS_EDIT") + "," + dialogDataModel.getString("IDS_STAT_MAX_CLUS_EDIT"));
                    }
                    this.mBuffer.append(")");
                }
            } else {
                this.mBuffer.append(" SCHEDULE");
            }
            bl = dialogDataModel.getBoolean("IDS_PROX_MATRIX_CHECK");
            if (bl != null && bl.booleanValue()) {
                this.mBuffer.append("\n" + SyntaxUtil.getSingleParameterSubCommand("PRINT", "DISTANCE", false));
            }
        } else {
            this.mBuffer.append(" NONE");
        }
    }

    private void generateSaveString(DialogDataModel dialogDataModel) {
        Boolean bl = dialogDataModel.getBoolean("IDS_SAVE_HIER_CLUS_NONE");
        if (bl != null && !bl.booleanValue() && (bl = dialogDataModel.getBoolean("IDS_SAVE_SINGLE_SOL_RADIO")) != null) {
            this.mBuffer.append("\n" + SyntaxUtil.getSubCommand("/SAVE CLUSTER("));
            if (bl != null && bl.booleanValue()) {
                this.mBuffer.append(dialogDataModel.getString("IDS_SAVE_NUM_CLUS_EDIT"));
            } else {
                this.mBuffer.append(dialogDataModel.getString("IDS_SAVE_MIN_CLUS_EDIT") + "," + dialogDataModel.getString("IDS_SAVE_MAX_CLUS_EDIT"));
            }
            this.mBuffer.append(")");
        }
    }

    private void checkAllOutputOff() {
        DialogDataModel dialogDataModel;
        Boolean bl;
        if (!(this.mDispStatsCheck.isSelected() || this.mDispPlotsCheck.isSelected() || (bl = (dialogDataModel = this.getDialogDataModel()).getBoolean("IDS_SAVE_HIER_CLUS_NONE")) != null && !bl.booleanValue())) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_HIER_ALLOUTPUT_OFF_WARNING"), VersionInfo.getAppVersionString());
        }
    }

    private String getOutfileLocation() {
        UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
        return utilityProxy.getServerTemporaryPath();
    }
}

