/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster.HierarchicalClusterDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class HierClusterStatistics
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    static final String IDS_STAT_AGGL_SCH_KEY = "IDS_AGGL_SCHEDULE_CHECK";
    static final String IDS_STAT_PROX_MAT_KEY = "IDS_PROX_MATRIX_CHECK";
    static final String IDS_STAT_NONE_SOL_KEY = "IDS_HIER_CLUS_STATS_NONE";
    static final String IDS_STAT_SINGLE_SOL_KEY = "IDS_SINGLE_SOL_STATS_RADIO";
    static final String IDS_STAT_RANGE_SOL_KEY = "IDS_RANGE_SOL_STATS_RADIO";
    static final String IDS_STAT_NUM_CLUS_KEY = "IDS_STAT_NUM_CLUS_EDIT";
    static final String IDS_STAT_MAX_CLUS_KEY = "IDS_STAT_MAX_CLUS_EDIT";
    static final String IDS_STAT_MIN_CLUS_KEY = "IDS_STAT_MIN_CLUS_EDIT";
    private JCheckBox mAgglScheduleCheck;
    private JCheckBox mProxMatrixCheck;
    private JRadioButton mNoneSolRadio;
    private JRadioButton mSingleSolRadio;
    private JRadioButton mRangeSolRadio;
    private IntTextField mNoOfClusterEdit;
    private IntTextField mMaxClusterEdit;
    private IntTextField mMinClusterEdit;
    private JLabel mNoOfClusterLabel;
    private JLabel mMaxClusterLabel;
    private JLabel mMinClusterLabel;
    private SpssButtonGroup mClusterMemGroup;

    public HierClusterStatistics(HierarchicalClusterDlg hierarchicalClusterDlg) {
        super(hierarchicalClusterDlg, hierarchicalClusterDlg.getResString("IDS_HIER_CLUSTER_STAT_TITLE"), true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableButtons();
        this.enableEditBoxes();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public boolean continuePressed() {
        int n;
        if (this.mSingleSolRadio.isSelected() && (n = Integer.parseInt(this.mNoOfClusterEdit.getText())) < 2) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OUTOF_RANGE_WARNING"), VersionInfo.getAppVersionString());
            this.mNoOfClusterEdit.requestFocus();
            this.mNoOfClusterEdit.selectAll();
            return false;
        }
        if (this.mRangeSolRadio.isSelected()) {
            n = Integer.parseInt(this.mMaxClusterEdit.getText());
            int n2 = Integer.parseInt(this.mMinClusterEdit.getText());
            if (n2 < 2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OUTOF_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mMinClusterEdit.requestFocus();
                this.mMinClusterEdit.selectAll();
                return false;
            }
            if (n <= n2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_INVALID_CLUS_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mMinClusterEdit.requestFocus();
                this.mMinClusterEdit.selectAll();
                return false;
            }
            if (n < 2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OUTOF_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mMaxClusterEdit.requestFocus();
                this.mMaxClusterEdit.selectAll();
                return false;
            }
        }
        return super.continuePressed();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_clus_sta";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.enableEditBoxes();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupClusterMemPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, 0, DialogUtil.getStandardControlInsets().bottom, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mAgglScheduleCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.top = 0;
        insets.bottom = n;
        gridBagConstraints.fill = 0;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mProxMatrixCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_STAT_AGGL_SCH_KEY);
        this.mAgglScheduleCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_STAT_PROX_MAT_KEY);
        this.mProxMatrixCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAgglScheduleCheck);
        spssButtonGroup.add(this.mProxMatrixCheck);
        this.mClusterMemGroup = new SpssButtonGroup();
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_STAT_NONE_SOL_KEY);
        this.mNoneSolRadio = new JRadioButton(toggleButtonAction);
        this.mClusterMemGroup.add(this.mNoneSolRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_STAT_SINGLE_SOL_KEY);
        this.mSingleSolRadio = new JRadioButton(toggleButtonAction);
        this.mClusterMemGroup.add(this.mSingleSolRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_STAT_RANGE_SOL_KEY);
        this.mRangeSolRadio = new JRadioButton(toggleButtonAction);
        this.mNoneSolRadio.addItemListener(this);
        this.mRangeSolRadio.addItemListener(this);
        this.mSingleSolRadio.addItemListener(this);
        this.mProxMatrixCheck.addItemListener(this);
        this.mAgglScheduleCheck.addItemListener(this);
        this.mNoOfClusterEdit = new IntTextField();
        this.mNoOfClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mNoOfClusterEdit.setAction((Action)new TextFieldAction(this.mParentDlg, IDS_STAT_NUM_CLUS_KEY));
        this.mClusterMemGroup.add(this.mRangeSolRadio);
        this.mNoOfClusterEdit.getDocument().addDocumentListener(this);
        this.mMaxClusterEdit = new IntTextField();
        this.mMaxClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mMaxClusterEdit.setAction((Action)new TextFieldAction(this.mParentDlg, IDS_STAT_MAX_CLUS_KEY));
        this.mMaxClusterEdit.getDocument().addDocumentListener(this);
        this.mMinClusterEdit = new IntTextField();
        this.mMinClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mMinClusterEdit.setAction((Action)new TextFieldAction(this.mParentDlg, IDS_STAT_MIN_CLUS_KEY));
        this.mMinClusterEdit.getDocument().addDocumentListener(this);
        this.mNoOfClusterLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_NUM_CLUS_LABEL");
        this.mNoOfClusterLabel.setLabelFor((Component)this.mNoOfClusterEdit);
        this.mMinClusterLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MIN_CLUS_LABEL");
        this.mMinClusterLabel.setLabelFor((Component)this.mMinClusterEdit);
        this.mMaxClusterLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MAX_CLUS_LABEL");
        this.mMaxClusterLabel.setLabelFor((Component)this.mMaxClusterEdit);
        this.enableEditBoxes();
    }

    private void setDefaults() {
        this.mAgglScheduleCheck.setSelected(true);
        this.mProxMatrixCheck.setSelected(false);
        this.mNoneSolRadio.setSelected(true);
        this.mNoOfClusterEdit.setColumns(4);
        this.mMaxClusterEdit.setColumns(4);
        this.mMinClusterEdit.setColumns(4);
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mAgglScheduleCheck);
        vector.add(this.mProxMatrixCheck);
        vector.add(this.mClusterMemGroup);
        vector.add(this.mNoOfClusterEdit);
        vector.add(this.mMinClusterEdit);
        vector.add(this.mMaxClusterEdit);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupClusterMemPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CLUSTER_MEM_PANEL"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n, n, insets.bottom, n);
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n3 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNoneSolRadio, gridBagConstraints, 0, 0, 2, 1, n3, insets2);
        insets2.top = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSingleSolRadio, gridBagConstraints, 0, 1, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.left = n2 * 2;
        DialogUtil.addUsingGBL(jPanel, this.mNoOfClusterLabel, gridBagConstraints, 0, 2, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.left = n2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNoOfClusterEdit, gridBagConstraints, 1, 2, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.left = n;
        DialogUtil.addUsingGBL(jPanel, this.mRangeSolRadio, gridBagConstraints, 0, 3, 2, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.left = n2 * 2;
        insets2.bottom = n2;
        DialogUtil.addUsingGBL(jPanel, this.mMinClusterLabel, gridBagConstraints, 0, 4, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.left = n2;
        insets2.bottom = insets.bottom;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinClusterEdit, gridBagConstraints, 1, 4, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.left = n2 * 2;
        insets2.bottom = n2;
        DialogUtil.addUsingGBL(jPanel, this.mMaxClusterLabel, gridBagConstraints, 0, 5, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.left = n2;
        insets2.bottom = insets.bottom;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxClusterEdit, gridBagConstraints, 1, 5, 1, 1, n3, insets2);
        return jPanel;
    }

    private void enableButtons() {
        if (this.mNoneSolRadio.isSelected()) {
            this.enableContinue(this.mAgglScheduleCheck.isSelected() || this.mProxMatrixCheck.isSelected());
        } else if (this.mSingleSolRadio.isSelected()) {
            this.enableContinue(this.mNoOfClusterEdit.getText().length() > 0);
        } else {
            this.enableContinue(this.mMaxClusterEdit.getText().length() > 0 && this.mMinClusterEdit.getText().length() > 0);
        }
    }

    private void enableEditBoxes() {
        boolean bl = this.mSingleSolRadio.isSelected();
        this.mNoOfClusterEdit.setEnabled(bl);
        this.mNoOfClusterEdit.setOpaque(bl);
        this.mNoOfClusterLabel.setEnabled(bl);
        bl = this.mRangeSolRadio.isSelected();
        this.mMaxClusterEdit.setEnabled(bl);
        this.mMaxClusterEdit.setOpaque(bl);
        this.mMaxClusterLabel.setEnabled(bl);
        this.mMinClusterEdit.setEnabled(bl);
        this.mMinClusterEdit.setOpaque(bl);
        this.mMinClusterLabel.setEnabled(bl);
    }
}

