/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster.HierarchicalClusterDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class HierClusterSave
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    static final String IDS_SAVE_NONE_SOL_KEY = "IDS_SAVE_HIER_CLUS_NONE";
    static final String IDS_SAVE_SINGLE_SOL_KEY = "IDS_SAVE_SINGLE_SOL_RADIO";
    static final String IDS_SAVE_RANGE_SOL_KEY = "IDS_SAVE_RANGE_SOL_RADIO";
    static final String IDS_SAVE_NUM_CLUS_KEY = "IDS_SAVE_NUM_CLUS_EDIT";
    static final String IDS_SAVE_MAX_CLUS_KEY = "IDS_SAVE_MAX_CLUS_EDIT";
    static final String IDS_SAVE_MIN_CLUS_KEY = "IDS_SAVE_MIN_CLUS_EDIT";
    private JRadioButton mNoneSolRadio;
    private JRadioButton mSingleSolRadio;
    private JRadioButton mRangeSolRadio;
    private IntTextField mNoOfClusterEdit;
    private IntTextField mMaxClusterEdit;
    private IntTextField mMinClusterEdit;
    private JLabel mNoOfClusterLabel;
    private JLabel mMaxClusterLabel;
    private JLabel mMinClusterLabel;
    private SpssButtonGroup mClusterMemGroup;

    public HierClusterSave(HierarchicalClusterDlg hierarchicalClusterDlg) {
        super(hierarchicalClusterDlg, hierarchicalClusterDlg.getResString("IDS_HIER_CLUSTER_SAVE_TITLE"), true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public boolean continuePressed() {
        if (this.mSingleSolRadio.isSelected()) {
            int n = Integer.parseInt(this.mNoOfClusterEdit.getText());
            if (n < 2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OUTOF_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mNoOfClusterEdit.requestFocus();
                this.mNoOfClusterEdit.selectAll();
                return false;
            }
        } else if (this.mRangeSolRadio.isSelected()) {
            int n = Integer.parseInt(this.mMaxClusterEdit.getText());
            int n2 = Integer.parseInt(this.mMinClusterEdit.getText());
            if (n2 < 2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OUTOF_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mMinClusterEdit.requestFocus();
                this.mMinClusterEdit.selectAll();
                return false;
            }
            if (n <= n2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_INVALID_CLUS_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mMinClusterEdit.requestFocus();
                this.mMinClusterEdit.selectAll();
                return false;
            }
            if (n < 2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OUTOF_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mMaxClusterEdit.requestFocus();
                this.mMaxClusterEdit.selectAll();
                return false;
            }
        }
        return super.continuePressed();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_clus_sav";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableButtons();
        this.enableEditBoxes();
        this.checkAllOutputOff();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.enableEditBoxes();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupClusterMemPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void initVars() {
        this.mClusterMemGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_SAVE_NONE_SOL_KEY);
        this.mNoneSolRadio = new JRadioButton(toggleButtonAction);
        this.mClusterMemGroup.add(this.mNoneSolRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_SAVE_SINGLE_SOL_KEY);
        this.mSingleSolRadio = new JRadioButton(toggleButtonAction);
        this.mClusterMemGroup.add(this.mSingleSolRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_SAVE_RANGE_SOL_KEY);
        this.mRangeSolRadio = new JRadioButton(toggleButtonAction);
        this.mClusterMemGroup.add(this.mRangeSolRadio);
        this.mNoneSolRadio.addItemListener(this);
        this.mSingleSolRadio.addItemListener(this);
        this.mRangeSolRadio.addItemListener(this);
        this.mNoOfClusterEdit = new IntTextField();
        this.mNoOfClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mNoOfClusterEdit.setAction((Action)new TextFieldAction(this.mParentDlg, IDS_SAVE_NUM_CLUS_KEY));
        this.mNoOfClusterEdit.getDocument().addDocumentListener(this);
        this.mMaxClusterEdit = new IntTextField();
        this.mMaxClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mMaxClusterEdit.setAction((Action)new TextFieldAction(this.mParentDlg, IDS_SAVE_MAX_CLUS_KEY));
        this.mMaxClusterEdit.getDocument().addDocumentListener(this);
        this.mMinClusterEdit = new IntTextField();
        this.mMinClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mMinClusterEdit.setAction((Action)new TextFieldAction(this.mParentDlg, IDS_SAVE_MIN_CLUS_KEY));
        this.mMinClusterEdit.getDocument().addDocumentListener(this);
        this.mNoOfClusterLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_NUM_CLUS_LABEL");
        this.mNoOfClusterLabel.setLabelFor((Component)this.mNoOfClusterEdit);
        this.mMinClusterLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MIN_CLUS_LABEL");
        this.mMinClusterLabel.setLabelFor((Component)this.mMinClusterEdit);
        this.mMaxClusterLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MAX_CLUS_LABEL");
        this.mMaxClusterLabel.setLabelFor((Component)this.mMaxClusterEdit);
    }

    private void setDefaults() {
        this.mNoneSolRadio.setSelected(true);
        this.mNoOfClusterEdit.setColumns(4);
        this.mMaxClusterEdit.setColumns(4);
        this.mMinClusterEdit.setColumns(4);
        this.enableEditBoxes();
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mClusterMemGroup);
        vector.add(this.mNoOfClusterEdit);
        vector.add(this.mMinClusterEdit);
        vector.add(this.mMaxClusterEdit);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupClusterMemPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CLUSTER_MEM_PANEL"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNoneSolRadio, gridBagConstraints, 0, 0, 2, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSingleSolRadio, gridBagConstraints, 0, 1, 2, 1, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        Insets insets = new Insets(0, n * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNoOfClusterLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        insets = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNoOfClusterEdit, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRangeSolRadio, gridBagConstraints, 0, 3, 2, 1, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        insets = new Insets(0, n * 2, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMinClusterLabel, gridBagConstraints, 0, 4, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        insets = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinClusterEdit, gridBagConstraints, 1, 4, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        insets = new Insets(0, n * 2, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMaxClusterLabel, gridBagConstraints, 0, 5, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        n2 = 23;
        insets = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxClusterEdit, gridBagConstraints, 1, 5, 1, 1, n2, insets);
        return jPanel;
    }

    private void enableButtons() {
        if (this.mSingleSolRadio.isSelected()) {
            this.enableContinue(this.mNoOfClusterEdit.getText().length() > 0);
        } else if (this.mRangeSolRadio.isSelected()) {
            this.enableContinue(this.mMaxClusterEdit.getText().length() > 0 && this.mMinClusterEdit.getText().length() > 0);
        }
    }

    private void enableEditBoxes() {
        boolean bl = this.mSingleSolRadio.isSelected();
        this.mNoOfClusterEdit.setEnabled(bl);
        this.mNoOfClusterEdit.setOpaque(bl);
        this.mNoOfClusterLabel.setEnabled(bl);
        bl = this.mRangeSolRadio.isSelected();
        this.mMaxClusterEdit.setEnabled(bl);
        this.mMaxClusterEdit.setOpaque(bl);
        this.mMaxClusterLabel.setEnabled(bl);
        this.mMinClusterEdit.setEnabled(bl);
        this.mMinClusterEdit.setOpaque(bl);
        this.mMinClusterLabel.setEnabled(bl);
    }

    private void checkAllOutputOff() {
        DialogDataModel dialogDataModel;
        if (this.mNoneSolRadio.isSelected() && !(dialogDataModel = this.mParentDlg.getDialogDataModel()).getBoolean("IDS_DISP_STATS_CHECK").booleanValue() && !dialogDataModel.getBoolean("IDS_DISP_PLOTS_CHECK").booleanValue()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_HIER_ALLOUTPUT_OFF_WARNING"), VersionInfo.getAppVersionString());
        }
    }
}

