/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.classify.hier_cluster.HierarchicalClusterDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class HierClusterPlots
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    static final String IDS_DENDROGRAM_KEY = "IDS_DENDROGRAM_CHECK";
    static final String IDS_ALL_CLUS_KEY = "IDS_ALL_CLUSTER_RADIO";
    static final String IDS_RANGE_CLUS_KEY = "IDS_RANGE_CLUSTER_RADIO";
    static final String IDS_NONE_CLUS_KEY = "IDS_HIER_CLUS_PLOTS_NONE";
    static final String IDS_START_CLUS_KEY = "IDS_START_CLUSTER_EDIT";
    static final String IDS_STOP_CLUS_KEY = "IDS_STOP_CLUSTER_EDIT";
    static final String IDS_STEPBY_CLUS_KEY = "IDS_STEPBY_CLUSTER_EDIT";
    static final String IDS_VERT_ORIE_KEY = "IDS_VERT_ORIE_RADIO";
    static final String IDS_HORI_ORIE_KEY = "IDS_HORI_ORIE_RADIO";
    private static final String START_BY_DEFAULT_VALUE = "1";
    private JCheckBox mDendrogramsCheck;
    private JRadioButton mAllClustersRadio;
    private JRadioButton mRangeClustersRadio;
    private JRadioButton mNoneClustersRadio;
    private IntTextField mStartClusterEdit;
    private IntTextField mStopClusterEdit;
    private IntTextField mStepByClusterEdit;
    private JLabel mStartClusterLabel;
    private JLabel mStopClusterLabel;
    private JLabel mStepByClusterLabel;
    private JRadioButton mVertOrienRadio;
    private JRadioButton mHoriOrienRadio;
    private SpssButtonGroup mIcicleGroup;
    private SpssButtonGroup mOrientationGroup;

    public HierClusterPlots(HierarchicalClusterDlg hierarchicalClusterDlg) {
        super(hierarchicalClusterDlg, hierarchicalClusterDlg.getResString("IDS_HIER_CLUSTER_PLOTS_TITLE"), true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public boolean continuePressed() {
        if (this.mRangeClustersRadio.isSelected()) {
            int n = Integer.parseInt(this.mStartClusterEdit.getText());
            int n2 = Integer.parseInt(this.mStepByClusterEdit.getText());
            int n3 = Integer.parseInt(this.mStopClusterEdit.getText());
            if (n == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OUTOF_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mStartClusterEdit.requestFocus();
                this.mStartClusterEdit.selectAll();
                return false;
            }
            if (n > n3) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_INVALID_CLUS_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mStartClusterEdit.requestFocus();
                this.mStartClusterEdit.selectAll();
                return false;
            }
            if (n3 == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OUTOF_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mStopClusterEdit.requestFocus();
                this.mStopClusterEdit.selectAll();
                return false;
            }
            if (n2 > Integer.parseInt(this.mStopClusterEdit.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_INVALID_CLUS_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mStepByClusterEdit.requestFocus();
                this.mStepByClusterEdit.selectAll();
                return false;
            }
            if (n2 == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OUTOF_RANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mStepByClusterEdit.requestFocus();
                this.mStepByClusterEdit.selectAll();
                return false;
            }
        }
        return super.continuePressed();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_clus_plo";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableButtons();
        this.enableEditBoxes();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupIciclePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDendrogramsCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.enableEditBoxes();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_DENDROGRAM_KEY);
        this.mDendrogramsCheck = new JCheckBox(toggleButtonAction);
        this.mDendrogramsCheck.setSelected(true);
        this.mIcicleGroup = new SpssButtonGroup();
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_ALL_CLUS_KEY);
        this.mAllClustersRadio = new JRadioButton(toggleButtonAction);
        this.mIcicleGroup.add(this.mAllClustersRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_RANGE_CLUS_KEY);
        this.mRangeClustersRadio = new JRadioButton(toggleButtonAction);
        this.mIcicleGroup.add(this.mRangeClustersRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_NONE_CLUS_KEY);
        this.mNoneClustersRadio = new JRadioButton(toggleButtonAction);
        this.mIcicleGroup.add(this.mNoneClustersRadio);
        this.mAllClustersRadio.addItemListener(this);
        this.mRangeClustersRadio.addItemListener(this);
        this.mNoneClustersRadio.addItemListener(this);
        this.mDendrogramsCheck.addItemListener(this);
        this.mStartClusterEdit = new IntTextField();
        this.mStartClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mStartClusterEdit.setAction((Action)new TextFieldAction(this.mParentDlg, IDS_START_CLUS_KEY));
        this.mStartClusterEdit.getDocument().addDocumentListener(this);
        this.mStopClusterEdit = new IntTextField();
        this.mStopClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mStopClusterEdit.setAction((Action)new TextFieldAction(this.mParentDlg, IDS_STOP_CLUS_KEY));
        this.mStopClusterEdit.getDocument().addDocumentListener(this);
        this.mStepByClusterEdit = new IntTextField();
        this.mStepByClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mStepByClusterEdit.setAction((Action)new TextFieldAction(this.mParentDlg, IDS_STEPBY_CLUS_KEY));
        this.mStepByClusterEdit.getDocument().addDocumentListener(this);
        this.mStartClusterLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_START_CLUS_LABEL");
        this.mStartClusterEdit.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mStartClusterLabel.setLabelFor((Component)this.mStartClusterEdit);
        this.mStopClusterLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_STOP_CLUS_LABEL");
        this.mStopClusterLabel.setLabelFor((Component)this.mStopClusterEdit);
        this.mStepByClusterLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_STEPBY_CLUS_LABEL");
        this.mStepByClusterLabel.setLabelFor((Component)this.mStepByClusterEdit);
        this.mOrientationGroup = new SpssButtonGroup();
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_VERT_ORIE_KEY);
        this.mVertOrienRadio = new JRadioButton(toggleButtonAction);
        this.mOrientationGroup.add(this.mVertOrienRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, IDS_HORI_ORIE_KEY);
        this.mHoriOrienRadio = new JRadioButton(toggleButtonAction);
        this.mOrientationGroup.add(this.mHoriOrienRadio);
    }

    private void setDefaults() {
        this.mAllClustersRadio.setSelected(true);
        this.mDendrogramsCheck.setSelected(false);
        this.mStartClusterEdit.setColumns(4);
        this.mStopClusterEdit.setColumns(4);
        this.mStepByClusterEdit.setColumns(4);
        this.mVertOrienRadio.setSelected(true);
        this.mStartClusterEdit.setText(START_BY_DEFAULT_VALUE);
        this.mStepByClusterEdit.setText(START_BY_DEFAULT_VALUE);
        this.enableEditBoxes();
    }

    private JPanel setupIciclePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(true);
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_ICICLE_PANEL"));
        jPanel.setBorder(titledBorder);
        titledBorder.getBorderInsets(jPanel, new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = 3;
        Insets insets = new Insets(n2, n2, DialogUtil.getStandardControlInsets().bottom, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n4 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mAllClustersRadio, gridBagConstraints, 0, 0, 2, 1, n4, insets);
        insets.top = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRangeClustersRadio, gridBagConstraints, 0, 1, 2, 1, n4, insets);
        gridBagConstraints.weightx = 0.0;
        insets.left = n * 2;
        insets.top = DialogUtil.getStandardControlInsets().top;
        DialogUtil.addUsingGBL(jPanel, this.mStartClusterLabel, gridBagConstraints, 0, 2, 1, 1, n4, insets);
        gridBagConstraints.weightx = 1.0;
        insets.left = n;
        insets.bottom = n3;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStartClusterEdit, gridBagConstraints, 1, 2, 1, 1, n4, insets);
        gridBagConstraints.weightx = 0.0;
        insets.left = n * 2;
        DialogUtil.addUsingGBL(jPanel, this.mStopClusterLabel, gridBagConstraints, 0, 3, 1, 1, n4, insets);
        gridBagConstraints.weightx = 1.0;
        insets.left = n;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStopClusterEdit, gridBagConstraints, 1, 3, 1, 1, n4, insets);
        gridBagConstraints.weightx = 0.0;
        insets.left = n * 2;
        DialogUtil.addUsingGBL(jPanel, this.mStepByClusterLabel, gridBagConstraints, 0, 4, 1, 1, n4, insets);
        gridBagConstraints.weightx = 1.0;
        insets.left = n;
        insets.bottom = DialogUtil.getStandardControlInsets().bottom;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStepByClusterEdit, gridBagConstraints, 1, 4, 1, 1, n4, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.left = n2;
        insets.bottom = n2;
        DialogUtil.addUsingGBL(jPanel, this.mNoneClustersRadio, gridBagConstraints, 0, 5, 2, 1, n4, insets);
        insets.top = 0;
        insets.left = -5;
        insets.bottom = -5;
        insets.right = -5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupOrientationPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 6, 2, 1, n4, insets);
        return jPanel;
    }

    private JPanel setupOrientationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_ORIENTATION_MEM_PANEL"));
        jPanel.setBorder(titledBorder);
        titledBorder.getBorderInsets(jPanel, new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, 0, DialogUtil.getStandardControlInsets().bottom, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mVertOrienRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        insets.top = 0;
        DialogUtil.addUsingGBL(jPanel, this.mHoriOrienRadio, gridBagConstraints, 0, 1, 2, 1, n2, insets);
        return jPanel;
    }

    private void enableButtons() {
        if (this.mNoneClustersRadio.isSelected()) {
            this.enableContinue(this.mDendrogramsCheck.isSelected());
        } else if (this.mRangeClustersRadio.isSelected()) {
            this.enableContinue(this.mStartClusterEdit.getText().length() > 0 && this.mStopClusterEdit.getText().length() > 0 && this.mStepByClusterEdit.getText().length() > 0);
        } else {
            this.enableContinue(true);
        }
    }

    private void enableEditBoxes() {
        boolean bl = this.mRangeClustersRadio.isSelected();
        this.mStartClusterLabel.setEnabled(bl);
        this.mStartClusterEdit.setEnabled(bl);
        this.mStartClusterEdit.setOpaque(bl);
        this.mStopClusterLabel.setEnabled(bl);
        this.mStopClusterEdit.setEnabled(bl);
        this.mStopClusterEdit.setOpaque(bl);
        this.mStepByClusterLabel.setEnabled(bl);
        this.mStepByClusterEdit.setEnabled(bl);
        this.mStepByClusterEdit.setOpaque(bl);
        bl = !this.mNoneClustersRadio.isSelected();
        this.mVertOrienRadio.setEnabled(bl);
        this.mHoriOrienRadio.setEnabled(bl);
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mDendrogramsCheck);
        vector.add(this.mIcicleGroup);
        vector.add(this.mStartClusterEdit);
        vector.add(this.mStopClusterEdit);
        vector.add(this.mStepByClusterEdit);
        vector.add(this.mOrientationGroup);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

