/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.discriminant;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DiscriminantAnalysisStepwiseMethod
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    public static final String RAOS_KEY = "IDS_STEPWISE_ROAS";
    public static final String FENTRY_KEY = "IDS_STEPWISE_FENTRY";
    public static final String FREMOVED_KEY = "IDS_STEPWISE_FREMOVAL";
    public static final String PENTRY_KEY = "IDS_STEPWISE_PENTRY";
    public static final String PREMOVAL_KEY = "IDS_STEPWISE_PREMOVAL";
    private JRadioButton mRdoWilks;
    private JRadioButton mRdoUnexplained;
    private JRadioButton mRdoMahalanobis;
    private JRadioButton mRdoFRatio;
    private JRadioButton mRdoRaos;
    private JRadioButton mRdoFValue;
    private JRadioButton mRdoFProbability;
    private JCheckBox mChkSummary;
    private JCheckBox mChkPairwise;
    private FloatTextField mTxtVEnter;
    private FloatTextField mTxtFEntry;
    private FloatTextField mTxtFRemoval;
    private FloatTextField mTxtPEntry;
    private FloatTextField mTxtPRemoval;
    private JLabel mLblVEnter;
    private JLabel mLblEntry;
    private JLabel mLblRemoval;
    private JLabel mLblEntryProb;
    private JLabel mLblRemovalProb;
    private SpssButtonGroup mGrpMethod;
    private SpssButtonGroup mGrpCriteria;

    public DiscriminantAnalysisStepwiseMethod(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_DISC_MET";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableEntryRemoval();
        this.enableVToEnter();
        this.enableContinue();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mTxtVEnter)) {
            this.mTxtVEnter.selectAll();
        }
        if (focusEvent.getSource().equals(this.mTxtFEntry)) {
            this.mTxtFEntry.selectAll();
        }
        if (focusEvent.getSource().equals(this.mTxtFRemoval)) {
            this.mTxtFRemoval.selectAll();
        }
        if (focusEvent.getSource().equals(this.mTxtPEntry)) {
            this.mTxtPEntry.selectAll();
        }
        if (focusEvent.getSource().equals(this.mTxtPRemoval)) {
            this.mTxtPRemoval.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mTxtVEnter)) {
            this.mTxtVEnter.select(0, 0);
        }
        if (focusEvent.getSource().equals(this.mTxtFEntry)) {
            this.mTxtFEntry.select(0, 0);
        }
        if (focusEvent.getSource().equals(this.mTxtFRemoval)) {
            this.mTxtFRemoval.select(0, 0);
        }
        if (focusEvent.getSource().equals(this.mTxtPEntry)) {
            this.mTxtPEntry.select(0, 0);
        }
        if (focusEvent.getSource().equals(this.mTxtPRemoval)) {
            this.mTxtPRemoval.select(0, 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue();
    }

    @Override
    public boolean continuePressed() {
        double d;
        double d2;
        if (this.mRdoFValue.isSelected() && (d2 = Double.parseDouble(this.mTxtFEntry.getText())) <= (d = Double.parseDouble(this.mTxtFRemoval.getText()))) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DISCRIMINANT_DEFINE_RANGE_WARNING"), VersionInfo.getAppVersionString());
            this.mTxtFRemoval.requestFocus();
            this.mTxtFRemoval.selectAll();
            return false;
        }
        if (this.mRdoFProbability.isSelected() && (d2 = Double.parseDouble(this.mTxtPEntry.getText())) >= (d = Double.parseDouble(this.mTxtPRemoval.getText()))) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_DISCRIMINANT_DEFINE_RANGE_WARNING"), VersionInfo.getAppVersionString());
            this.mTxtPRemoval.requestFocus();
            this.mTxtPRemoval.selectAll();
            return false;
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mRdoWilks = new JRadioButton(new ToggleButtonAction(this, "IDS_DISCRIMINANT_STEPWISE_WILKS_RADIO"));
        this.mRdoUnexplained = new JRadioButton(new ToggleButtonAction(this, "IDS_DISCRIMINANT_STEPWISE_UNEXPLAINED_RADIO"));
        this.mRdoMahalanobis = new JRadioButton(new ToggleButtonAction(this, "IDS_DISCRIMINANT_STEPWISE_MAHALANOBIS_RADIO"));
        this.mRdoFRatio = new JRadioButton(new ToggleButtonAction(this, "IDS_DISCRIMINANT_STEPWISE_FRATIO_RADIO"));
        this.mRdoRaos = new JRadioButton(new ToggleButtonAction(this, "IDS_DISCRIMINANT_STEPWISE_RAOS_RADIO"));
        this.mRdoFValue = new JRadioButton(new ToggleButtonAction(this, "IDS_DISCRIMINANT_STEPWISE_FVALUE_RADIO"));
        this.mRdoFProbability = new JRadioButton(new ToggleButtonAction(this, "IDS_DISCRIMINANT_STEPWISE_USEFPROBABILITY_RADIO"));
        this.mChkSummary = new JCheckBox(new ToggleButtonAction(this, "IDS_DISCRIMINANT_STEPWISE_SUMMARY_CHECK"));
        this.mChkPairwise = new JCheckBox(new ToggleButtonAction(this, "IDS_DISCRIMINANT_STEPWISE_PAIRWISE_CHECK"));
        this.mLblVEnter = DialogUtil.createLabel(this, "IDS_DISCRIMINANT_STEPWISE_VTOENTER_LABEL");
        this.mLblEntry = DialogUtil.createLabel(this, "IDS_DISCRIMINANT_STEPWISE_ENTRY_LABEL");
        this.mLblRemoval = DialogUtil.createLabel(this, "IDS_DISCRIMINANT_STEPWISE_REMOVAL_LABEL");
        this.mLblEntryProb = DialogUtil.createLabel(this, "IDS_REG_BL_OPTIONS_ENTRY_LABEL");
        this.mLblRemovalProb = DialogUtil.createLabel(this, "IDS_DISCRIMINANT_STEPWISE_REMOVALF_LABEL");
        this.mTxtVEnter = new FloatTextField(-9999.0, 9999.0, 4);
        this.mTxtPEntry = new FloatTextField(0.0, 1.0, 3);
        this.mTxtPRemoval = new FloatTextField(0.0, 1.0, 3);
        this.mTxtFEntry = new FloatTextField(0.0, 99999.0, 4);
        this.mTxtFRemoval = new FloatTextField(0.0, 99999.0, 4);
        this.mTxtVEnter.setAction((Action)new TextFieldAction(this.mParentDlg, RAOS_KEY));
        this.mTxtFEntry.setAction((Action)new TextFieldAction(this.mParentDlg, FENTRY_KEY));
        this.mTxtFRemoval.setAction((Action)new TextFieldAction(this.mParentDlg, FREMOVED_KEY));
        this.mTxtPEntry.setAction((Action)new TextFieldAction(this.mParentDlg, PENTRY_KEY));
        this.mTxtPRemoval.setAction((Action)new TextFieldAction(this.mParentDlg, PREMOVAL_KEY));
        this.mRdoRaos.addItemListener(this);
        this.mRdoFProbability.addItemListener(this);
        this.mRdoFValue.addItemListener(this);
        this.mTxtVEnter.getDocument().addDocumentListener(this);
        this.mTxtPEntry.getDocument().addDocumentListener(this);
        this.mTxtPRemoval.getDocument().addDocumentListener(this);
        this.mTxtFEntry.getDocument().addDocumentListener(this);
        this.mTxtFRemoval.getDocument().addDocumentListener(this);
        this.mTxtFEntry.addFocusListener((FocusListener)this);
        this.mTxtFRemoval.addFocusListener((FocusListener)this);
        this.mTxtPEntry.addFocusListener((FocusListener)this);
        this.mTxtPRemoval.addFocusListener((FocusListener)this);
        this.mTxtVEnter.addFocusListener((FocusListener)this);
        this.mLblVEnter.setLabelFor((Component)this.mTxtVEnter);
        this.mLblEntry.setLabelFor((Component)this.mTxtFEntry);
        this.mLblRemoval.setLabelFor((Component)this.mTxtFRemoval);
        this.mLblEntryProb.setLabelFor((Component)this.mTxtPEntry);
        this.mLblRemovalProb.setLabelFor((Component)this.mTxtPRemoval);
    }

    private void setDefaults() {
        this.mTxtVEnter.setText("0");
        this.mTxtFEntry.setText("3.84");
        this.mTxtFRemoval.setText("2.71");
        this.mTxtPEntry.setText(".05");
        this.mTxtPRemoval.setText(".10");
        this.mTxtVEnter.setEnabled(false);
        this.mTxtPEntry.setEnabled(false);
        this.mTxtPRemoval.setEnabled(false);
        this.mLblVEnter.setEnabled(false);
        this.mLblEntryProb.setEnabled(false);
        this.mLblRemovalProb.setEnabled(false);
        this.mRdoWilks.setSelected(true);
        this.mRdoFValue.setSelected(true);
        this.mChkSummary.setSelected(true);
    }

    private void addComponents(JPanel jPanel) {
        JComponent[] jComponentArray = new JComponent[6];
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.left, insets.top, insets.right, insets.bottom);
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin() * 4;
        jComponentArray[0] = this.mRdoWilks;
        jComponentArray[1] = this.mRdoUnexplained;
        jComponentArray[2] = this.mRdoMahalanobis;
        jComponentArray[3] = this.mRdoFRatio;
        jComponentArray[4] = this.mRdoRaos;
        gridBagConstraints.fill = 1;
        int n3 = 24;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(0, n2, n, 0);
        DialogUtil.addUsingGBL(jPanel3, this.mLblVEnter, gridBagConstraints, 0, 0, 1, 1, n3, insets2);
        insets2.set(0, n, n, 0);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mTxtVEnter, gridBagConstraints, 1, 0, 1, 1, n3, insets2);
        jComponentArray[5] = jPanel3;
        jPanel2 = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_KMEANS_METHOD"), 6);
        this.mGrpMethod = DialogUtil.createButtonGroup(jPanel2);
        n3 = 23;
        insets2.set(0, 0, n, n);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n3, insets2);
        jPanel2 = PanelFactory.getEmptyPanel(this.getResString("IDS_DISPLAY_PANEL"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, insets.left * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel2, this.mChkSummary, gridBagConstraints, 0, 0, 1, 1, n3, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(insets.top, DialogUtil.getGroupBoxInnerMargin() * 10, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel2, this.mChkPairwise, gridBagConstraints, 1, 0, 1, 1, n3, insets2);
        gridBagConstraints.fill = 1;
        insets2.set(0, 0, n, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n3, insets2);
        DialogUtil.createButtonGroup(jPanel2);
        jPanel2 = new JPanel(new GridBagLayout());
        n3 = 23;
        DialogUtil.addUsingGBL(jPanel2, this.mRdoFValue, gridBagConstraints, 0, 0, 1, 1, n3, null);
        gridBagConstraints.fill = 1;
        jPanel3 = new JPanel(new GridBagLayout());
        n3 = 24;
        insets2.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, this.mLblEntry, gridBagConstraints, 0, 0, 1, 1, n3, insets2);
        insets2.set(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mTxtFEntry, gridBagConstraints, 1, 0, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel3, this.mLblRemoval, gridBagConstraints, 2, 0, 1, 1, n3, insets2);
        insets2.set(0, n2, 0, n);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mTxtFRemoval, gridBagConstraints, 3, 0, 1, 1, n3, insets2);
        n3 = 23;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 1, 1, 1, n3, null);
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mRdoFProbability, gridBagConstraints, 0, 2, 1, 1, n3, insets2);
        jPanel3 = new JPanel(new GridBagLayout());
        n3 = 24;
        insets2.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, this.mLblEntryProb, gridBagConstraints, 0, 0, 1, 1, n3, insets2);
        insets2.set(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mTxtPEntry, gridBagConstraints, 1, 0, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel3, this.mLblRemovalProb, gridBagConstraints, 2, 0, 1, 1, n3, insets2);
        insets2.set(0, n2, 0, n);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mTxtPRemoval, gridBagConstraints, 3, 0, 1, 1, n3, insets2);
        n3 = 23;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 3, 1, 1, n3, null);
        this.mGrpCriteria = DialogUtil.createButtonGroup(jPanel2);
        jComponentArray = new JComponent[]{jPanel2};
        jPanel2 = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_ALSCAL_CRITERIA"), 1);
        insets2.set(0, 0, n, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n3, insets2);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mGrpMethod);
        vector.add(this.mTxtVEnter);
        vector.add(this.mGrpCriteria);
        vector.add(this.mTxtFEntry);
        vector.add(this.mTxtFRemoval);
        vector.add(this.mTxtPEntry);
        vector.add(this.mTxtPRemoval);
        vector.add(this.mChkSummary);
        vector.add(this.mChkPairwise);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void enableVToEnter() {
        if (this.mRdoRaos.isSelected()) {
            this.mLblVEnter.setEnabled(true);
            this.mTxtVEnter.setEnabled(true);
            this.mTxtVEnter.setOpaque(true);
        } else {
            this.mLblVEnter.setEnabled(false);
            this.mTxtVEnter.setEnabled(false);
            this.mTxtVEnter.setOpaque(false);
        }
    }

    private void enableEntryRemoval() {
        if (this.mRdoFValue.isSelected()) {
            this.mLblEntry.setEnabled(true);
            this.mLblRemoval.setEnabled(true);
            this.mTxtFEntry.setEnabled(true);
            this.mTxtFRemoval.setEnabled(true);
            this.mLblEntryProb.setEnabled(false);
            this.mLblRemovalProb.setEnabled(false);
            this.mTxtPEntry.setEnabled(false);
            this.mTxtPRemoval.setEnabled(false);
            this.mTxtFEntry.setOpaque(true);
            this.mTxtFRemoval.setOpaque(true);
            this.mTxtPEntry.setOpaque(false);
            this.mTxtPRemoval.setOpaque(false);
        } else {
            this.mLblEntry.setEnabled(false);
            this.mLblRemoval.setEnabled(false);
            this.mTxtFEntry.setEnabled(false);
            this.mTxtFRemoval.setEnabled(false);
            this.mLblEntryProb.setEnabled(true);
            this.mLblRemovalProb.setEnabled(true);
            this.mTxtPEntry.setEnabled(true);
            this.mTxtPRemoval.setEnabled(true);
            this.mTxtFEntry.setOpaque(false);
            this.mTxtFRemoval.setOpaque(false);
            this.mTxtPEntry.setOpaque(true);
            this.mTxtPRemoval.setOpaque(true);
        }
    }

    private void enableContinue() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.mRdoRaos.isSelected()) {
            bl = !this.mTxtVEnter.getText().trim().equals("");
        }
        if (this.mRdoFValue.isSelected()) {
            bl2 = !this.mTxtFEntry.getText().trim().equals("") && !this.mTxtFRemoval.getText().trim().equals("");
        }
        if (this.mRdoFProbability.isSelected()) {
            bl3 = !this.mTxtPEntry.getText().trim().equals("") && !this.mTxtPRemoval.getText().trim().equals("");
        }
        if (bl && bl2 && bl3) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }
}

