/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.classify.discriminant;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.AnalyzeDefineRange;
import com.spss.java_client.ui.dialogs.base.analyze.classify.discriminant.DiscriminantAnalysisClassification;
import com.spss.java_client.ui.dialogs.base.analyze.classify.discriminant.DiscriminantAnalysisSave;
import com.spss.java_client.ui.dialogs.base.analyze.classify.discriminant.DiscriminantAnalysisStatistics;
import com.spss.java_client.ui.dialogs.base.analyze.classify.discriminant.DiscriminantAnalysisStepwiseMethod;
import com.spss.java_client.ui.dialogs.base.analyze.classify.discriminant.DiscriminantAnalysisValue;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DiscriminantAnalysisDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
FocusListener {
    public static final String USE_STEPWISE_METHOD_KEY = "IDS_DISCRIMINANT_STEPWISE_RADIO";
    private final int STATISTICS = 0;
    private final int METHOD = 1;
    private final int CLASSIFICATION = 2;
    private final int SAVE = 3;
    private final int DEFINE_RANGE = 4;
    private final int VALUE = 5;
    private SrcVariableList mLstSrcVar;
    private JScrollPane mScrollSrcVar;
    private ArrowButton mArrGroupVariable;
    private JLabel mLblGroupVariable;
    private TargetVariableList mLstGroupVariable;
    private JScrollPane mScrollGroupVariable;
    private JButton mBtnDefineRange;
    private JLabel mLblIndependents;
    private TargetVariableList mLstIndependents;
    private JScrollPane mScrollindependents;
    private ArrowButton mArrIndependents;
    private JPanel mPanelRdo;
    private JRadioButton mRdoIndedendent;
    private JRadioButton mRdoStepwise;
    private JLabel mLblSelectionVariable;
    private TargetVariableList mLstSelectionVariable;
    private CorrespondenceSpssVarFormatter mFormatterGrouping;
    private CorrespondenceSpssVarFormatter mFormatterSelection;
    private GroupListModel mMdlGroupVariable;
    private SelectionListModel mMdlSelectionVariable;
    private JScrollPane mScrollSelectionVariable;
    private ArrowButton mArrSelectionVariable;
    private JButton mBtnStatistics;
    private JButton mBtnMethod;
    private JButton mBtnClassify;
    private JButton mBtnSave;
    private JButton mBootstrapButton;
    private JButton mBtnValue;
    private SpssButtonGroup mbtnGrp;
    private boolean mSetRange;
    private boolean mSetValue;
    private boolean mIsBootstrapOK;

    public DiscriminantAnalysisDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_DISCRIMINANT_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        String string;
        CharSequence charSequence;
        CharSequence charSequence2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        boolean bl = false;
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && this.mBootstrapButton.isEnabled() && dialogDataModel != null) {
            bl = true;
            charSequence2 = this.mLstGroupVariable.getVariablesStringList();
            charSequence = this.mLstIndependents.getVariablesStringList();
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax((String)charSequence2, (String)charSequence, dialogDataModel));
        }
        charSequence2 = new StringBuffer();
        charSequence = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        DialogDataModel dialogDataModel2 = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("DISCRIMINANT"));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/GROUPS="));
        stringBuffer.append(this.mLstGroupVariable.getVariablesStringList());
        stringBuffer.append("(");
        stringBuffer.append(dialogDataModel2.getString("IDS_DEFINE_RANGE_MINIMUM"));
        stringBuffer.append(" ");
        stringBuffer.append(dialogDataModel2.getString("IDS_DEFINE_RANGE_MAXIMUM"));
        stringBuffer.append(")");
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/VARIABLES="));
        stringBuffer.append(this.mLstIndependents.getVariablesStringList());
        if (this.mLstSelectionVariable.getVariablesStringList() != null && this.mLstSelectionVariable.getVariablesStringList().length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/SELECT="));
            stringBuffer.append(this.mLstSelectionVariable.getVariablesStringList());
            stringBuffer.append("(");
            stringBuffer.append(dialogDataModel2.getString("IDS_VALUE"));
            stringBuffer.append(")");
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/ANALYSIS ALL"));
        String string2 = null;
        if (dialogDataModel2.getString("EXPORT_XML_FILE_PATH") != null && dialogDataModel2.getString("EXPORT_XML_FILE_PATH").length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/OUTFILE=MODEL("));
            string2 = dialogDataModel2.getString("EXPORT_XML_FILE_PATH");
            stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            stringBuffer.append(")");
        }
        if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_SAVE_PREDICTED_CHECK") != null) {
            ((StringBuffer)charSequence2).delete(0, ((StringBuffer)charSequence2).length());
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_SAVE_PREDICTED_CHECK").booleanValue()) {
                ((StringBuffer)charSequence2).append("CLASS ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_SAVE_SCORES_CHECK").booleanValue()) {
                ((StringBuffer)charSequence2).append("SCORES ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_SAVE_PROBABILITIES_CHECK").booleanValue()) {
                ((StringBuffer)charSequence2).append("PROBS ");
            }
            if (((StringBuffer)charSequence2).length() > 0) {
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/SAVE="));
                stringBuffer.append(((StringBuffer)charSequence2).toString());
            }
        }
        if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STATISTICS_MEANS_CHECK") != null) {
            ((StringBuffer)charSequence).delete(0, ((StringBuffer)charSequence).length());
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STATISTICS_MEANS_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("MEAN STDDEV ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STATISTICS_ANOVA_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("UNIVF ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STATISTICS_BOX_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("BOXM ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STATISTICS_FISHER_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("COEFF ");
            }
            if (dialogDataModel2.getBoolean("IDS_REG_BL_SAVE_UNSTANDARDIZE_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("RAW ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STATISTICS_WGCORRELATION_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("CORR ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STATISTICS_WGCOVARIANCE_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("COV ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STATISTICS_SGCOVARIANCE_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("GCOV ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STATISTICS_TOTALCOVARIANCE_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("TCOV ");
            }
        }
        if (dialogDataModel2.getBoolean(USE_STEPWISE_METHOD_KEY).booleanValue()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/METHOD="));
            ((StringBuffer)charSequence2).delete(0, ((StringBuffer)charSequence2).length());
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_WILKS_RADIO") != null) {
                if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_WILKS_RADIO").booleanValue()) {
                    stringBuffer.append("WILKS ");
                }
                if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_UNEXPLAINED_RADIO").booleanValue()) {
                    stringBuffer.append("MINRESID ");
                }
                if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_MAHALANOBIS_RADIO").booleanValue()) {
                    stringBuffer.append("MAHAL ");
                }
                if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_FRATIO_RADIO").booleanValue()) {
                    stringBuffer.append("MAXMINF ");
                }
                if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_RAOS_RADIO").booleanValue()) {
                    stringBuffer.append("RAO ");
                    stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/VIN="));
                    stringBuffer.append(dialogDataModel2.getString("IDS_STEPWISE_ROAS"));
                }
                if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_FVALUE_RADIO").booleanValue()) {
                    stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FIN="));
                    stringBuffer.append(dialogDataModel2.getString("IDS_STEPWISE_FENTRY"));
                    stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FOUT="));
                    stringBuffer.append(dialogDataModel2.getString("IDS_STEPWISE_FREMOVAL"));
                }
                if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_USEFPROBABILITY_RADIO").booleanValue()) {
                    stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/PIN="));
                    stringBuffer.append(dialogDataModel2.getString("IDS_STEPWISE_PENTRY"));
                    stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/POUT="));
                    stringBuffer.append(dialogDataModel2.getString("IDS_STEPWISE_PREMOVAL"));
                }
                if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_PAIRWISE_CHECK").booleanValue()) {
                    ((StringBuffer)charSequence).append("FPAIR ");
                }
            } else {
                stringBuffer.append("WILKS ");
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FIN=3.84"));
                stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/FOUT=2.71"));
                stringBuffer3.append("\n").append(SyntaxUtil.getSubCommand("/HISTORY"));
            }
        }
        stringBuffer2.append("\n").append(SyntaxUtil.getSubCommand("/PRIORS "));
        if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_ALLGROUPEQUAL_RADIO") != null) {
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_ALLGROUPEQUAL_RADIO").booleanValue()) {
                stringBuffer2.append("EQUAL ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_COMPUTE_RADIO").booleanValue()) {
                stringBuffer2.append("SIZE ");
            }
        } else {
            stringBuffer2.append("EQUAL ");
        }
        if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_SUMMARY_CHECK") != null) {
            stringBuffer3.delete(0, stringBuffer3.length());
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_STEPWISE_SUMMARY_CHECK").booleanValue()) {
                stringBuffer3.append("\n").append(SyntaxUtil.getSubCommand("/HISTORY"));
            } else {
                stringBuffer3.append("\n").append(SyntaxUtil.getSubCommand("/HISTORY=NONE"));
            }
        }
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(stringBuffer3);
        stringBuffer3.delete(0, stringBuffer3.length());
        stringBuffer2.delete(0, stringBuffer2.length());
        ((StringBuffer)charSequence2).delete(0, ((StringBuffer)charSequence2).length());
        if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_ALLGROUPEQUAL_RADIO") != null) {
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_COMBINEDGROUP_CHECK").booleanValue()) {
                ((StringBuffer)charSequence2).append("COMBINED ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_SEPERATEGROUP_CHECK").booleanValue()) {
                ((StringBuffer)charSequence2).append("SEPARATE  ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_TERR_CHECK").booleanValue()) {
                ((StringBuffer)charSequence2).append("MAP ");
            }
            if (((StringBuffer)charSequence2).length() > 0) {
                stringBuffer2.append("\n").append(SyntaxUtil.getSubCommand("/PLOT="));
                stringBuffer2.append(((StringBuffer)charSequence2).toString());
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_SUMMARY_CHECK").booleanValue()) {
                ((StringBuffer)charSequence).append("TABLE ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_LEAVE_CHECK").booleanValue() && !dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_SEPERATEGROUP_RADIO").booleanValue()) {
                ((StringBuffer)charSequence).append("CROSSVALID ");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_CASE_CHECK").booleanValue()) {
                stringBuffer2.append("\n").append(SyntaxUtil.getSubCommand("/PLOT=CASES"));
                if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_LIMIT_CHECK").booleanValue()) {
                    stringBuffer2.append("(");
                    stringBuffer2.append(dialogDataModel2.getString("IDS_CLASSIFICATION_LIMIT"));
                    stringBuffer2.append(")");
                }
            }
            stringBuffer3.append("\n").append(SyntaxUtil.getSubCommand("/CLASSIFY=NONMISSING "));
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_SEPERATEGROUP_RADIO").booleanValue()) {
                stringBuffer3.append("SEPARATE");
            } else {
                stringBuffer3.append("POOLED");
            }
            if (dialogDataModel2.getBoolean("IDS_DISCRIMINANT_CLASSIFICATION_REPLACE_CHECK").booleanValue()) {
                stringBuffer3.append(" MEANSUB");
            }
        } else {
            stringBuffer3.append("\n").append(SyntaxUtil.getSubCommand("/CLASSIFY=NONMISSING POOLED"));
        }
        if (((StringBuffer)charSequence).length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/STATISTICS="));
            stringBuffer.append(((StringBuffer)charSequence).toString());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(stringBuffer2.toString());
        }
        if (stringBuffer3.length() > 0) {
            stringBuffer.append(stringBuffer3.toString());
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        PesFile pesFile = PES_Repository.getPesFile((String)string2);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if (bl) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_classify_discriminant";
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_DISC";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mRdoStepwise.isSelected()) {
            this.mBtnMethod.setEnabled(true);
        } else {
            this.mBtnMethod.setEnabled(false);
        }
        this.enableBootstrappingButton();
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && this.mBootstrapButton.isEnabled() && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runBootstrapSubDialog();
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mMdlGroupVariable) && this.mLstGroupVariable.getModel().getSize() == 1) {
            this.mBtnDefineRange.setEnabled(true);
        }
        if (listDataEvent.getSource().equals(this.mMdlSelectionVariable) && this.mLstSelectionVariable.getModel().getSize() == 1) {
            this.mBtnValue.setEnabled(true);
            this.mSetValue = false;
        }
        this.enableOkButton();
        this.enableBootstrappingButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mLstGroupVariable.getModel().getSize() == 0) {
            this.mBtnDefineRange.setEnabled(false);
            this.resetGroupingComponent();
            this.mSetRange = false;
        }
        if (this.mLstSelectionVariable.getModel().getSize() == 0) {
            this.mBtnValue.setEnabled(false);
            this.resetSelectionComponent();
            this.mSetValue = true;
        }
        this.enableOkButton();
        this.enableBootstrappingButton();
    }

    public void setRange(String string, String string2) {
        String string3 = "(" + string + " " + string2 + ")";
        ((GroupListModel)this.mLstGroupVariable.getModel()).setElementPropertyAt(0, string3);
        this.mSetRange = true;
        this.enableOkButton();
    }

    public void setValue(String string) {
        String string2 = "=" + string;
        ((SelectionListModel)this.mLstSelectionVariable.getModel()).setElementPropertyAt(0, string2);
        this.mSetValue = true;
        this.enableOkButton();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mLstGroupVariable) {
            this.mBtnDefineRange.setEnabled(this.mLstGroupVariable.getModel().getSize() > 0);
        }
        if (focusEvent.getSource() != this.mLstGroupVariable) {
            this.mBtnDefineRange.setEnabled(false);
        }
        if (focusEvent.getSource() == this.mLstSelectionVariable) {
            this.mBtnValue.setEnabled(this.mLstSelectionVariable.getModel().getSize() > 0);
        }
        if (focusEvent.getSource() != this.mLstSelectionVariable) {
            this.mBtnValue.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.getDialogDataModel().putMap(this.mLstGroupVariable.getIdentifier(), null);
        this.getDialogDataModel().putMap(this.mLstSelectionVariable.getIdentifier(), null);
        this.mFormatterGrouping.getVarMap().clear();
        this.mFormatterSelection.getVarMap().clear();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscriminantAnalysisDlg.this.runSubDialog(0);
            }
        };
        this.mBtnStatistics = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_DISCRIMINANT_METHOD_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscriminantAnalysisDlg.this.runSubDialog(1);
            }
        };
        this.mBtnMethod = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_DISCRIMINANT_CLASSIFY_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscriminantAnalysisDlg.this.runSubDialog(2);
            }
        };
        this.mBtnClassify = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_DISCRIMINANT_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscriminantAnalysisDlg.this.runSubDialog(3);
            }
        };
        this.mBtnSave = new JButton(toggleButtonAction);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DiscriminantAnalysisDlg.this.runBootstrapSubDialog();
                }
            };
            this.mBootstrapButton = new JButton(toggleButtonAction);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrapButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        this.addOptionsPanelButton(jPanel, this.mBtnStatistics);
        this.addOptionsPanelButton(jPanel, this.mBtnMethod);
        this.addOptionsPanelButton(jPanel, this.mBtnClassify);
        this.addOptionsPanelButton(jPanel, this.mBtnSave);
        if (this.mBootstrapButton != null) {
            this.addOptionsPanelButton(jPanel, this.mBootstrapButton);
        }
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mFormatterGrouping.setVarMap(this.getDialogDataModel().getMap(this.mLstGroupVariable.getIdentifier()));
        this.mFormatterSelection.setVarMap(this.getDialogDataModel().getMap(this.mLstSelectionVariable.getIdentifier()));
        if (this.mLstGroupVariable.getModel().getSize() == 1) {
            this.mSetRange = true;
        }
        if (this.mLstSelectionVariable.getModel().getSize() == 1) {
            this.mSetValue = true;
        }
        this.enableOkButton();
        this.mLstSrcVar.setSelectedIndex(0);
        this.mLstSrcVar.requestFocus();
        this.enableBootstrappingButton();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mLstGroupVariable.getIdentifier(), this.mFormatterGrouping.getVarMapForSerialization());
        this.getDialogDataModel().putMap(this.mLstSelectionVariable.getIdentifier(), this.mFormatterSelection.getVarMapForSerialization());
    }

    private void runSubDialog(int n) {
        switch (n) {
            case 0: {
                this.runSubDialog(new DiscriminantAnalysisStatistics(this, this.getResString("IDS_DISCRIMINANT_STATISTICS_TITLE"), true));
                break;
            }
            case 2: {
                this.runSubDialog(new DiscriminantAnalysisClassification(this, this.getResString("IDS_DISCRIMINANT_CLASSIFICATION_TITLE"), true));
                break;
            }
            case 1: {
                this.runSubDialog(new DiscriminantAnalysisStepwiseMethod(this, this.getResString("IDS_DISCRIMINANT_STEPWISE_TITLE"), true));
                break;
            }
            case 3: {
                this.runSubDialog(new DiscriminantAnalysisSave(this, this.getResString("IDS_DISCRIMINANT_SAVE_TITLE"), true));
                break;
            }
            case 4: {
                this.runSubDialog(new AnalyzeDefineRange(this, this.getResString("IDS_DISCRIMINANT_DEFINE_RANGE_TITLE"), "IDH_DISC_RANGE", -999, 9999, false, false, false));
                DialogDataModel dialogDataModel = this.getDialogDataModel();
                if (!AnalyzeDefineRange.isContinueButtonPressed) break;
                this.setRange(dialogDataModel.getString("IDS_DEFINE_RANGE_MINIMUM"), dialogDataModel.getString("IDS_DEFINE_RANGE_MAXIMUM"));
                break;
            }
            case 5: {
                this.runSubDialog(new DiscriminantAnalysisValue(this, this.getResString("IDS_DISCRIMINANT_VALUE_TITLE"), true));
            }
        }
    }

    private void initVars() {
        this.mSetRange = false;
        this.mSetValue = true;
        this.mLstSrcVar = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollSrcVar = new JScrollPane(this.mLstSrcVar);
        this.mScrollSrcVar.setPreferredSize(this.mLstSrcVar.getMinimumSize());
        this.mLstSrcVar.addFocusListener(this);
        this.mLstSrcVar.addVarFilter(new SpssVarFilter(8, false));
        this.mLstSrcVar.setIdentifier("IDS_DISCRIMINANT_SOURCE_VARIABLE");
        this.mLstGroupVariable = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mLstGroupVariable.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollGroupVariable = new JScrollPane(this.mLstGroupVariable);
        this.mScrollGroupVariable.setPreferredSize(this.mLstGroupVariable.getMinimumSize());
        this.mScrollGroupVariable.setHorizontalScrollBarPolicy(31);
        this.mScrollGroupVariable.setVerticalScrollBarPolicy(21);
        this.mFormatterGrouping = new CorrespondenceSpssVarFormatter(this.mLstGroupVariable);
        this.mMdlGroupVariable = new GroupListModel(this.mFormatterGrouping);
        this.mLstGroupVariable.setModel(this.mMdlGroupVariable);
        this.mLstGroupVariable.setCellRenderer(new CustomVarListCellRenderer(this.mFormatterGrouping));
        this.mLstGroupVariable.setIdentifier("IDS_DISCRIMINANT_GROUPING_VARIABLE");
        this.mLstGroupVariable.addFocusListener(this);
        this.mLstIndependents = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mLstIndependents.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollindependents = new JScrollPane(this.mLstIndependents);
        this.mScrollindependents.setVerticalScrollBarPolicy(20);
        this.mScrollGroupVariable.setHorizontalScrollBarPolicy(31);
        this.mLstIndependents.setIdentifier("IDS_DISCRIMINANT_INDEPENDENT_VARIABLE");
        this.mLstIndependents.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mLstIndependents.getFixedCellHeight() * 3 + 2));
        this.mScrollindependents.setPreferredSize(this.mLstIndependents.getMinimumSize());
        this.mLstIndependents.addFocusListener(this);
        this.mLstSelectionVariable = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mLstSelectionVariable.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollSelectionVariable = new JScrollPane(this.mLstSelectionVariable);
        this.mScrollSelectionVariable.setPreferredSize(this.mLstSelectionVariable.getMinimumSize());
        this.mScrollSelectionVariable.setHorizontalScrollBarPolicy(31);
        this.mScrollSelectionVariable.setVerticalScrollBarPolicy(21);
        this.mFormatterSelection = new CorrespondenceSpssVarFormatter(this.mLstSelectionVariable);
        this.mMdlSelectionVariable = new SelectionListModel(this.mFormatterSelection);
        this.mLstSelectionVariable.setModel(this.mMdlSelectionVariable);
        this.mLstSelectionVariable.setCellRenderer(new CustomVarListCellRenderer(this.mFormatterSelection));
        this.mLstSelectionVariable.setIdentifier("IDS_DISCRIMINANT_SELECTION_VARIABLE");
        this.mLstSelectionVariable.addFocusListener(this);
        this.mLblGroupVariable = DialogUtil.createLabel(this, "IDS_GROUPING_VARIABLES_COLON");
        this.mLblIndependents = DialogUtil.createLabel(this, "IDS_DISCRIMINANT_INDEPENDENTS_LABEL");
        this.mLblSelectionVariable = DialogUtil.createLabel(this, "IDS_DISCRIMINANT_SELECTION_LABEL");
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_KINDEPENDENT_RANGE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscriminantAnalysisDlg.this.runSubDialog(4);
            }
        };
        this.mBtnDefineRange = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_DISCRIMINANT_VALUE_BTN"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiscriminantAnalysisDlg.this.runSubDialog(5);
            }
        };
        this.mBtnValue = new JButton(toggleButtonAction);
        this.mArrGroupVariable = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrGroupVariable.registerVariableList(this.mLstSrcVar, SpssArrowButton.ButtonOrientation.right);
        this.mArrGroupVariable.registerVariableList(this.mLstGroupVariable, SpssArrowButton.ButtonOrientation.left);
        this.mArrIndependents = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrIndependents.registerVariableList(this.mLstSrcVar, SpssArrowButton.ButtonOrientation.right);
        this.mArrIndependents.registerVariableList(this.mLstIndependents, SpssArrowButton.ButtonOrientation.left);
        this.mArrSelectionVariable = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrSelectionVariable.registerVariableList(this.mLstSrcVar, SpssArrowButton.ButtonOrientation.right);
        this.mArrSelectionVariable.registerVariableList(this.mLstSelectionVariable, SpssArrowButton.ButtonOrientation.left);
        this.mRdoIndedendent = new JRadioButton(new ToggleButtonAction(this, "IDS_DISCRIMINANT_ENTER_INDEPENDENTS_TOGETHER_RADIO"));
        this.mRdoStepwise = new JRadioButton(new ToggleButtonAction(this, USE_STEPWISE_METHOD_KEY));
        this.mRdoIndedendent.addItemListener(this);
        this.mRdoStepwise.addItemListener(this);
        this.mLstSelectionVariable.getModel().addListDataListener(this);
        this.mLstGroupVariable.getModel().addListDataListener(this);
        this.mLstIndependents.getModel().addListDataListener(this);
        JComponent[] jComponentArray = new JComponent[]{this.mRdoIndedendent, this.mRdoStepwise};
        this.mPanelRdo = PanelFactory.getGridPanel(jComponentArray, "", 2);
        this.mbtnGrp = DialogUtil.createButtonGroup(this.mPanelRdo);
        this.mLblGroupVariable.setLabelFor(this.mLstGroupVariable);
        this.mLblIndependents.setLabelFor(this.mLstIndependents);
        this.mLblSelectionVariable.setLabelFor(this.mLstSelectionVariable);
    }

    private void setDefaults() {
        this.mLstSrcVar.loadFromActiveDataset();
        this.mLstSrcVar.setSelectedIndex(0);
        this.mLstSrcVar.requestFocus();
        this.mLstGroupVariable.removeAll();
        this.mLstIndependents.removeAll();
        this.mLstSelectionVariable.removeAll();
        this.mBtnDefineRange.setEnabled(false);
        this.mBtnValue.setEnabled(false);
        this.mBtnMethod.setEnabled(false);
        this.mRdoIndedendent.setSelected(true);
        this.mArrGroupVariable.setEnabled(true);
        this.mArrIndependents.setEnabled(true);
        this.mArrSelectionVariable.setEnabled(true);
        this.mArrGroupVariable.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrIndependents.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrSelectionVariable.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DISCRIMINANT_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollSrcVar, gridBagConstraints, 0, 1, 1, 5, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 20;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mArrGroupVariable, gridBagConstraints, 1, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLblGroupVariable, gridBagConstraints, 2, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mScrollGroupVariable, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mBtnDefineRange, gridBagConstraints, 2, 3, 2, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupIndependentsTargetVarsListPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 4, 2, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel2 = this.setupSelectionTargetVarsListPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 5, 2, 1, n, null);
    }

    private JPanel setupIndependentsTargetVarsListPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        int n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mArrIndependents, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLblIndependents, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mScrollindependents, gridBagConstraints, 1, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPanelRdo, gridBagConstraints, 1, 2, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupSelectionTargetVarsListPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mArrSelectionVariable, gridBagConstraints, 0, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLblSelectionVariable, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mScrollSelectionVariable, gridBagConstraints, 1, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            insets.top -= 5;
        }
        DialogUtil.addUsingGBL(jPanel, this.mBtnValue, gridBagConstraints, 2, 1, 1, 2, n, insets);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mLstSrcVar);
        vector.add(this.mArrGroupVariable);
        vector.add(this.mArrIndependents);
        vector.add(this.mLstGroupVariable);
        vector.add(this.mBtnDefineRange);
        vector.add(this.mLstIndependents);
        vector.add(this.mbtnGrp);
        vector.add(this.mArrSelectionVariable);
        vector.add(this.mLstSelectionVariable);
        vector.add(this.mBtnValue);
        vector.add(this.mBtnStatistics);
        vector.add(this.mBtnMethod);
        vector.add(this.mBtnClassify);
        vector.add(this.mBtnSave);
        if (VersionInfo.allowBootstrapping()) {
            vector.add(this.mBootstrapButton);
        }
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void enableOkButton() {
        if (this.mSetRange && this.mLstIndependents.getModel().getSize() > 0 && this.mSetValue) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    private void resetGroupingComponent() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString("IDS_DEFINE_RANGE_MINIMUM", null);
        dialogDataModel.putString("IDS_DEFINE_RANGE_MAXIMUM", null);
    }

    private void resetSelectionComponent() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString("IDS_VALUE", null);
    }

    private void runBootstrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }

    private void enableBootstrappingButton() {
        if (this.mBootstrapButton != null) {
            if (BootstrapDlg.isCurrentDatasetInMIMode() || this.mLstSelectionVariable.getModel().getSize() != 0 || this.mRdoStepwise.isSelected()) {
                this.mBootstrapButton.setEnabled(false);
            } else {
                this.mBootstrapButton.setEnabled(true);
            }
        }
    }

    private class CorrespondenceSpssVarFormatter
    extends SpssVarFormatter {
        public CorrespondenceSpssVarFormatter(TargetVariableList targetVariableList) {
            super(targetVariableList);
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            String string = "";
            String string2 = this.getVarMap().get(iSpssVariable.getId().asInt()).toString();
            if (string2.contains("(")) {
                string2 = string2.substring(1, string2.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    string = string + UIToolResUtil.addLocale((String)stringTokenizer.nextToken()) + " ";
                }
                string = string.trim();
                string = "(" + string + ")";
            } else {
                string = UIToolResUtil.addLocale((String)string2);
            }
            return iSpssVariable.getName() + string;
        }
    }

    private class SelectionListModel
    extends CustomVarListModel {
        public SelectionListModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        @Override
        public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "=? ");
            return super.insertElementAt(iSpssVariable, n);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "=? ");
            return super.addElement(iSpssVariable);
        }

        public void setElementPropertyAt(int n, String string) {
            if (n < 0 || n >= this.mVariables.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            ISpssVariable iSpssVariable = this.getElementAt(n);
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), string);
            this.fireContentsChanged(iSpssVariable, n, n);
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }

    private class GroupListModel
    extends CustomVarListModel {
        public GroupListModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        @Override
        public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(? ?)");
            return super.insertElementAt(iSpssVariable, n);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(? ?)");
            return super.addElement(iSpssVariable);
        }

        public void setElementPropertyAt(int n, String string) {
            if (n < 0 || n >= this.mVariables.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            ISpssVariable iSpssVariable = this.getElementAt(n);
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), string);
            this.fireContentsChanged(iSpssVariable, n, n);
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }
}

