/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.server.messages.sysfilemsg.ObsVecMap;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ScannedVariable;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ValueLabelGridRow;
import com.spss.java_client.ui.dialogs.common.FrequenciesScanner;
import com.spss.java_client.ui.dialogs.common.IFrequencyScannerListener;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.dictionary.IDataSrc;
import com.spss.shared.core_tools.format.CellValueFormatter;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;

public abstract class ScanBaseDlg
extends BayesianBaseDlg
implements IFrequencyScannerListener {
    private static final String BULR_SCANNED_VARS_LIST_KEY = "IDS_BULR_SCANNED_VARS_LIST_KEY";
    private static final int MAX_NUMBER_OF_CASES = 200;
    protected Vector<LocallyUniqueId> mScanVars;
    protected ArrayList<ISpssVariable> mScanVariables;
    protected boolean mScanFinished = false;
    private long mValueListLimit = 200L;
    private List<ScannedVariable> mScannedVarsList;

    public ScanBaseDlg(JFrame jFrame) {
        super(jFrame);
    }

    public ScannedVariable findScannedVariable(ISpssVariable iSpssVariable) {
        ScannedVariable scannedVariable = null;
        if (this.mScannedVarsList != null) {
            for (ScannedVariable scannedVariable2 : this.mScannedVarsList) {
                if (!scannedVariable2.getVariable().getName().equals(iSpssVariable.getName())) continue;
                scannedVariable = scannedVariable2;
                break;
            }
        }
        return scannedVariable;
    }

    @Override
    public void finishedScanning(CoreFrequencies coreFrequencies) {
        System.out.println("ScanBaseDlg: finishScanning()-START...");
        this.setCursor(Cursor.getPredefinedCursor(0));
        ISpssVariable[] iSpssVariableArray = this.mScanVariables.toArray(new ISpssVariable[this.mScanVariables.size()]);
        this.setInitialValues(iSpssVariableArray, coreFrequencies);
        System.out.println("ScanBaseDlg: finishScanning()-END...");
    }

    public List<ScannedVariable> getScannedVarList() {
        if (this.mScannedVarsList == null) {
            this.mScannedVarsList = new ArrayList<ScannedVariable>();
        }
        return this.mScannedVarsList;
    }

    public boolean isVarFromModel(VarListModel varListModel, ISpssVariable iSpssVariable) {
        boolean bl = false;
        if (iSpssVariable == null) {
            return bl;
        }
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = varListModel.getElementAt(i);
            if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mScannedVarsList = (List)this.getDialogDataModel().getObject(BULR_SCANNED_VARS_LIST_KEY);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putObject(BULR_SCANNED_VARS_LIST_KEY, this.mScannedVarsList);
    }

    protected boolean needScanning(VarListModel varListModel, VarListModel varListModel2) {
        if (this.mScannedVarsList == null || this.mScannedVarsList.size() == 0) {
            return true;
        }
        if (this.mScannedVarsList.size() == varListModel.getSize() + (varListModel2 != null ? varListModel2.getSize() : 0)) {
            boolean bl = false;
            for (ScannedVariable scannedVariable : this.mScannedVarsList) {
                int n;
                boolean bl2 = false;
                String string = scannedVariable.getVariable().getName();
                for (n = 0; n < varListModel.getSize(); ++n) {
                    if (!string.equals(varListModel.getElementAt(n).getName())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2 && varListModel2 != null) {
                    for (n = 0; n < varListModel2.getSize(); ++n) {
                        if (!string.equals(varListModel2.getElementAt(n).getName())) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2) {
                    return true;
                }
                bl = bl2;
            }
            if (bl) {
                return false;
            }
        }
        return true;
    }

    public ArrayList<String> getCatsList(ScannedVariable scannedVariable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ValueLabelGridRow> list = scannedVariable.getValueLabelGrid();
        String string = scannedVariable.getVariable().getName();
        for (ValueLabelGridRow valueLabelGridRow : list) {
            double d = valueLabelGridRow.getCount();
            if (d == 0.0 || scannedVariable.getVariable().isMissing((OBS)valueLabelGridRow.getValue())) continue;
            String string2 = CellValueFormatter.obsToString((OBS)((OBS)valueLabelGridRow.getValue()), (SPSS_Format)scannedVariable.getVariable().getFormat());
            String string3 = valueLabelGridRow.getLabel();
            if (string3 != null && (string3.contains("Missing") || string3.contains("missing"))) continue;
            string3 = string + ":";
            String string4 = string3 + string2;
            arrayList.add(string4);
        }
        return arrayList;
    }

    protected boolean isScanVarModelChanged(ISpssVariable[] iSpssVariableArray, VarListModel varListModel) {
        boolean bl = false;
        if (iSpssVariableArray.length != varListModel.getSize()) {
            bl = true;
        } else {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                boolean bl2 = false;
                for (int i = 0; i < varListModel.getSize(); ++i) {
                    if (!iSpssVariable.getName().equals(varListModel.getElementAt(i).getName())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void setInitialValues(ISpssVariable[] iSpssVariableArray, CoreFrequencies coreFrequencies) {
        Object object;
        try {
            int n = iSpssVariableArray.length;
            object = this.getScannedVarList();
            if (object != null) {
                object.clear();
            }
            for (int i = 0; i < n; ++i) {
                this.mScannedVarsList.add(new ScannedVariable(iSpssVariableArray[i].clone()));
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        OBS oBS = null;
        DataMgr dataMgr = DataMgr.getDataMgr();
        ISpssDataSrc iSpssDataSrc = dataMgr.getDataSource(dataMgr.getActiveDocumentId());
        long l = System.currentTimeMillis();
        int n = 0;
        while (n == 0) {
            n = coreFrequencies.getVarMapCount();
            if (System.currentTimeMillis() - l <= 60000L) continue;
        }
        for (int i = 0; i < n; ++i) {
            ObsVecMap obsVecMap = coreFrequencies.getVariableMap(i);
            ScannedVariable scannedVariable = this.mScannedVarsList.get(i);
            object = scannedVariable.getValueLableMapForSorting();
            ISpssVariable iSpssVariable = scannedVariable.getVariable();
            TreeMap treeMap = obsVecMap.getObsMap();
            long l2 = 0L;
            for (Map.Entry entry : treeMap.entrySet()) {
                if (this.mValueListLimit != -1L && l2 >= this.mValueListLimit) break;
                ++l2;
                OBS oBS2 = (OBS)entry.getKey();
                Double d = (Double)entry.getValue();
                if (oBS2.isMissing((IDataSrc)iSpssDataSrc)) continue;
                boolean bl = false;
                if (object != null) {
                    for (OBS oBS3 : object.keySet()) {
                        if (!oBS3.equals((Object)oBS2)) continue;
                        bl = true;
                        oBS = oBS3;
                        break;
                    }
                }
                if (!bl) {
                    ValueLabelGridRow valueLabelGridRow = new ValueLabelGridRow(oBS2, "", iSpssVariable);
                    if (object != null) {
                        object.put(oBS2, valueLabelGridRow);
                    }
                    oBS = oBS2;
                }
                if (object == null) continue;
                ((ValueLabelGridRow)object.get(oBS)).setCount(d);
            }
            scannedVariable.createValueLabelGrid();
        }
    }

    protected abstract ArrayList<ISpssVariable> getScanVariables();

    protected void performScanning(IFrequencyScannerListener iFrequencyScannerListener) {
        Object object;
        this.setCursor(Cursor.getPredefinedCursor(3));
        int n = this.mScanVariables.size();
        DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        LocallyUniqueId locallyUniqueId = dataFrame.getDatasetId();
        this.mScanVars = new Vector();
        for (int i = 0; i < n; ++i) {
            object = this.mScanVariables.get(i);
            this.mScanVars.add(object.getId());
        }
        CoreFrequencies coreFrequencies = new CoreFrequencies();
        coreFrequencies.run(locallyUniqueId, this.mScanVars, 500, 200L);
        object = new FrequenciesScanner(coreFrequencies, SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), "Scanning Cases");
        ((FrequenciesScanner)object).registerScannerListener(iFrequencyScannerListener);
        ((FrequenciesScanner)object).startScanning();
    }
}

