/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.RepeatedMeasAnovaBayesFactorSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.RepeatedMeasAnovaCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.RepeatedMeasAnovaPlotsSubDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class RepeatedMeasAnovaStatsDlg
extends BayesianBaseDlg
implements ListDataListener {
    private TargetVariableList mWeightVarList;
    private ArrowButton mWeightArrowButton;
    private JButton mPlotsButton;

    public RepeatedMeasAnovaStatsDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getResString("IDS_BAYESIAN_REPEATEDMEAS_ANOVA_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_repeated";
    }

    @Override
    public String getIActionKey() {
        return "analyze_bayesian_repeatedmeas_anova";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableContinue());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableContinue());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableContinue());
    }

    @Override
    public String generateSyntax() {
        boolean bl;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("BAYES REPEATED "));
        stringBuffer.append(this.mTargetVarList.getVariablesStringList());
        stringBuffer.append("\n");
        stringBuffer.append(RepeatedMeasAnovaCriteriaSubDlg.getCriteriaDlgSyntax(dialogDataModel));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/INFERENCE"));
        Boolean bl2 = dialogDataModel.getBoolean("IDS_BAYES_FACTOR");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_USE_BOTH");
        String string = bl2 != null && bl2 != false ? "BAYESFACTOR" : (bl3 != null && bl3 != false ? "BOTH" : "POSTERIOR");
        stringBuffer.append(" ANALYSIS=").append(string);
        if (this.mWeightVarList.getModel().getSize() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/DESIGN"));
            stringBuffer.append(" REGWGT=");
            stringBuffer.append(this.mWeightVarList.getModel().getElementAt(0).getName());
        }
        boolean bl4 = bl = dialogDataModel.containsBooleanKey("IDS_DISTRIBUTION") ? dialogDataModel.getBoolean("IDS_DISTRIBUTION") : true;
        if (!bl) {
            stringBuffer.append(RepeatedMeasAnovaBayesFactorSubDlg.getByesFactorSyntax(dialogDataModel));
        }
        if (!this.mBayesFactorRadio.isSelected()) {
            stringBuffer.append(RepeatedMeasAnovaPlotsSubDlg.getPlotsSyntax(dialogDataModel, this.mTargetVarList.getModel()));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mWeightVarList.removeAll();
        this.setDefaults();
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.mBayesFactorButton.setEnabled(false);
    }

    @Override
    protected void onAnalysisRadio() {
        this.mBayesFactorButton.setEnabled(!this.mDistributionRadio.isSelected());
        this.mPlotsButton.setEnabled(!this.mBayesFactorRadio.isSelected());
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = this.createSideButtonPanel(true);
        jPanel.remove(this.mPriorsButton);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_PLOTS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepeatedMeasAnovaStatsDlg.this.onPlotsButton();
            }
        };
        this.mPlotsButton = new JButton(toggleButtonAction);
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.top + insets.bottom;
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(this.mPlotsButton);
        return jPanel;
    }

    @Override
    protected void initVars() {
        super.initVars();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setIdentifier("REPEATEDMEAS_ANOVA_TARGET_LIST");
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mWeightVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mWeightVarList.getModel().addListDataListener(this);
        this.mWeightVarList.setIdentifier("REPEATEDMEAS_ANOVA_WEIGHT_VARIALE_LIST");
        this.mWeightArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWeightArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWeightArrowButton.registerVariableList(this.mWeightVarList, SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    protected void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mWeightArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mWeightVarList);
        vector.add(this.mAnalysisGroup);
        vector.add(this.mCriteriaButton);
        vector.add(this.mBayesFactorButton);
        vector.add(this.mPlotsButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    @Override
    protected void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BAYESIAN_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 5, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_BAYESIAN_REPEATEDMEAS_VAR");
        jLabel2.setLabelFor(this.mTargetVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        Insets insets2 = (Insets)insets.clone();
        insets2.right += 20;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 20;
        gridBagConstraints.fill = 0;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        insets = new Insets(0, insets3.left, 0, insets3.right);
        DialogUtil.addUsingGBL(jPanel, this.mWeightArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, DialogUtil.getComponentGroupGap());
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_BULR_WEIGHT");
        jLabel3.setLabelFor(this.mWeightVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets);
        JScrollPane jScrollPane3 = new JScrollPane(this.mWeightVarList);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        jScrollPane3.setPreferredSize(this.mWeightVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        JPanel jPanel2 = this.createAnalysisPanel();
        gridBagConstraints.fill = 2;
        insets2.top += 5;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 4, 1, 1, n, insets2);
    }

    @Override
    protected void onCriteriaButton() {
        this.runSubDialog(new RepeatedMeasAnovaCriteriaSubDlg(this, this.getResString("IDS_BAYESIAN_REPEATEDMEAS_CRITERIA_SUBDLG_TITLE")));
    }

    @Override
    protected void onBayesFactorButton() {
        this.runSubDialog(new RepeatedMeasAnovaBayesFactorSubDlg(this, this.getResString("IDS_BAYESIAN_REPEATEDMEAS_BF_SUBDLG_TITLE")));
    }

    private void onPlotsButton() {
        this.runSubDialog(new RepeatedMeasAnovaPlotsSubDlg((BaseProcedureDialog)this, this.getResString("IDS_BAYESIAN_REPEATEDMEAS_PLOTS_SUBDLG_TITLE"), this.mTargetVarList.getModel()));
    }

    private boolean canEnableContinue() {
        return this.mTargetVarList.getModel().getSize() > 1;
    }
}

