/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class RepeatedMeasAnovaPlotsSubDlg
extends BaseSubDialog {
    private static final String REPEATED_MEAS_PLOTS_TABLE_VECTOR_KEY = "IDS_REPEATED_MEAS_PLOTS_TABLE_VECTOR";
    private PlotsTable mPlotsTable;
    private VarListModel mRepeatedMeasVarModel;

    RepeatedMeasAnovaPlotsSubDlg(BaseProcedureDialog baseProcedureDialog, String string, VarListModel varListModel) {
        super(baseProcedureDialog, string, true);
        this.mRepeatedMeasVarModel = varListModel;
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_repeated_plots";
    }

    static String getPlotsSyntax(DialogDataModel dialogDataModel, VarListModel varListModel) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Vector vector = (Vector)dialogDataModel.getObject(REPEATED_MEAS_PLOTS_TABLE_VECTOR_KEY);
        if (vector == null || vector.size() == 0) {
            return "";
        }
        for (Object e : vector) {
            Boolean bl;
            SpssVariable spssVariable = (SpssVariable)((Vector)e).get(0);
            if (!RepeatedMeasAnovaPlotsSubDlg.isInTargetList(spssVariable, varListModel) || (bl = (Boolean)((Vector)e).get(1)) == null || !bl.booleanValue()) continue;
            stringBuilder2.append(spssVariable.getName());
            stringBuilder2.append(" ");
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("\n");
            stringBuilder.append(SyntaxUtil.getSubCommand("/PLOT"));
            stringBuilder.append(" MEANS=");
            stringBuilder.append(stringBuilder2.toString().trim());
        }
        return stringBuilder.toString();
    }

    private static boolean isInTargetList(SpssVariable spssVariable, VarListModel varListModel) {
        boolean bl = false;
        for (int i = 0; i < varListModel.getSize(); ++i) {
            if (!spssVariable.getName().equals(varListModel.getElementAt(i).getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPlotsTable);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.createPlotsTablePanel();
        jPanel.add((Component)jPanel2, "Center");
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        Vector vector = (Vector)dialogDataModel.getObject(REPEATED_MEAS_PLOTS_TABLE_VECTOR_KEY);
        super.loadState(dialogDataModel);
        this.mPlotsTable.reloadTable(vector);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        if (this.mPlotsTable != null) {
            Vector<Vector> vector = ((DefaultTableModel)this.mPlotsTable.getModel()).getDataVector();
            dialogDataModel.putObject(REPEATED_MEAS_PLOTS_TABLE_VECTOR_KEY, vector);
        }
        return super.saveState(dialogDataModel);
    }

    private JPanel createPlotsTablePanel() {
        Object[] objectArray = this.getResStringArray("IDS_BAYESIAN_REPEATEDMEAS_PLOTS_TABLE_COL_NAMES");
        JPanel jPanel = new JPanel(new GridBagLayout());
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        for (int i = 0; i < this.mRepeatedMeasVarModel.getSize(); ++i) {
            defaultTableModel.addRow(new Object[]{this.mRepeatedMeasVarModel.getElementAt(i), false});
        }
        this.mPlotsTable = new PlotsTable(defaultTableModel);
        JScrollPane jScrollPane = new JScrollPane(this.mPlotsTable);
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    class PlotsTable
    extends BayesianBaseDlg.BaseTable {
        PlotsTable(TableModel tableModel) {
            super(tableModel);
            this.setRowHeight(this.getRowHeight() + 5);
            this.setupColumns();
            TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
            JLabel jLabel = (JLabel)((Object)tableCellRenderer);
            jLabel.setHorizontalAlignment(0);
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setPreferredSize(new Dimension(jTableHeader.getPreferredSize().width, jTableHeader.getPreferredSize().height + 6));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        private void setupColumns() {
            if (this.columnModel.getColumnCount() == 0) {
                return;
            }
            TableColumn tableColumn = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer(true);
            varLabelRenderer.setHorizontalAlignment(0);
            tableColumn.setCellRenderer(varLabelRenderer);
            tableColumn.setPreferredWidth(100);
            tableColumn.setMinWidth(60);
            TableColumn tableColumn2 = this.columnModel.getColumn(1);
            tableColumn2.setPreferredWidth(50);
            tableColumn2.setMinWidth(50);
        }
    }
}

