/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RepeatedMeasAnovaCriteriaSubDlg
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    private FloatTextField mIntervalPercentageField;
    private IntTextField mNumberField;
    private JCheckBox mSetSeedCheck;
    private JLabel mSeedCustomLabel;
    private IntTextField mSeedCustomField;

    RepeatedMeasAnovaCriteriaSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setDefaults();
        this.addListeners();
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_repeated_criteria";
    }

    static String getCriteriaDlgSyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        String string = dialogDataModel.getString("IDS_INTERVAL_PERCENTAGE_LABEL") != null ? dialogDataModel.getString("IDS_INTERVAL_PERCENTAGE_LABEL") : "95";
        stringBuilder.append(" CILEVEL=").append(string);
        Boolean bl = dialogDataModel.getBoolean("IDS_SET_CUSTOM_SEED");
        string = dialogDataModel.getString("IDS_MCA_SEED_CUSTOM_LABEL");
        stringBuilder.append(" SEED=").append(bl != null && bl != false && string.length() > 0 ? string : "RANDOM");
        string = dialogDataModel.getString("IDS_NUMBER_MC_SAMPLES_LABEL");
        stringBuilder.append(" MCSAMPLES=").append(string != null && string.length() > 0 ? string : "30000");
        return stringBuilder.toString();
    }

    private void initVars() {
        this.mIntervalPercentageField = new FloatTextField(0.0, 100.0, 1, true);
        this.mIntervalPercentageField.setIncludeMinRange(false);
        this.mIntervalPercentageField.setIncludeMaxRange(false);
        this.mIntervalPercentageField.setColumns(8);
        this.mIntervalPercentageField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_INTERVAL_PERCENTAGE_LABEL"));
        this.mSetSeedCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_SET_CUSTOM_SEED"));
        this.mSeedCustomLabel = DialogUtil.createLabel(this, "IDS_MCA_SEED_CUSTOM_LABEL");
        this.mSeedCustomField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mSeedCustomField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_MCA_SEED_CUSTOM_LABEL"));
        this.mSeedCustomField.setColumns(8);
        this.mSeedCustomLabel.setLabelFor((Component)this.mSeedCustomField);
        this.mNumberField = new IntTextField(1000, 1000000, true);
        this.mNumberField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_NUMBER_MC_SAMPLES_LABEL"));
        this.mNumberField.setColumns(8);
    }

    private void addListeners() {
        this.mSetSeedCheck.addItemListener(this);
        this.mIntervalPercentageField.getDocument().addDocumentListener(this);
        this.mSeedCustomField.getDocument().addDocumentListener(this);
        this.mNumberField.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mIntervalPercentageField.setText("95");
        this.mSeedCustomField.setText("2000000");
        this.mNumberField.setText("30000");
        this.mSetSeedCheck.setSelected(false);
        this.mSeedCustomLabel.setEnabled(false);
        this.mSeedCustomField.setEnabled(false);
    }

    private void onSetCustomSeed(boolean bl) {
        this.mSeedCustomLabel.setEnabled(bl);
        this.mSeedCustomField.setEnabled(bl);
    }

    private void setupPanel(JPanel jPanel) {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n / 2, 0, n / 2, 0);
        int n2 = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.mIntervalPercentageField.setPreferredSize(new Dimension(100, 26));
        this.mIntervalPercentageField.setMinimumSize(new Dimension(70, 26));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_INTERVAL_PERCENTAGE_LABEL");
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mIntervalPercentageField, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        jLabel.setLabelFor((Component)this.mIntervalPercentageField);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = this.createNumericalMethodPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_NUMERICAL_METHOD_TITLE")));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
    }

    private JPanel createNumericalMethodPanel() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_NUMBER_MC_SAMPLES_LABEL");
        jLabel.setLabelFor((Component)this.mNumberField);
        this.mSeedCustomField.setPreferredSize(new Dimension(100, 26));
        this.mSeedCustomField.setMinimumSize(new Dimension(70, 26));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSetSeedCheck, gridBagConstraints, 0, 0, 3, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mSeedCustomLabel, gridBagConstraints, 0, 1, 1, 1, n, new Insets(insets.top, insets.left + 40, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSeedCustomField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.top += 3;
        insets.bottom += 3;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberField, gridBagConstraints, 2, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mIntervalPercentageField);
        vector.add(this.mSetSeedCheck);
        vector.add(this.mSeedCustomField);
        vector.add(this.mNumberField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean canEnableContinue() {
        boolean bl;
        boolean bl2 = bl = this.mIntervalPercentageField.getText().length() > 0 && this.mNumberField.getText().length() > 0;
        if (bl && this.mSetSeedCheck.isSelected()) {
            bl = this.mSeedCustomField.getText().length() > 0;
        }
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mSetSeedCheck) {
            this.onSetCustomSeed(this.mSetSeedCheck.isSelected());
        }
    }
}

