/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RepeatedMeasAnovaBayesFactorSubDlg
extends BaseSubDialog {
    private JRadioButton mBicRadio;
    private JRadioButton mRouderRadio;
    private SpssButtonGroup mBRRadioGroup;

    RepeatedMeasAnovaBayesFactorSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_repeated_bayes";
    }

    @Override
    public boolean continuePressed() {
        String string;
        int n;
        boolean bl = true;
        DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        boolean bl2 = dataFrame.hasWeightVar();
        if (this.mRouderRadio.isSelected() && bl2 && ((n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string = this.getResString("ERR_BAYESIAN_REPEATEDMEAS_BF_MESG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 3 || n == -1)) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mBicRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BAYESIAN_REPEATEDMEAS_BF_BIC"));
        this.mRouderRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BAYESIAN_REPEATEDMEAS_BF_ROUDER"));
        this.mBRRadioGroup = new SpssButtonGroup();
        this.mBRRadioGroup.add(this.mBicRadio);
        this.mBRRadioGroup.add(this.mRouderRadio);
    }

    public static String getByesFactorSyntax(DialogDataModel dialogDataModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(SyntaxUtil.getSubCommand("/ESTBF"));
        boolean bl = dialogDataModel.containsBooleanKey("IDS_BAYESIAN_REPEATEDMEAS_BF_BIC") ? dialogDataModel.getBoolean("IDS_BAYESIAN_REPEATEDMEAS_BF_BIC") : true;
        stringBuilder.append(" COMPUTATION=").append(bl ? "BIC" : "ROUDER");
        return stringBuilder.toString();
    }

    private void setDefaults() {
        this.mBicRadio.setSelected(true);
    }

    private void setupPanel(JPanel jPanel) {
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BAYESIAN_REPEATEDMEAS_BF_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mBicRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mRouderRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mBRRadioGroup);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

