/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PairedVariablesDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PairedVariablesDropListener;
import com.spss.java_client.ui.dialogs.adv_stats.rep_measures.ListTraversalArrowButton;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianNormalStatsDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.PairedVariableUtility;
import com.spss.java_client.ui.dialogs.common.PairedVariablesTable;
import com.spss.java_client.ui.dialogs.common.SwapTableContentListener;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class RelatedSampleBayesianStatsDlg
extends BayesianNormalStatsDlg
implements ActionListener {
    private PairedVariablesTable mPairedVarTable;
    private JScrollPane mPairedScrollPane;
    private JButton mSwapButton;
    private ListTraversalArrowButton mUpDownButtons;
    private JPanel mPanel;

    public RelatedSampleBayesianStatsDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getResString("IDS_BAYESIAN_RELATED_SAMPLE_NORMAL"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    protected int getMiddlePanelRightGap() {
        return 0;
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("BAYES")).append(" RELATED");
        stringBuffer.append("\n");
        this.addBayesianBodySyntax(stringBuffer, dialogDataModel);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_bayesian_related_sample";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_relatedsample_normal";
    }

    @Override
    public void reset() {
        super.reset();
        this.mIsReloading = true;
        this.mComponentsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.getDialogDataModel().putSerializableArray("PAIRED_TTEST_TARGET_LIST", null);
        this.enableOkPaste(false);
        this.setDefaults();
        this.mSwapButton.setEnabled(false);
        this.mUpDownButtons.resetArrowButtons();
        this.mIsReloading = false;
    }

    @Override
    public void pack() {
        super.pack();
        DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), this.mSrcVarList);
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    @Override
    protected void initVars() {
        super.initVars();
        this.mPairedVarTable = new PairedVariablesTable(this.mSrcVarList, this.getResStringArray("IDS_PAIRED_COLUMN_NAMES_ARRAY"));
        this.mPairedVarTable.getColumnModel().getColumn(0).setMaxWidth(50);
        this.mPairedScrollPane = new JScrollPane(this.mPairedVarTable);
        this.mPairedScrollPane.setPreferredSize(new Dimension(400, 130));
        this.mComponentsArrowButton.registerComponents(this.mPairedVarTable, SpssArrowButton.ButtonOrientation.left);
        this.mSwapButton = new JButton();
        String string = ResUtil.getCommonDlgString("IDS_PAIR_VARIABLE_SWAP_BUTTON_IMAGE");
        URL uRL = ResUtil.getCommonDlgImageResource(string);
        this.mSwapButton.setIcon(new ImageIcon(uRL));
        this.mSwapButton.setMinimumSize(new Dimension(33, 30));
        this.mSwapButton.setPreferredSize(new Dimension(33, 30));
        this.mUpDownButtons = new ListTraversalArrowButton(this.mPairedVarTable, false, this.mSrcVarList.getSelectionBackground()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RelatedSampleBayesianStatsDlg.this.mIsReloading = true;
                int n = RelatedSampleBayesianStatsDlg.this.mPairedVarTable.getSelectedRow();
                int[] nArray = RelatedSampleBayesianStatsDlg.this.mPairedVarTable.getSelectedRows();
                super.actionPerformed(actionEvent);
                RelatedSampleBayesianStatsDlg.this.switchRowsForDataTable(actionEvent, n, nArray);
                RelatedSampleBayesianStatsDlg.this.mIsReloading = false;
            }
        };
        this.mSwapButton.setEnabled(false);
        this.mPanel = this.mUpDownButtons.setupArrowButtonPanel();
    }

    @Override
    protected void addListeners() {
        ActionListener[] actionListenerArray;
        super.addListeners();
        for (ActionListener actionListener : actionListenerArray = this.mComponentsArrowButton.getActionListeners()) {
            this.mComponentsArrowButton.removeActionListener(actionListener);
        }
        this.mComponentsArrowButton.addActionListener(this);
        this.mSwapButton.addActionListener(new SwapTableContentListener(this.mPairedVarTable, this.mSwapButton));
        this.mPairedVarTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (RelatedSampleBayesianStatsDlg.this.mIsReloading) {
                    return;
                }
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                RelatedSampleBayesianStatsDlg.this.onPairedTableChanged(n, n2);
                RelatedSampleBayesianStatsDlg.this.repaint();
            }
        });
    }

    @Override
    protected void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mComponentsArrowButton);
        vector.add(this.mPairedVarTable);
        vector.add(this.mDataTable);
        for (n = 0; n < this.mPanel.getComponentCount(); ++n) {
            vector.add(this.mPanel.getComponent(n));
        }
        vector.add(this.mSwapButton);
        vector.add(this.mAnalysisGroup);
        vector.add(this.mCriteriaButton);
        vector.add(this.mPriorsButton);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        PairedVariableUtility.loadTableData(this.getDialogDataModel(), this.mPairedVarTable);
        this.enableOkPasteButtons();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        PairedVariableUtility.saveTableData(this.getDialogDataModel(), this.mPairedVarTable);
    }

    @Override
    protected void setDefaults() {
        this.mIsReloading = true;
        super.setDefaults();
        PairedVariableUtility.resetTable(this.mPairedVarTable);
        this.mIsReloading = false;
    }

    @Override
    protected String[] getDataTableColumnNames() {
        return new String[]{this.getResString("IDS_PAIR_VARIABLE_COLUMN"), this.getResString("IDS_DATA_VARIANCE_KNOWN_COLUMN"), this.getResString("IDS_VARIANCE_VALUE_COLUMN"), this.getResString("IDS_NULL_TEST_VALUE_COLUMN"), this.getResString("IDS_G_VALUE_COLUMN")};
    }

    @Override
    protected void addToDataTable(Object object) {
        Object object2;
        int n;
        BayesianNormalStatsDlg.NormalVariableDataBag normalVariableDataBag = null;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mDataTable.getModel();
        boolean bl = false;
        for (n = 0; n < defaultTableModel.getRowCount(); ++n) {
            object2 = (String)defaultTableModel.getValueAt(n, 0);
            if (!object.equals(object2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return;
        }
        if (this.mVariableDataVector != null && this.mVariableDataVector.size() > 0) {
            block1: for (n = 0; n < this.mVariableDataVector.size(); ++n) {
                object2 = (Vector)this.mVariableDataVector.get(n);
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    String string = (String)((Vector)object2).get(0);
                    if (!string.equals(object)) continue;
                    boolean bl2 = (Boolean)((Vector)object2).get(1);
                    String string2 = (String)((Vector)object2).get(2);
                    String string3 = (String)((Vector)object2).get(3);
                    String string4 = (String)((Vector)object2).get(4);
                    normalVariableDataBag = new BayesianNormalStatsDlg.NormalVariableDataBag(string, bl2, string2, string3, string4);
                    break block1;
                }
            }
        }
        if (normalVariableDataBag == null) {
            normalVariableDataBag = new BayesianNormalStatsDlg.NormalVariableDataBag(object);
        }
        Object[] objectArray = new Object[]{object, normalVariableDataBag.getDataVarianceKnown(), normalVariableDataBag.vValue, normalVariableDataBag.nValue, normalVariableDataBag.gValue};
        defaultTableModel.addRow(objectArray);
        if (defaultTableModel.getRowCount() > 0) {
            this.mDataTable.setRowSelectionInterval(defaultTableModel.getRowCount() - 1, defaultTableModel.getRowCount() - 1);
        }
    }

    @Override
    protected JPanel createRightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        int n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.createPairedVarTablePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, this.getMiddlePanelRightGap()));
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel3 = this.createSideButtonPanel(false);
        n = 12;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(10, 50, 0, 10);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel3);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        int n2 = DialogUtil.getComponentGroupGap();
        insets = new Insets(n2, 0, n2, n2);
        JPanel jPanel4 = this.createDataTablePanel();
        if (jPanel4 != null) {
            DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel5 = this.createAnalysisPanel();
        if (jPanel5 != null) {
            DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 2, 1, 1, n, insets);
        }
        return jPanel;
    }

    private void switchRowsForDataTable(ActionEvent actionEvent, int n, int[] nArray) {
        ArrowButton arrowButton = (ArrowButton)actionEvent.getSource();
        if (arrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.up) {
            this.manipulateDataTable(--n, SpssArrowButton.ButtonOrientation.up, nArray);
        } else {
            this.manipulateDataTable(n += this.mPairedVarTable.getSelectedRowCount(), SpssArrowButton.ButtonOrientation.down, nArray);
        }
    }

    private void manipulateDataTable(int n, SpssArrowButton.ButtonOrientation buttonOrientation, int[] nArray) {
        int n2;
        Object[] objectArray;
        int n3;
        Object[] objectArray2 = new Object[this.mDataTable.getColumnCount()];
        for (n3 = 0; n3 < this.mDataTable.getColumnCount(); ++n3) {
            objectArray2[n3] = this.mDataTable.getModel().getValueAt(n, n3);
        }
        if (buttonOrientation == SpssArrowButton.ButtonOrientation.up) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                objectArray = new Object[this.mDataTable.getColumnCount()];
                for (n2 = 0; n2 < this.mDataTable.getColumnCount(); ++n2) {
                    objectArray[n2] = this.mDataTable.getModel().getValueAt(nArray[n3], n2);
                    if (n2 == 0) {
                        objectArray[n2] = Integer.valueOf(Integer.parseInt((String)objectArray[n2]) - 1).toString();
                    }
                    this.mDataTable.getModel().setValueAt(objectArray[n2], nArray[n3] - 1, n2);
                }
            }
        } else if (buttonOrientation == SpssArrowButton.ButtonOrientation.down) {
            for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                objectArray = new Object[this.mDataTable.getColumnCount()];
                for (n2 = 0; n2 < this.mDataTable.getColumnCount(); ++n2) {
                    objectArray[n2] = this.mDataTable.getModel().getValueAt(nArray[n3], n2).toString();
                    if (n2 == 0) {
                        objectArray[n2] = Integer.valueOf(Integer.parseInt((String)objectArray[n2]) + 1).toString();
                    }
                    this.mDataTable.getModel().setValueAt(objectArray[n2], nArray[n3] + 1, n2);
                }
            }
        }
        for (n3 = 0; n3 < this.mDataTable.getColumnCount(); ++n3) {
            if (buttonOrientation == SpssArrowButton.ButtonOrientation.up) {
                if (n3 == 0) {
                    objectArray2[n3] = Integer.valueOf(Integer.parseInt((String)objectArray2[n3]) + nArray.length).toString();
                }
                this.mDataTable.getModel().setValueAt(objectArray2[n3], n + nArray.length, n3);
                continue;
            }
            if (n3 == 0) {
                objectArray2[n3] = Integer.valueOf(Integer.parseInt((String)objectArray2[n3]) - nArray.length).toString();
            }
            this.mDataTable.getModel().setValueAt(objectArray2[n3], n - nArray.length, n3);
        }
    }

    private JPanel createPairedVarTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PAIRED_VARIABLES");
        jLabel.setLabelFor(this.mPairedVarTable);
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, 3, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mPairedScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        insets.set(0, n2, 0, n2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.anchor = 15;
        DialogUtil.addUsingGBL(jPanel2, this.mSwapButton, gridBagConstraints, 0, 1, 1, 1, n, new Insets(insets.top, insets.left * 2, insets.bottom, insets.right));
        gridBagConstraints.fill = 2;
        insets.set(0, 0, n2, n2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 3, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void enableOkPasteButtons() {
        this.enableOkPaste(!this.hasBlankCellAvailable(this.mPairedVarTable));
    }

    private boolean hasBlankCellAvailable(PlainTable plainTable) {
        for (int i = 0; i < plainTable.getModel().getRowCount(); ++i) {
            int n = 0;
            for (int j = 1; j < 3; ++j) {
                Object object = plainTable.getValueAt(i, j);
                if (object instanceof String) continue;
                ++n;
            }
            if ((i != 0 && i >= plainTable.getModel().getRowCount() - 1 || n != 0) && n != true) continue;
            return true;
        }
        return false;
    }

    private void enableSwapButton() {
        boolean bl = true;
        int[] nArray = this.mPairedVarTable.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (!this.mPairedVarTable.getValueAt(nArray[i], 1).equals("") || !this.mPairedVarTable.getValueAt(nArray[i], 2).equals("")) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        this.mSwapButton.setEnabled(bl);
    }

    private void onPairedTableChanged(int n, int n2) {
        if (this.mPairedVarTable.getRowCount() == 0) {
            return;
        }
        String string = (String)this.mPairedVarTable.getValueAt(n, 0);
        boolean bl = n2 > -1 && this.mPairedVarTable.getValueAt(n, n2) instanceof String;
        Object object = this.mPairedVarTable.getValueAt(n, 1);
        Object object2 = this.mPairedVarTable.getValueAt(n, 2);
        if (!(bl || object instanceof String || object2 instanceof String)) {
            this.addToDataTable(string);
        } else if (bl && (object instanceof String || object2 instanceof String)) {
            this.removeFromDataTable(string);
        }
        this.enableOkPasteButtons();
        this.enableSwapButton();
    }

    private void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler) {
        if (component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            ListDragAdapter listDragAdapter = new ListDragAdapter(variableList, dragPane, "VariableList");
            DialogUtil.modifyMouseInputListeners(variableList, listDragAdapter);
        } else if (component instanceof PlainTable) {
            PairedVariablesDragAdapter pairedVariablesDragAdapter = new PairedVariablesDragAdapter(this.mPairedVarTable, dragPane, "PlainTable");
            DialogUtil.modifyMouseInputListeners(this.mPairedVarTable, pairedVariablesDragAdapter);
            dragPane.addDropListener((IDropListener)new PairedVariablesDropListener(this.mPairedVarTable, iVarMoveHandler, this.mSrcVarList));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2, iVarMoveHandler);
            }
        }
    }

    @Override
    protected String getDATASyntaxSubsets(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.mDistributionRadio.isSelected();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = ((Vector)vector.get(i)).get(1);
            boolean bl2 = e instanceof Boolean ? ((Boolean)e).booleanValue() : e.equals("true");
            String string = (String)((Vector)vector.get(i)).get(2);
            String string2 = (String)((Vector)vector.get(i)).get(3);
            String string3 = (String)((Vector)vector.get(i)).get(4);
            String string4 = (bl2 ? string : "") + ";" + (!bl ? string2 + ";" + (string3.length() > 0 ? string3 : "") : ";");
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PAIR"));
            stringBuffer.append(" VARIABLES=");
            ISpssVariable iSpssVariable = (ISpssVariable)this.mPairedVarTable.getValueAt(i, 1);
            ISpssVariable iSpssVariable2 = (ISpssVariable)this.mPairedVarTable.getValueAt(i, 2);
            String string5 = iSpssVariable.getName() + " " + iSpssVariable2.getName();
            stringBuffer.append(string5);
            String[] stringArray = string4.split(";");
            if (stringArray.length > 0 && stringArray[0].length() > 0) {
                stringBuffer.append(" VARIANCE=").append(stringArray[0]);
            }
            if (stringArray.length > 1 && stringArray[1].length() > 0) {
                stringBuffer.append(" NULLVALUE=").append(stringArray[1]);
            }
            if (stringArray.length <= 2 || stringArray[2].length() <= 0) continue;
            stringBuffer.append(" ALTERGVALUE=").append(stringArray[2]);
        }
        return stringBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mComponentsArrowButton)) {
            if (SpssArrowButton.ButtonOrientation.right != ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
                PairedVariableUtility.removeElementFromTable(this.mPairedVarTable, this.mSrcVarList);
                this.mUpDownButtons.resetArrowButtons();
                this.mSwapButton.setEnabled(false);
            } else {
                PairedVariableUtility.addElementToTable(this.mPairedVarTable, this.mSrcVarList);
            }
        }
    }
}

