/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PearsonPriorsSubDlg
extends BaseSubDialog
implements DocumentListener {
    private JRadioButton mUniformRadio;
    private JRadioButton mJeffreysRadio;
    private JRadioButton mSetValueRadio;
    private SpssButtonGroup mUJSRadioGroup;
    private JLabel mCValueLabel;
    private FloatTextField mCValueField;
    private boolean mIsBayesFactorSelected;

    public PearsonPriorsSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, true);
        this.mIsBayesFactorSelected = bl;
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_pearson_priors";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mUniformRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_PEARSON_PRIORS_UNIFORM"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PearsonPriorsSubDlg.this.onSetValueRadio(PearsonPriorsSubDlg.this.mSetValueRadio.isSelected());
                PearsonPriorsSubDlg.this.enableContinue(PearsonPriorsSubDlg.this.canEnableContinue());
            }
        });
        this.mJeffreysRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_PEARSON_PRIORS_JEFFREYS"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PearsonPriorsSubDlg.this.onSetValueRadio(PearsonPriorsSubDlg.this.mSetValueRadio.isSelected());
                PearsonPriorsSubDlg.this.enableContinue(PearsonPriorsSubDlg.this.canEnableContinue());
            }
        });
        this.mSetValueRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_PEARSON_PRIORS_SET_CVALUE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PearsonPriorsSubDlg.this.onSetValueRadio(PearsonPriorsSubDlg.this.mSetValueRadio.isSelected());
                PearsonPriorsSubDlg.this.enableContinue(PearsonPriorsSubDlg.this.canEnableContinue());
            }
        });
        this.mCValueLabel = DialogUtil.createLabel(this, "IDS_PEARSON_PRIORS_CVALUE");
        this.mCValueField = new FloatTextField(Double.NaN, Double.NaN, 5, false);
        this.mCValueField.setAllowMinMax(false, false);
        this.mCValueField.setColumns(8);
        this.mCValueField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_PEARSON_PRIORS_CVALUE"));
        this.mCValueLabel.setLabelFor((Component)this.mCValueField);
        this.mUJSRadioGroup = new SpssButtonGroup();
        this.mUJSRadioGroup.add(this.mUniformRadio);
        this.mUJSRadioGroup.add(this.mJeffreysRadio);
        this.mUJSRadioGroup.add(this.mSetValueRadio);
        this.mCValueField.getDocument().addDocumentListener(this);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mUniformRadio.setEnabled(!this.mIsBayesFactorSelected);
        this.mJeffreysRadio.setEnabled(!this.mIsBayesFactorSelected);
        this.mSetValueRadio.setEnabled(!this.mIsBayesFactorSelected);
        this.onSetValueRadio(!this.mIsBayesFactorSelected && this.mSetValueRadio.isSelected());
    }

    public static String getPriorsSyntax(DialogDataModel dialogDataModel, boolean bl) {
        if (bl) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_PEARSON_PRIORS_UNIFORM") ? dialogDataModel.getBoolean("IDS_PEARSON_PRIORS_UNIFORM") : true;
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_PEARSON_PRIORS_SET_CVALUE") ? dialogDataModel.getBoolean("IDS_PEARSON_PRIORS_SET_CVALUE") : false;
        String string = dialogDataModel.getString("IDS_PEARSON_PRIORS_CVALUE");
        stringBuffer.append(" CVALUE=");
        if (bl2.booleanValue()) {
            stringBuffer.append("0");
        } else if (bl3.booleanValue()) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("-1.5");
        }
        return stringBuffer.toString();
    }

    private void setDefaults() {
        this.mUniformRadio.setSelected(true);
        this.mJeffreysRadio.setSelected(false);
        this.mUniformRadio.setEnabled(!this.mIsBayesFactorSelected);
        this.mJeffreysRadio.setEnabled(!this.mIsBayesFactorSelected);
        this.mSetValueRadio.setEnabled(!this.mIsBayesFactorSelected);
        this.onSetValueRadio(false);
        this.mCValueField.setText("");
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mUniformRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mJeffreysRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSetValueRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCValueLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCValueField, gridBagConstraints, 1, 3, 1, 1, n, insets);
    }

    private void onSetValueRadio(boolean bl) {
        this.mCValueLabel.setEnabled(bl);
        this.mCValueField.setEnabled(bl);
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        if (this.mSetValueRadio.isSelected()) {
            bl = this.mCValueField.getText().length() > 0;
        }
        return bl;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mUJSRadioGroup);
        vector.add(this.mCValueField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

