/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PearsonCriteriaSubDlg
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    private FloatTextField mIntervalPercentageField;
    private JRadioButton mPairwiseRadio;
    private JRadioButton mListwiseRadio;
    private SpssButtonGroup mMissingValuesGroup;
    private JLabel mSimulatedLabel;
    private IntTextField mSimulatedField;
    private JLabel mToleranceLabel;
    private FloatTextField mToleranceField;
    private JLabel mNumberLabel;
    private IntTextField mNumberField;
    private JLabel mMaxIterationsLabel;
    private IntTextField mMaxIterationsField;
    private JCheckBox mSetSeedCheck;
    private JLabel mSeedCustomLabel;
    private IntTextField mSeedCustomField;
    private boolean mIsEstimateBayesFactorSelected;
    private boolean mIsDistributionSelected;
    private boolean mIsFromLogLinear;
    private JRadioButton mAscendingRadio;
    private JRadioButton mDescendingRadio;
    private SpssButtonGroup mADGroup;
    private String mDialogHelpID;

    public PearsonCriteriaSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, boolean bl2, boolean bl3) {
        super(baseProcedureDialog, string, true);
        this.mIsEstimateBayesFactorSelected = bl;
        this.mIsDistributionSelected = bl2;
        this.mIsFromLogLinear = bl3;
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel, bl3);
        this.pack();
        this.setDefaults();
        this.addListeners();
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        this.setDialogHelpID("idh_bayesian_pearson_criteria");
    }

    public PearsonCriteriaSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        super(baseProcedureDialog, string, true);
        this.mIsEstimateBayesFactorSelected = bl;
        this.mIsDistributionSelected = bl2;
        this.mIsFromLogLinear = bl3;
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel, bl3);
        this.pack();
        this.setDefaults();
        this.addListeners();
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        this.setDialogHelpID(string2);
    }

    @Override
    public String getDialogHelpID() {
        return this.mDialogHelpID;
    }

    public void setDialogHelpID(String string) {
        this.mDialogHelpID = string;
    }

    public static String getCriteriaDlgSyntax(DialogDataModel dialogDataModel, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING SCOPE="));
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_EXCLUDE_LISTWISE_RADIO") ? dialogDataModel.getBoolean("IDS_EXCLUDE_LISTWISE_RADIO") : false;
        stringBuffer.append(bl3 != null && bl3 != false ? "LISTWISE" : "PAIRWISE").append("\n");
        PearsonCriteriaSubDlg.addCriteriaSyntax(dialogDataModel, stringBuffer, bl, bl2, false);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void addCriteriaSyntax(DialogDataModel dialogDataModel, StringBuffer stringBuffer, boolean bl, boolean bl2, boolean bl3) {
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        String string = dialogDataModel.getString("IDS_INTERVAL_PERCENTAGE_LABEL") != null ? dialogDataModel.getString("IDS_INTERVAL_PERCENTAGE_LABEL") : "95";
        stringBuffer.append(" CILEVEL=").append(string);
        Boolean bl4 = dialogDataModel.getBoolean("IDS_SET_CUSTOM_SEED");
        string = dialogDataModel.getString("IDS_MCA_SEED_CUSTOM_LABEL");
        stringBuffer.append(" SEED=").append(bl4 != null && bl4 != false && string.length() > 0 ? string : "RANDOM");
        if (!bl) {
            if (!bl3) {
                string = dialogDataModel.getString("IDS_NUMBER_MC_SAMPLES_LABEL");
                stringBuffer.append(" MCSAMPLES=").append(string != null && string.length() > 0 ? string : "1000000");
            }
            string = dialogDataModel.getString("IDS_TOLERANCE_LABEL");
            stringBuffer.append(" TOL=").append(string != null && string.length() > 0 ? string : (bl3 ? "0.000001" : "0.0001"));
            string = dialogDataModel.getString("IDS_MAX_ITERATIONS_LABEL");
            stringBuffer.append(" MAXITER=").append(string != null && string.length() > 0 ? string : "2000");
        }
        if (!bl2) {
            string = dialogDataModel.getString("IDS_PEARSON_CORR_CRITERIA_SIMULATED");
            stringBuffer.append(" POSTSAMPLES=").append(string != null && string.length() > 0 ? string : "1000000");
        }
        if (bl3) {
            Boolean bl5 = dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_PRINT_ASCENDING") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_PRINT_ASCENDING") : true;
            stringBuffer.append(" ORDER=").append(bl5 != false ? "ASCENDING" : "DESCENDING");
        }
    }

    private void initVars() {
        this.mIntervalPercentageField = new FloatTextField(0.0, 100.0, 1, true);
        this.mIntervalPercentageField.setIncludeMinRange(false);
        this.mIntervalPercentageField.setIncludeMaxRange(false);
        this.mIntervalPercentageField.setColumns(8);
        this.mIntervalPercentageField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_INTERVAL_PERCENTAGE_LABEL"));
        this.mPairwiseRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_PEARSON_CORR_CRITERIA_PAIRWISE"));
        this.mListwiseRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXCLUDE_LISTWISE_RADIO"));
        this.mMissingValuesGroup = new SpssButtonGroup();
        this.mMissingValuesGroup.add(this.mPairwiseRadio);
        this.mMissingValuesGroup.add(this.mListwiseRadio);
        this.mSetSeedCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_SET_CUSTOM_SEED"));
        this.mSeedCustomLabel = DialogUtil.createLabel(this, "IDS_MCA_SEED_CUSTOM_LABEL");
        this.mSeedCustomField = new IntTextField(1, this.mIsFromLogLinear ? Integer.MAX_VALUE : 2000000000, true);
        this.mSeedCustomField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_MCA_SEED_CUSTOM_LABEL"));
        this.mSeedCustomField.setColumns(8);
        this.mSeedCustomLabel.setLabelFor((Component)this.mSeedCustomField);
        this.mToleranceField = new FloatTextField(Double.MIN_VALUE, 0.001, 5, false);
        this.mToleranceField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_TOLERANCE_LABEL"));
        this.mToleranceField.setColumns(8);
        this.mMaxIterationsField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxIterationsField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_MAX_ITERATIONS_LABEL"));
        this.mMaxIterationsField.setColumns(8);
        this.mNumberField = new IntTextField(1000, 1000000, true);
        this.mNumberField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_NUMBER_MC_SAMPLES_LABEL"));
        this.mNumberField.setColumns(8);
        this.mSimulatedLabel = DialogUtil.createLabel(this, "IDS_PEARSON_CORR_CRITERIA_SIMULATED");
        this.mSimulatedField = new IntTextField(1000, 1000000, true);
        this.mSimulatedField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_PEARSON_CORR_CRITERIA_SIMULATED"));
        this.mSimulatedField.setColumns(8);
        this.mSimulatedLabel.setLabelFor((Component)this.mSimulatedField);
        this.mAscendingRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_PRINT_ASCENDING"));
        this.mDescendingRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_PRINT_DESCENDING"));
        this.mADGroup = new SpssButtonGroup();
        this.mADGroup.add(this.mAscendingRadio);
        this.mADGroup.add(this.mDescendingRadio);
    }

    private void addListeners() {
        this.mPairwiseRadio.addItemListener(this);
        this.mListwiseRadio.addItemListener(this);
        this.mSetSeedCheck.addItemListener(this);
        this.mIntervalPercentageField.getDocument().addDocumentListener(this);
        this.mSeedCustomField.getDocument().addDocumentListener(this);
        this.mToleranceField.getDocument().addDocumentListener(this);
        this.mMaxIterationsField.getDocument().addDocumentListener(this);
        this.mNumberField.getDocument().addDocumentListener(this);
        this.mSimulatedField.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mIntervalPercentageField.setText("95");
        this.mPairwiseRadio.setSelected(true);
        this.mToleranceField.setText(this.mIsFromLogLinear ? "0.000001" : "0.0001");
        this.mMaxIterationsField.setText("2000");
        this.mSeedCustomField.setText("2000000");
        this.mNumberField.setText("10000");
        this.mSimulatedField.setText("10000");
        this.setEnableStateForNumericMethod();
        this.mAscendingRadio.setSelected(true);
    }

    private void setEnableStateForNumericMethod() {
        this.mToleranceLabel.setEnabled(!this.mIsDistributionSelected);
        this.mToleranceField.setEnabled(!this.mIsDistributionSelected);
        this.mMaxIterationsLabel.setEnabled(!this.mIsDistributionSelected);
        this.mMaxIterationsField.setEnabled(!this.mIsDistributionSelected);
        this.mNumberLabel.setEnabled(!this.mIsDistributionSelected);
        this.mNumberField.setEnabled(!this.mIsDistributionSelected);
        this.mSimulatedLabel.setEnabled(!this.mIsEstimateBayesFactorSelected);
        this.mSimulatedField.setEnabled(!this.mIsEstimateBayesFactorSelected);
        this.onSetCustomSeed(!this.mIsDistributionSelected && this.mSetSeedCheck.isSelected());
    }

    private void onSetCustomSeed(boolean bl) {
        this.mSeedCustomLabel.setEnabled(bl);
        this.mSeedCustomField.setEnabled(bl);
    }

    private void setupPanel(JPanel jPanel, boolean bl) {
        JPanel jPanel2;
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n / 2, 0, n / 2, 0);
        gridBagConstraints.weighty = 1.0;
        int n2 = 23;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.mIntervalPercentageField.setPreferredSize(new Dimension(100, 26));
        this.mIntervalPercentageField.setMinimumSize(new Dimension(70, 26));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_INTERVAL_PERCENTAGE_LABEL");
        DialogUtil.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mIntervalPercentageField, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        jLabel.setLabelFor((Component)this.mIntervalPercentageField);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        if (!bl) {
            jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MISSING_VALUES_TITLE")));
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(this.mPairwiseRadio);
            jPanel2.add(this.mListwiseRadio);
            jPanel2.add(Box.createVerticalStrut(4));
            DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        }
        jPanel2 = this.createNumericalMethodPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_NUMERICAL_METHOD_TITLE")));
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, !bl ? 2 : 1, 1, 1, n2, insets2);
        if (bl) {
            JPanel jPanel4 = new JPanel(new FlowLayout(3, 20, 0));
            jPanel4.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LOG_LINEAR_PRINT_FORMAT_GROUP")));
            jPanel4.add(this.mAscendingRadio);
            jPanel4.add(this.mDescendingRadio);
            DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
        }
    }

    private JPanel createNumericalMethodPanel() {
        this.mToleranceLabel = DialogUtil.createLabel(this, "IDS_TOLERANCE_LABEL");
        this.mToleranceLabel.setLabelFor((Component)this.mToleranceField);
        this.mMaxIterationsLabel = DialogUtil.createLabel(this, "IDS_MAX_ITERATIONS_LABEL");
        this.mMaxIterationsLabel.setLabelFor((Component)this.mMaxIterationsField);
        this.mNumberLabel = DialogUtil.createLabel(this, "IDS_NUMBER_MC_SAMPLES_LABEL");
        this.mNumberLabel.setLabelFor((Component)this.mNumberField);
        this.mSeedCustomField.setPreferredSize(new Dimension(100, 26));
        this.mSeedCustomField.setMinimumSize(new Dimension(70, 26));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSetSeedCheck, gridBagConstraints, 0, 0, 3, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mSeedCustomLabel, gridBagConstraints, 0, 1, 1, 1, n, new Insets(insets.top, insets.left + 40, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mToleranceLabel, gridBagConstraints, 0, 2, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMaxIterationsLabel, gridBagConstraints, 0, 3, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSeedCustomField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mToleranceField, gridBagConstraints, 2, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationsField, gridBagConstraints, 2, 3, 1, 1, n, insets);
        int n2 = 3;
        if (!this.mIsFromLogLinear) {
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mNumberLabel, gridBagConstraints, 0, ++n2, 2, 1, n, insets);
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberField, gridBagConstraints, 2, n2, 1, 1, n, insets);
        }
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSimulatedLabel, gridBagConstraints, 0, ++n2, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSimulatedField, gridBagConstraints, 2, n2, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mIntervalPercentageField);
        if (!this.mIsFromLogLinear) {
            vector.add(this.mMissingValuesGroup);
        }
        vector.add(this.mSetSeedCheck);
        vector.add(this.mSeedCustomField);
        vector.add(this.mToleranceField);
        vector.add(this.mMaxIterationsField);
        if (!this.mIsFromLogLinear) {
            vector.add(this.mNumberField);
        }
        vector.add(this.mSimulatedField);
        if (this.mIsFromLogLinear) {
            vector.add(this.mADGroup);
        }
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean canEnableContinue() {
        boolean bl;
        boolean bl2 = bl = this.mIntervalPercentageField.getText().length() > 0;
        if (bl && this.mSetSeedCheck.isSelected()) {
            boolean bl3 = bl = this.mSeedCustomField.getText().length() > 0;
        }
        if (bl && !this.mIsDistributionSelected) {
            boolean bl4 = bl = this.mToleranceField.getText().length() > 0;
            if (bl) {
                boolean bl5 = bl = this.mMaxIterationsField.getText().length() > 0;
            }
            if (bl) {
                boolean bl6 = bl = this.mNumberField.getText().length() > 0;
            }
        }
        if (bl && !this.mIsEstimateBayesFactorSelected) {
            bl = this.mSimulatedField.getText().length() > 0;
        }
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mSetSeedCheck) {
            this.onSetCustomSeed(this.mSetSeedCheck.isSelected());
        }
    }
}

