/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.PearsonBayesFactorSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.PearsonCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.PearsonPriorsSubDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PearsonCorreBayesianStatsDlg
extends BayesianBaseDlg
implements ListDataListener {
    private static final String SPINNER_FIELD_VALUE = "IDS_BAYESIAN_PEARSON_MAX_PLOTS";
    private JLabel mMaxPlotsLabel;
    private NumberSpinner mMaxPlotsSpinner;

    public PearsonCorreBayesianStatsDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getResString("IDS_BAYESIAN_PEARSON_CORRE_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("BAYES")).append(" CORRELATION");
        stringBuffer.append("\n");
        this.addBayesianBodySyntax(stringBuffer, dialogDataModel);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.setDefaults();
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.mMaxPlotsSpinner.setValue((Object)10);
        this.onAnalysisRadio();
    }

    protected void addBayesianBodySyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        stringBuffer.append(PearsonCriteriaSubDlg.getCriteriaDlgSyntax(dialogDataModel, this.mDistributionRadio.isSelected(), this.mBayesFactorRadio.isSelected()));
        stringBuffer.append(SyntaxUtil.getSubCommand("/INFERENCE"));
        if (this.mTargetVarList.getModel().getSize() > 0) {
            stringBuffer.append(" VARIABLES=").append(this.mTargetVarList.getVariablesStringList());
        }
        String string = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_BAYES_FACTOR");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_USE_BOTH");
        string = bl != null && bl != false ? "BAYESFACTOR" : (bl2 != null && bl2 != false ? "BOTH" : "POSTERIOR");
        stringBuffer.append(" ANALYSIS=").append(string);
        if (this.mMaxPlotsSpinner.isEnabled()) {
            stringBuffer.append(" MAXPLOTS=").append(this.mMaxPlotsSpinner.getValueForSyntax());
        }
        stringBuffer.append(PearsonPriorsSubDlg.getPriorsSyntax(dialogDataModel, this.mBayesFactorRadio.isSelected()));
        stringBuffer.append(PearsonBayesFactorSubDlg.getByesFactorSyntax(dialogDataModel, this.mDistributionRadio.isSelected()));
    }

    @Override
    public String getIActionKey() {
        return "analyze_bayesian_pearson_corre";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_pearson";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 1);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 1);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.mTargetVarList.getModel().addListDataListener(this);
    }

    @Override
    protected int getMiddlePanelRightGap() {
        return 10;
    }

    @Override
    protected void onAnalysisRadio() {
        boolean bl = this.mDistributionRadio.isSelected() || this.mUseBothRadio.isSelected();
        this.mMaxPlotsLabel.setEnabled(bl);
        this.mMaxPlotsSpinner.setEnabled(bl);
    }

    @Override
    protected void initVars() {
        super.initVars();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setIdentifier("PearsonCorreTargetVarList");
        this.mTargetVarList.setMaxLimitOfList(300);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 7 + 2));
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mMaxPlotsLabel = DialogUtil.createLabel(this, SPINNER_FIELD_VALUE);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(10, 0, 50, 1);
        IntTextField intTextField = new IntTextField(true);
        this.mMaxPlotsSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mMaxPlotsLabel.setLabelFor((Component)this.mMaxPlotsSpinner);
        Dimension dimension = this.mMaxPlotsSpinner.getPreferredSize();
        dimension.width = 50;
        this.mMaxPlotsSpinner.setPreferredSize(dimension);
    }

    @Override
    protected JPanel createAnalysisPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BAYESIAN_ANALYSIS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        DialogUtil.addUsingGBL(jPanel, this.mDistributionRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mBayesFactorRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mUseBothRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        Insets insets2 = (Insets)insets.clone();
        insets2.top += 6;
        DialogUtil.addUsingGBL(jPanel, this.mMaxPlotsLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxPlotsSpinner, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel createMiddlePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TEST_VARIABLES");
        int n = 18;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        jLabel.setLabelFor(this.mTargetVarList);
        JPanel jPanel2 = this.createAnalysisPanel();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, new Insets(n2, 0, 0, 0));
        return jPanel;
    }

    @Override
    protected JPanel createRightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        int n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.createMiddlePanel();
        if (jPanel2 != null) {
            DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, this.getMiddlePanelRightGap()));
        }
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel3 = this.createSideButtonPanel(true);
        n = 12;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(10, 20, 0, 10);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel3);
        return jPanel;
    }

    @Override
    protected void onCriteriaButton() {
        this.runSubDialog(new PearsonCriteriaSubDlg((BaseProcedureDialog)this, this.getResString("IDS_PEARSON_CORR_CRITERIA_TITLE"), this.mBayesFactorRadio.isSelected(), this.mDistributionRadio.isSelected(), false));
    }

    @Override
    protected void onPriorsButton() {
        new PearsonPriorsSubDlg(this, this.getResString("IDS_PEARSON_PRIORS_TITLE"), this.mBayesFactorRadio.isSelected());
    }

    @Override
    protected void onBayesFactorButton() {
        new PearsonBayesFactorSubDlg(this, this.getResString("IDS_PEARSON_BAYES_FACTOR_TITLE"), this.mDistributionRadio.isSelected());
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putObject(SPINNER_FIELD_VALUE, this.mMaxPlotsSpinner.getValue());
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        if (this.mMaxPlotsSpinner != null && this.getDialogDataModel().getObject(SPINNER_FIELD_VALUE) != null) {
            this.mMaxPlotsSpinner.setValue(this.getDialogDataModel().getObject(SPINNER_FIELD_VALUE));
        }
    }
}

