/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PearsonBayesFactorSubDlg
extends BaseSubDialog
implements DocumentListener {
    private JRadioButton mJZSRadio;
    private JRadioButton mFractionalRadio;
    private SpssButtonGroup mJFRadioGroup;
    private JLabel mFractionBLabel;
    private FloatTextField mFractionBField;
    private JLabel mNullValueLabel;
    private FloatTextField mNullValueField;
    private boolean mIsDistributionSelected;

    public PearsonBayesFactorSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, true);
        this.mIsDistributionSelected = bl;
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_pearson_bayes";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mJZSRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_PEARSON_BAYES_FACTOR_JZS"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PearsonBayesFactorSubDlg.this.onFractionalRadio(PearsonBayesFactorSubDlg.this.mFractionalRadio.isSelected());
                PearsonBayesFactorSubDlg.this.enableContinue(PearsonBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mFractionalRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_PEARSON_BAYES_FACTOR_FRACTIONAL"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PearsonBayesFactorSubDlg.this.onFractionalRadio(PearsonBayesFactorSubDlg.this.mFractionalRadio.isSelected());
                PearsonBayesFactorSubDlg.this.enableContinue(PearsonBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mFractionBLabel = DialogUtil.createLabel(this, "IDS_PEARSON_BAYES_FACTOR_B");
        this.mFractionBField = new FloatTextField(0.0, 1.0, 5, false);
        this.mFractionBField.setAllowMinMax(false, false);
        this.mFractionBField.setIncludeMaxRange(false);
        this.mFractionBField.setIncludeMinRange(false);
        this.mFractionBField.setColumns(8);
        this.mFractionBField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_PEARSON_BAYES_FACTOR_B"));
        this.mFractionBLabel.setLabelFor((Component)this.mFractionBField);
        this.mNullValueLabel = DialogUtil.createLabel(this, "IDS_PEARSON_BAYES_NULL_VALUE");
        this.mNullValueField = new FloatTextField(-1.0, 1.0, 5, false);
        this.mNullValueField.setAllowMinMax(false, false);
        this.mNullValueField.setIncludeMaxRange(false);
        this.mNullValueField.setIncludeMinRange(false);
        this.mNullValueField.setColumns(8);
        this.mNullValueField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_PEARSON_BAYES_NULL_VALUE"));
        this.mNullValueLabel.setLabelFor((Component)this.mNullValueField);
        this.mJFRadioGroup = new SpssButtonGroup();
        this.mJFRadioGroup.add(this.mJZSRadio);
        this.mJFRadioGroup.add(this.mFractionalRadio);
        this.mFractionBField.getDocument().addDocumentListener(this);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.onFractionalRadio(!this.mIsDistributionSelected && this.mFractionalRadio.isSelected());
    }

    public static String getByesFactorSyntax(DialogDataModel dialogDataModel, boolean bl) {
        if (bl) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/ESTBF"));
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_PEARSON_BAYES_FACTOR_JZS") ? dialogDataModel.getBoolean("IDS_PEARSON_BAYES_FACTOR_JZS") : true;
        String string = dialogDataModel.getString("IDS_PEARSON_BAYES_FACTOR_B");
        String string2 = dialogDataModel.getString("IDS_PEARSON_BAYES_NULL_VALUE");
        stringBuffer.append(" TYPE=");
        if (bl2.booleanValue()) {
            stringBuffer.append("JZS");
        } else {
            stringBuffer.append("FRACTION(");
            stringBuffer.append(string != null && string.length() > 0 ? string : "0.5");
            stringBuffer.append(")");
            stringBuffer.append(" NULLVALUE=");
            stringBuffer.append(string2 != null && string2.length() > 0 ? string2 : "0");
        }
        return stringBuffer.toString();
    }

    private void setDefaults() {
        this.mJZSRadio.setSelected(true);
        this.mFractionalRadio.setSelected(false);
        this.mJZSRadio.setEnabled(!this.mIsDistributionSelected);
        this.mFractionalRadio.setEnabled(!this.mIsDistributionSelected);
        this.onFractionalRadio(false);
        this.mFractionBField.setText("0.5");
        this.mNullValueField.setText("0");
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 30;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mJZSRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFractionalRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFractionBLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mFractionBField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNullValueLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNullValueField, gridBagConstraints, 1, 3, 1, 1, n, insets);
    }

    private void onFractionalRadio(boolean bl) {
        this.mFractionBLabel.setEnabled(bl);
        this.mFractionBField.setEnabled(bl);
        this.mNullValueLabel.setEnabled(bl);
        this.mNullValueField.setEnabled(bl);
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        if (this.mFractionalRadio.isSelected()) {
            bl = this.mFractionBField.getText().length() > 0;
        }
        return bl;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mJFRadioGroup);
        vector.add(this.mFractionBField);
        vector.add(this.mNullValueField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

