/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BPPriorsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.CommonCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.OneSampleBayesianBaseDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class OneSamplePoBayesianStatsDlg
extends OneSampleBayesianBaseDlg {
    private static final int COLUMN_POINT_NULL = 1;
    private static final int COLUMN_NP_SHAPE = 2;
    private static final int COLUMN_NP_SCALE = 3;
    private static final int COLUMN_NULL_RATE = 4;
    private static final int COLUMN_ALT_SHAPE = 5;
    private static final int COLUMN_ALT_SCALE = 6;

    public OneSamplePoBayesianStatsDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getResString("IDS_BAYESIAN_ONE_SAMPLE_POISSON"));
    }

    @Override
    public String getIActionKey() {
        return "analyze_bayesian_one_sample_po";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_onesample_poisson";
    }

    @Override
    protected int getMiddlePanelRightGap() {
        return 50;
    }

    @Override
    protected void initVars() {
        super.initVars();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
    }

    @Override
    protected JPanel createDataTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Object[] objectArray = new String[]{this.getResString("IDS_VARIABLE_COLUMN"), this.getResString("IDS_POINT_NULL"), this.getResString("IDS_NULL_PRIOR_SHAPE"), this.getResString("IDS_NULL_PRIOR_SCALE"), this.getResString("IDS_NULL_RATE"), this.getResString("IDS_ALT_PRIOR_SHAPE"), this.getResString("IDS_ALT_PRIOR_SCALE")};
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BAYES_PO_DATA_GROUP_LABEL");
        this.mDataTable = new BayesFactorTable(defaultTableModel);
        this.mDataTable.getTableHeader().setDefaultRenderer(new OneSampleBayesianBaseDlg.SimpleHeaderRenderer());
        this.mDataTableScrollPane = new JScrollPane(this.mDataTable);
        this.mDataTableScrollPane.setPreferredSize(new Dimension(600, 100));
        jLabel.setLabelFor(this.mDataTable);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.mDataTableScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected void addToDataTable(Object object) {
        Serializable serializable;
        BayesFactorVariableDataBag bayesFactorVariableDataBag = null;
        if (this.mVariableDataVector != null) {
            block0: for (int i = 0; i < this.mVariableDataVector.size(); ++i) {
                serializable = (Vector)this.mVariableDataVector.get(i);
                for (int j = 0; j < ((Vector)serializable).size(); ++j) {
                    ISpssVariable iSpssVariable = (ISpssVariable)((Vector)serializable).get(0);
                    if (!iSpssVariable.getName().equals(((ISpssVariable)object).getName())) continue;
                    boolean bl = (Boolean)((Vector)serializable).get(1);
                    String string = (String)((Vector)serializable).get(2);
                    String string2 = (String)((Vector)serializable).get(3);
                    String string3 = (String)((Vector)serializable).get(4);
                    String string4 = (String)((Vector)serializable).get(5);
                    String string5 = (String)((Vector)serializable).get(6);
                    bayesFactorVariableDataBag = new BayesFactorVariableDataBag(iSpssVariable, bl, string, string2, string3, string4, string5);
                    break block0;
                }
            }
        }
        if (bayesFactorVariableDataBag == null) {
            bayesFactorVariableDataBag = new BayesFactorVariableDataBag(object, "2", "2");
        }
        Object[] objectArray = new Object[]{object, bayesFactorVariableDataBag.isPointNull, bayesFactorVariableDataBag.npShapeValue, bayesFactorVariableDataBag.npScaleValue, bayesFactorVariableDataBag.nullRateValue, bayesFactorVariableDataBag.altShapeValue, bayesFactorVariableDataBag.altScaleValue};
        serializable = (DefaultTableModel)this.mDataTable.getModel();
        ((DefaultTableModel)serializable).addRow(objectArray);
        this.mDataTable.setRowSelectionInterval(((DefaultTableModel)serializable).getRowCount() - 1, ((DefaultTableModel)serializable).getRowCount() - 1);
    }

    @Override
    protected void onBayesianAnalysisRadios(Object object) {
        if (object == this.mDistributionRadio || object == this.mBayesFactorRadio || object == this.mUseBothRadio) {
            this.mDataTable.setEnabled(this.mBayesFactorRadio.isSelected() || this.mUseBothRadio.isSelected());
            super.onBayesianAnalysisRadios(object);
            this.mPriorsButton.setEnabled(!this.mBayesFactorRadio.isSelected());
        }
    }

    @Override
    protected void onCriteriaButton() {
        this.runSubDialog(new CommonCriteriaSubDlg(this, this.getResString("IDS_CRITERIA_SUBDLG_TITLE"), this.mDistributionRadio.isSelected()));
    }

    @Override
    protected void onPriorsButton() {
        this.runSubDialog(new BPPriorsSubDlg(this, this.getResString("IDS_BP_PRIORS_SUBDLG_TITLE")));
    }

    @Override
    protected String getTotalDataSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Vector> vector = ((DefaultTableModel)this.mDataTable.getModel()).getDataVector();
        stringBuffer.append(this.getDATASyntaxSubsets(vector));
        return stringBuffer.toString();
    }

    @Override
    protected String getDATASyntaxSubsets(Vector vector) {
        Object object;
        Object object2;
        String[] stringArray;
        CharSequence charSequence;
        Object object3;
        String string;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < vector.size(); ++i) {
            boolean bl = (Boolean)((Vector)vector.get(i)).get(1);
            String object4 = (String)((Vector)vector.get(i)).get(2);
            string = (String)((Vector)vector.get(i)).get(3);
            object3 = (String)((Vector)vector.get(i)).get(4);
            charSequence = (String)((Vector)vector.get(i)).get(5);
            stringArray = (String)((Vector)vector.get(i)).get(6);
            object2 = bl ? object3 : object4 + " " + string;
            object = (String)charSequence + " " + (String)stringArray;
            String string2 = (String)object2 + ";" + (String)object;
            ArrayList arrayList = (ArrayList)hashMap.get(string2);
            if (arrayList == null) {
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                arrayList2.add(i);
                hashMap.put(string2, arrayList2);
                continue;
            }
            arrayList.add(i);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : hashMap.entrySet()) {
            string = (String)entry.getKey();
            object3 = (ArrayList)entry.getValue();
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/DATA"));
            stringBuffer.append(" VARIABLES=");
            charSequence = new StringBuilder();
            stringArray = ((ArrayList)object3).iterator();
            while (stringArray.hasNext()) {
                object2 = (Integer)stringArray.next();
                object = (ISpssVariable)((Vector)vector.get((Integer)object2)).get(0);
                ((StringBuilder)charSequence).append(object.getName());
                ((StringBuilder)charSequence).append(" ");
            }
            ((StringBuilder)charSequence).trimToSize();
            stringBuffer.append(charSequence);
            if (!this.mDataTable.isEnabled()) continue;
            stringArray = string.split(";");
            stringBuffer.append(" NULLPRIORPARAM=").append(stringArray[0]);
            stringBuffer.append(" ALTERPRIORPARAM=").append(stringArray[1]);
        }
        return stringBuffer.toString();
    }

    class BayesFactorTable
    extends BayesianBaseDlg.BaseTable {
        BayesFactorTable(TableModel tableModel) {
            super(tableModel);
            this.setupColumns();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl = (Boolean)this.getValueAt(n, 1);
            if (n2 == 0) {
                return false;
            }
            if (n2 == 2 || n2 == 3) {
                return !bl;
            }
            if (n2 == 4) {
                return bl;
            }
            return true;
        }

        @Override
        protected boolean validateTable(boolean bl) {
            int n;
            boolean bl2 = true;
            String string = OneSamplePoBayesianStatsDlg.this.getResString("IDS_NULL_RATE_LABEL");
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            block0: for (n = 0; n < defaultTableModel.getRowCount(); ++n) {
                boolean bl3 = (Boolean)defaultTableModel.getValueAt(n, 1);
                for (int i = 2; i <= 6; ++i) {
                    String string2 = (String)defaultTableModel.getValueAt(n, i);
                    String string3 = null;
                    if (string2.length() == 0) {
                        if (!(i != 2 && i != 3 || bl3)) {
                            string3 = MessageFormat.format(OneSamplePoBayesianStatsDlg.this.getResString("ERR_BINOMIAL_UNCHECKED_VALUE_WARNING"), string);
                        } else if (i == 4) {
                            if (!bl3) continue;
                            string3 = MessageFormat.format(OneSamplePoBayesianStatsDlg.this.getResString("ERR_BINOMIAL_CHECKED_VALUE_WARNING"), string);
                        } else {
                            string3 = MessageFormat.format(OneSamplePoBayesianStatsDlg.this.getResString("ERR_PO_MSG_VALUE_WARNING"), 0);
                        }
                    } else if (Double.parseDouble(string2) == 0.0) {
                        string3 = MessageFormat.format(OneSamplePoBayesianStatsDlg.this.getResString("ERR_PO_MSG_VALUE_WARNING"), 0);
                    }
                    if (string3 == null) continue;
                    if (!bl) {
                        this.onDisplayWarning(string3, n, i);
                    }
                    bl2 = false;
                    break block0;
                }
            }
            if (bl2) {
                for (n = 0; n < defaultTableModel.getRowCount(); ++n) {
                    int n2;
                    String string4 = (String)defaultTableModel.getValueAt(n, 2);
                    String string5 = (String)defaultTableModel.getValueAt(n, 3);
                    double d = Double.parseDouble(string4);
                    double d2 = Double.parseDouble(string5);
                    if (d != 0.0 && d2 != 0.0 || d == d2) continue;
                    int n3 = n2 = d == 0.0 ? 3 : 2;
                    if (!bl) {
                        String string6 = OneSamplePoBayesianStatsDlg.this.getResString("ERR_BI_PO_MSG_NP_ZERO_VALUE_WARNING");
                        this.onDisplayWarning(string6, n, n2);
                    }
                    bl2 = false;
                    break;
                }
            }
            return bl2;
        }

        private void setupColumns() {
            TableColumn tableColumn;
            int n;
            TableColumn tableColumn2 = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer();
            tableColumn2.setCellRenderer(varLabelRenderer);
            tableColumn2.setPreferredWidth(60);
            tableColumn2.setMinWidth(60);
            TableColumn tableColumn3 = this.columnModel.getColumn(1);
            tableColumn3.setPreferredWidth(15);
            tableColumn3.setMinWidth(15);
            BayesianBaseDlg.ValueRenderer valueRenderer = new BayesianBaseDlg.ValueRenderer();
            for (n = 2; n <= 4; ++n) {
                tableColumn = this.columnModel.getColumn(n);
                tableColumn.setCellRenderer(valueRenderer);
                tableColumn.setPreferredWidth(40);
                tableColumn.setMinWidth(20);
                tableColumn.setCellEditor(new BayesianBaseDlg.FloatValueCellEditor(0.0, Double.NaN, n == 4));
            }
            for (n = 5; n <= 6; ++n) {
                tableColumn = this.columnModel.getColumn(n);
                tableColumn.setCellRenderer(valueRenderer);
                tableColumn.setPreferredWidth(60);
                tableColumn.setMinWidth(20);
                tableColumn.setCellEditor(new BayesianBaseDlg.FloatValueCellEditor(0.0, Double.NaN, false));
            }
        }
    }

    class BayesFactorVariableDataBag
    extends BayesianBaseDlg.VariableDataBag {
        boolean isPointNull;
        String npShapeValue;
        String npScaleValue;
        String nullRateValue;
        String altShapeValue;
        String altScaleValue;

        BayesFactorVariableDataBag(Object object, String string, String string2) {
            super(object);
            this.isPointNull = false;
            this.npShapeValue = "";
            this.npScaleValue = "";
            this.nullRateValue = "";
            this.altShapeValue = "";
            this.altScaleValue = "";
            this.npShapeValue = string;
            this.npScaleValue = string2;
        }

        BayesFactorVariableDataBag(Object object, boolean bl, String string, String string2, String string3, String string4, String string5) {
            super(object);
            this.isPointNull = false;
            this.npShapeValue = "";
            this.npScaleValue = "";
            this.nullRateValue = "";
            this.altShapeValue = "";
            this.altScaleValue = "";
            this.isPointNull = bl;
            this.npShapeValue = string;
            this.npScaleValue = string2;
            this.nullRateValue = string3;
            this.altShapeValue = string4;
            this.altScaleValue = string5;
        }
    }
}

