/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BPPriorsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.CommonCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.OneSampleBayesianBaseDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class OneSampleBiBayesianStatsDlg
extends OneSampleBayesianBaseDlg {
    private static final int COLUMN_POINT_NULL = 1;
    private static final int COLUMN_NP_SHAPE = 2;
    private static final int COLUMN_NP_SCALE = 3;
    private static final int COLUMN_NULL_PROP = 4;
    private static final int COLUMN_ALT_SHAPE = 5;
    private static final int COLUMN_ALT_SCALE = 6;
    private static final int COLUMN_DS_CAT = 7;
    private static final int COLUMN_VALUE = 8;
    private ArrayList<TableCellEditor> mComboEditors;
    private ArrayList<TableCellEditor> mCutpointLevelEditors;

    public OneSampleBiBayesianStatsDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getResString("IDS_BAYESIAN_ONE_SAMPLE_BINOMIAL"));
    }

    @Override
    public String getIActionKey() {
        return "analyze_bayesian_one_sample_bi";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_onesample_binomial";
    }

    @Override
    protected int getMiddlePanelRightGap() {
        return 140;
    }

    @Override
    protected JPanel createDataTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Object[] objectArray = new String[]{this.getResString("IDS_VARIABLE_COLUMN"), this.getResString("IDS_POINT_NULL"), this.getResString("IDS_NULL_PRIOR_SHAPE"), this.getResString("IDS_NULL_PRIOR_SCALE"), this.getResString("IDS_NULL_PROP"), this.getResString("IDS_ALT_PRIOR_SHAPE"), this.getResString("IDS_ALT_PRIOR_SCALE"), this.getResString("IDS_BINOMIAL_DEFINE_SUCCESS_CAT"), this.getResString("IDS_BI_VALUE_COLUMN")};
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BAYES_BI_DATA_GROUP_LABEL");
        this.mDataTable = new BayesFactorTable(defaultTableModel);
        this.mDataTable.getTableHeader().setDefaultRenderer(new OneSampleBayesianBaseDlg.SimpleHeaderRenderer());
        this.mDataTableScrollPane = new JScrollPane(this.mDataTable);
        this.mDataTableScrollPane.setPreferredSize(new Dimension(700, 100));
        jLabel.setLabelFor(this.mDataTable);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.mDataTableScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        String[] stringArray = new String[]{this.getResString("IDS_BINOMIAL_COMBO_LAST_CATEGORY"), this.getResString("IDS_BINOMIAL_COMBO_FIRST_CATEGORY"), this.getResString("IDS_BINOMIAL_COMBO_MIDPOINT"), this.getResString("IDS_BINOMIAL_COMBO_CUTPOINT"), this.getResString("IDS_BINOMIAL_COMBO_LEVEL")};
        this.mComboEditors = new ArrayList(2);
        JComboBox jComboBox = this.createValueCombo(stringArray);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        this.mComboEditors.add(defaultCellEditor);
        stringArray = new String[]{this.getResString("IDS_BINOMIAL_COMBO_LAST_CATEGORY"), this.getResString("IDS_BINOMIAL_COMBO_FIRST_CATEGORY"), this.getResString("IDS_BINOMIAL_COMBO_LEVEL")};
        JComboBox jComboBox2 = this.createValueCombo(stringArray);
        DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(jComboBox2);
        this.mComboEditors.add(defaultCellEditor2);
        this.mCutpointLevelEditors = new ArrayList(2);
        BayesianBaseDlg.FloatValueCellEditor floatValueCellEditor = new BayesianBaseDlg.FloatValueCellEditor(Double.NaN, Double.NaN, false);
        this.mCutpointLevelEditors.add(floatValueCellEditor);
        StringTextField stringTextField = new StringTextField();
        stringTextField.setDocument(new LevelDocument());
        BayesianBaseDlg.BaseValueCellEditor baseValueCellEditor = new BayesianBaseDlg.BaseValueCellEditor(stringTextField);
        this.mCutpointLevelEditors.add(baseValueCellEditor);
    }

    @Override
    protected void addToDataTable(Object object) {
        Serializable serializable;
        BayesFactorVariableDataBag bayesFactorVariableDataBag = null;
        if (this.mVariableDataVector != null) {
            block0: for (int i = 0; i < this.mVariableDataVector.size(); ++i) {
                serializable = (Vector)this.mVariableDataVector.get(i);
                for (int j = 0; j < ((Vector)serializable).size(); ++j) {
                    ISpssVariable iSpssVariable = (ISpssVariable)((Vector)serializable).get(0);
                    if (!iSpssVariable.getName().equals(((ISpssVariable)object).getName())) continue;
                    boolean bl = (Boolean)((Vector)serializable).get(1);
                    String string = (String)((Vector)serializable).get(2);
                    String string2 = (String)((Vector)serializable).get(3);
                    String string3 = (String)((Vector)serializable).get(4);
                    String string4 = (String)((Vector)serializable).get(5);
                    String string5 = (String)((Vector)serializable).get(6);
                    String string6 = (String)((Vector)serializable).get(7);
                    String string7 = (String)((Vector)serializable).get(8);
                    bayesFactorVariableDataBag = new BayesFactorVariableDataBag(iSpssVariable, bl, string, string2, string3, string4, string5, string6, string7);
                    break block0;
                }
            }
        }
        if (bayesFactorVariableDataBag == null) {
            bayesFactorVariableDataBag = new BayesFactorVariableDataBag(object, "2", "2");
        }
        Object[] objectArray = new Object[]{object, bayesFactorVariableDataBag.isPointNull, bayesFactorVariableDataBag.npShapeValue, bayesFactorVariableDataBag.npScaleValue, bayesFactorVariableDataBag.nullPropValue, bayesFactorVariableDataBag.altShapeValue, bayesFactorVariableDataBag.altScaleValue, bayesFactorVariableDataBag.dsCategory, bayesFactorVariableDataBag.value};
        serializable = (DefaultTableModel)this.mDataTable.getModel();
        ((DefaultTableModel)serializable).addRow(objectArray);
        this.mDataTable.setRowSelectionInterval(((DefaultTableModel)serializable).getRowCount() - 1, ((DefaultTableModel)serializable).getRowCount() - 1);
    }

    @Override
    protected void onCriteriaButton() {
        this.runSubDialog(new CommonCriteriaSubDlg(this, this.getResString("IDS_CRITERIA_SUBDLG_TITLE"), this.mDistributionRadio.isSelected()));
    }

    @Override
    protected void onPriorsButton() {
        this.runSubDialog(new BPPriorsSubDlg(this, this.getResString("IDS_BP_PRIORS_SUBDLG_TITLE")));
    }

    @Override
    protected void onBayesianAnalysisRadios(Object object) {
        super.onBayesianAnalysisRadios(object);
        this.mPriorsButton.setEnabled(!this.mBayesFactorRadio.isSelected());
    }

    @Override
    protected String getTotalDataSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Vector> vector = ((DefaultTableModel)this.mDataTable.getModel()).getDataVector();
        Vector<Vector> vector2 = new Vector<Vector>();
        Vector<Vector> vector3 = new Vector<Vector>();
        for (Vector vector4 : vector) {
            ISpssVariable iSpssVariable = (ISpssVariable)vector4.get(0);
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            if (sPSS_Format.getFormatType().isNumericFormat()) {
                vector2.add(vector4);
                continue;
            }
            if (!sPSS_Format.getFormatType().isStringFormat()) continue;
            vector3.add(vector4);
        }
        stringBuffer.append(this.getDATASyntaxSubsets(vector2));
        stringBuffer.append(this.getDATASyntaxSubsets(vector3));
        return stringBuffer.toString();
    }

    @Override
    protected String getDATASyntaxSubsets(Vector vector) {
        ArrayList arrayList;
        Object object;
        String[] stringArray;
        Object object2;
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        boolean bl = this.mDistributionRadio.isSelected();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)((Vector)vector.get(i)).get(7);
            String object3 = (String)((Vector)vector.get(i)).get(8);
            string = this.getSuccessSyntaxStr(true, string2, object3);
            if (!bl) {
                boolean bl2 = (Boolean)((Vector)vector.get(i)).get(1);
                object2 = (String)((Vector)vector.get(i)).get(2);
                stringArray = (String)((Vector)vector.get(i)).get(3);
                Object object4 = (String)((Vector)vector.get(i)).get(4);
                object = (String)((Vector)vector.get(i)).get(5);
                String string3 = (String)((Vector)vector.get(i)).get(6);
                Object object5 = bl2 ? object4 : (String)object2 + " " + (String)stringArray;
                String string4 = (String)object + " " + string3;
                string = string + ";" + (String)object5 + ";" + string4;
            } else {
                string = string + ";" + ";";
            }
            arrayList = (ArrayList)hashMap.get(string);
            if (arrayList == null) {
                object2 = new ArrayList();
                ((ArrayList)object2).add(i);
                hashMap.put(string, object2);
                continue;
            }
            arrayList.add(i);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : hashMap.entrySet()) {
            string = (String)entry.getKey();
            arrayList = (ArrayList)entry.getValue();
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/DATA"));
            stringBuffer.append(" VARIABLES=");
            object2 = new StringBuilder();
            for (Object object4 : arrayList) {
                object = (ISpssVariable)((Vector)vector.get((Integer)object4)).get(0);
                ((StringBuilder)object2).append(object.getName()).append(" ");
            }
            ((StringBuilder)object2).trimToSize();
            stringBuffer.append((CharSequence)object2);
            stringArray = string.split(";");
            stringBuffer.append(" SUCCESS=").append(stringArray[0]);
            if (stringArray.length > 1) {
                stringBuffer.append(" NULLPRIORPARAM=").append(stringArray[1]);
            }
            if (stringArray.length <= 2) continue;
            stringBuffer.append(" ALTERPRIORPARAM=").append(stringArray[2]);
        }
        return stringBuffer.toString();
    }

    private JComboBox createValueCombo(String[] stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n = OneSampleBiBayesianStatsDlg.this.mDataTable.getSelectedColumn();
                    int n2 = OneSampleBiBayesianStatsDlg.this.mDataTable.getSelectedRow();
                    if (n == 7) {
                        OneSampleBiBayesianStatsDlg.this.mDataTable.setValueAt("", n2, n + 1);
                    }
                }
            }
        });
        return jComboBox;
    }

    private String getSuccessSyntaxStr(boolean bl, String string, String string2) {
        String string3 = null;
        if (bl) {
            if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_LAST_CATEGORY"))) {
                string3 = "LAST";
            } else if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_FIRST_CATEGORY"))) {
                string3 = "FIRST";
            } else if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_MIDPOINT"))) {
                string3 = "MIDPOINT";
            } else if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_CUTPOINT"))) {
                string3 = "CUTPOINT";
            } else if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_LEVEL"))) {
                string3 = "LEVEL";
            }
            if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_CUTPOINT")) || string.equals(this.getResString("IDS_BINOMIAL_COMBO_LEVEL"))) {
                string3 = string3 + "(" + string2 + ")";
            }
        } else {
            if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_LAST_CATEGORY"))) {
                string3 = "LAST";
            } else if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_FIRST_CATEGORY"))) {
                string3 = "FIRST";
            } else if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_LEVEL"))) {
                string3 = "LEVEL";
            }
            if (string.equals(this.getResString("IDS_BINOMIAL_COMBO_LEVEL"))) {
                string3 = string3 + "(" + string2 + ")";
            }
        }
        return string3;
    }

    class LevelDocument
    extends PlainDocument {
        boolean mIsStringVar;

        LevelDocument() {
        }

        void setIsStringVar(boolean bl) {
            this.mIsStringVar = bl;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            Locale locale = UIToolResUtil.getSPSSLocale();
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            char c = decimalFormatSymbols.getDecimalSeparator();
            try {
                for (int i = cArray.length - 1; i >= 0; --i) {
                    char c2 = cArray[i];
                    if (this.mIsStringVar || Character.isDigit(c2) || c2 == ' ' || c2 == c) {
                        super.insertString(n, String.valueOf(c2), attributeSet);
                        continue;
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    class BayesFactorTable
    extends BayesianBaseDlg.BaseTable {
        BayesFactorTable(TableModel tableModel) {
            super(tableModel);
            this.setupColumns();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl = OneSampleBiBayesianStatsDlg.this.mDistributionRadio.isSelected();
            boolean bl2 = (Boolean)this.getValueAt(n, 1);
            if (n2 == 0) {
                return false;
            }
            if (n2 == 8) {
                String string = (String)this.getValueAt(n, 7);
                return string.equals(OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_CUTPOINT")) || string.equals(OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_LEVEL"));
            }
            if (n2 == 1 || n2 == 5 || n2 == 6) {
                return !bl;
            }
            if (n2 == 2 || n2 == 3) {
                return !bl && !bl2;
            }
            if (n2 == 4) {
                return !bl && bl2;
            }
            return true;
        }

        @Override
        protected boolean validateTable(boolean bl) {
            String string;
            int n;
            boolean bl2 = true;
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            boolean bl3 = OneSampleBiBayesianStatsDlg.this.mDistributionRadio.isSelected();
            String string2 = OneSampleBiBayesianStatsDlg.this.getResString("IDS_NULL_PROP_LABEL");
            block0: for (n = 0; n < defaultTableModel.getRowCount(); ++n) {
                boolean bl4 = (Boolean)defaultTableModel.getValueAt(n, 1);
                if (!bl3) {
                    for (int i = 2; i <= 6; ++i) {
                        string = (String)defaultTableModel.getValueAt(n, i);
                        String string3 = null;
                        if (string.length() == 0) {
                            if (!(i != 2 && i != 3 || bl4)) {
                                string3 = MessageFormat.format(OneSampleBiBayesianStatsDlg.this.getResString("ERR_BINOMIAL_UNCHECKED_VALUE_WARNING"), string2);
                            } else if (i == 4) {
                                if (!bl4) continue;
                                string3 = MessageFormat.format(OneSampleBiBayesianStatsDlg.this.getResString("ERR_BINOMIAL_CHECKED_VALUE_WARNING"), string2);
                            } else {
                                string3 = MessageFormat.format(OneSampleBiBayesianStatsDlg.this.getResString("ERR_BINOMIAL_EMPTY_ALTVALUE_WARNING"), 0);
                            }
                        }
                        if (string3 == null) continue;
                        if (!bl) {
                            this.onDisplayWarning(string3, n, i);
                        }
                        bl2 = false;
                        break block0;
                    }
                }
                String string4 = (String)defaultTableModel.getValueAt(n, 8);
                string = (String)defaultTableModel.getValueAt(n, 7);
                boolean bl5 = string.equals(OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_CUTPOINT"));
                boolean bl6 = string.equals(OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_LEVEL"));
                if (!bl5 && !bl6 || string4.length() != 0) continue;
                if (!bl) {
                    String string5;
                    String string6;
                    if (bl5) {
                        string6 = OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_CUTPOINT");
                        string5 = MessageFormat.format(OneSampleBiBayesianStatsDlg.this.getResString("ERR_BINOMIAL_EMPTY_CUTPOINT_VALUE_WARNING"), string6);
                    } else {
                        string6 = OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_LEVEL");
                        string5 = MessageFormat.format(OneSampleBiBayesianStatsDlg.this.getResString("ERR_BINOMIAL_EMPTY_LEVEL_VALUE_WARNING"), string6);
                    }
                    this.onDisplayWarning(string5, n, 8);
                }
                bl2 = false;
                break;
            }
            if (bl2 && !bl3) {
                for (n = 0; n < defaultTableModel.getRowCount(); ++n) {
                    String string7 = (String)defaultTableModel.getValueAt(n, 2);
                    String string8 = (String)defaultTableModel.getValueAt(n, 3);
                    string = (String)defaultTableModel.getValueAt(n, 5);
                    String string9 = (String)defaultTableModel.getValueAt(n, 6);
                    double d = Double.parseDouble(string7);
                    double d2 = Double.parseDouble(string8);
                    double d3 = Double.parseDouble(string);
                    double d4 = Double.parseDouble(string9);
                    if ((d == 0.0 || d2 == 0.0) && d != d2) {
                        if (!bl) {
                            int n2 = d == 0.0 ? 3 : 2;
                            String string10 = OneSampleBiBayesianStatsDlg.this.getResString("ERR_BI_PO_MSG_NP_ZERO_VALUE_WARNING");
                            this.onDisplayWarning(string10, n, n2);
                        }
                        bl2 = false;
                        break;
                    }
                    if (d3 != 0.0 && d4 != 0.0 || d3 == d4) continue;
                    if (!bl) {
                        int n3 = d3 == 0.0 ? 6 : 5;
                        String string11 = OneSampleBiBayesianStatsDlg.this.getResString("ERR_BI_PO_MSG_ALT_ZERO_VALUE_WARNING");
                        this.onDisplayWarning(string11, n, n3);
                    }
                    bl2 = false;
                    break;
                }
            }
            return bl2;
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            int n3 = this.convertColumnIndexToModel(n2);
            ISpssVariable iSpssVariable = (ISpssVariable)this.getValueAt(n, 0);
            FormatType formatType = iSpssVariable.getFormat().getFormatType();
            if (n3 == 7) {
                SPSS_Format sPSS_Format = iSpssVariable.getFormat();
                FormatType formatType2 = sPSS_Format.getFormatType();
                if (formatType2.isStringFormat()) {
                    return (TableCellEditor)OneSampleBiBayesianStatsDlg.this.mComboEditors.get(1);
                }
                return (TableCellEditor)OneSampleBiBayesianStatsDlg.this.mComboEditors.get(0);
            }
            if (n3 == 8) {
                String string = (String)this.getValueAt(n, 7);
                if (string.equals(OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_CUTPOINT"))) {
                    return (TableCellEditor)OneSampleBiBayesianStatsDlg.this.mCutpointLevelEditors.get(0);
                }
                if (string.equals(OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_LEVEL"))) {
                    BayesianBaseDlg.BaseValueCellEditor baseValueCellEditor = (BayesianBaseDlg.BaseValueCellEditor)OneSampleBiBayesianStatsDlg.this.mCutpointLevelEditors.get(1);
                    LevelDocument levelDocument = (LevelDocument)((StringTextField)((Object)baseValueCellEditor.getComponent())).getDocument();
                    levelDocument.setIsStringVar(!formatType.isNumericFormat());
                    return baseValueCellEditor;
                }
            }
            return super.getCellEditor(n, n2);
        }

        private void setupColumns() {
            TableColumn tableColumn;
            int n;
            TableColumn tableColumn2 = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer();
            tableColumn2.setCellRenderer(varLabelRenderer);
            tableColumn2.setPreferredWidth(60);
            tableColumn2.setMinWidth(60);
            TableColumn tableColumn3 = this.columnModel.getColumn(1);
            tableColumn3.setPreferredWidth(20);
            tableColumn3.setMinWidth(20);
            BayesianBaseDlg.ValueRenderer valueRenderer = new BayesianBaseDlg.ValueRenderer();
            for (n = 2; n <= 4; ++n) {
                tableColumn = this.columnModel.getColumn(n);
                tableColumn.setCellRenderer(valueRenderer);
                tableColumn.setPreferredWidth(50);
                tableColumn.setMinWidth(20);
                if (n == 4) {
                    tableColumn.setCellEditor(new BayesianBaseDlg.FloatValueCellEditor(0.0, 1.0, true, true));
                    continue;
                }
                tableColumn.setCellEditor(new BayesianBaseDlg.FloatValueCellEditor(0.0, Double.NaN, true));
            }
            for (n = 5; n <= 6; ++n) {
                tableColumn = this.columnModel.getColumn(n);
                tableColumn.setCellRenderer(valueRenderer);
                tableColumn.setPreferredWidth(60);
                tableColumn.setMinWidth(20);
                tableColumn.setCellEditor(new BayesianBaseDlg.FloatValueCellEditor(0.0, Double.NaN, true));
            }
            TableColumn tableColumn4 = this.columnModel.getColumn(7);
            tableColumn4.setCellRenderer(valueRenderer);
            tableColumn4.setPreferredWidth(90);
            tableColumn4.setMinWidth(20);
            tableColumn = this.columnModel.getColumn(8);
            tableColumn.setCellRenderer(valueRenderer);
            tableColumn.setCellEditor(new BayesianBaseDlg.FloatValueCellEditor(Double.NaN, Double.NaN, false));
            tableColumn.setPreferredWidth(40);
            tableColumn.setMinWidth(20);
        }
    }

    class BayesFactorVariableDataBag
    extends BayesianBaseDlg.VariableDataBag {
        boolean isPointNull;
        String npShapeValue;
        String npScaleValue;
        String nullPropValue;
        String altShapeValue;
        String altScaleValue;
        String dsCategory;
        String value;

        BayesFactorVariableDataBag(Object object, String string, String string2) {
            super(object);
            this.isPointNull = false;
            this.npShapeValue = "";
            this.npScaleValue = "";
            this.nullPropValue = "";
            this.altShapeValue = "";
            this.altScaleValue = "";
            this.dsCategory = OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_LAST_CATEGORY");
            this.value = "";
            this.npShapeValue = string;
            this.npScaleValue = string2;
        }

        BayesFactorVariableDataBag(ISpssVariable iSpssVariable, boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            super(iSpssVariable);
            this.isPointNull = false;
            this.npShapeValue = "";
            this.npScaleValue = "";
            this.nullPropValue = "";
            this.altShapeValue = "";
            this.altScaleValue = "";
            this.dsCategory = OneSampleBiBayesianStatsDlg.this.getResString("IDS_BINOMIAL_COMBO_LAST_CATEGORY");
            this.value = "";
            this.isPointNull = bl;
            this.npShapeValue = string;
            this.npScaleValue = string2;
            this.nullPropValue = string3;
            this.altShapeValue = string4;
            this.altScaleValue = string5;
            this.dsCategory = string6;
            this.value = string7;
        }
    }
}

