/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BPPriorsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianNormalStatsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.CommonCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.OneSampleBiBayesianStatsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.OneSamplePoBayesianStatsDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class OneSampleBayesianBaseDlg
extends BayesianBaseDlg
implements ListDataListener,
ItemListener {
    public OneSampleBayesianBaseDlg(JFrame jFrame) {
        super(jFrame);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("BAYES")).append(" ONESAMPLE");
        stringBuffer.append("\n");
        this.addBayesianBodySyntax(stringBuffer, dialogDataModel);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return null;
    }

    @Override
    public String getDialogHelpID() {
        return null;
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
    }

    protected String getTotalDataSyntax(DialogDataModel dialogDataModel) {
        return "";
    }

    @Override
    protected int getMiddlePanelRightGap() {
        return 30;
    }

    protected JPanel createDataTablePanel() {
        return null;
    }

    @Override
    protected JPanel createRightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        int n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.createMiddlePanel();
        if (jPanel2 != null) {
            DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, this.getMiddlePanelRightGap()));
        }
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel3 = this.createSideButtonPanel(false);
        n = 12;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(10, 20, 0, 10);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel3);
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(n2, 0, n2, n2);
        JPanel jPanel4 = this.createDataTablePanel();
        if (jPanel4 != null) {
            DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 2, 1, n, insets);
        }
        return jPanel;
    }

    private JPanel createMiddlePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TEST_VARIABLES");
        int n = 18;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        jLabel.setLabelFor(this.mTargetVarList);
        JPanel jPanel2 = this.createAnalysisPanel();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, new Insets(n2, 0, 0, 0));
        return jPanel;
    }

    @Override
    protected void initVars() {
        super.initVars();
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setIdentifier("OneSampleBaseTargetVarList");
        this.mTargetVarList.setMaxLimitOfList(500);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 7 + 2));
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    protected void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mAnalysisGroup);
        vector.add(this.mDataTable);
        vector.add(this.mCriteriaButton);
        vector.add(this.mPriorsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object instanceof VarListModel) {
            ISpssVariable iSpssVariable = ((VarListModel)object).getMovedVar();
            this.addToDataTable(iSpssVariable);
        }
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object instanceof VarListModel) {
            ISpssVariable iSpssVariable = ((VarListModel)object).getMovedVar();
            this.removeFromDataTable(iSpssVariable);
        }
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    protected void addToDataTable(Object object) {
    }

    protected String getDATASyntaxSubsets(Vector vector) {
        return "";
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.mTargetVarList.getModel().addListDataListener(this);
    }

    protected void addBayesianBodySyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        stringBuffer.append(CommonCriteriaSubDlg.getCommonCriteriaDlgSyntax(dialogDataModel, this.mDistributionRadio.isSelected()));
        stringBuffer.append(SyntaxUtil.getSubCommand("/INFERENCE"));
        stringBuffer.append(" DISTRIBUTION=");
        String string = this instanceof OneSampleBiBayesianStatsDlg ? "BINOMIAL" : (this instanceof OneSamplePoBayesianStatsDlg ? "POISSON" : "NORMAL");
        stringBuffer.append(string);
        if (this.mTargetVarList.getModel().getSize() > 0) {
            stringBuffer.append(" VARIABLES=").append(this.mTargetVarList.getVariablesStringList());
        }
        Boolean bl = dialogDataModel.getBoolean("IDS_BAYES_FACTOR");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_USE_BOTH");
        string = bl != null && bl != false ? "BAYESFACTOR" : (bl2 != null && bl2 != false ? "BOTH" : "POSTERIOR");
        stringBuffer.append(" ANALYSIS=").append(string);
        if (this instanceof OneSampleBiBayesianStatsDlg || this instanceof OneSamplePoBayesianStatsDlg) {
            boolean bl3 = dialogDataModel.getBoolean("IDS_BAYES_FACTOR");
            if (!bl3) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/PRIOR"));
                stringBuffer.append(BPPriorsSubDlg.getBPPriorsDlgSyntax(dialogDataModel));
            }
        } else {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRIOR"));
            stringBuffer.append(((BayesianNormalStatsDlg)this).getNormalPriorsDlgSyntax(dialogDataModel));
        }
        stringBuffer.append(this.getTotalDataSyntax(dialogDataModel));
    }

    static class SimpleHeaderRenderer
    extends DefaultTableCellRenderer {
        SimpleHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!jTable.isEnabled()) {
                component.setForeground(Color.gray);
            } else {
                component.setForeground(Color.black);
            }
            if (n == -1) {
                JTableHeader jTableHeader = jTable.getTableHeader();
                if (jTableHeader != null) {
                    if (jTable.isEnabled()) {
                        this.setForeground(jTableHeader.getForeground());
                    }
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                    this.setHorizontalAlignment(2);
                    this.getAccessibleContext().setAccessibleName(BayesianBaseDlg.htmlToPlainText(object.toString()));
                }
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
            return component;
        }
    }
}

