/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NormalPriorsSubDlg
extends BaseSubDialog
implements ItemListener,
ActionListener,
DocumentListener {
    private static final String PRIOR_DISTRIBUTION = "IDS_NORMAL_PRIORS_DISTRIBUTION";
    private static final String PRIORS_VARIANCE = "IDS_NORMAL_PRIORS_VARIANCE";
    private static final String PRIORS_PRECISION = "IDS_NORMAL_PRIORS_PRECISION";
    private static final String INF_SHAPE_PARAM = "IDS_INF_SHAPE_PARAM";
    private static final String INF_SCALE_PARAM = "IDS_INF_SCALE_PARAM";
    private static final String PRIORS_NORMAL = "IDS_PRIORS_NORMAL";
    private static final String PRIORS_DIFFUSE = "IDS_PRIORS_DIFFUSE";
    private static final String PRIORS_LOCATION_PARAM = "IDS_PRIORS_LOCATION_PARAM";
    private static final String PRIORS_SCALE_PARAM = "IDS_PRIORS_SCALE_PARAM";
    private static final String PRIORS_KAPPA = "IDS_PRIORS_KAPPA";
    private JRadioButton mVarianceRadio;
    private JRadioButton mPrecisionRadio;
    private SpssButtonGroup mVPGroup;
    private JLabel mPriorDistLabel;
    private JComboBox<String> mPriorDistCombo;
    private JLabel mInfShapeParamLabel;
    private FloatTextField mInfShapeParamField;
    private JLabel mInfScaleParamLabel;
    private FloatTextField mInfScaleParamField;
    private JRadioButton mNormalRadio;
    private JRadioButton mDiffuseRadio;
    private SpssButtonGroup mNDGroup;
    private JLabel mLocationParamLabel;
    private FloatTextField mLocationParamField;
    private JLabel mPriorScaleParamLabel;
    private FloatTextField mPriorScaleParamField;
    private JLabel mKappaLabel;
    private FloatTextField mKappaField;
    private boolean mAtLeastOneVarianceKnownDeselected = false;
    private boolean mAtLeastOneVarianceKnownSelected = false;

    public NormalPriorsSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, boolean bl2) {
        super(baseProcedureDialog, string, true);
        this.mAtLeastOneVarianceKnownDeselected = bl;
        this.mAtLeastOneVarianceKnownSelected = bl2;
        this.setDefaults();
        this.addListeners();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_onesample_normal_priors";
    }

    public static String getNormalPriorsDlgSyntax(DialogDataModel dialogDataModel, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NormalPriorsSubDlg.getPriorsDistSyntaxPortion(dialogDataModel, bl, bl2));
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVPGroup);
        vector.add(this.mPriorDistCombo);
        vector.add(this.mInfShapeParamField);
        vector.add(this.mInfScaleParamField);
        vector.add(this.mNDGroup);
        vector.add(this.mLocationParamField);
        vector.add(this.mPriorScaleParamField);
        vector.add(this.mKappaField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupPanel(JPanel jPanel) {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = 23;
        JPanel jPanel2 = this.createInfPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        JPanel jPanel3 = this.createPriorsPanel();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
    }

    protected void initVars() {
        this.mVarianceRadio = new JRadioButton(new ToggleButtonAction(this, PRIORS_VARIANCE));
        this.mPrecisionRadio = new JRadioButton(new ToggleButtonAction(this, PRIORS_PRECISION));
        this.mVPGroup = new SpssButtonGroup();
        this.mVPGroup.add(this.mVarianceRadio);
        this.mVPGroup.add(this.mPrecisionRadio);
        this.mPriorDistCombo = new JComboBox();
        ComboboxAction comboboxAction = new ComboboxAction(this, PRIOR_DISTRIBUTION);
        this.mPriorDistCombo.setAction(comboboxAction);
        this.mInfShapeParamField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mInfShapeParamField.setIncludeMinRange(false);
        this.mInfShapeParamField.setIncludeMaxRange(false);
        this.mInfShapeParamField.setAction((Action)new TextFieldAction(this.mParentDlg, INF_SHAPE_PARAM));
        this.mInfShapeParamField.setColumns(10);
        this.mInfScaleParamField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mInfScaleParamField.setIncludeMinRange(false);
        this.mInfScaleParamField.setIncludeMaxRange(false);
        this.mInfScaleParamField.setAction((Action)new TextFieldAction(this.mParentDlg, INF_SCALE_PARAM));
        this.mInfScaleParamField.setColumns(10);
        this.mNormalRadio = new JRadioButton(new ToggleButtonAction(this, PRIORS_NORMAL));
        this.mDiffuseRadio = new JRadioButton(new ToggleButtonAction(this, PRIORS_DIFFUSE));
        this.mNDGroup = new SpssButtonGroup();
        this.mNDGroup.add(this.mNormalRadio);
        this.mNDGroup.add(this.mDiffuseRadio);
        this.mLocationParamField = new FloatTextField(Double.NaN, Double.NaN, 5, false);
        this.mLocationParamField.setAction((Action)new TextFieldAction(this.mParentDlg, PRIORS_LOCATION_PARAM));
        this.mLocationParamField.setColumns(10);
        this.mLocationParamField.setIncludeMinRange(false);
        this.mLocationParamField.setIncludeMaxRange(false);
        this.mPriorScaleParamField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mPriorScaleParamField.setIncludeMinRange(false);
        this.mPriorScaleParamField.setIncludeMaxRange(false);
        this.mPriorScaleParamField.setAction((Action)new TextFieldAction(this.mParentDlg, PRIORS_SCALE_PARAM));
        this.mPriorScaleParamField.setColumns(10);
        this.mKappaField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mKappaField.setAction((Action)new TextFieldAction(this.mParentDlg, PRIORS_KAPPA));
        this.mKappaField.setColumns(10);
        this.mKappaField.setIncludeMinRange(false);
        this.mKappaField.setIncludeMaxRange(false);
    }

    private void addListeners() {
        this.mPriorDistCombo.addActionListener(this);
        this.mVarianceRadio.addItemListener(this);
        this.mPrecisionRadio.addItemListener(this);
        this.mNormalRadio.addItemListener(this);
        this.mDiffuseRadio.addItemListener(this);
        this.mInfShapeParamField.getDocument().addDocumentListener(this);
        this.mInfScaleParamField.getDocument().addDocumentListener(this);
        this.mLocationParamField.getDocument().addDocumentListener(this);
        this.mPriorScaleParamField.getDocument().addDocumentListener(this);
        this.mKappaField.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mVarianceRadio.setSelected(true);
        this.mDiffuseRadio.setSelected(true);
        this.onEnteringDialog();
    }

    private void onEnteringDialog() {
        this.mVarianceRadio.setEnabled(this.mAtLeastOneVarianceKnownDeselected);
        this.mPrecisionRadio.setEnabled(this.mAtLeastOneVarianceKnownDeselected);
        this.mPriorDistLabel.setEnabled(this.mAtLeastOneVarianceKnownDeselected);
        this.mPriorDistCombo.setEnabled(this.mAtLeastOneVarianceKnownDeselected);
        this.mInfShapeParamLabel.setEnabled(true);
        this.mInfShapeParamField.setEnabled(true);
        this.mInfScaleParamLabel.setEnabled(true);
        this.mInfScaleParamField.setEnabled(true);
        this.mNormalRadio.setEnabled(true);
        this.mDiffuseRadio.setEnabled(true);
        this.onVarianceRadio();
        this.onNormalRadio();
    }

    private void onVarianceRadio() {
        String[] stringArray;
        int n = this.mPriorDistCombo.getSelectedIndex();
        this.mPriorDistCombo.removeAllItems();
        boolean bl = this.mVarianceRadio.isSelected();
        for (String string : stringArray = this.getResStringArray(bl ? "IDS_NORMAL_PRIORS_DISTR_VARIANCE_ARRAY" : "IDS_NORMAL_PRIORS_DISTR_PRECISION_ARRAY")) {
            this.mPriorDistCombo.addItem(string);
        }
        if (n > -1 && n < stringArray.length) {
            this.mPriorDistCombo.setSelectedIndex(n);
        }
        this.onComboSelection();
    }

    private void onNormalRadio() {
        boolean bl = this.mNormalRadio.isSelected();
        this.mLocationParamLabel.setEnabled(bl);
        this.mLocationParamField.setEnabled(bl);
        this.mPriorScaleParamLabel.setEnabled(this.mAtLeastOneVarianceKnownSelected && bl);
        this.mPriorScaleParamField.setEnabled(this.mAtLeastOneVarianceKnownSelected && bl);
        this.mKappaLabel.setEnabled(bl);
        this.mKappaField.setEnabled(bl);
    }

    private void onComboSelection() {
        boolean bl = this.mVarianceRadio.isSelected();
        int n = this.mPriorDistCombo.getSelectedIndex();
        boolean bl2 = bl && (n == 1 || n == 2) || !bl && (n == 0 || n == 1);
        this.mInfShapeParamField.setEnabled(bl2);
        this.mInfShapeParamLabel.setEnabled(bl2);
        boolean bl3 = bl && (n == 1 || n == 2) || !bl && n == 0;
        this.mInfScaleParamField.setEnabled(bl3);
        this.mInfScaleParamLabel.setEnabled(bl3);
    }

    private JPanel createInfPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_INFERENCE_PARAMETER_TITLE")));
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mVarianceRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPrecisionRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mPriorDistLabel = DialogUtil.createLabel(this, PRIOR_DISTRIBUTION);
        DialogUtil.addUsingGBL(jPanel, this.mPriorDistLabel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mPriorDistLabel.setLabelFor(this.mPriorDistCombo);
        DialogUtil.addUsingGBL(jPanel, this.mPriorDistCombo, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.mInfShapeParamLabel = DialogUtil.createLabel(this, INF_SHAPE_PARAM);
        this.mInfShapeParamLabel.setLabelFor((Component)this.mInfShapeParamField);
        DialogUtil.addUsingGBL(jPanel, this.mInfShapeParamLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mInfShapeParamField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.mInfScaleParamLabel = DialogUtil.createLabel(this, INF_SCALE_PARAM);
        this.mInfScaleParamLabel.setLabelFor((Component)this.mInfScaleParamField);
        DialogUtil.addUsingGBL(jPanel, this.mInfScaleParamLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mInfScaleParamField, gridBagConstraints, 1, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createPriorsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PRIORS_GROUP_TITLE")));
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNormalRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDiffuseRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mLocationParamLabel = DialogUtil.createLabel(this, PRIORS_LOCATION_PARAM);
        this.mLocationParamLabel.setLabelFor((Component)this.mLocationParamField);
        DialogUtil.addUsingGBL(jPanel, this.mLocationParamLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLocationParamField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.mPriorScaleParamLabel = DialogUtil.createLabel(this, PRIORS_SCALE_PARAM);
        this.mPriorScaleParamLabel.setLabelFor((Component)this.mPriorScaleParamField);
        DialogUtil.addUsingGBL(jPanel, this.mPriorScaleParamLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPriorScaleParamField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.mKappaLabel = DialogUtil.createLabel(this, PRIORS_KAPPA);
        this.mKappaLabel.setLabelFor((Component)this.mKappaField);
        DialogUtil.addUsingGBL(jPanel, this.mKappaLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mKappaField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        return jPanel;
    }

    private static String getPriorsDistSyntaxPortion(DialogDataModel dialogDataModel, boolean bl, boolean bl2) {
        String string;
        String string2;
        Object object;
        Boolean bl3;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            bl3 = dialogDataModel.containsBooleanKey(PRIORS_PRECISION) ? dialogDataModel.getBoolean(PRIORS_PRECISION) : false;
            object = dialogDataModel.getInteger(PRIOR_DISTRIBUTION) != null ? dialogDataModel.getInteger(PRIOR_DISTRIBUTION) : 0;
            string2 = dialogDataModel.getString(INF_SHAPE_PARAM);
            string = dialogDataModel.getString(INF_SCALE_PARAM);
            if (!bl3.booleanValue()) {
                stringBuffer.append(" VARDIST=");
                if ((Integer)object == 0) {
                    stringBuffer.append("DIFFUSE");
                } else if ((Integer)object == 1 || (Integer)object == 2) {
                    stringBuffer.append((Integer)object == 1 ? "INVCHISQ(" : "INVGAMMA(");
                    stringBuffer.append(string2).append(" ");
                    stringBuffer.append(string).append(")");
                } else {
                    stringBuffer.append((Integer)object == 3 ? "JEFFREYS2" : "JEFFREYS4");
                }
            } else {
                stringBuffer.append(" PRECDIST=");
                if ((Integer)object == 0) {
                    stringBuffer.append("GAMMA(");
                    stringBuffer.append(string2).append(" ");
                    stringBuffer.append(string).append(")");
                } else if ((Integer)object == 1) {
                    stringBuffer.append("CHISQ(");
                    stringBuffer.append(string2).append(")");
                }
            }
        }
        bl3 = dialogDataModel.containsBooleanKey(PRIORS_NORMAL) ? dialogDataModel.getBoolean(PRIORS_NORMAL) : false;
        stringBuffer.append(" MEANDIST=");
        if (!bl3.booleanValue()) {
            stringBuffer.append("DIFFUSE");
        } else {
            stringBuffer.append("NORMAL").append("(");
            object = dialogDataModel.getString(PRIORS_LOCATION_PARAM);
            string2 = dialogDataModel.getString(PRIORS_SCALE_PARAM);
            stringBuffer.append((String)object);
            if (bl2) {
                stringBuffer.append(" ").append(string2);
            }
            stringBuffer.append(")");
            stringBuffer.append(" KAPPA=");
            string = dialogDataModel.getString(PRIORS_KAPPA);
            stringBuffer.append(string != null && string.length() > 0 ? string : "1");
        }
        return stringBuffer.toString();
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        if (this.mInfShapeParamField.isEnabled()) {
            boolean bl2 = bl = this.mInfShapeParamField.getText().length() > 0;
        }
        if (bl && this.mInfScaleParamField.isEnabled()) {
            boolean bl3 = bl = this.mInfScaleParamField.getText().length() > 0;
        }
        if (bl && this.mLocationParamField.isEnabled()) {
            boolean bl4 = bl = this.mLocationParamField.getText().length() > 0;
        }
        if (bl && this.mPriorScaleParamField.isEnabled()) {
            boolean bl5 = bl = this.mPriorScaleParamField.getText().length() > 0;
        }
        if (bl && this.mKappaField.isEnabled()) {
            bl = this.mKappaField.getText().length() > 0;
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object = itemEvent.getSource();
            if (object == this.mNormalRadio || object == this.mDiffuseRadio) {
                this.onNormalRadio();
                this.enableContinue(this.canEnableContinue());
            } else if (object == this.mVarianceRadio || object == this.mPrecisionRadio) {
                this.onVarianceRadio();
                this.enableContinue(this.canEnableContinue());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mPriorDistCombo) {
            this.onComboSelection();
            this.enableContinue(this.canEnableContinue());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

