/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.LogLinearBayesFactorSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.LogLinearPrintSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.PearsonCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.ScanBaseDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LogLinearStatsDlg
extends ScanBaseDlg
implements ListDataListener {
    static final String LOGLINEAR_ROW_VAR_LIST = "IDS_LOG_LINEAR_ROW_VAR_LIST";
    static final String LOGLINEAR_COL_VAR_LIST = "IDS_LOG_LINEAR_COL_VAR_LIST";
    private ArrowButton mRowVarListArrow;
    private ArrowButton mColVarListArrow;
    private TargetVariableList mRowVarList;
    private TargetVariableList mColVarList;

    public LogLinearStatsDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getResString("IDS_LOG_LINEAR_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("BAYES")).append(" LOGLINEAR");
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/TABLE "));
        stringBuffer.append(this.mRowVarList.getVariablesStringList());
        String string = this.mColVarList.getVariablesStringList();
        stringBuffer.append(" BY ").append(string);
        stringBuffer.append("\n");
        this.addBayesianBodySyntax(stringBuffer, dialogDataModel);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    protected void addBayesianBodySyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        PearsonCriteriaSubDlg.addCriteriaSyntax(dialogDataModel, stringBuffer, this.mDistributionRadio.isSelected(), this.mBayesFactorRadio.isSelected(), true);
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/INFERENCE"));
        String string = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_BAYES_FACTOR");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_USE_BOTH");
        string = bl != null && bl != false ? "BAYESFACTOR" : (bl2 != null && bl2 != false ? "BOTH" : "POSTERIOR");
        stringBuffer.append(" ANALYSIS=").append(string);
        stringBuffer.append(LogLinearPrintSubDlg.getPrintDlgSyntax(dialogDataModel));
        stringBuffer.append(LogLinearBayesFactorSubDlg.getBFDlgSyntax(dialogDataModel, this.mDistributionRadio.isSelected()));
    }

    @Override
    public String getIActionKey() {
        return "analyze_bayesian_log_linear";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_loglinear";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.mRowVarList.getModel().getSize() > 0 && this.mColVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mRowVarList.getModel().getSize() > 0 && this.mColVarList.getModel().getSize() > 0) {
            this.enableOkPaste(false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected boolean okPastePressed() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = !this.mDistributionRadio.isSelected() && dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_MULTI") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_MULTI") : true;
        Boolean bl2 = !this.mDistributionRadio.isSelected() && dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_NONPARAM") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_NONPARAM") : false;
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_CONJUGATE") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_CONJUGATE") : false;
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_LOGLINEAR_BF_ROW_VAR_ARRAY_KEY");
        ISpssVariable[] iSpssVariableArray2 = dialogDataModel.getVarArray("IDS_LOGLINEAR_BF_COL_VAR_ARRAY_KEY");
        if ((bl.booleanValue() && bl3.booleanValue() || bl2.booleanValue()) && (this.isScanVarModelChanged(iSpssVariableArray, this.mRowVarList.getModel()) || this.isScanVarModelChanged(iSpssVariableArray2, this.mColVarList.getModel()))) {
            dialogDataModel.putObject("IDS_LOGLINEAR_SP_TABLE_VECTOR", null);
            dialogDataModel.putObject("IDS_LOGLINEAR_DIR_TABLE_VECTOR", null);
            return true;
        }
        return super.okPastePressed();
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.mRowVarList.removeAll();
        this.mColVarList.removeAll();
        this.enableOkPaste(false);
    }

    @Override
    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("IDS_LOG_LINEAR_SRC_VAR_LIST");
        this.mDistributionRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_DISTRIBUTION"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearStatsDlg.this.onAnalysisRadio();
            }
        });
        this.mBayesFactorRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BAYES_FACTOR"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearStatsDlg.this.onAnalysisRadio();
            }
        });
        this.mUseBothRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_USE_BOTH"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearStatsDlg.this.onAnalysisRadio();
            }
        });
        this.mAnalysisGroup = new SpssButtonGroup();
        this.mAnalysisGroup.add(this.mDistributionRadio);
        this.mAnalysisGroup.add(this.mBayesFactorRadio);
        this.mAnalysisGroup.add(this.mUseBothRadio);
        this.mRowVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mRowVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowVarList.getModel().addListDataListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.mRowVarList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mRowVarList.getMinimumSize());
        this.mRowVarList.setIdentifier(LOGLINEAR_ROW_VAR_LIST);
        this.mRowVarList.addVarFilter(new SpssVarFilter(4, true, false));
        this.mColVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mColVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mColVarList.getModel().addListDataListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.mColVarList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mColVarList.getMinimumSize());
        this.mColVarList.setIdentifier(LOGLINEAR_COL_VAR_LIST);
        this.mColVarList.addVarFilter(new SpssVarFilter(4, true, false));
        this.mRowVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowVarListArrow.registerVariableList(this.mRowVarList, SpssArrowButton.ButtonOrientation.left);
        this.mColVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColVarListArrow.registerVariableList(this.mColVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void setupPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_LOG_LINEAR_ROW_VAR");
        jLabel.setLabelFor(this.mRowVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_LOG_LINEAR_COL_VAR");
        jLabel2.setLabelFor(this.mColVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_BAYESIAN_SOURCE_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 8, n, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRowVarListArrow, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mRowVarList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mRowVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mColVarListArrow, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        JScrollPane jScrollPane3 = new JScrollPane(this.mColVarList);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        jScrollPane3.setPreferredSize(this.mColVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.createAnalysisPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 4, 1, 1, n, insets);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = this.createSideButtonPanel(true);
        this.mPriorsButton.setVisible(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_LOG_LINEAR_PRINT_BTN"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearStatsDlg.this.onPrintButton();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.top + insets.bottom;
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(jButton);
        return jPanel;
    }

    @Override
    protected ArrayList<ISpssVariable> getScanVariables() {
        int n;
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (n = 0; n < this.mRowVarList.getModel().getSize(); ++n) {
            arrayList.add(this.mRowVarList.getModel().getElementAt(n));
        }
        for (n = 0; n < this.mColVarList.getModel().getSize(); ++n) {
            arrayList.add(this.mColVarList.getModel().getElementAt(n));
        }
        return arrayList;
    }

    @Override
    protected void onCriteriaButton() {
        this.runSubDialog(new PearsonCriteriaSubDlg(this, this.getResString("IDS_LOG_LINEAR_CREITERIA_TITLE"), this.mBayesFactorRadio.isSelected(), this.mDistributionRadio.isSelected(), true, "idh_bayesian_loglinear_criteria"));
    }

    @Override
    protected void onBayesFactorButton() {
        this.mScanVariables = this.getScanVariables();
        if (this.mScanVariables.size() == 0 || !this.needScanning(this.mRowVarList.getModel(), this.mColVarList.getModel())) {
            new LogLinearBayesFactorSubDlg((BaseProcedureDialog)this, this.getResString("IDS_LOG_LINEAR_BF_TITLE"), this.mDistributionRadio.isSelected(), this.mRowVarList.getModel(), this.mColVarList.getModel());
            return;
        }
        this.performScanning(this);
        do {
            System.out.println("Proceeding Scanning......");
        } while (!this.mScanFinished);
        System.out.println("mScanFinished - 1");
        new LogLinearBayesFactorSubDlg((BaseProcedureDialog)this, this.getResString("IDS_LOG_LINEAR_BF_TITLE"), this.mDistributionRadio.isSelected(), this.mRowVarList.getModel(), this.mColVarList.getModel());
        this.mScanFinished = false;
    }

    protected void onPrintButton() {
        new LogLinearPrintSubDlg(this, this.getResString("IDS_LOG_LINEAR_PRINT_TITLE"));
    }

    @Override
    public void finishedScanning(CoreFrequencies coreFrequencies) {
        super.finishedScanning(coreFrequencies);
        this.mScanFinished = true;
    }

    @Override
    protected void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mRowVarListArrow);
        vector.add(this.mRowVarList);
        vector.add(this.mColVarListArrow);
        vector.add(this.mColVarList);
        vector.add(this.mAnalysisGroup);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }
}

