/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRPriorsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.ScanBaseDlg;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ScannedVariable;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class LogLinearBayesFactorSubDlg
extends BaseSubDialog {
    private static final String LOGLINEAR_SP_TABLE_VECTOR_KEY = "IDS_LOGLINEAR_SP_TABLE_VECTOR";
    private static final String LOGLINEAR_DIR_TABLE_VECTOR_KEY = "IDS_LOGLINEAR_DIR_TABLE_VECTOR";
    public static final String LOGLINEAR_BF_ROW_VAR_ARRAY_KEY = "IDS_LOGLINEAR_BF_ROW_VAR_ARRAY_KEY";
    public static final String LOGLINEAR_BF_COL_VAR_ARRAY_KEY = "IDS_LOGLINEAR_BF_COL_VAR_ARRAY_KEY";
    private JRadioButton mPoissonRadio;
    private JRadioButton mMultinomialRadio;
    private JRadioButton mNonparametricRadio;
    private SpssButtonGroup mPMNGroup;
    private JRadioButton mMGrandRadio;
    private JRadioButton mMRowRadio;
    private JRadioButton mMColumnRadio;
    private SpssButtonGroup mGRCGroup;
    private JRadioButton mConjugateRadio;
    private JRadioButton mMixtureRadio;
    private JRadioButton mIntrinsicRadio;
    private SpssButtonGroup mCMIGroup;
    private JRadioButton mNRowRadio;
    private JRadioButton mNColumnRadio;
    private SpssButtonGroup mRCGroup;
    private JLabel mShapeParamsTableLabel;
    private ShapeParamsTable mShapeParamsTable;
    private JButton mShapeParamsTableResetButton;
    private JLabel mScaleParamLabel;
    private FloatTextField mScaleParamField;
    private JLabel mDirichletTableLabel;
    private DirichletTable mDirichletTable;
    private JButton mDirichletTableResetButton;
    private boolean mIsDistRadioSelected;
    private VarListModel mRowVarModel;
    private VarListModel mColVarModel;
    private Vector mShapeParamsTableVector;
    private Vector mDirichletTableVector;
    private ScanBaseDlg mScanBaseDlg;

    public LogLinearBayesFactorSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, VarListModel varListModel, VarListModel varListModel2) {
        super(baseProcedureDialog, string, true);
        this.mIsDistRadioSelected = bl;
        this.mRowVarModel = varListModel;
        this.mColVarModel = varListModel2;
        this.mScanBaseDlg = (ScanBaseDlg)this.mParentDlg;
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_loglinear_bayes";
    }

    @Override
    public boolean continuePressed() {
        return !(!this.mIsDistRadioSelected && (this.mShapeParamsTable.isEnabled() && !this.mShapeParamsTable.validateTable(false) || this.mDirichletTable.isEnabled() && !this.mDirichletTable.validateTable(false)) || !super.continuePressed());
    }

    public static String getBFDlgSyntax(DialogDataModel dialogDataModel, boolean bl) {
        if (bl) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/ESTBF"));
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_POISSON") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_POISSON") : false;
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_MULTI") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_MULTI") : true;
        Boolean bl4 = dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_GRAND") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_GRAND") : true;
        Boolean bl5 = dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_MROW") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_MROW") : false;
        Boolean bl6 = dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_CONJUGATE") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_CONJUGATE") : true;
        Boolean bl7 = dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_MIXTURE") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_MIXTURE") : false;
        Boolean bl8 = dialogDataModel.containsBooleanKey("IDS_LOG_LINEAR_BF_NROW") ? dialogDataModel.getBoolean("IDS_LOG_LINEAR_BF_NROW") : false;
        stringBuffer.append(" MODEL=").append(bl2 != false ? "POISSON" : (bl3 != false ? "MULTINOMIAL" : "NONPARAMETRIC"));
        if (bl3.booleanValue()) {
            stringBuffer.append(" FIX_MARGIN=").append(bl4 != false ? "TOTAL" : (bl5 != false ? "ROW" : "COLUMN"));
            stringBuffer.append(" PRIOR_TYPE=").append(bl6 != false ? "CONJUGATE" : (bl7 != false ? "MIXTURE_DIRICHLET" : "INTRINSIC"));
            if (bl6.booleanValue()) {
                stringBuffer.append(" SHAPEPARAMS=");
                stringBuffer.append(LogLinearBayesFactorSubDlg.getTableSyntaxValues(dialogDataModel, LOGLINEAR_SP_TABLE_VECTOR_KEY, false));
            }
        } else if (bl2.booleanValue()) {
            stringBuffer.append(" SHAPEPARAMS=");
            stringBuffer.append(LogLinearBayesFactorSubDlg.getTableSyntaxValues(dialogDataModel, LOGLINEAR_SP_TABLE_VECTOR_KEY, false));
            String string = dialogDataModel.getString("IDS_LOG_LINEAR_BF_SCALE_PARAM");
            String string2 = string != null && string.length() > 0 ? string : "DATA";
            stringBuffer.append(" SCALEPARAM=").append(string2);
        } else {
            stringBuffer.append(" FIX_MARGIN=").append(bl8 != false ? "ROW" : "COLUMN");
            stringBuffer.append(" LAMBDAS=").append(LogLinearBayesFactorSubDlg.getTableSyntaxValues(dialogDataModel, LOGLINEAR_DIR_TABLE_VECTOR_KEY, true));
        }
        return stringBuffer.toString();
    }

    private static String getTableSyntaxValues(DialogDataModel dialogDataModel, String string, boolean bl) {
        Vector vector = (Vector)dialogDataModel.getObject(string);
        if (vector == null) {
            return "1";
        }
        String string2 = (String)((Vector)vector.get(0)).get(1);
        boolean bl2 = false;
        block0: for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.get(i);
            for (int j = 1; j < vector2.size(); ++j) {
                String string3 = (String)vector2.get(j);
                if (string3 == null || string3.length() <= 0 || string2.equals(string3)) continue;
                bl2 = true;
                break block0;
            }
        }
        if (!bl2) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector3 = (Vector)vector.get(i);
            for (int j = 1; j < vector3.size(); ++j) {
                String string4 = (String)vector3.get(j);
                if (string4 == null || string4.length() <= 0) continue;
                stringBuffer.append(string4);
                if (j >= vector3.size() - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.trimToSize();
            if (i >= vector.size() - 1) continue;
            stringBuffer.append(!bl ? ";" : " ");
        }
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mShapeParamsTableVector = (Vector)dialogDataModel.getObject(LOGLINEAR_SP_TABLE_VECTOR_KEY);
        this.mDirichletTableVector = (Vector)dialogDataModel.getObject(LOGLINEAR_DIR_TABLE_VECTOR_KEY);
        if (this.mShapeParamsTableVector != null && this.mShapeParamsTable != null) {
            this.mShapeParamsTable.reloadTable(this.mShapeParamsTableVector);
        }
        if (this.mDirichletTableVector != null && this.mDirichletTable != null) {
            this.mDirichletTable.reloadTable(this.mDirichletTableVector);
        }
        this.onMultinomial();
        this.onNonparametric();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putVarArray(LOGLINEAR_BF_ROW_VAR_ARRAY_KEY, BULRPriorsSubDlg.getVarArray(this.mRowVarModel));
        dialogDataModel.putVarArray(LOGLINEAR_BF_COL_VAR_ARRAY_KEY, BULRPriorsSubDlg.getVarArray(this.mColVarModel));
        if (this.mShapeParamsTable != null) {
            this.mShapeParamsTableVector = ((DefaultTableModel)this.mShapeParamsTable.getModel()).getDataVector();
            dialogDataModel.putObject(LOGLINEAR_SP_TABLE_VECTOR_KEY, this.mShapeParamsTableVector);
        }
        if (this.mDirichletTable != null) {
            this.mDirichletTableVector = ((DefaultTableModel)this.mDirichletTable.getModel()).getDataVector();
            dialogDataModel.putObject(LOGLINEAR_DIR_TABLE_VECTOR_KEY, this.mDirichletTableVector);
        }
        return super.saveState(dialogDataModel);
    }

    private void initVars() {
        this.mPoissonRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_POISSON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onMultinomial();
                LogLinearBayesFactorSubDlg.this.onNonparametric();
            }
        });
        this.mMultinomialRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_MULTI"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onMultinomial();
                LogLinearBayesFactorSubDlg.this.onNonparametric();
            }
        });
        this.mNonparametricRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_NONPARAM"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onMultinomial();
                LogLinearBayesFactorSubDlg.this.onNonparametric();
            }
        });
        this.mPMNGroup = new SpssButtonGroup();
        this.mPMNGroup.add(this.mPoissonRadio);
        this.mPMNGroup.add(this.mMultinomialRadio);
        this.mPMNGroup.add(this.mNonparametricRadio);
        this.mMGrandRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_GRAND"));
        this.mMRowRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_MROW"));
        this.mMColumnRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_MCOLUMN"));
        this.mGRCGroup = new SpssButtonGroup();
        this.mGRCGroup.add(this.mMGrandRadio);
        this.mGRCGroup.add(this.mMRowRadio);
        this.mGRCGroup.add(this.mMColumnRadio);
        this.mConjugateRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_CONJUGATE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onConjugate(LogLinearBayesFactorSubDlg.this.mMultinomialRadio.isSelected(), LogLinearBayesFactorSubDlg.this.mPoissonRadio.isSelected());
            }
        });
        this.mMixtureRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_MIXTURE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onConjugate(LogLinearBayesFactorSubDlg.this.mMultinomialRadio.isSelected(), LogLinearBayesFactorSubDlg.this.mPoissonRadio.isSelected());
            }
        });
        this.mIntrinsicRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_INTRINSIC"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onConjugate(LogLinearBayesFactorSubDlg.this.mMultinomialRadio.isSelected(), LogLinearBayesFactorSubDlg.this.mPoissonRadio.isSelected());
            }
        });
        this.mCMIGroup = new SpssButtonGroup();
        this.mCMIGroup.add(this.mConjugateRadio);
        this.mCMIGroup.add(this.mMixtureRadio);
        this.mCMIGroup.add(this.mIntrinsicRadio);
        this.mNRowRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_NROW"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onRowColSum();
            }
        });
        this.mNColumnRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_LOG_LINEAR_BF_NCOLUMN"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onRowColSum();
            }
        });
        this.mRCGroup = new SpssButtonGroup();
        this.mRCGroup.add(this.mNRowRadio);
        this.mRCGroup.add(this.mNColumnRadio);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_PRIORS_RESET", "IDK_BULR_PRIORS_MEAN_RESET_KEY"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onResetButton(true);
            }
        };
        this.mDirichletTableResetButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_PRIORS_RESET", "IDK_BULR_PRIORS_VCM_RESET_KEY"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogLinearBayesFactorSubDlg.this.onResetButton(false);
            }
        };
        this.mShapeParamsTableResetButton = new JButton(toggleButtonAction);
        this.mScaleParamField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mScaleParamField.setIncludeMinRange(false);
        this.mScaleParamField.setIncludeMaxRange(false);
        this.mScaleParamField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_LOG_LINEAR_BF_SCALE_PARAM"));
        this.mScaleParamField.setColumns(8);
        this.mShapeParamsTableLabel = DialogUtil.createLabel(this, "IDS_LOG_LINEAR_BF_SHAPE_PARAM");
    }

    private void onResetButton(boolean bl) {
        if (bl) {
            this.mDirichletTable.resetTable();
        } else {
            this.mShapeParamsTable.resetTable();
        }
    }

    private void setDefaults() {
        this.mMultinomialRadio.setSelected(true);
        this.mMGrandRadio.setSelected(true);
        this.mNRowRadio.setSelected(true);
        this.mConjugateRadio.setSelected(true);
        this.onEntering();
        this.mScaleParamField.setText("");
        if (this.mShapeParamsTableVector != null) {
            this.mShapeParamsTableVector.clear();
        }
        if (this.mDirichletTableVector != null) {
            this.mDirichletTableVector.clear();
        }
    }

    private void onRowColSum() {
        this.mDirichletTable.updateDirichletTable(this.mNRowRadio.isSelected());
    }

    private void onConjugate(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.mConjugateRadio.isEnabled() && this.mConjugateRadio.isSelected();
        if (bl) {
            this.mShapeParamsTableLabel.setEnabled(bl3);
            this.mShapeParamsTable.setEnabled(bl3);
            this.mScaleParamLabel.setEnabled(false);
            this.mScaleParamField.setEnabled(false);
            this.mShapeParamsTableResetButton.setEnabled(bl3);
        } else if (bl2) {
            this.mShapeParamsTableLabel.setEnabled(true);
            this.mShapeParamsTable.setEnabled(true);
            this.mScaleParamLabel.setEnabled(true);
            this.mScaleParamField.setEnabled(true);
            this.mShapeParamsTableResetButton.setEnabled(true);
        } else {
            this.mShapeParamsTableLabel.setEnabled(false);
            this.mShapeParamsTable.setEnabled(false);
            this.mScaleParamLabel.setEnabled(false);
            this.mScaleParamField.setEnabled(false);
            this.mShapeParamsTableResetButton.setEnabled(false);
        }
    }

    private void onEntering() {
        boolean bl = !this.mIsDistRadioSelected;
        this.mPoissonRadio.setEnabled(bl);
        this.mMultinomialRadio.setEnabled(bl);
        this.mNonparametricRadio.setEnabled(bl);
        this.onMultinomial();
        this.onNonparametric();
    }

    private void onMultinomial() {
        boolean bl = this.mMultinomialRadio.isEnabled() && this.mMultinomialRadio.isSelected();
        boolean bl2 = this.mPoissonRadio.isEnabled() && this.mPoissonRadio.isSelected();
        this.mMGrandRadio.setEnabled(bl);
        this.mMRowRadio.setEnabled(bl);
        this.mMColumnRadio.setEnabled(bl);
        this.mConjugateRadio.setEnabled(bl);
        this.mMixtureRadio.setEnabled(bl);
        this.mIntrinsicRadio.setEnabled(bl);
        this.onConjugate(bl, bl2);
    }

    private void onNonparametric() {
        boolean bl = this.mNonparametricRadio.isEnabled() && this.mNonparametricRadio.isSelected();
        this.mNRowRadio.setEnabled(bl);
        this.mNColumnRadio.setEnabled(bl);
        this.mDirichletTableLabel.setEnabled(bl);
        this.mDirichletTable.setEnabled(bl);
        this.mDirichletTableResetButton.setEnabled(bl);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 30;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mPoissonRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMultinomialRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = this.createMFPPanel();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        JPanel jPanel3 = this.createNFPPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 2, 1, 2, n, insets2);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mNonparametricRadio, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private JPanel createMFPPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 15, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LOG_LINEAR_BF_FIXED_MARGINS_GROUP")));
        jPanel2.add(this.mMGrandRadio);
        jPanel2.add(this.mMRowRadio);
        jPanel2.add(this.mMColumnRadio);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LOG_LINEAR_BF_PRIOR_DIST_GROUP")));
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 30;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel3, this.mConjugateRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel4 = this.createShapeScaleParamsTablePanel();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, jPanel4, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mMixtureRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mIntrinsicRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createNFPPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 19, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LOG_LINEAR_BF_FIXED_MARGINS_GROUP")));
        jPanel2.add(this.mNRowRadio);
        jPanel2.add(this.mNColumnRadio);
        JPanel jPanel3 = this.createPriorTablePanel();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 30;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createShapeScaleParamsTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mShapeParamsTable = this.createShapeParamsTable();
        this.mShapeParamsTableLabel.setLabelFor(this.mShapeParamsTable);
        this.mShapeParamsTable.setAutoResizeMode(0);
        this.mScaleParamLabel = DialogUtil.createLabel(this, "IDS_LOG_LINEAR_BF_SCALE_PARAM");
        this.mScaleParamLabel.setLabelFor((Component)this.mScaleParamField);
        JScrollPane jScrollPane = new JScrollPane(this.mShapeParamsTable);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        int n = 18;
        DialogUtil.addUsingGBL(jPanel, this.mShapeParamsTableLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mShapeParamsTableResetButton, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mScaleParamLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mScaleParamField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createPriorTablePanel() {
        Object[] objectArray = this.getResStringArray("IDS_LOG_LINEAR_BF_DIRICHLET_TABLE_COL_NAMES");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LOG_LINEAR_BF_PRIOR_DIST_GROUP")));
        this.mDirichletTableLabel = DialogUtil.createLabel(this, "IDS_LOG_LINEAR_BF_DIRICHLET");
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        this.mDirichletTable = new DirichletTable(defaultTableModel, 0.0, Double.NaN, false);
        this.mDirichletTable.updateDirichletTable(true);
        JScrollPane jScrollPane = new JScrollPane(this.mDirichletTable);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 150));
        this.mDirichletTableLabel.setLabelFor(this.mDirichletTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        int n = 18;
        DialogUtil.addUsingGBL(jPanel, this.mDirichletTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDirichletTableResetButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private ShapeParamsTable createShapeParamsTable() {
        ArrayList<ISpssVariable> arrayList = BULRPriorsSubDlg.getVariables(this.mColVarModel, null);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("");
        for (ISpssVariable object22 : arrayList) {
            ScannedVariable scannedVariable = this.mScanBaseDlg.findScannedVariable(object22);
            ISpssVariable iSpssVariable = this.mScanBaseDlg.getCatsList(scannedVariable);
            for (Object object : iSpssVariable) {
                arrayList2.add((String)object);
            }
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(arrayList2.toArray(new String[arrayList.size()]), 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        ArrayList<ISpssVariable> arrayList3 = BULRPriorsSubDlg.getVariables(this.mRowVarModel, null);
        for (ISpssVariable iSpssVariable : arrayList3) {
            Object object;
            object = this.mScanBaseDlg.findScannedVariable(iSpssVariable);
            ArrayList<String> arrayList4 = this.mScanBaseDlg.getCatsList((ScannedVariable)object);
            for (String string : arrayList4) {
                Object[] objectArray = new Object[defaultTableModel.getColumnCount()];
                Arrays.fill(objectArray, "1");
                objectArray[0] = string;
                defaultTableModel.addRow(objectArray);
            }
        }
        return new ShapeParamsTable(defaultTableModel, 0.0, Double.NaN, false){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPMNGroup);
        vector.add(this.mGRCGroup);
        vector.add(this.mCMIGroup);
        vector.add(this.mShapeParamsTable);
        vector.add(this.mShapeParamsTableResetButton);
        vector.add(this.mScaleParamField);
        vector.add(this.mRCGroup);
        vector.add(this.mDirichletTable);
        vector.add(this.mDirichletTableResetButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    class ShapeParamsTable
    extends BayesianBaseDlg.BaseTable {
        ShapeParamsTable(TableModel tableModel, double d, double d2, boolean bl) {
            super(tableModel);
            this.setupColumns();
            this.setupCellEditors(d, d2, bl);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.isEnabled() && n2 > 0;
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (this.isEnabled() && n2 > 0) {
                return (TableCellEditor)((ArrayList)this.mTableCellEditors.get(n)).get(n2);
            }
            return null;
        }

        @Override
        protected boolean validateTable(boolean bl) {
            String string = null;
            block0: for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = 1; j < this.getColumnCount() - 1; ++j) {
                    String string2 = (String)this.getValueAt(i, j);
                    if (string2.length() == 0) {
                        string = LogLinearBayesFactorSubDlg.this.getResString("ERR_MSG_EMPTY_VALUE_WARNING");
                    } else if (string2.length() > 0 && Double.parseDouble(string2) == 0.0) {
                        string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MSG_GREATER_THAN"), 0);
                    }
                    if (string == null) continue;
                    if (bl) break block0;
                    SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                    this.setRowSelectionInterval(i, i);
                    this.setColumnSelectionInterval(j, j);
                    this.requestFocus();
                    break block0;
                }
            }
            return string == null;
        }

        private void resetTable() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = 1; j < this.getColumnCount(); ++j) {
                    this.setValueAt("1", i, j);
                }
            }
        }

        private void setupColumns() {
            if (this.columnModel.getColumnCount() == 0) {
                return;
            }
            TableColumn tableColumn = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer(true);
            tableColumn.setCellRenderer(varLabelRenderer);
            tableColumn.setPreferredWidth(50);
            tableColumn.setMinWidth(50);
            int n = this.getModel().getColumnCount();
            BayesianBaseDlg.ValueRenderer valueRenderer = new BayesianBaseDlg.ValueRenderer();
            for (int i = 1; i < n; ++i) {
                TableColumn tableColumn2 = this.columnModel.getColumn(i);
                tableColumn2.setCellRenderer(valueRenderer);
                tableColumn2.setPreferredWidth(50);
                tableColumn2.setMinWidth(50);
            }
        }
    }

    class DirichletTable
    extends BayesianBaseDlg.BaseTable {
        DirichletTable(TableModel tableModel, double d, double d2, boolean bl) {
            super(tableModel);
            this.updateDirichletTable(true);
            this.setupColumns();
            this.setupCellEditors(d, d2, bl);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return LogLinearBayesFactorSubDlg.this.mNonparametricRadio.isSelected() && n2 == 1;
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (LogLinearBayesFactorSubDlg.this.mNonparametricRadio.isSelected() && n2 == 1) {
                return (TableCellEditor)((ArrayList)this.mTableCellEditors.get(n)).get(n2);
            }
            return null;
        }

        void updateDirichletTable(boolean bl) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            while (defaultTableModel.getRowCount() > 0) {
                defaultTableModel.removeRow(0);
            }
            ArrayList<ISpssVariable> arrayList = bl ? BULRPriorsSubDlg.getVariables(LogLinearBayesFactorSubDlg.this.mColVarModel, null) : BULRPriorsSubDlg.getVariables(LogLinearBayesFactorSubDlg.this.mRowVarModel, null);
            for (ISpssVariable iSpssVariable : arrayList) {
                ScannedVariable scannedVariable = LogLinearBayesFactorSubDlg.this.mScanBaseDlg.findScannedVariable(iSpssVariable);
                ArrayList<String> arrayList2 = LogLinearBayesFactorSubDlg.this.mScanBaseDlg.getCatsList(scannedVariable);
                for (int i = 1; i <= arrayList2.size(); ++i) {
                    String string = "lambda" + i;
                    ((DefaultTableModel)this.getModel()).addRow(new Object[]{string, "1"});
                }
            }
        }

        @Override
        protected boolean validateTable(boolean bl) {
            String string = null;
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string2 = (String)this.getValueAt(i, 1);
                if (string2.length() == 0) {
                    string = LogLinearBayesFactorSubDlg.this.getResString("ERR_MSG_EMPTY_VALUE_WARNING");
                }
                if (string == null || bl) continue;
                SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                this.setRowSelectionInterval(i, i);
                this.setColumnSelectionInterval(1, 1);
                this.requestFocus();
                break;
            }
            return string == null;
        }

        private void resetTable() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt("1", i, 1);
            }
        }

        private void setupColumns() {
            if (this.columnModel.getColumnCount() == 0) {
                return;
            }
            TableColumn tableColumn = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer(true);
            tableColumn.setCellRenderer(varLabelRenderer);
            tableColumn.setPreferredWidth(60);
            tableColumn.setMinWidth(60);
            BayesianBaseDlg.ValueRenderer valueRenderer = new BayesianBaseDlg.ValueRenderer();
            TableColumn tableColumn2 = this.columnModel.getColumn(1);
            tableColumn2.setCellRenderer(valueRenderer);
            tableColumn2.setPreferredWidth(50);
            tableColumn2.setMinWidth(50);
        }
    }
}

