/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRFTestsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.ScanBaseDlg;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ScannedVariable;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class LayerPanel
extends JPanel
implements ListDataListener {
    private JLabel mSourceListLabel;
    private SrcVariableList mSrcVarList;
    private JLabel mTargetVarListLabel;
    private TargetVariableList mTargetVarList;
    private ArrowButton mArrowButton;
    private JLabel mTestingTableLabel;
    private TestingTable mTestingTable;
    private JButton mResetButton;
    private JCheckBox mIncludeCheck;
    private JLabel mTestValueLabel;
    private FloatTextField mTestValueField;
    private JLabel mTestLabelLabel;
    private StringTextField mTestLabelField;
    private boolean mIsBayesFactorSelected;
    private BaseSubDialog mSubDlg;
    private VarListModel mFactorsModel;
    private VarListModel mCovModel;
    private LayerData mCurrentLayerData;
    private ScanBaseDlg mScanBaseDlg;

    LayerPanel(BaseSubDialog baseSubDialog, boolean bl, VarListModel varListModel, VarListModel varListModel2) {
        this.mIsBayesFactorSelected = bl;
        this.mSubDlg = baseSubDialog;
        if (baseSubDialog instanceof BULRFTestsSubDlg) {
            this.mScanBaseDlg = ((BULRFTestsSubDlg)baseSubDialog).getScanBaseDlg();
        }
        this.mFactorsModel = varListModel;
        this.mCovModel = varListModel2;
        this.initVars();
        this.setupPanel();
    }

    LayerData getLayerData() {
        return new LayerData(this.mTargetVarList.getModel(), (Vector)((DefaultTableModel)this.mTestingTable.getModel()).getDataVector().clone(), this.mIncludeCheck.isSelected(), this.mTestValueField.getText(), this.mTestLabelField.getText());
    }

    void resetLayerPanel() {
        this.mTargetVarList.getModel().removeAll();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mTestingTable.getModel();
        int n = defaultTableModel.getRowCount();
        for (int i = n - 1; i >= 0; --i) {
            defaultTableModel.removeRow(i);
        }
        this.refreshSrcList();
        this.mIncludeCheck.setSelected(false);
        this.onIncludeCheck();
        this.mTestValueField.setText("0");
        this.mTestLabelField.setText("");
    }

    boolean canEnableContinue() {
        boolean bl = true;
        if (this.mIncludeCheck.isEnabled() && this.mIncludeCheck.isSelected()) {
            bl = this.mTestValueField.getText().length() > 0;
        }
        return bl;
    }

    boolean isValidLayerPanel(boolean bl) {
        boolean bl2 = true;
        int n = this.mTestingTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.mTestingTable.getValueAt(i, 1);
            if (string != null && string.length() != 0) continue;
            bl2 = false;
            if (bl) break;
            this.mTestingTable.onDisplayWarning(this.mSubDlg.getResString("ERR_MSG_EMPTY_VALUE_WARNING"), i, 1);
            break;
        }
        if (bl2) {
            String string;
            if (n == 0 && !this.mIncludeCheck.isSelected()) {
                bl2 = false;
                if (!bl) {
                    string = this.mSubDlg.getResString("ERR_MSG_INCLUDE_NOT_CHECKED_EMPTY_TABLE");
                    SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                }
            }
            if (bl2 && this.mIncludeCheck.isSelected() && this.mTestValueField.getText().length() == 0) {
                bl2 = false;
                if (!bl) {
                    string = this.mSubDlg.getResString("ERR_MSG_EMPTY_VALUE_WARNING");
                    SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                    this.mTestValueField.requestFocusInWindow();
                }
            }
        }
        return bl2;
    }

    private void initVars() {
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("BULRFTestsSrcVarList");
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setIdentifier("BULRFTestsTargetVarList");
        this.mTargetVarList.setMaxLimitOfList(300);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 7 + 2));
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        Object[] objectArray = this.mSubDlg.getResStringArray("IDS_BULR_FTESTS_COLUMN_NAMES_ARRAY");
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        this.mTestingTable = new TestingTable(defaultTableModel);
        this.mTestingTableLabel = DialogUtil.createLabel(this.mSubDlg, "IDS_BULR_FTESTS_TABLE_LABEL");
        this.mTestingTableLabel.setLabelFor(this.mTestingTable);
        this.mIncludeCheck = new JCheckBox(new ToggleButtonAction(this.mSubDlg, "IDS_BULR_FTESTS_INCLUDE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerPanel.this.onIncludeCheck();
            }
        });
        this.mTestValueLabel = DialogUtil.createLabel(this.mSubDlg, "IDS_BULR_FTESTS_TEST_VALUE");
        this.mTestValueField = new FloatTextField(Double.NaN, Double.NaN, 5, false);
        this.mTestValueField.setColumns(8);
        this.mTestValueField.setAction((Action)new TextFieldAction(this.mSubDlg, "IDS_BULR_FTESTS_TEST_VALUE"));
        this.mTestValueLabel.setLabelFor((Component)this.mTestValueField);
        this.mTestLabelLabel = DialogUtil.createLabel(this.mSubDlg, "IDS_BULR_FTESTS_TEST_LABEL");
        this.mTestLabelField = new StringTextField();
        this.mTestLabelField.setColumns(8);
        this.mTestLabelField.setAction(new TextFieldAction(this.mSubDlg, "IDS_BULR_FTESTS_TEST_LABEL"));
        this.mTestLabelLabel.setLabelFor((Component)((Object)this.mTestLabelField));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mSubDlg, "IDS_BULR_PRIORS_RESET", "IDK_BULR_PRIORS_MEAN_RESET_KEY"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerPanel.this.onResetButton();
            }
        };
        this.mResetButton = new JButton(toggleButtonAction);
    }

    void setDefaults() {
        this.onEntering();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mIncludeCheck.setSelected(false);
        this.onIncludeCheck();
        this.mTestValueField.setText("0");
        this.mTestLabelField.setText("");
    }

    private void onResetButton() {
        for (int i = 0; i < this.mTestingTable.getRowCount(); ++i) {
            this.mTestingTable.setValueAt("0", i, 1);
        }
    }

    void onIncludeCheck() {
        this.mTestValueLabel.setEnabled(this.mIncludeCheck.isEnabled() && this.mIncludeCheck.isSelected());
        this.mTestValueField.setEnabled(this.mIncludeCheck.isEnabled() && this.mIncludeCheck.isSelected());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mTestingTableLabel.setEnabled(bl);
        this.mResetButton.setEnabled(bl);
        this.mTestingTable.setEnabled(bl);
        this.mIncludeCheck.setEnabled(bl);
        this.onIncludeCheck();
        this.mTestLabelLabel.setEnabled(bl);
        this.mTestLabelField.setEnabled(bl);
    }

    private ArrayList<ISpssVariable> getVariables() {
        int n;
        int n2;
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (this.mFactorsModel != null) {
            n2 = this.mFactorsModel.getSize();
            for (n = 0; n < n2; ++n) {
                arrayList.add(this.mFactorsModel.getElementAt(n));
            }
        }
        if (this.mCovModel != null) {
            n2 = this.mCovModel.getSize();
            for (n = 0; n < n2; ++n) {
                arrayList.add(this.mCovModel.getElementAt(n));
            }
        }
        return arrayList;
    }

    void selectFirstItemInSrcList() {
        this.mSrcVarList.setSelectedIndex(0);
    }

    void loadLayerPanel(LayerData layerData) {
        this.mTargetVarList.getModel().removeAll();
        for (int i = 0; i < layerData.targetVarArray.size(); ++i) {
            this.mTargetVarList.getModel().addElement(layerData.targetVarArray.get(i));
        }
        this.mIncludeCheck.setSelected(layerData.includeIntercept);
        this.refreshSrcList();
        this.mTestingTable.reloadTable(layerData.variableValueVector);
        this.mTestValueField.setText(layerData.testingValue);
        this.onIncludeCheck();
        this.mTestLabelField.setText(layerData.testLabel);
    }

    private void refreshSrcList() {
        ArrayList<ISpssVariable> arrayList = this.getVariables();
        this.mSrcVarList.getModel().removeAll();
        VarListModel varListModel = this.mSrcVarList.getModel();
        for (ISpssVariable iSpssVariable : arrayList) {
            VarListModel varListModel2 = this.mTargetVarList.getModel();
            if (varListModel.contains(iSpssVariable) || varListModel2.contains(iSpssVariable)) continue;
            varListModel.addElement(iSpssVariable);
        }
        for (int i = this.mTargetVarList.getModel().getSize() - 1; i >= 0; --i) {
            ISpssVariable iSpssVariable;
            iSpssVariable = this.mTargetVarList.getModel().getElementAt(i);
            if (this.mFactorsModel.contains(iSpssVariable) || this.mCovModel.contains(iSpssVariable)) continue;
            this.mTargetVarList.getModel().removeElement(iSpssVariable);
        }
    }

    private JPanel createRightBottomPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        int n2 = 16;
        DialogUtil.addUsingGBL(jPanel, this.mTestingTableLabel, gridBagConstraints, 0, 0, 3, 1, n2, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mTestingTable);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 1, n2, insets);
        n2 = 11;
        DialogUtil.addUsingGBL(jPanel, this.mResetButton, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        n2 = 18;
        Insets insets2 = new Insets(n, insets.left, n, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCheck, gridBagConstraints, 0, 2, 3, 1, n2, insets2);
        Insets insets3 = (Insets)insets.clone();
        insets3.left += 20;
        DialogUtil.addUsingGBL(jPanel, this.mTestValueLabel, gridBagConstraints, 0, 3, 1, 1, n2, insets3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTestValueField, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTestLabelLabel, gridBagConstraints, 0, 4, 1, 1, n2, insets2);
        Insets insets4 = (Insets)insets.clone();
        insets4.top = n;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTestLabelField), gridBagConstraints, 1, 4, 1, 1, n2, insets4);
        return jPanel;
    }

    private void setupPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        this.mSourceListLabel = DialogUtil.createLabel(this.mSubDlg, "IDS_BAYESIAN_SOURCE_LABEL");
        this.mSourceListLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(this, this.mSourceListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(new Dimension(200, 340));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = (Insets)DialogUtil.getArrowButtonInsets().clone();
        insets2.top += 30;
        DialogUtil.addUsingGBL(this, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mTargetVarListLabel = DialogUtil.createLabel(this.mSubDlg, "IDS_BULR_FTESTS_TARGET_LABEL");
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mTargetVarListLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(this, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        this.mTargetVarListLabel.setLabelFor(this.mTargetVarList);
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(this, this.createRightBottomPanel(), gridBagConstraints, 2, 2, 1, 1, n, new Insets(n2, 0, 0, 0));
    }

    private void addToDataTable(Object object) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mTestingTable.getModel();
        if (object instanceof ISpssVariable) {
            if (this.mScanBaseDlg.isVarFromModel(this.mFactorsModel, (ISpssVariable)object)) {
                ScannedVariable scannedVariable = this.mScanBaseDlg.findScannedVariable((ISpssVariable)object);
                ArrayList<String> arrayList = this.mScanBaseDlg.getCatsList(scannedVariable);
                for (int i = 0; i < arrayList.size(); ++i) {
                    boolean bl = i == arrayList.size() - 1;
                    defaultTableModel.addRow(new Object[]{arrayList.get(i), "0", !bl});
                }
            } else {
                defaultTableModel.addRow(new Object[]{object, "0", true});
            }
        }
        if (this.mCurrentLayerData != null) {
            this.mTestingTable.reloadTable(this.mCurrentLayerData.variableValueVector);
        }
        this.mTestingTable.setRowSelectionInterval(defaultTableModel.getRowCount() - 1, defaultTableModel.getRowCount() - 1);
    }

    void addListeners(DocumentListener documentListener) {
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTestValueField.getDocument().addDocumentListener(documentListener);
    }

    private void onEntering() {
        this.mSourceListLabel.setEnabled(!this.mIsBayesFactorSelected);
        this.mTargetVarListLabel.setEnabled(!this.mIsBayesFactorSelected);
        this.mTargetVarList.setEnabled(!this.mIsBayesFactorSelected);
        this.mArrowButton.setEnabled(!this.mIsBayesFactorSelected);
        this.mSrcVarList.setEnabled(!this.mIsBayesFactorSelected);
        this.mTestingTableLabel.setEnabled(!this.mIsBayesFactorSelected);
        this.mTestingTable.setEnabled(!this.mIsBayesFactorSelected);
        this.mIncludeCheck.setEnabled(!this.mIsBayesFactorSelected);
        this.mTestLabelLabel.setEnabled(!this.mIsBayesFactorSelected);
        this.mTestLabelField.setEnabled(!this.mIsBayesFactorSelected);
        this.mResetButton.setEnabled(!this.mIsBayesFactorSelected);
        this.refreshSrcList();
    }

    void addFocusTraversalPolicy(Vector<Object> vector) {
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mTestingTable);
        vector.add(this.mResetButton);
        vector.add(this.mIncludeCheck);
        vector.add(this.mTestValueField);
        vector.add(this.mTestLabelField);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object instanceof VarListModel) {
            ISpssVariable iSpssVariable = ((VarListModel)object).getMovedVar();
            this.addToDataTable(iSpssVariable);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object instanceof VarListModel) {
            ISpssVariable iSpssVariable = ((VarListModel)object).getMovedVar();
            this.removeFromDataTable(iSpssVariable);
        }
    }

    private void removeFromDataTable(Object object) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mTestingTable.getModel();
        ScannedVariable scannedVariable = this.mScanBaseDlg.findScannedVariable((ISpssVariable)object);
        ArrayList<String> arrayList = null;
        if (scannedVariable != null) {
            arrayList = this.mScanBaseDlg.getCatsList(scannedVariable);
        }
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            boolean bl;
            Object object2 = defaultTableModel.getValueAt(i, 0);
            if (object2 instanceof ISpssVariable) {
                bl = ((ISpssVariable)object2).getName().equals(((ISpssVariable)object).getName());
            } else {
                boolean bl2 = bl = arrayList != null && arrayList.contains(object2) || object2.equals(object.toString());
            }
            if (!bl) continue;
            defaultTableModel.removeRow(i);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public class LayerData {
        ArrayList<ISpssVariable> targetVarArray = new ArrayList();
        Vector<Object> variableValueVector;
        boolean includeIntercept;
        String testingValue;
        String testLabel;

        LayerData(VarListModel varListModel, Vector<Object> vector, boolean bl, String string, String string2) {
            for (int i = 0; i < varListModel.getSize(); ++i) {
                this.targetVarArray.add(varListModel.getElementAt(i));
            }
            this.variableValueVector = vector;
            this.includeIntercept = bl;
            this.testingValue = string;
            this.testLabel = string2;
        }
    }

    class TestingTable
    extends BayesianBaseDlg.BaseTable {
        TestingTable(TableModel tableModel) {
            super(tableModel);
            this.setupColumns();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 && (this.getValueAt(n, 2) == null || (Boolean)this.getValueAt(n, 2) != false);
        }

        boolean hasEmptyValue() {
            boolean bl = false;
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string = (String)this.getValueAt(i, 1);
                if (string != null && string.length() != 0) continue;
                bl = true;
                break;
            }
            return bl;
        }

        private void setupColumns() {
            TableColumn tableColumn = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer();
            tableColumn.setCellRenderer(varLabelRenderer);
            tableColumn.setPreferredWidth(70);
            tableColumn.setMinWidth(30);
            BayesianBaseDlg.ValueRenderer valueRenderer = new BayesianBaseDlg.ValueRenderer();
            TableColumn tableColumn2 = this.columnModel.getColumn(1);
            tableColumn2.setCellRenderer(valueRenderer);
            tableColumn2.setPreferredWidth(60);
            tableColumn2.setMinWidth(30);
            tableColumn2.setCellEditor(new BayesianBaseDlg.FloatValueCellEditor(Double.NaN, Double.NaN, false));
            int n = this.getModel().getColumnCount();
            TableColumn tableColumn3 = this.columnModel.getColumn(n - 1);
            tableColumn3.setPreferredWidth(0);
            tableColumn3.setMinWidth(0);
            tableColumn3.setMaxWidth(0);
        }
    }
}

