/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesFactorSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.IndeptCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.IndeptPriorsSubDlg;
import com.spss.java_client.ui.dialogs.common.DefineGroupsSubDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class IndeptSampleBayesianStatsDlg
extends BayesianBaseDlg
implements ListDataListener {
    private TargetVariableList mTargetGroupVarList;
    private ArrowButton mGroupArrowButton;
    private JButton mDefineGroupsButton;
    private DefineGroupsSubDlg.GroupVarFormatter mTargetGroupVarFormatter;

    public IndeptSampleBayesianStatsDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getResString("IDS_BAYESIAN_INDEPT_SAMPLE_NORMAL_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_independent_sample_inference";
    }

    @Override
    public String getIActionKey() {
        return "analyze_bayesian_indept_sample";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        boolean bl = false;
        if (this.mTargetGroupVarList.getModel().getSize() > 0) {
            this.mDefineGroupsButton.setEnabled(true);
            ISpssVariable iSpssVariable = this.mTargetGroupVarList.getModel().getElementAt(0);
            String[] stringArray = (String[])this.mTargetGroupVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (stringArray != null && !stringArray[0].equals("?") && this.mTargetVarList.getModel().getSize() > 0) {
                bl = true;
            }
        } else {
            this.mDefineGroupsButton.setEnabled(false);
        }
        this.enableOkPaste(bl);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        boolean bl = false;
        if (this.mTargetGroupVarList.getModel().getSize() > 0) {
            this.mDefineGroupsButton.setEnabled(true);
            ISpssVariable iSpssVariable = this.mTargetGroupVarList.getModel().getElementAt(0);
            String[] stringArray = (String[])this.mTargetGroupVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (stringArray != null && !stringArray[0].equals("?") && this.mTargetVarList.getModel().getSize() > 0) {
                bl = true;
            }
        } else {
            this.mDefineGroupsButton.setEnabled(false);
        }
        this.enableOkPaste(bl);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        boolean bl = false;
        if (this.mTargetGroupVarList.getModel().getSize() > 0) {
            this.mDefineGroupsButton.setEnabled(true);
            ISpssVariable iSpssVariable = this.mTargetGroupVarList.getModel().getElementAt(0);
            String[] stringArray = (String[])this.mTargetGroupVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (stringArray != null && !stringArray[0].equals("?") && this.mTargetVarList.getModel().getSize() > 0) {
                bl = true;
            }
        } else {
            this.mDefineGroupsButton.setEnabled(false);
        }
        this.enableOkPaste(bl);
    }

    public TargetVariableList getGroupVarList() {
        return this.mTargetGroupVarList;
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("BAYES INDEPENDENT"));
        stringBuffer.append("\n");
        stringBuffer.append(IndeptCriteriaSubDlg.getIndeptCriteriaDlgSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.getSubCommand("/INFERENCE"));
        stringBuffer.append(" DISTRIBUTION=NORMAL");
        if (this.mTargetVarList.getModel().getSize() > 0) {
            stringBuffer.append(" VARIABLES=").append(this.mTargetVarList.getVariablesStringList());
        }
        Boolean bl = dialogDataModel.getBoolean("IDS_BAYES_FACTOR");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_USE_BOTH");
        String string = bl != null && bl != false ? "BAYESFACTOR" : (bl2 != null && bl2 != false ? "BOTH" : "POSTERIOR");
        stringBuffer.append(" ANALYSIS=").append(string);
        stringBuffer.append(" GROUP=");
        stringBuffer.append(this.mTargetGroupVarList.getModel().getElementAt(0).getName());
        stringBuffer.append(" SELECT=");
        stringBuffer.append(this.mTargetGroupVarFormatter.getDisplaySyntax(this.mTargetGroupVarList.getModel().getElementAt(0)));
        stringBuffer.append(IndeptPriorsSubDlg.getPriorsDataVarSyntax(dialogDataModel));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRIOR"));
        stringBuffer.append(IndeptPriorsSubDlg.getIndeptPriorSyntax(dialogDataModel));
        stringBuffer.append(BayesFactorSubDlg.getByesFactorSyntax(dialogDataModel, this.mDistributionRadio.isSelected()));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mTargetGroupVarList.removeAll();
        this.setDefaults();
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mTargetGroupVarList.getIdentifier(), this.mTargetGroupVarFormatter.getVarMapForSerialization());
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mTargetGroupVarFormatter.setVarMap(this.getDialogDataModel().getMap(this.mTargetGroupVarList.getIdentifier()));
        boolean bl = false;
        if (this.mTargetGroupVarList.getModel().getSize() > 0) {
            this.mDefineGroupsButton.setEnabled(true);
            ISpssVariable iSpssVariable = this.mTargetGroupVarList.getModel().getElementAt(0);
            String[] stringArray = (String[])this.mTargetGroupVarFormatter.getVarMap().get(iSpssVariable.getId().asInt());
            if (stringArray != null && !stringArray[0].equals("?") && this.mTargetVarList.getModel().getSize() > 0) {
                bl = true;
            }
        } else {
            this.mDefineGroupsButton.setEnabled(false);
        }
        this.enableOkPaste(bl);
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        return this.createSideButtonPanel(true);
    }

    @Override
    protected void initVars() {
        super.initVars();
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setIdentifier("TARGET_LIST");
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetGroupVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetGroupVarFormatter = new DefineGroupsSubDlg.GroupVarFormatter(this.mTargetGroupVarList);
        this.mTargetGroupVarList.setModel(new DefineGroupsSubDlg.GroupVarModel(this.mTargetGroupVarFormatter));
        this.mTargetGroupVarList.setCellRenderer(new CustomVarListCellRenderer(this.mTargetGroupVarFormatter));
        this.mTargetGroupVarList.getModel().addListDataListener(this);
        this.mTargetGroupVarList.setIdentifier("GROUP_VARIALE_LIST");
        this.mGroupArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mGroupArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mGroupArrowButton.registerVariableList(this.mTargetGroupVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_BAYESIAN_INDEPT_DEFINE_GROUP_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndeptSampleBayesianStatsDlg.this.runDefineGroupsSubDialog();
                IndeptSampleBayesianStatsDlg.this.mTargetGroupVarList.requestFocus();
            }
        };
        this.mDefineGroupsButton = new JButton(toggleButtonAction);
        this.mDefineGroupsButton.setEnabled(true);
    }

    @Override
    protected void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mGroupArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mTargetGroupVarList);
        vector.add(this.mDefineGroupsButton);
        vector.add(this.mAnalysisGroup);
        vector.add(this.mCriteriaButton);
        vector.add(this.mPriorsButton);
        vector.add(this.mBayesFactorButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    @Override
    protected void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BAYESIAN_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 5, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_TEST_VARIABLES");
        jLabel2.setLabelFor(this.mTargetVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        Insets insets2 = (Insets)insets.clone();
        insets2.right += 20;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 20;
        gridBagConstraints.fill = 0;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        insets = new Insets(0, insets3.left, 0, insets3.right);
        DialogUtil.addUsingGBL(jPanel, this.mGroupArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, DialogUtil.getComponentGroupGap());
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_BAYESIAN_INDEPT_GROUPING_VARIABLES");
        jLabel3.setLabelFor(this.mTargetGroupVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets);
        JScrollPane jScrollPane3 = new JScrollPane(this.mTargetGroupVarList);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        jScrollPane3.setPreferredSize(this.mTargetGroupVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mDefineGroupsButton, gridBagConstraints, 2, 4, 1, 1, n, insets);
        JPanel jPanel2 = this.createAnalysisPanel();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 5, 1, 1, n, insets2);
    }

    @Override
    protected void onCriteriaButton() {
        this.runSubDialog(new IndeptCriteriaSubDlg(this, this.getResString("IDS_INDEPT_CRITERIA_SUBDLG_TITLE")));
    }

    @Override
    protected void onPriorsButton() {
        this.runSubDialog(new IndeptPriorsSubDlg(this, this.getResString("IDS_INDEPT_PRIORS_SUBDLG_TITLE")));
    }

    private void runDefineGroupsSubDialog() {
        boolean bl = this.mTargetGroupVarList.getModel().getElementAt(0).getType() != 0;
        String string = bl ? "idh_bayesian_independent_sample_define_groups_string" : "idh_bayesian_independent_sample_define_groups_numeric";
        this.runSubDialog(new DefineGroupsSubDlg(this, this.mTargetGroupVarList.getModel().getElementAt(0).getType() != 0, this.mTargetGroupVarList, string));
    }
}

