/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class IndeptPriorsSubDlg
extends BaseSubDialog
implements DocumentListener {
    private static final String NORMAL_TABLE_FIELDS_ARRAY = "IDS_NORMAL_FIELDS_ARRAY";
    private JRadioButton mVarianceKnownRadio;
    private JRadioButton mAssumeEqVRadio;
    private JRadioButton mAssumeUnequalRadio;
    private SpssButtonGroup mVAButtonGroup;
    private JLabel mGroup1VLabel;
    private JLabel mGroup2VLabel;
    private FloatTextField mGroup1VField;
    private FloatTextField mGroup2VField;
    private JRadioButton mJeffreysRadio;
    private JRadioButton mInverseCSRadio;
    private SpssButtonGroup mJIButtonGroup;
    private JLabel mDegreeFreedomLabel;
    private JLabel mScaleParamLabel;
    private FloatTextField mDegreeFreedomField;
    private FloatTextField mScaleParamField;
    private JRadioButton mDiffuseRadio;
    private JRadioButton mNormalRadio;
    private SpssButtonGroup mDNButtonGroup;
    private NormalFieldsTable mNormalFieldsTable;
    private FocusableTextArea mInfoArea;

    public IndeptPriorsSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.setDefaults();
        this.addListeners();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_independent_sample_priors";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        String string = (String)this.mNormalFieldsTable.getValueAt(0, 1);
        String string2 = (String)this.mNormalFieldsTable.getValueAt(0, 2);
        String string3 = (String)this.mNormalFieldsTable.getValueAt(1, 1);
        String string4 = (String)this.mNormalFieldsTable.getValueAt(1, 2);
        String[][] stringArrayArray = new String[][]{{string, string2}, {string3, string4}};
        dialogDataModel.putArray(NORMAL_TABLE_FIELDS_ARRAY, (Object[])stringArrayArray);
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        String[][] stringArray = (String[][])dialogDataModel.getArray(NORMAL_TABLE_FIELDS_ARRAY);
        if (stringArray != null) {
            this.mNormalFieldsTable.setValueAt(stringArray[0][0], 0, 1);
            this.mNormalFieldsTable.setValueAt(stringArray[0][1], 0, 2);
            this.mNormalFieldsTable.setValueAt(stringArray[1][0], 1, 1);
            this.mNormalFieldsTable.setValueAt(stringArray[1][1], 1, 2);
        }
        this.onVarianceKnown(this.mVarianceKnownRadio.isSelected());
        this.onAssumeEq(this.mAssumeEqVRadio.isSelected());
        this.onAssumeUnEq(this.mAssumeUnequalRadio.isSelected());
        this.onInverseCS(this.mInverseCSRadio.isEnabled() && this.mInverseCSRadio.isSelected());
        this.mNormalFieldsTable.setEnabled(this.mNormalRadio.isEnabled() && this.mNormalRadio.isSelected());
    }

    public static String getPriorsDataVarSyntax(DialogDataModel dialogDataModel) {
        String string = "";
        Boolean bl = dialogDataModel.containsBooleanKey("IDS_INDEPT_VARIANCE_KNOWN") ? dialogDataModel.getBoolean("IDS_INDEPT_VARIANCE_KNOWN") : false;
        String string2 = dialogDataModel.getString("IDS_IDEPT_GROUP1_VARIANCE");
        String string3 = dialogDataModel.getString("IDS_IDEPT_GROUP2_VARIANCE");
        if (bl.booleanValue() && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            string = " DATAVAR=" + string2 + " " + string3;
        }
        return string;
    }

    public static String getIndeptPriorSyntax(DialogDataModel dialogDataModel) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_INDEPT_VARIANCE_KNOWN") ? dialogDataModel.getBoolean("IDS_INDEPT_VARIANCE_KNOWN") : false;
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_INDEPT_ASSUME_VARIANCE") ? dialogDataModel.getBoolean("IDS_INDEPT_ASSUME_VARIANCE") : false;
        Boolean bl4 = dialogDataModel.containsBooleanKey("IDS_INDEPT_ASSUME_UNEQUAL") ? dialogDataModel.getBoolean("IDS_INDEPT_ASSUME_UNEQUAL") : true;
        boolean bl5 = dialogDataModel.containsBooleanKey("IDS_INDEPT_VARIANCE_JEFFREYS") ? dialogDataModel.getBoolean("IDS_INDEPT_VARIANCE_JEFFREYS") : true;
        boolean bl6 = dialogDataModel.containsBooleanKey("IDS_INDEPT_VARIANCE_INVERSE") ? dialogDataModel.getBoolean("IDS_INDEPT_VARIANCE_INVERSE") : true;
        String string = dialogDataModel.getString("IDS_INDEPT_DEGREE_FREEDOM");
        String string2 = dialogDataModel.getString("IDS_INDEPT_SCALE_PARAM");
        stringBuffer.append(" EQUALDATAVAR=").append(bl3 != false ? "TRUE" : "FALSE");
        if (bl3.booleanValue()) {
            stringBuffer.append(" VARDIST=");
            if (bl5) {
                stringBuffer.append("JEFFREYS");
            } else if (bl6) {
                stringBuffer.append("INVCHISQ(").append(string).append(" ").append(string2).append(")");
            }
        }
        if (bl4.booleanValue()) {
            stringBuffer.append(" VARDIST=DIFFUSE");
        }
        boolean bl7 = bl = dialogDataModel.containsBooleanKey("IDS_INDEPT_MEAN_DIFFUSE") ? dialogDataModel.getBoolean("IDS_INDEPT_MEAN_DIFFUSE") : true;
        if (bl2.booleanValue()) {
            if (bl) {
                stringBuffer.append(" MEANDIST=DIFFUSE");
            } else {
                String[][] stringArray = (String[][])dialogDataModel.getArray(NORMAL_TABLE_FIELDS_ARRAY);
                if (stringArray != null) {
                    String string3 = stringArray[0][0];
                    String string4 = stringArray[0][1];
                    String string5 = stringArray[1][0];
                    String string6 = stringArray[1][1];
                    stringBuffer.append(" MEANDIST=");
                    stringBuffer.append("NORMAL(");
                    stringBuffer.append(string3);
                    stringBuffer.append(" ");
                    stringBuffer.append(string4);
                    stringBuffer.append(" ");
                    stringBuffer.append(string5);
                    stringBuffer.append(" ");
                    stringBuffer.append(string6);
                    stringBuffer.append(")");
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean continuePressed() {
        return this.mNormalFieldsTable == null || !this.mNormalFieldsTable.isEnabled() || this.mNormalFieldsTable.validateTable(false);
    }

    protected void initVars() {
        this.mVarianceKnownRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_VARIANCE_KNOWN"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndeptPriorsSubDlg.this.onVarianceKnown(IndeptPriorsSubDlg.this.mVarianceKnownRadio.isSelected());
                IndeptPriorsSubDlg.this.onAssumeEq(IndeptPriorsSubDlg.this.mAssumeEqVRadio.isSelected());
                IndeptPriorsSubDlg.this.onAssumeUnEq(IndeptPriorsSubDlg.this.mAssumeUnequalRadio.isSelected());
                IndeptPriorsSubDlg.this.enableContinue(IndeptPriorsSubDlg.this.canEnableContinue());
            }
        });
        this.mGroup1VLabel = DialogUtil.createLabel(this, "IDS_IDEPT_GROUP1_VARIANCE");
        this.mGroup1VField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mGroup1VField.setIncludeMinRange(false);
        this.mGroup1VField.setIncludeMaxRange(false);
        this.mGroup1VField.setColumns(8);
        this.mGroup1VField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_IDEPT_GROUP1_VARIANCE"));
        this.mGroup1VLabel.setLabelFor((Component)this.mGroup1VField);
        this.mGroup2VLabel = DialogUtil.createLabel(this, "IDS_IDEPT_GROUP2_VARIANCE");
        this.mGroup2VField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mGroup2VField.setIncludeMinRange(false);
        this.mGroup2VField.setIncludeMaxRange(false);
        this.mGroup2VField.setColumns(8);
        this.mGroup2VField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_IDEPT_GROUP2_VARIANCE"));
        this.mGroup2VLabel.setLabelFor((Component)this.mGroup2VField);
        this.mAssumeEqVRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_ASSUME_VARIANCE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndeptPriorsSubDlg.this.onVarianceKnown(IndeptPriorsSubDlg.this.mVarianceKnownRadio.isSelected());
                IndeptPriorsSubDlg.this.onAssumeEq(IndeptPriorsSubDlg.this.mAssumeEqVRadio.isSelected());
                IndeptPriorsSubDlg.this.onAssumeUnEq(IndeptPriorsSubDlg.this.mAssumeUnequalRadio.isSelected());
                IndeptPriorsSubDlg.this.enableContinue(IndeptPriorsSubDlg.this.canEnableContinue());
            }
        });
        this.mAssumeUnequalRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_ASSUME_UNEQUAL"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndeptPriorsSubDlg.this.onVarianceKnown(IndeptPriorsSubDlg.this.mVarianceKnownRadio.isSelected());
                IndeptPriorsSubDlg.this.onAssumeEq(IndeptPriorsSubDlg.this.mAssumeEqVRadio.isSelected());
                IndeptPriorsSubDlg.this.onAssumeUnEq(IndeptPriorsSubDlg.this.mAssumeUnequalRadio.isSelected());
                IndeptPriorsSubDlg.this.enableContinue(IndeptPriorsSubDlg.this.canEnableContinue());
            }
        });
        this.mVAButtonGroup = new SpssButtonGroup();
        this.mVAButtonGroup.add(this.mVarianceKnownRadio);
        this.mVAButtonGroup.add(this.mAssumeEqVRadio);
        this.mVAButtonGroup.add(this.mAssumeUnequalRadio);
        this.mJeffreysRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_VARIANCE_JEFFREYS"));
        this.mInverseCSRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_VARIANCE_INVERSE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndeptPriorsSubDlg.this.onInverseCS(IndeptPriorsSubDlg.this.mInverseCSRadio.isSelected());
                IndeptPriorsSubDlg.this.enableContinue(IndeptPriorsSubDlg.this.canEnableContinue());
            }
        });
        this.mJIButtonGroup = new SpssButtonGroup();
        this.mJIButtonGroup.add(this.mJeffreysRadio);
        this.mJIButtonGroup.add(this.mInverseCSRadio);
        this.mDegreeFreedomLabel = DialogUtil.createLabel(this, "IDS_INDEPT_DEGREE_FREEDOM");
        this.mDegreeFreedomField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mDegreeFreedomField.setIncludeMinRange(false);
        this.mDegreeFreedomField.setIncludeMaxRange(false);
        this.mDegreeFreedomField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_INDEPT_DEGREE_FREEDOM"));
        this.mDegreeFreedomField.setColumns(8);
        this.mDegreeFreedomLabel.setLabelFor((Component)this.mDegreeFreedomField);
        this.mScaleParamLabel = DialogUtil.createLabel(this, "IDS_INDEPT_SCALE_PARAM");
        this.mScaleParamField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mScaleParamField.setIncludeMinRange(false);
        this.mScaleParamField.setIncludeMaxRange(false);
        this.mScaleParamField.setColumns(8);
        this.mScaleParamField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_INDEPT_SCALE_PARAM"));
        this.mScaleParamLabel.setLabelFor((Component)this.mScaleParamField);
        this.mDiffuseRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_MEAN_DIFFUSE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndeptPriorsSubDlg.this.mNormalFieldsTable.setEnabled(IndeptPriorsSubDlg.this.mNormalRadio.isSelected());
            }
        });
        this.mNormalRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_MEAN_NORMAL"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndeptPriorsSubDlg.this.mNormalFieldsTable.setEnabled(IndeptPriorsSubDlg.this.mNormalRadio.isSelected());
            }
        });
        this.mDNButtonGroup = new SpssButtonGroup();
        this.mDNButtonGroup.add(this.mDiffuseRadio);
        this.mDNButtonGroup.add(this.mNormalRadio);
        Object[] objectArray = this.getResStringArray("IDS_INDEPT_MEAN_COLUMN_NAMES");
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        this.mNormalFieldsTable = new NormalFieldsTable(defaultTableModel);
        Object[] objectArray2 = new Object[]{this.getResString("IDS_INDEPT_LOC_PARAM"), "", ""};
        Object[] objectArray3 = new Object[]{this.getResString("IDS_INDEPT_SCALE_PARAM"), "", ""};
        defaultTableModel.addRow(objectArray2);
        defaultTableModel.addRow(objectArray3);
    }

    private void setDefaults() {
        this.onVarianceKnown(false);
        this.mAssumeUnequalRadio.setSelected(true);
        this.onAssumeEq(false);
        this.onAssumeUnEq(true);
        this.mJeffreysRadio.setSelected(true);
        this.mDiffuseRadio.setSelected(true);
        this.mNormalRadio.setSelected(false);
        this.mNormalFieldsTable.setEnabled(false);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = 23;
        JPanel jPanel2 = this.createDataVariancePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JPanel jPanel3 = this.createPVPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        JPanel jPanel4 = this.createPMPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 1, 1, n2, insets);
    }

    private JPanel createPVPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_INDEPT_PRIOR_VARIANCE_TITLE")));
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mJeffreysRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mInverseCSRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDegreeFreedomLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDegreeFreedomField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mScaleParamLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mScaleParamField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.mInfoArea = new FocusableTextArea(this.getResString("IDS_INDEPT_DIFFUSE_INFO_LABEL"), new ImageIcon(uRL));
        DialogUtil.addUsingGBL(jPanel, this.mInfoArea, gridBagConstraints, 0, 4, 2, 1, n, null);
        return jPanel;
    }

    private JPanel createPMPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_INDEPT_PRIOR_MEAN_TITLE")));
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDiffuseRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNormalRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mNormalFieldsTable);
        jScrollPane.setPreferredSize(new Dimension(330, 65));
        jScrollPane.setMinimumSize(new Dimension(330, 60));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 5, 1, 1, n, insets2);
        return jPanel;
    }

    private void onVarianceKnown(boolean bl) {
        this.mGroup1VLabel.setEnabled(bl);
        this.mGroup1VField.setEnabled(bl);
        this.mGroup2VLabel.setEnabled(bl);
        this.mGroup2VField.setEnabled(bl);
        this.mDiffuseRadio.setEnabled(bl);
        this.mNormalRadio.setEnabled(bl);
        this.mNormalFieldsTable.setEnabled(bl && this.mNormalRadio.isSelected());
    }

    private void onAssumeEq(boolean bl) {
        this.mJeffreysRadio.setEnabled(bl);
        this.mInverseCSRadio.setEnabled(bl);
        this.onInverseCS(bl && this.mInverseCSRadio.isSelected());
    }

    private void onAssumeUnEq(boolean bl) {
        this.mInfoArea.setEnabled(bl);
    }

    private void onInverseCS(boolean bl) {
        this.mDegreeFreedomLabel.setEnabled(bl);
        this.mDegreeFreedomField.setEnabled(bl);
        this.mScaleParamLabel.setEnabled(bl);
        this.mScaleParamField.setEnabled(bl);
    }

    private JPanel createDataVariancePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_INDEPT_DATA_VARIANCE_TITLE")));
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mVarianceKnownRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mGroup1VLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mGroup1VField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mGroup2VLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mGroup2VField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mAssumeEqVRadio, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mAssumeUnequalRadio, gridBagConstraints, 0, 4, 2, 1, n, insets);
        return jPanel;
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        if (this.mVarianceKnownRadio.isSelected()) {
            boolean bl2 = bl = this.mGroup1VField.getText().length() > 0 && this.mGroup2VField.getText().length() > 0;
        }
        if (bl && this.mInverseCSRadio.isEnabled() && this.mInverseCSRadio.isSelected()) {
            bl = this.mDegreeFreedomField.getText().length() > 0 && this.mScaleParamField.getText().length() > 0;
        }
        return bl;
    }

    private void addListeners() {
        this.mGroup1VField.getDocument().addDocumentListener(this);
        this.mGroup2VField.getDocument().addDocumentListener(this);
        this.mDegreeFreedomField.getDocument().addDocumentListener(this);
        this.mScaleParamField.getDocument().addDocumentListener(this);
        this.mNormalFieldsTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                IndeptPriorsSubDlg.this.enableContinue(IndeptPriorsSubDlg.this.canEnableContinue());
            }
        });
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVAButtonGroup);
        vector.add(this.mGroup1VField);
        vector.add(this.mGroup2VField);
        vector.add(this.mJeffreysRadio);
        vector.add(this.mInverseCSRadio);
        vector.add(this.mDegreeFreedomField);
        vector.add(this.mScaleParamField);
        vector.add(this.mInfoArea);
        vector.add(this.mDNButtonGroup);
        vector.add(this.mNormalFieldsTable);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    class RowLabelRenderer
    extends JLabel
    implements TableCellRenderer {
        RowLabelRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(10);
            this.setBackground(UIManager.getColor("TableHeader.background"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setText(object.toString());
            }
            this.setEnabled(jTable.isEnabled());
            this.setFont(jTable.getFont());
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    class NormalFieldsTable
    extends BayesianBaseDlg.BaseTable {
        TableCellEditor[] mCellEditors;

        NormalFieldsTable(TableModel tableModel) {
            super(tableModel);
            this.mCellEditors = new TableCellEditor[2];
            this.setRowSelectionAllowed(false);
            this.setupColumns();
            this.setFillsViewportHeight(true);
            this.mCellEditors[0] = new BayesianBaseDlg.FloatValueCellEditor(Double.NaN, Double.NaN, false);
            this.mCellEditors[1] = new BayesianBaseDlg.FloatValueCellEditor(0.0, Double.NaN, false);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            return n == 0 ? this.mCellEditors[0] : this.mCellEditors[1];
        }

        @Override
        protected boolean validateTable(boolean bl) {
            boolean bl2 = true;
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            String string = null;
            block0: for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                for (int j = 1; j <= 2; ++j) {
                    String string2 = (String)defaultTableModel.getValueAt(i, j);
                    if (string2.length() == 0) {
                        string = IndeptPriorsSubDlg.this.getResString("ERR_MSG_EMPTY_VALUE_WARNING");
                    } else if (j == 2 && Double.parseDouble(string2) == 0.0) {
                        string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MSG_GREATER_THAN"), 0);
                    }
                    if (string == null) continue;
                    if (!bl) {
                        SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                        this.setRowSelectionInterval(i, i);
                        this.setColumnSelectionInterval(j, j);
                        IndeptPriorsSubDlg.this.mNormalFieldsTable.requestFocus();
                    }
                    bl2 = false;
                    break block0;
                }
            }
            return bl2;
        }

        private void setupColumns() {
            TableColumn tableColumn = this.columnModel.getColumn(0);
            RowLabelRenderer rowLabelRenderer = new RowLabelRenderer();
            tableColumn.setCellRenderer(rowLabelRenderer);
            tableColumn.setPreferredWidth(180);
            TableColumn tableColumn2 = this.columnModel.getColumn(1);
            BayesianBaseDlg.ValueRenderer valueRenderer = new BayesianBaseDlg.ValueRenderer();
            tableColumn2.setCellRenderer(valueRenderer);
            tableColumn2.setPreferredWidth(100);
            tableColumn2.setMinWidth(50);
            tableColumn2 = this.columnModel.getColumn(2);
            tableColumn2.setCellRenderer(valueRenderer);
            tableColumn2.setCellRenderer(valueRenderer);
            tableColumn2.setPreferredWidth(100);
            tableColumn2.setMinWidth(50);
        }
    }
}

