/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IndeptCriteriaSubDlg
extends BaseSubDialog
implements DocumentListener {
    static final String INTERVAL_PERCENTAGE = "IDS_INTERVAL_PERCENTAGE_LABEL";
    static final String EXCLUDE_ANALYSIS = "IDS_EXCLUDE_ANALYSIS_RADIO";
    static final String EXCLUDE_LISTWISE = "IDS_EXCLUDE_LISTWISE_RADIO";
    static final String TOLERANCE = "IDS_TOLERANCE_LABEL";
    static final String MAX_ITERATIONS = "IDS_MAX_ITERATIONS_LABEL";
    private FloatTextField mIntervalPercentageField;
    private JRadioButton mAnalysisRadio;
    private JRadioButton mListwiseRadio;
    private SpssButtonGroup mMissingValuesGroup;
    private FloatTextField mToleranceField;
    private IntTextField mMaxIterationsField;

    public IndeptCriteriaSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.setDefaults();
        this.addListeners();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_independent_sample_criteria";
    }

    public static String getIndeptCriteriaDlgSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING SCOPE="));
        Boolean bl = dialogDataModel.containsBooleanKey(EXCLUDE_LISTWISE) ? dialogDataModel.getBoolean(EXCLUDE_LISTWISE) : false;
        stringBuffer.append(bl != null && bl != false ? "LISTWISE" : "ANALYSIS").append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        String string = dialogDataModel.getString(INTERVAL_PERCENTAGE) != null ? dialogDataModel.getString(INTERVAL_PERCENTAGE) : "95";
        stringBuffer.append(" CILEVEL=").append(string);
        string = dialogDataModel.getString(TOLERANCE);
        stringBuffer.append(" TOL=").append(string != null && string.length() > 0 ? string : "0.000001");
        string = dialogDataModel.getString(MAX_ITERATIONS);
        stringBuffer.append(" MAXITER=").append(string != null && string.length() > 0 ? string : "2000");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mIntervalPercentageField = new FloatTextField(0.0, 100.0, 1, true);
        this.mIntervalPercentageField.setAllowMinMax(false, false);
        this.mIntervalPercentageField.setColumns(8);
        this.mIntervalPercentageField.setAction((Action)new TextFieldAction(this.mParentDlg, INTERVAL_PERCENTAGE));
        this.mAnalysisRadio = new JRadioButton(new ToggleButtonAction(this, EXCLUDE_ANALYSIS));
        this.mListwiseRadio = new JRadioButton(new ToggleButtonAction(this, EXCLUDE_LISTWISE));
        this.mMissingValuesGroup = new SpssButtonGroup();
        this.mMissingValuesGroup.add(this.mAnalysisRadio);
        this.mMissingValuesGroup.add(this.mListwiseRadio);
        this.mToleranceField = new FloatTextField(Math.abs(Double.MIN_VALUE), 0.001, 3, true);
        this.mToleranceField.setAction((Action)new TextFieldAction(this.mParentDlg, TOLERANCE));
        this.mToleranceField.setColumns(8);
        this.mMaxIterationsField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxIterationsField.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_ITERATIONS));
        this.mMaxIterationsField.setColumns(8);
    }

    private void setDefaults() {
        this.mIntervalPercentageField.setText("95");
        this.mAnalysisRadio.setSelected(true);
        this.mToleranceField.setText("0.000001");
        this.mMaxIterationsField.setText("2000");
    }

    private void addListeners() {
        this.mIntervalPercentageField.getDocument().addDocumentListener(this);
        this.mToleranceField.getDocument().addDocumentListener(this);
        this.mMaxIterationsField.getDocument().addDocumentListener(this);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n / 2, 0, n / 2, 0);
        gridBagConstraints.weighty = 1.0;
        int n2 = 23;
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        jPanel2.setLayout(boxLayout);
        JLabel jLabel = DialogUtil.createLabel(this, INTERVAL_PERCENTAGE);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(3));
        jPanel2.add((Component)this.mIntervalPercentageField);
        jLabel.setLabelFor((Component)this.mIntervalPercentageField);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MISSING_VALUES_TITLE")));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(this.mAnalysisRadio);
        jPanel3.add(this.mListwiseRadio);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        JPanel jPanel4 = this.createAdaptiveMethodPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ADAPTIVE_Q_METHOD_TITLE")));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n2, insets);
    }

    private JPanel createAdaptiveMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, TOLERANCE);
        jLabel.setLabelFor((Component)this.mToleranceField);
        JLabel jLabel2 = DialogUtil.createLabel(this, MAX_ITERATIONS);
        jLabel2.setLabelFor((Component)this.mMaxIterationsField);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mToleranceField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationsField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mIntervalPercentageField);
        vector.add(this.mMissingValuesGroup);
        vector.add(this.mToleranceField);
        vector.add(this.mMaxIterationsField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean canEnableContinue() {
        boolean bl;
        boolean bl2 = bl = this.mIntervalPercentageField.getText().length() > 0;
        if (bl) {
            bl = this.mToleranceField.getText().length() > 0 && this.mMaxIterationsField.getText().length() > 0;
        }
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

