/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CommonCriteriaSubDlg
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final String INTERVAL_PERCENTAGE = "IDS_INTERVAL_PERCENTAGE_LABEL";
    public static final String EXCLUDE_ANALYSIS = "IDS_EXCLUDE_ANALYSIS_RADIO";
    public static final String EXCLUDE_LISTWISE = "IDS_EXCLUDE_LISTWISE_RADIO";
    public static final String ADAPTIVE_QUADRATURE = "IDS_ADAPTIVE_QUADRATURE";
    public static final String MONTE_APPROXIMATION = "IDS_MONTE_APPROXIMATION";
    public static final String TOLERANCE = "IDS_TOLERANCE_LABEL";
    public static final String MAX_ITERATIONS = "IDS_MAX_ITERATIONS_LABEL";
    public static final String NUMBER_MC_SAMPLES = "IDS_NUMBER_MC_SAMPLES_LABEL";
    public static final String SET_CUSTOM_SEED = "IDS_SET_CUSTOM_SEED";
    public static final String MCA_SEED_CUSTOM = "IDS_MCA_SEED_CUSTOM_LABEL";
    private FloatTextField mIntervalPercentageField;
    private JRadioButton mAnalysisRadio;
    private JRadioButton mListwiseRadio;
    private SpssButtonGroup mMissingValuesGroup;
    private JRadioButton mAdaptiveRadio;
    private JRadioButton mMonteRadio;
    private SpssButtonGroup mNumericMethodGroup;
    private JLabel mToleranceLabel;
    private FloatTextField mToleranceField;
    private JLabel mNumberLabel;
    private IntTextField mNumberField;
    private JLabel mMaxIterationsLabel;
    private IntTextField mMaxIterationsField;
    private JCheckBox mSetSeedCheck;
    private JLabel mSeedCustomLabel;
    private IntTextField mSeedCustomField;
    private boolean mIsDistributionSelected;

    public CommonCriteriaSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, true);
        this.mIsDistributionSelected = bl;
        this.setDefaults();
        this.addListeners();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_onesample_criteria";
    }

    public static String getCommonCriteriaDlgSyntax(DialogDataModel dialogDataModel, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING SCOPE="));
        Boolean bl2 = dialogDataModel.containsBooleanKey(EXCLUDE_LISTWISE) ? dialogDataModel.getBoolean(EXCLUDE_LISTWISE) : false;
        stringBuffer.append(bl2 != null && bl2 != false ? "LISTWISE" : "ANALYSIS").append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        String string = dialogDataModel.getString(INTERVAL_PERCENTAGE) != null ? dialogDataModel.getString(INTERVAL_PERCENTAGE) : "95";
        stringBuffer.append(" CILEVEL=").append(string);
        if (!bl) {
            Boolean bl3 = dialogDataModel.containsBooleanKey(MONTE_APPROXIMATION) ? dialogDataModel.getBoolean(MONTE_APPROXIMATION) : false;
            stringBuffer.append(" METHOD=");
            boolean bl4 = bl3 != null && bl3 != false;
            stringBuffer.append(bl4 ? "MCA" : "AGL");
            if (!bl4) {
                string = dialogDataModel.getString(TOLERANCE);
                stringBuffer.append(" TOL=").append(string != null && string.length() > 0 ? string : "0.000001");
                string = dialogDataModel.getString(MAX_ITERATIONS);
                stringBuffer.append(" MAXITER=").append(string != null && string.length() > 0 ? string : "2000");
            } else {
                bl3 = dialogDataModel.getBoolean(SET_CUSTOM_SEED);
                string = dialogDataModel.getString(MCA_SEED_CUSTOM);
                stringBuffer.append(" SEED=").append(bl3 != null && bl3 != false && string.length() > 0 ? string : "RANDOM");
                string = dialogDataModel.getString(NUMBER_MC_SAMPLES);
                stringBuffer.append(" MCSAMPLES=").append(string != null && string.length() > 0 ? string : "1000000");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mIntervalPercentageField = new FloatTextField(0.0, 100.0, 1, true);
        this.mIntervalPercentageField.setAllowMinMax(false, false);
        this.mIntervalPercentageField.setColumns(8);
        this.mIntervalPercentageField.setAction((Action)new TextFieldAction(this.mParentDlg, INTERVAL_PERCENTAGE));
        this.mAnalysisRadio = new JRadioButton(new ToggleButtonAction(this, EXCLUDE_ANALYSIS));
        this.mListwiseRadio = new JRadioButton(new ToggleButtonAction(this, EXCLUDE_LISTWISE));
        this.mMissingValuesGroup = new SpssButtonGroup();
        this.mMissingValuesGroup.add(this.mAnalysisRadio);
        this.mMissingValuesGroup.add(this.mListwiseRadio);
        this.mAdaptiveRadio = new JRadioButton(new ToggleButtonAction(this, ADAPTIVE_QUADRATURE));
        this.mMonteRadio = new JRadioButton(new ToggleButtonAction(this, MONTE_APPROXIMATION));
        this.mNumericMethodGroup = new SpssButtonGroup();
        this.mNumericMethodGroup.add(this.mAdaptiveRadio);
        this.mNumericMethodGroup.add(this.mMonteRadio);
        this.mToleranceField = new FloatTextField(Math.abs(Double.MIN_VALUE), 0.001, 3, true);
        this.mToleranceField.setAction((Action)new TextFieldAction(this.mParentDlg, TOLERANCE));
        this.mToleranceField.setColumns(8);
        this.mMaxIterationsField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxIterationsField.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_ITERATIONS));
        this.mMaxIterationsField.setColumns(8);
        this.mSetSeedCheck = new JCheckBox(new ToggleButtonAction(this, SET_CUSTOM_SEED));
        this.mSeedCustomLabel = DialogUtil.createLabel(this, MCA_SEED_CUSTOM);
        this.mSeedCustomField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mSeedCustomField.setAction((Action)new TextFieldAction(this.mParentDlg, MCA_SEED_CUSTOM));
        this.mSeedCustomField.setColumns(8);
        this.mSeedCustomLabel.setLabelFor((Component)this.mSeedCustomField);
        this.mNumberField = new IntTextField(1000, 1000000, true);
        this.mNumberField.setAction((Action)new TextFieldAction(this.mParentDlg, NUMBER_MC_SAMPLES));
        this.mNumberField.setColumns(8);
    }

    private void addListeners() {
        this.mAnalysisRadio.addItemListener(this);
        this.mListwiseRadio.addItemListener(this);
        this.mAdaptiveRadio.addItemListener(this);
        this.mMonteRadio.addItemListener(this);
        this.mSetSeedCheck.addItemListener(this);
        this.mIntervalPercentageField.getDocument().addDocumentListener(this);
        this.mToleranceField.getDocument().addDocumentListener(this);
        this.mMaxIterationsField.getDocument().addDocumentListener(this);
        this.mSeedCustomField.getDocument().addDocumentListener(this);
        this.mNumberField.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mIntervalPercentageField.setText("95");
        this.mAnalysisRadio.setSelected(true);
        this.mAdaptiveRadio.setSelected(true);
        this.mToleranceField.setText("0.000001");
        this.mMaxIterationsField.setText("2000");
        this.mSeedCustomField.setText("2000000");
        this.mNumberField.setText("10000");
        this.setEnabledForNumericMethodGroup(!this.mIsDistributionSelected);
        this.onMonteRadio(false);
    }

    private void setEnabledForNumericMethodGroup(boolean bl) {
        this.mAdaptiveRadio.setEnabled(bl);
        this.mMonteRadio.setEnabled(bl);
        this.onAdaptiveRadio(!this.mIsDistributionSelected && this.mAdaptiveRadio.isSelected());
    }

    private void onAdaptiveRadio(boolean bl) {
        this.mToleranceLabel.setEnabled(bl);
        this.mToleranceField.setEnabled(bl);
        this.mMaxIterationsLabel.setEnabled(bl);
        this.mMaxIterationsField.setEnabled(bl);
    }

    private void onMonteRadio(boolean bl) {
        this.mSeedCustomField.setEnabled(bl && !this.mIsDistributionSelected);
        this.mNumberLabel.setEnabled(bl && !this.mIsDistributionSelected);
        this.mNumberField.setEnabled(bl && !this.mIsDistributionSelected);
        this.mSetSeedCheck.setEnabled(bl && !this.mIsDistributionSelected);
        this.onSetCustomSeed(bl && !this.mIsDistributionSelected && this.mSetSeedCheck.isSelected());
    }

    private void onSetCustomSeed(boolean bl) {
        this.mSeedCustomLabel.setEnabled(bl);
        this.mSeedCustomField.setEnabled(bl);
    }

    private void setupPanel(JPanel jPanel) {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n / 2, 0, n / 2, 0);
        int n2 = 23;
        this.mIntervalPercentageField.setPreferredSize(new Dimension(100, 26));
        this.mIntervalPercentageField.setMinimumSize(new Dimension(70, 26));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, INTERVAL_PERCENTAGE);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mIntervalPercentageField, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        jLabel.setLabelFor((Component)this.mIntervalPercentageField);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MISSING_VALUES_TITLE")));
        DialogUtil.addUsingGBL(jPanel3, this.mAnalysisRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mListwiseRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        JPanel jPanel4 = this.createNumericalMethodPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_NUMERICAL_METHOD_TITLE")));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
    }

    private JPanel createNumericalMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mAdaptiveRadio, gridBagConstraints, 0, 0, 3, 1, n, insets);
        this.mToleranceLabel = DialogUtil.createLabel(this, TOLERANCE);
        this.mToleranceLabel.setLabelFor((Component)this.mToleranceField);
        this.mMaxIterationsLabel = DialogUtil.createLabel(this, MAX_ITERATIONS);
        this.mMaxIterationsLabel.setLabelFor((Component)this.mMaxIterationsField);
        this.mNumberLabel = DialogUtil.createLabel(this, NUMBER_MC_SAMPLES);
        Insets insets2 = new Insets(insets.top, insets.left + 25, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mToleranceLabel, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxIterationsLabel, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSeedCustomLabel, gridBagConstraints, 0, 5, 1, 1, n, new Insets(insets.top, insets.left + 46, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mNumberLabel, gridBagConstraints, 0, 6, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMonteRadio, gridBagConstraints, 0, 3, 3, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSetSeedCheck, gridBagConstraints, 0, 4, 3, 1, n, new Insets(insets.top, insets.left + 20, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSeedCustomField, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mToleranceField, gridBagConstraints, 2, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationsField, gridBagConstraints, 2, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberField, gridBagConstraints, 2, 6, 1, 1, n, insets);
        this.mNumberLabel.setLabelFor((Component)this.mNumberField);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mIntervalPercentageField);
        vector.add(this.mMissingValuesGroup);
        vector.add(this.mNumericMethodGroup);
        vector.add(this.mToleranceField);
        vector.add(this.mMaxIterationsField);
        vector.add(this.mSetSeedCheck);
        vector.add(this.mSeedCustomField);
        vector.add(this.mNumberField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean canEnableContinue() {
        boolean bl;
        boolean bl2 = bl = this.mIntervalPercentageField.getText().length() > 0;
        if (bl && !this.mIsDistributionSelected) {
            if (this.mAdaptiveRadio.isSelected()) {
                bl = this.mToleranceField.getText().length() > 0 && this.mMaxIterationsField.getText().length() > 0;
            } else {
                if (this.mSetSeedCheck.isSelected()) {
                    boolean bl3 = bl = this.mSeedCustomField.getText().length() > 0;
                }
                if (bl) {
                    bl = this.mNumberField.getText().length() > 0;
                }
            }
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mMonteRadio || object == this.mAdaptiveRadio) {
            if (itemEvent.getStateChange() == 1) {
                this.onMonteRadio(this.mMonteRadio.isSelected());
                this.onAdaptiveRadio(this.mAdaptiveRadio.isSelected());
            }
        } else if (object == this.mSetSeedCheck) {
            this.onSetCustomSeed(this.mSetSeedCheck.isSelected());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

