/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesFactorSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.PearsonCorreBayesianStatsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.RelatedSampleBayesianStatsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public abstract class BayesianBaseDlg
extends BaseProcedureDialog
implements ItemListener {
    public static final String DISTRIBUTION_RADIO = "IDS_DISTRIBUTION";
    public static final String BAYES_FACTOR_RADIO = "IDS_BAYES_FACTOR";
    public static final String USE_BOTH_RADIO = "IDS_USE_BOTH";
    public static final String CRITERIA_BUTTON = "IDS_CRITERIA_BUTTON";
    public static final String PRIORS_BUTTON = "IDS_PRIORS_BUTTON";
    public static final int COLUMN_VARIABLE = 0;
    public static final String VARIABLE_DATA_VECTOR_KEY = "VariableDataKey";
    protected SrcVariableList mSrcVarList;
    protected ArrowButton mArrowButton;
    protected ComponentsArrowButton mComponentsArrowButton;
    protected JButton mCriteriaButton;
    protected JButton mPriorsButton;
    protected JRadioButton mDistributionRadio;
    protected JRadioButton mBayesFactorRadio;
    protected JRadioButton mUseBothRadio;
    protected SpssButtonGroup mAnalysisGroup;
    protected BaseTable mDataTable;
    protected JScrollPane mDataTableScrollPane;
    protected Vector mVariableDataVector;
    protected boolean mIsReloading = false;
    protected TargetVariableList mTargetVarList;
    protected JButton mBayesFactorButton;

    public BayesianBaseDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setupPanel(jPanel);
        this.addListeners();
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected void setFocusTraversalPolicy() {
    }

    protected void addListeners() {
        this.mDistributionRadio.addItemListener(this);
        this.mBayesFactorRadio.addItemListener(this);
        this.mUseBothRadio.addItemListener(this);
        if (this.mDataTable != null) {
            this.mDataTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (BayesianBaseDlg.this.mIsReloading) {
                        return;
                    }
                    int n = tableModelEvent.getFirstRow();
                    int n2 = tableModelEvent.getColumn();
                    BayesianBaseDlg.this.onDataTableChanged(n, n2);
                    BayesianBaseDlg.this.repaint();
                }
            });
        }
    }

    protected void onDataTableChanged(int n, int n2) {
    }

    protected void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mDistributionRadio.setSelected(true);
        this.onAnalysisRadio();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        if (this.mDataTable != null) {
            this.mDataTable.removeAll();
        }
        if (this.mVariableDataVector != null) {
            this.mVariableDataVector.clear();
        }
    }

    protected void removeFromDataTable(Object object) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mDataTable.getModel();
        int n = -1;
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            Object object2 = defaultTableModel.getValueAt(i, 0);
            boolean bl = object2 instanceof ISpssVariable ? ((ISpssVariable)object2).getName().equals(((ISpssVariable)object).getName()) : object2.equals(object.toString());
            if (!bl) continue;
            defaultTableModel.removeRow(i);
            n = i;
            break;
        }
        if (n > -1 && this.mVariableDataVector != null && n < this.mVariableDataVector.size()) {
            this.mVariableDataVector.remove(n);
        }
    }

    protected int getMiddlePanelRightGap() {
        return 150;
    }

    @Override
    protected void loadDialogState() {
        this.mVariableDataVector = (Vector)this.getDialogDataModel().getObject(VARIABLE_DATA_VECTOR_KEY);
        super.loadDialogState();
        this.onAnalysisRadio();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        if (this.mDataTable != null) {
            this.mVariableDataVector = ((DefaultTableModel)this.mDataTable.getModel()).getDataVector();
            this.getDialogDataModel().putObject(VARIABLE_DATA_VECTOR_KEY, this.mVariableDataVector);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.setDefaults();
        this.mSrcVarList.requestFocus();
        if (this.mDataTable != null) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.mDataTable.getModel();
            defaultTableModel.getDataVector().removeAllElements();
            defaultTableModel.fireTableDataChanged();
        }
    }

    protected JPanel createAnalysisPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BAYESIAN_ANALYSIS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        DialogUtil.addUsingGBL(jPanel, this.mDistributionRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mBayesFactorRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mUseBothRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("OneSampleBaseSrcVarList");
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mComponentsArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mComponentsArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDistributionRadio = new JRadioButton(new ToggleButtonAction(this, DISTRIBUTION_RADIO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BayesianBaseDlg.this.onAnalysisRadio();
            }
        });
        this.mBayesFactorRadio = new JRadioButton(new ToggleButtonAction(this, BAYES_FACTOR_RADIO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BayesianBaseDlg.this.onAnalysisRadio();
            }
        });
        this.mUseBothRadio = new JRadioButton(new ToggleButtonAction(this, USE_BOTH_RADIO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BayesianBaseDlg.this.onAnalysisRadio();
            }
        });
        this.mAnalysisGroup = new SpssButtonGroup();
        this.mAnalysisGroup.add(this.mDistributionRadio);
        this.mAnalysisGroup.add(this.mBayesFactorRadio);
        this.mAnalysisGroup.add(this.mUseBothRadio);
    }

    protected void onAnalysisRadio() {
    }

    protected JPanel createSideButtonPanel(boolean bl) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, CRITERIA_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BayesianBaseDlg.this.onCriteriaButton();
            }
        };
        this.mCriteriaButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, PRIORS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BayesianBaseDlg.this.onPriorsButton();
            }
        };
        this.mPriorsButton = new JButton(toggleButtonAction);
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.top + insets.bottom;
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        jPanel.add(this.mCriteriaButton);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(this.mPriorsButton);
        if (bl) {
            toggleButtonAction = new ToggleButtonAction(this, "IDS_BAYES_FACTOR_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BayesianBaseDlg.this.onBayesFactorButton();
                }
            };
            this.mBayesFactorButton = new JButton(toggleButtonAction);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mBayesFactorButton);
        }
        return jPanel;
    }

    protected void onCriteriaButton() {
    }

    protected void onPriorsButton() {
    }

    protected void onBayesFactorButton() {
        new BayesFactorSubDlg(this, this.getResString("IDS_INDEPT_FACTOR_TITLE"), this.mDistributionRadio.isSelected());
    }

    protected void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.5;
        int n = 18;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BAYESIAN_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(new Dimension(200, this instanceof PearsonCorreBayesianStatsDlg ? 250 : 400));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = (Insets)DialogUtil.getArrowButtonInsets().clone();
        insets2.top += 60;
        SpssArrowButton spssArrowButton = this instanceof RelatedSampleBayesianStatsDlg ? this.mComponentsArrowButton : this.mArrowButton;
        DialogUtil.addUsingGBL(jPanel2, spssArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JPanel jPanel3 = this.createRightPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, null);
    }

    protected JPanel createRightPanel() {
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object = itemEvent.getSource();
            this.onBayesianAnalysisRadios(object);
        }
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        return this.mDataTable == null || !this.mDataTable.isEnabled() || this.mDataTable.validateTable(false);
    }

    protected void onBayesianAnalysisRadios(Object object) {
        if (this.mDataTable != null) {
            this.mDataTable.repaint();
        }
    }

    static String htmlToPlainText(String string) {
        String string2 = string.replaceAll("<[^>]*>", " ");
        string2 = string2.replace("&nbsp;", " ");
        string2 = string2.replace("&amp;", "&");
        string2 = string2.replaceAll("&.*?;", "");
        return string2;
    }

    class VariableDataBag {
        Object variable;

        VariableDataBag(Object object) {
            this.variable = object;
        }

        Object getVariable() {
            return this.variable;
        }
    }

    public static class BaseValueCellEditor
    extends DefaultCellEditor {
        public BaseValueCellEditor(ContextEnabledTextField contextEnabledTextField) {
            super((JTextField)contextEnabledTextField);
            final ContextEnabledTextField contextEnabledTextField2 = (ContextEnabledTextField)this.getComponent();
            this.setClickCountToStart(1);
            contextEnabledTextField2.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    contextEnabledTextField2.selectAll();
                }
            });
        }
    }

    public static class FloatValueCellEditor
    extends BaseValueCellEditor {
        public FloatValueCellEditor(double d, double d2, boolean bl) {
            this(d, d2, bl, false);
        }

        public FloatValueCellEditor(double d, double d2, boolean bl, boolean bl2) {
            super((ContextEnabledTextField)new FloatTextField(d, d2, 5, d == 0.0));
            FloatTextField floatTextField = (FloatTextField)this.getComponent();
            floatTextField.setIncludeMinRange(bl);
            floatTextField.setIncludeMaxRange(bl2);
        }
    }

    public static class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CheckBoxCellRenderer() {
            this.setBorderPainted(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            boolean bl3 = false;
            if (object instanceof String) {
                bl3 = object.equals("true");
            } else if (object instanceof Boolean) {
                bl3 = (Boolean)object;
            }
            this.setSelected(object != null && bl3);
            this.setEnabled(jTable.isEnabled());
            this.setBorder(bl2 ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : this.noFocusBorder);
            return this;
        }
    }

    public static class ValueRenderer
    extends JLabel
    implements TableCellRenderer {
        ValueRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(10);
            this.setFocusable(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(new EmptyBorder(1, 2, 1, 2));
            }
            if (object instanceof String) {
                String string = UIToolResUtil.addLocale((String)((String)object));
                this.setText(string);
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setEnabled(jTable.isEnabled() && jTable.isCellEditable(n, n2));
            this.setFont(jTable.getFont());
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    public static class VarLabelRenderer
    extends JLabel
    implements TableCellRenderer {
        boolean showName = false;

        VarLabelRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(10);
            this.setFocusable(true);
        }

        VarLabelRenderer(boolean bl) {
            this();
            this.showName = bl;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(new EmptyBorder(1, 2, 1, 2));
            }
            if (object instanceof ISpssVariable) {
                ISpssVariable iSpssVariable = (ISpssVariable)object;
                this.setText(this.showName ? iSpssVariable.getName() : (iSpssVariable.getLabel().length() > 0 ? iSpssVariable.getLabel() : iSpssVariable.getName()));
            } else if (object != null) {
                this.setText(object.toString());
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setEnabled(jTable.isEnabled());
            this.setFont(jTable.getFont());
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    public static class BaseTable
    extends PlainTable {
        protected ArrayList<ArrayList<TableCellEditor>> mTableCellEditors = new ArrayList();

        public BaseTable(TableModel tableModel) {
            super(tableModel);
            this.initTable();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        protected void setupCellEditors(double d, double d2, boolean bl) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                ArrayList<FloatValueCellEditor> arrayList = new ArrayList<FloatValueCellEditor>();
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    arrayList.add(j == 0 ? null : new FloatValueCellEditor(d, d2, bl));
                }
                this.mTableCellEditors.add(arrayList);
            }
        }

        public void reloadTable(Vector vector) {
            if (vector != null && vector.size() > 0) {
                if (this.getRowCount() == 0) {
                    return;
                }
                Object[][] objectArray = BaseTable.to2DimArray(vector);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i >= this.getRowCount()) continue;
                    Object object = this.getValueAt(i, 0);
                    for (int j = 1; j < objectArray[i].length; ++j) {
                        Object object2 = objectArray[i][0];
                        if (!object.equals(object2) || i >= this.getRowCount() || j >= this.getColumnCount()) continue;
                        this.setValueAt(objectArray[i][j], i, j);
                    }
                }
            }
        }

        public static Object[][] to2DimArray(Vector vector) {
            Object[][] objectArray = new Object[vector.size()][0];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = ((Vector)vector.get(i)).toArray();
            }
            return objectArray;
        }

        protected boolean validateTable(boolean bl) {
            return true;
        }

        private void initTable() {
            this.getTableHeader().setReorderingAllowed(false);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.setFocusTraversalKeys(0, null);
            this.setFocusTraversalKeys(1, null);
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                this.setGridColor(this.getGridColor().darker());
            }
            this.setRowSelectionAllowed(true);
            this.setRowHeight(this.getRowHeight() + 3);
        }

        protected void onDisplayWarning(String string, int n, int n2) {
            SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
            this.setRowSelectionInterval(n, n);
            this.setColumnSelectionInterval(n2, n2);
            this.requestFocus();
        }

        @Override
        protected String getHeaderTooltip(int n) {
            String string = this.getColumnName(n);
            return BayesianBaseDlg.htmlToPlainText(string);
        }
    }
}

